/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.functions;

import com.healthmarketscience.rmiio.RemoteInputStream;
import com.healthmarketscience.rmiio.RemoteInputStreamClient;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.api.RealizationResult;
import org.apache.geode.management.configuration.AbstractConfiguration;
import org.apache.geode.management.configuration.Deployment;
import org.apache.geode.management.configuration.DiskStore;
import org.apache.geode.management.configuration.GatewayReceiver;
import org.apache.geode.management.configuration.HasFile;
import org.apache.geode.management.configuration.Index;
import org.apache.geode.management.configuration.Member;
import org.apache.geode.management.configuration.Pdx;
import org.apache.geode.management.configuration.Region;
import org.apache.geode.management.internal.CacheElementOperation;
import org.apache.geode.management.internal.beans.FileUploader;
import org.apache.geode.management.internal.configuration.realizers.ConfigurationRealizer;
import org.apache.geode.management.internal.configuration.realizers.DeploymentRealizer;
import org.apache.geode.management.internal.configuration.realizers.DiskStoreRealizer;
import org.apache.geode.management.internal.configuration.realizers.GatewayReceiverRealizer;
import org.apache.geode.management.internal.configuration.realizers.IndexRealizer;
import org.apache.geode.management.internal.configuration.realizers.MemberRealizer;
import org.apache.geode.management.internal.configuration.realizers.PdxRealizer;
import org.apache.geode.management.internal.configuration.realizers.RegionConfigRealizer;
import org.apache.geode.management.runtime.RuntimeInfo;
import org.apache.logging.log4j.Logger;

public class CacheRealizationFunction
implements InternalFunction<List> {
    private static final Logger logger = LogService.getLogger();
    @Immutable
    private static final Map<Class, ConfigurationRealizer> realizers = new HashMap<Class, ConfigurationRealizer>();
    private static final long serialVersionUID = -2695517414081975343L;

    @Override
    public void execute(FunctionContext<List> context) {
        AbstractConfiguration cacheElement = (AbstractConfiguration)context.getArguments().get(0);
        CacheElementOperation operation = (CacheElementOperation)((Object)context.getArguments().get(1));
        if (operation == CacheElementOperation.GET) {
            try {
                InternalCache cache = (InternalCache)context.getCache();
                context.getResultSender().lastResult(this.executeGet(context, cache, cacheElement));
            }
            catch (CacheClosedException e) {
                context.getResultSender().lastResult(null);
            }
            catch (Exception e) {
                this.logError("Unable to gather runtime information on this member. ", e);
                context.getResultSender().lastResult(null);
            }
        } else {
            try {
                RemoteInputStream jarStream = (RemoteInputStream)context.getArguments().get(2);
                InternalCache cache = (InternalCache)context.getCache();
                context.getResultSender().lastResult(this.executeUpdate(context.getMemberName(), cache, cacheElement, operation, jarStream));
            }
            catch (CacheClosedException e) {
                context.getResultSender().lastResult(new RealizationResult().setSuccess(false).setMessage(e.getMessage()));
            }
            catch (Exception e) {
                this.logError("unable to update cache with the configuration.", e);
                context.getResultSender().lastResult(new RealizationResult().setSuccess(false).setMemberName(context.getMemberName()).setMessage(e.getMessage()));
            }
        }
    }

    @VisibleForTesting
    void logError(String s, Exception e) {
        logger.error(s, (Throwable)e);
    }

    public RuntimeInfo executeGet(FunctionContext<List> context, InternalCache cache, AbstractConfiguration cacheElement) {
        ConfigurationRealizer realizer = realizers.get(cacheElement.getClass());
        if (realizer == null) {
            return null;
        }
        Object runtimeInfo = realizer.get(cacheElement, cache);
        if (!cacheElement.isGlobalRuntime()) {
            runtimeInfo.setMemberName(context.getMemberName());
        }
        return runtimeInfo;
    }

    public RealizationResult executeUpdate(String memberName, InternalCache cache, AbstractConfiguration cacheElement, CacheElementOperation operation, RemoteInputStream jarStream) throws Exception {
        ConfigurationRealizer realizer = realizers.get(cacheElement.getClass());
        RealizationResult result = new RealizationResult();
        result.setMemberName(memberName);
        if (realizer == null || realizer.isReadyOnly()) {
            return result.setMessage("Server '" + memberName + "' needs to be restarted for this configuration change to be realized.");
        }
        if (cacheElement instanceof HasFile && jarStream != null) {
            HasFile configuration = (HasFile)cacheElement;
            Set<File> files = CacheRealizationFunction.stageFileContent(Collections.singletonList(configuration.getFileName()), Collections.singletonList(jarStream));
            configuration.setFile(files.iterator().next());
        }
        switch (operation) {
            case CREATE: {
                if (realizer.exists(cacheElement, cache)) {
                    return result.setMessage(cacheElement.getClass().getSimpleName() + " '" + cacheElement.getId() + "' already exists. Skipped creation.");
                }
                result = realizer.create(cacheElement, cache);
                break;
            }
            case DELETE: {
                if (!realizer.exists(cacheElement, cache)) {
                    return result.setMessage(cacheElement.getClass().getSimpleName() + " '" + cacheElement.getId() + "' does not exist.");
                }
                result = realizer.delete(cacheElement, cache);
                break;
            }
            case UPDATE: {
                if (!realizer.exists(cacheElement, cache)) {
                    return result.setSuccess(false).setMessage(cacheElement.getClass().getSimpleName() + " '" + cacheElement.getId() + "' does not exist.");
                }
                result = realizer.update(cacheElement, cache);
            }
        }
        result.setMemberName(memberName);
        return result;
    }

    public static Set<File> stageFileContent(List<String> jarNames, List<RemoteInputStream> jarStreams) throws IOException {
        HashSet<File> stagedJars = new HashSet<File>();
        try {
            Path tempDir = FileUploader.createSecuredTempDirectory("deploy-");
            for (int i = 0; i < jarNames.size(); ++i) {
                Path tempJar = Paths.get(tempDir.toString(), jarNames.get(i));
                FileOutputStream fos = new FileOutputStream(tempJar.toString());
                InputStream input = RemoteInputStreamClient.wrap((RemoteInputStream)jarStreams.get(i));
                IOUtils.copyLarge((InputStream)input, (OutputStream)fos);
                fos.close();
                input.close();
                stagedJars.add(tempJar.toFile());
            }
        }
        catch (IOException iox) {
            for (RemoteInputStream jarStream : jarStreams) {
                try {
                    jarStream.close(true);
                }
                catch (IOException iOException) {}
            }
            throw iox;
        }
        return stagedJars;
    }

    @Override
    public boolean isHA() {
        return false;
    }

    static {
        realizers.put(Region.class, new RegionConfigRealizer());
        realizers.put(GatewayReceiver.class, new GatewayReceiverRealizer());
        realizers.put(Member.class, new MemberRealizer());
        realizers.put(Pdx.class, new PdxRealizer());
        realizers.put(Deployment.class, new DeploymentRealizer());
        realizers.put(Index.class, new IndexRealizer());
        realizers.put(DiskStore.class, new DiskStoreRealizer());
    }
}

