/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.api;

import com.healthmarketscience.rmiio.RemoteInputStream;
import com.healthmarketscience.rmiio.RemoteStreamServer;
import com.healthmarketscience.rmiio.SimpleRemoteInputStream;
import com.healthmarketscience.rmiio.exporter.RemoteStreamExporter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.distributed.DistributedLockService;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.InternalConfigurationPersistenceService;
import org.apache.geode.distributed.internal.locks.DLockService;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.execute.AbstractExecution;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.api.ClusterManagementException;
import org.apache.geode.management.api.ClusterManagementGetResult;
import org.apache.geode.management.api.ClusterManagementListOperationsResult;
import org.apache.geode.management.api.ClusterManagementListResult;
import org.apache.geode.management.api.ClusterManagementOperation;
import org.apache.geode.management.api.ClusterManagementOperationResult;
import org.apache.geode.management.api.ClusterManagementRealizationException;
import org.apache.geode.management.api.ClusterManagementRealizationResult;
import org.apache.geode.management.api.ClusterManagementResult;
import org.apache.geode.management.api.ClusterManagementService;
import org.apache.geode.management.api.EntityGroupInfo;
import org.apache.geode.management.api.EntityInfo;
import org.apache.geode.management.api.RealizationResult;
import org.apache.geode.management.configuration.AbstractConfiguration;
import org.apache.geode.management.configuration.Deployment;
import org.apache.geode.management.configuration.DiskStore;
import org.apache.geode.management.configuration.GatewayReceiver;
import org.apache.geode.management.configuration.GroupableConfiguration;
import org.apache.geode.management.configuration.HasFile;
import org.apache.geode.management.configuration.Index;
import org.apache.geode.management.configuration.Links;
import org.apache.geode.management.configuration.Member;
import org.apache.geode.management.configuration.Pdx;
import org.apache.geode.management.configuration.Region;
import org.apache.geode.management.configuration.RegionScoped;
import org.apache.geode.management.internal.CacheElementOperation;
import org.apache.geode.management.internal.ManagementAgent;
import org.apache.geode.management.internal.SystemManagementService;
import org.apache.geode.management.internal.configuration.mutators.CacheConfigurationManager;
import org.apache.geode.management.internal.configuration.mutators.ConfigurationManager;
import org.apache.geode.management.internal.configuration.mutators.DeploymentManager;
import org.apache.geode.management.internal.configuration.mutators.DiskStoreManager;
import org.apache.geode.management.internal.configuration.mutators.GatewayReceiverConfigManager;
import org.apache.geode.management.internal.configuration.mutators.IndexConfigManager;
import org.apache.geode.management.internal.configuration.mutators.PdxManager;
import org.apache.geode.management.internal.configuration.mutators.RegionConfigManager;
import org.apache.geode.management.internal.configuration.validators.CommonConfigurationValidator;
import org.apache.geode.management.internal.configuration.validators.ConfigurationValidator;
import org.apache.geode.management.internal.configuration.validators.DeploymentValidator;
import org.apache.geode.management.internal.configuration.validators.DiskStoreValidator;
import org.apache.geode.management.internal.configuration.validators.GatewayReceiverConfigValidator;
import org.apache.geode.management.internal.configuration.validators.IndexValidator;
import org.apache.geode.management.internal.configuration.validators.MemberValidator;
import org.apache.geode.management.internal.configuration.validators.PdxValidator;
import org.apache.geode.management.internal.configuration.validators.RegionConfigValidator;
import org.apache.geode.management.internal.exceptions.EntityExistsException;
import org.apache.geode.management.internal.functions.CacheRealizationFunction;
import org.apache.geode.management.internal.operation.OperationHistoryManager;
import org.apache.geode.management.internal.operation.OperationManager;
import org.apache.geode.management.internal.operation.OperationState;
import org.apache.geode.management.internal.operation.RegionOperationStateStore;
import org.apache.geode.management.runtime.OperationResult;
import org.apache.geode.management.runtime.RuntimeInfo;
import org.apache.logging.log4j.Logger;

public class LocatorClusterManagementService
implements ClusterManagementService {
    @VisibleForTesting
    public static final String CMS_DLOCK_SERVICE_NAME = "CMS_DLOCK_SERVICE";
    private static final Logger logger = LogService.getLogger();
    private final InternalConfigurationPersistenceService persistenceService;
    private final Map<Class, ConfigurationManager> managers;
    private final Map<Class, ConfigurationValidator> validators;
    private final OperationManager operationManager;
    private final MemberValidator memberValidator;
    private final CommonConfigurationValidator commonValidator;
    private final InternalCache cache;
    private DistributedLockService cmsDlockService;

    public LocatorClusterManagementService(InternalCache cache, InternalConfigurationPersistenceService persistenceService) {
        this(cache, persistenceService, new ConcurrentHashMap<Class, ConfigurationManager>(), new ConcurrentHashMap<Class, ConfigurationValidator>(), new MemberValidator(cache, persistenceService), new CommonConfigurationValidator(), new OperationManager(cache, new OperationHistoryManager(new RegionOperationStateStore(cache), cache)));
        this.managers.put(Region.class, new RegionConfigManager(persistenceService));
        this.managers.put(Pdx.class, new PdxManager(persistenceService));
        this.managers.put(GatewayReceiver.class, new GatewayReceiverConfigManager(persistenceService));
        this.managers.put(Index.class, new IndexConfigManager(persistenceService));
        this.managers.put(Deployment.class, new DeploymentManager(persistenceService));
        this.managers.put(DiskStore.class, new DiskStoreManager(persistenceService));
        this.validators.put(Region.class, new RegionConfigValidator(cache));
        this.validators.put(GatewayReceiver.class, new GatewayReceiverConfigValidator());
        this.validators.put(Pdx.class, new PdxValidator());
        this.validators.put(Index.class, new IndexValidator());
        this.validators.put(Deployment.class, new DeploymentValidator());
        this.validators.put(DiskStore.class, new DiskStoreValidator());
    }

    @VisibleForTesting
    public LocatorClusterManagementService(InternalCache cache, InternalConfigurationPersistenceService persistenceService, Map<Class, ConfigurationManager> managers, Map<Class, ConfigurationValidator> validators, MemberValidator memberValidator, CommonConfigurationValidator commonValidator, OperationManager operationManager) {
        this.cache = cache;
        this.persistenceService = persistenceService;
        this.managers = managers;
        this.validators = validators;
        this.memberValidator = memberValidator;
        this.commonValidator = commonValidator;
        this.operationManager = operationManager;
    }

    @VisibleForTesting
    synchronized DistributedLockService getCmsDlockService() {
        if (this.cmsDlockService == null) {
            this.cmsDlockService = DLockService.getOrCreateService(CMS_DLOCK_SERVICE_NAME, this.cache.getInternalDistributedSystem());
        }
        return this.cmsDlockService;
    }

    private boolean lockCMS() {
        return this.getCmsDlockService().lock(CMS_DLOCK_SERVICE_NAME, -1L, -1L);
    }

    private void unlockCMS() {
        this.getCmsDlockService().unlock(CMS_DLOCK_SERVICE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends AbstractConfiguration<?>> ClusterManagementRealizationResult create(T config) {
        ConfigurationManager<T> configurationManager = this.getConfigurationManager(config);
        if (this.persistenceService == null) {
            return this.assertSuccessful(new ClusterManagementRealizationResult(ClusterManagementResult.StatusCode.ERROR, "Cluster configuration service needs to be enabled."));
        }
        this.lockCMS();
        try {
            Set<DistributedMember> targetedMembers;
            try {
                this.commonValidator.validate(CacheElementOperation.CREATE, config);
                ConfigurationValidator validator = this.validators.get(config.getClass());
                if (validator != null) {
                    validator.validate(CacheElementOperation.CREATE, config);
                }
                if (configurationManager instanceof CacheConfigurationManager) {
                    this.memberValidator.validateCreate(config, (CacheConfigurationManager)configurationManager);
                }
            }
            catch (EntityExistsException e) {
                LocatorClusterManagementService.raise(ClusterManagementResult.StatusCode.ENTITY_EXISTS, e);
            }
            catch (IllegalArgumentException e) {
                LocatorClusterManagementService.raise(ClusterManagementResult.StatusCode.ILLEGAL_ARGUMENT, e);
            }
            Set<Object> groups = new HashSet<String>();
            if (config instanceof RegionScoped) {
                String regionName = ((RegionScoped)config).getRegionName();
                groups = this.memberValidator.findGroups(regionName);
                if (groups.isEmpty()) {
                    LocatorClusterManagementService.raise(ClusterManagementResult.StatusCode.ENTITY_NOT_FOUND, "Region provided does not exist: " + regionName);
                }
                targetedMembers = this.memberValidator.findServers(groups.toArray(new String[0]));
            } else {
                String groupName = AbstractConfiguration.getGroupName((String)config.getGroup());
                groups.add(groupName);
                targetedMembers = this.memberValidator.findServers(groupName);
            }
            ClusterManagementRealizationResult result = new ClusterManagementRealizationResult();
            List functionResults = this.executeCacheRealizationFunction(config, CacheElementOperation.CREATE, targetedMembers);
            functionResults.forEach(arg_0 -> ((ClusterManagementRealizationResult)result).addMemberStatus(arg_0));
            if (result.getStatusCode() != ClusterManagementResult.StatusCode.OK) {
                result.setStatus(ClusterManagementResult.StatusCode.ERROR, "Failed to create on all members.");
                ClusterManagementRealizationResult clusterManagementRealizationResult = this.assertSuccessful(result);
                return clusterManagementRealizationResult;
            }
            ArrayList<String> updatedGroups = new ArrayList<String>();
            ArrayList<String> failedGroups = new ArrayList<String>();
            for (String string : groups) {
                try {
                    configurationManager.add(config, string);
                    updatedGroups.add(string);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    failedGroups.add(string);
                }
            }
            this.setResultStatus(result, updatedGroups, failedGroups);
            if (result.isSuccessful()) {
                result.setLinks(config.getLinks());
            }
            ClusterManagementRealizationResult clusterManagementRealizationResult = this.assertSuccessful(result);
            return clusterManagementRealizationResult;
        }
        finally {
            this.unlockCMS();
        }
    }

    @VisibleForTesting
    void setResultStatus(ClusterManagementRealizationResult result, List<String> updatedGroups, List<String> failedGroups) {
        String successMessage = null;
        String failedMessage = null;
        if (!updatedGroups.isEmpty()) {
            successMessage = "Successfully updated configuration for " + String.join((CharSequence)", ", updatedGroups) + ".";
        }
        if (!failedGroups.isEmpty()) {
            failedMessage = "Failed to update configuration for " + String.join((CharSequence)", ", failedGroups) + ".";
        }
        if (failedMessage == null) {
            result.setStatus(ClusterManagementResult.StatusCode.OK, successMessage);
            return;
        }
        if (successMessage == null) {
            result.setStatus(ClusterManagementResult.StatusCode.FAIL_TO_PERSIST, failedMessage);
            return;
        }
        result.setStatus(ClusterManagementResult.StatusCode.FAIL_TO_PERSIST, successMessage + " " + failedMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends AbstractConfiguration<?>> ClusterManagementRealizationResult delete(T config) {
        CacheConfigurationManager configurationManager = (CacheConfigurationManager)this.getConfigurationManager(config);
        if (this.persistenceService == null) {
            return this.assertSuccessful(new ClusterManagementRealizationResult(ClusterManagementResult.StatusCode.ERROR, "Cluster configuration service needs to be enabled."));
        }
        this.lockCMS();
        try {
            try {
                this.commonValidator.validate(CacheElementOperation.DELETE, config);
                ConfigurationValidator validator = this.validators.get(config.getClass());
                if (validator != null) {
                    validator.validate(CacheElementOperation.DELETE, config);
                }
            }
            catch (IllegalArgumentException e) {
                LocatorClusterManagementService.raise(ClusterManagementResult.StatusCode.ILLEGAL_ARGUMENT, e);
            }
            ClusterManagementRealizationResult groupsWithThisElement = this.memberValidator.findGroupsWithThisElement(config, configurationManager);
            if (((String[])groupsWithThisElement).length == 0) {
                LocatorClusterManagementService.raise(ClusterManagementResult.StatusCode.ENTITY_NOT_FOUND, config.getClass().getSimpleName() + " '" + config.getId() + "' does not exist.");
            }
            ClusterManagementRealizationResult result = new ClusterManagementRealizationResult();
            List functionResults = this.executeCacheRealizationFunction(config, CacheElementOperation.DELETE, this.memberValidator.findServers((String[])groupsWithThisElement));
            functionResults.forEach(arg_0 -> ((ClusterManagementRealizationResult)result).addMemberStatus(arg_0));
            if (result.getStatusCode() != ClusterManagementResult.StatusCode.OK) {
                result.setStatus(ClusterManagementResult.StatusCode.ERROR, "Failed to delete on all members.");
                ClusterManagementRealizationResult clusterManagementRealizationResult = result;
                return clusterManagementRealizationResult;
            }
            ArrayList<String> updatedGroups = new ArrayList<String>();
            ArrayList<String> failedGroups = new ArrayList<String>();
            for (String finalGroup : groupsWithThisElement) {
                try {
                    configurationManager.delete(config, finalGroup);
                    updatedGroups.add(finalGroup);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    failedGroups.add(finalGroup);
                }
            }
            this.setResultStatus(result, updatedGroups, failedGroups);
            ClusterManagementRealizationResult clusterManagementRealizationResult = this.assertSuccessful(result);
            return clusterManagementRealizationResult;
        }
        finally {
            this.unlockCMS();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends AbstractConfiguration<?>> ClusterManagementRealizationResult update(T config) {
        CacheConfigurationManager configurationManager = (CacheConfigurationManager)this.getConfigurationManager(config);
        if (this.persistenceService == null) {
            return this.assertSuccessful(new ClusterManagementRealizationResult(ClusterManagementResult.StatusCode.ERROR, "Cluster configuration service needs to be enabled."));
        }
        this.lockCMS();
        try {
            try {
                this.commonValidator.validate(CacheElementOperation.UPDATE, config);
                ConfigurationValidator validator = this.validators.get(config.getClass());
                if (validator != null) {
                    validator.validate(CacheElementOperation.UPDATE, config);
                }
            }
            catch (IllegalArgumentException e) {
                LocatorClusterManagementService.raise(ClusterManagementResult.StatusCode.ILLEGAL_ARGUMENT, e);
            }
            ClusterManagementRealizationResult groupsWithThisElement = this.memberValidator.findGroupsWithThisElement(config, configurationManager);
            if (((String[])groupsWithThisElement).length == 0) {
                LocatorClusterManagementService.raise(ClusterManagementResult.StatusCode.ENTITY_NOT_FOUND, config.getClass().getSimpleName() + " '" + config.getId() + "' does not exist.");
            }
            ClusterManagementRealizationResult result = new ClusterManagementRealizationResult();
            List functionResults = this.executeCacheRealizationFunction(config, CacheElementOperation.UPDATE, this.memberValidator.findServers((String[])groupsWithThisElement));
            for (RealizationResult funcResult : functionResults) {
                result.addMemberStatus(funcResult);
            }
            if (result.getStatusCode() != ClusterManagementResult.StatusCode.OK) {
                result.setStatus(ClusterManagementResult.StatusCode.ERROR, "Failed to update on all members.");
                ClusterManagementRealizationResult clusterManagementRealizationResult = result;
                return clusterManagementRealizationResult;
            }
            ArrayList<String> updatedGroups = new ArrayList<String>();
            ArrayList<String> failedGroups = new ArrayList<String>();
            for (String groupName : groupsWithThisElement) {
                try {
                    configurationManager.update(config, groupName);
                    updatedGroups.add(groupName);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    failedGroups.add(groupName);
                }
            }
            this.setResultStatus(result, updatedGroups, failedGroups);
            if (result.isSuccessful()) {
                result.setLinks(config.getLinks());
            }
            ClusterManagementRealizationResult clusterManagementRealizationResult = this.assertSuccessful(result);
            return clusterManagementRealizationResult;
        }
        finally {
            this.unlockCMS();
        }
    }

    public <T extends AbstractConfiguration<R>, R extends RuntimeInfo> ClusterManagementListResult<T, R> list(T filter) {
        ClusterManagementListResult result = new ClusterManagementListResult();
        if (this.persistenceService == null) {
            return this.assertSuccessful(new ClusterManagementListResult(ClusterManagementResult.StatusCode.ERROR, "Cluster configuration service needs to be enabled."));
        }
        ArrayList resultList = new ArrayList();
        if (filter instanceof Member) {
            resultList.add(filter);
        } else {
            ConfigurationManager<T> manager = this.getConfigurationManager(filter);
            Set<String> groups = StringUtils.isNotBlank((CharSequence)filter.getGroup()) ? Collections.singleton(filter.getGroup()) : this.persistenceService.getGroups();
            for (String group : groups) {
                List<AbstractConfiguration> list = manager.list(filter, group);
                if (!AbstractConfiguration.isCluster((String)group)) {
                    list.forEach(t -> {
                        if (t instanceof GroupableConfiguration) {
                            ((GroupableConfiguration)t).setGroup(group);
                        }
                    });
                }
                list.stream().filter(t -> !resultList.contains(t)).forEach(resultList::add);
            }
        }
        ArrayList<EntityGroupInfo> responses = new ArrayList<EntityGroupInfo>();
        boolean hasRuntimeInfo = this.hasRuntimeInfo(filter.getClass());
        for (AbstractConfiguration element : resultList) {
            Set<DistributedMember> members;
            EntityGroupInfo response = new EntityGroupInfo(element);
            responses.add(response);
            if (!hasRuntimeInfo || (members = filter instanceof Member ? this.memberValidator.findMembers(filter.getId(), filter.getGroup()) : this.memberValidator.findServers(element)).size() == 0) continue;
            if (element.isGlobalRuntime()) {
                members = Collections.singleton(members.iterator().next());
            }
            List<R> runtimeInfos = this.executeCacheRealizationFunction(element, CacheElementOperation.GET, members);
            response.setRuntimeInfo(runtimeInfos);
        }
        if (filter instanceof Member) {
            List members = ((EntityGroupInfo)responses.get(0)).getRuntimeInfo();
            for (RuntimeInfo memberInfo : members) {
                Member member = new Member();
                member.setId(memberInfo.getMemberName());
                EntityInfo entityInfo = new EntityInfo(memberInfo.getMemberName(), Collections.singletonList(new EntityGroupInfo((AbstractConfiguration)member, Collections.singletonList(memberInfo))));
                result.addEntityInfo(entityInfo);
            }
        } else {
            result.setEntityGroupInfo(responses);
        }
        return this.assertSuccessful(result);
    }

    public <T extends AbstractConfiguration<R>, R extends RuntimeInfo> ClusterManagementGetResult<T, R> get(T config) {
        ClusterManagementListResult<T, R> list = this.list(config);
        List result = list.getResult();
        if (result.size() == 0) {
            LocatorClusterManagementService.raise(ClusterManagementResult.StatusCode.ENTITY_NOT_FOUND, config.getClass().getSimpleName() + " '" + config.getId() + "' does not exist.");
        }
        return new ClusterManagementGetResult((EntityInfo)result.get(0));
    }

    public <A extends ClusterManagementOperation<V>, V extends OperationResult> ClusterManagementOperationResult<A, V> start(A op) {
        OperationState operationState = this.operationManager.submit(op);
        return this.assertSuccessful((ClusterManagementResult)this.toClusterManagementOperationResult(ClusterManagementResult.StatusCode.ACCEPTED, "Operation started.  Use the URI to check its status.", operationState));
    }

    public <A extends ClusterManagementOperation<V>, V extends OperationResult> ClusterManagementListOperationsResult<A, V> list(A opType) {
        return this.assertSuccessful(new ClusterManagementListOperationsResult(this.operationManager.list(opType).stream().map(this::toClusterManagementOperationResult).collect(Collectors.toList())));
    }

    private <A extends ClusterManagementOperation<V>, V extends OperationResult> ClusterManagementOperationResult<A, V> toClusterManagementOperationResult(ClusterManagementResult.StatusCode statusCode, String message, OperationState<A, V> operationState) {
        ClusterManagementOperationResult result = new ClusterManagementOperationResult(statusCode, message, operationState.getOperationStart(), operationState.getOperationEnd(), operationState.getOperation(), operationState.getId(), operationState.getResult(), operationState.getThrowable());
        A operation = operationState.getOperation();
        if (operation != null) {
            result.setLinks(new Links(operationState.getId(), operation.getEndpoint()));
        }
        return result;
    }

    public <A extends ClusterManagementOperation<V>, V extends OperationResult> ClusterManagementOperationResult<A, V> get(A opType, String opId) {
        OperationState operationState = this.operationManager.get(opId);
        if (operationState == null) {
            LocatorClusterManagementService.raise(ClusterManagementResult.StatusCode.ENTITY_NOT_FOUND, "Operation '" + opId + "' does not exist.");
        }
        return this.toClusterManagementOperationResult(operationState);
    }

    public <A extends ClusterManagementOperation<V>, V extends OperationResult> CompletableFuture<ClusterManagementOperationResult<A, V>> getFuture(A opType, String opId) {
        throw new IllegalStateException("This should never be called on locator");
    }

    private <A extends ClusterManagementOperation<V>, V extends OperationResult> ClusterManagementOperationResult<A, V> toClusterManagementOperationResult(OperationState<A, V> operationState) {
        ClusterManagementResult.StatusCode resultStatus = ClusterManagementResult.StatusCode.OK;
        String resultMessage = "";
        if (operationState.getOperationEnd() == null) {
            resultStatus = ClusterManagementResult.StatusCode.IN_PROGRESS;
        } else if (operationState.getThrowable() != null) {
            resultStatus = ClusterManagementResult.StatusCode.ERROR;
            resultMessage = operationState.getThrowable().toString();
        } else if (operationState.getResult() != null) {
            if (!operationState.getResult().getSuccess()) {
                resultStatus = ClusterManagementResult.StatusCode.ERROR;
            }
            if (operationState.getResult().getStatusMessage() != null) {
                resultMessage = operationState.getResult().getStatusMessage();
            }
        }
        return this.toClusterManagementOperationResult(resultStatus, resultMessage, operationState);
    }

    private <T extends ClusterManagementResult> T assertSuccessful(T result) {
        if (!result.isSuccessful()) {
            if (result instanceof ClusterManagementRealizationResult) {
                throw new ClusterManagementRealizationException((ClusterManagementRealizationResult)result);
            }
            throw new ClusterManagementException(result);
        }
        return result;
    }

    private static void raise(ClusterManagementResult.StatusCode statusCode, String statusMessage) {
        throw new ClusterManagementException(new ClusterManagementResult(statusCode, statusMessage));
    }

    private static void raise(ClusterManagementResult.StatusCode statusCode, Exception e) {
        throw new ClusterManagementException(new ClusterManagementResult(statusCode, e.getMessage()), (Throwable)e);
    }

    public boolean isConnected() {
        return true;
    }

    public void close() {
        this.operationManager.close();
    }

    private <T extends AbstractConfiguration> ConfigurationManager<T> getConfigurationManager(T config) {
        ConfigurationManager configurationManager = this.managers.get(config.getClass());
        if (configurationManager == null) {
            LocatorClusterManagementService.raise(ClusterManagementResult.StatusCode.ILLEGAL_ARGUMENT, String.format("%s is not supported.", config.getClass().getSimpleName()));
        }
        return configurationManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    <R> List<R> executeCacheRealizationFunction(AbstractConfiguration configuration, CacheElementOperation operation, Set<DistributedMember> targetMembers) {
        if (targetMembers.size() == 0) {
            return Collections.emptyList();
        }
        HashSet<DistributedMember> targetMemberPRE1_12_0 = new HashSet<DistributedMember>();
        HashSet<DistributedMember> targetMemberPOST1_12_0 = new HashSet<DistributedMember>();
        targetMembers.stream().forEach(member -> {
            if (((InternalDistributedMember)member).getVersion().isOlderThan((Version)KnownVersion.GEODE_1_12_0)) {
                targetMemberPRE1_12_0.add((DistributedMember)member);
            } else {
                targetMemberPOST1_12_0.add((DistributedMember)member);
            }
        });
        File file = null;
        if (configuration instanceof HasFile) {
            file = ((HasFile)configuration).getFile();
        }
        if (file == null) {
            Execution execution;
            CacheRealizationFunction function;
            ArrayList<R> functionResults = new ArrayList<R>();
            if (targetMemberPRE1_12_0.size() > 0) {
                function = new org.apache.geode.management.internal.cli.functions.CacheRealizationFunction();
                execution = FunctionService.onMembers(targetMemberPRE1_12_0).setArguments(Arrays.asList(new Serializable[]{configuration, operation, null}));
                ((AbstractExecution)execution).setIgnoreDepartedMembers(true);
                functionResults.addAll(this.cleanResults((List)execution.execute(function).getResult()));
            }
            if (targetMemberPOST1_12_0.size() > 0) {
                function = new CacheRealizationFunction();
                execution = FunctionService.onMembers(targetMemberPOST1_12_0).setArguments(Arrays.asList(new Serializable[]{configuration, operation, null}));
                ((AbstractExecution)execution).setIgnoreDepartedMembers(true);
                functionResults.addAll(this.cleanResults((List)execution.execute(function).getResult()));
            }
            return functionResults;
        }
        RemoteStreamExporter exporter = null;
        ManagementAgent agent = ((SystemManagementService)ManagementService.getExistingManagementService(this.cache)).getManagementAgent();
        exporter = agent.getRemoteStreamExporter();
        ArrayList<R> results = new ArrayList<R>();
        for (DistributedMember member2 : targetMembers) {
            FileInputStream fileInputStream = null;
            SimpleRemoteInputStream inputStream = null;
            RemoteInputStream remoteInputStream = null;
            try {
                List<R> functionResults;
                fileInputStream = new FileInputStream(file.getAbsolutePath());
                inputStream = new SimpleRemoteInputStream((InputStream)fileInputStream);
                remoteInputStream = (RemoteInputStream)exporter.export((RemoteStreamServer)inputStream);
                Execution execution = FunctionService.onMember(member2).setArguments(Arrays.asList(new Object[]{configuration, operation, remoteInputStream}));
                ((AbstractExecution)execution).setIgnoreDepartedMembers(true);
                if (((InternalDistributedMember)member2).getVersion().isOlderThan((Version)KnownVersion.GEODE_1_12_0)) {
                    function = new org.apache.geode.management.internal.cli.functions.CacheRealizationFunction();
                    functionResults = this.cleanResults((List)execution.execute(function).getResult());
                } else {
                    function = new CacheRealizationFunction();
                    functionResults = this.cleanResults((List)execution.execute(function).getResult());
                }
                results.addAll(functionResults);
            }
            catch (IOException e) {
                LocatorClusterManagementService.raise(ClusterManagementResult.StatusCode.ILLEGAL_ARGUMENT, "Invalid file: " + file.getAbsolutePath());
            }
            finally {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (remoteInputStream == null) continue;
                    remoteInputStream.close(true);
                }
                catch (IOException iOException) {}
            }
        }
        return results;
    }

    @VisibleForTesting
    <R> List<R> cleanResults(List<?> functionResults) {
        ArrayList results = new ArrayList();
        for (Object functionResult : functionResults) {
            if (functionResult == null) continue;
            if (functionResult instanceof Throwable) {
                logger.warn("Error executing CacheRealizationFunction.", (Throwable)functionResult);
                continue;
            }
            results.add(functionResult);
        }
        return results;
    }

    @VisibleForTesting
    Class<?> getRuntimeClass(Class<?> configClass) {
        Type genericSuperclass = configClass.getGenericSuperclass();
        if (genericSuperclass instanceof ParameterizedType) {
            return (Class)((ParameterizedType)genericSuperclass).getActualTypeArguments()[0];
        }
        return null;
    }

    @VisibleForTesting
    boolean hasRuntimeInfo(Class<?> configClass) {
        return !RuntimeInfo.class.equals(this.getRuntimeClass(configClass));
    }
}

