/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class AgentUtil {
    private static final Logger logger = LogService.getLogger();
    private final String gemfireVersion;
    private static final String GEODE_HOME = "GEODE_HOME";

    public AgentUtil(String gemfireVersion) {
        this.gemfireVersion = gemfireVersion;
    }

    public URI findWarLocation(String warFilePrefix) {
        String unversionedWarFileName;
        String versionedWarFileName = warFilePrefix + "-" + this.gemfireVersion + ".war";
        URI possiblePath = this.lookupWarLocationFromClasspath(versionedWarFileName, unversionedWarFileName = warFilePrefix + ".war");
        if (possiblePath != null) {
            logger.info("Located war: {} at location: {}", (Object)warFilePrefix, (Object)possiblePath);
            return possiblePath;
        }
        possiblePath = this.findPossibleWarLocationFromGeodeHome(versionedWarFileName, unversionedWarFileName);
        if (possiblePath != null) {
            logger.info("Located war: {} at location: {}", (Object)warFilePrefix, (Object)possiblePath);
            return possiblePath;
        }
        possiblePath = this.findPossibleWarLocationFromExtraLocations(versionedWarFileName, unversionedWarFileName);
        if (possiblePath != null) {
            logger.info("Located war: {} at location: {}", (Object)warFilePrefix, (Object)possiblePath);
            return possiblePath;
        }
        logger.warn(warFilePrefix + " war file was not found");
        return null;
    }

    private URI findPossibleWarLocationFromExtraLocations(String versionedWarFileName, String unversionedWarFileName) {
        URL url = Arrays.stream(new String[]{versionedWarFileName, "tools/Pulse/" + versionedWarFileName, "tools/Extensions/" + versionedWarFileName, "lib/" + versionedWarFileName, unversionedWarFileName}).map(possibleFile -> this.getClass().getClassLoader().getResource((String)possibleFile)).filter(Objects::nonNull).findFirst().orElse(null);
        URI uri = null;
        if (url != null) {
            try {
                uri = url.toURI();
                logger.info("War file found: {}", (Object)uri.toString());
            }
            catch (URISyntaxException ex) {
                logger.warn("War file URL could not be converted to URI: {}", (Object)url.toString());
            }
        }
        return uri;
    }

    private URI findPossibleWarLocationFromGeodeHome(String versionedWarFileName, String unversionedWarFileName) {
        String[] possibleFiles = new String[]{};
        String geodeHome = this.getGeodeHome();
        if (StringUtils.isNotBlank((CharSequence)geodeHome)) {
            possibleFiles = new String[]{geodeHome + "/tools/Extensions/" + versionedWarFileName, geodeHome + "/tools/Pulse/" + versionedWarFileName, geodeHome + "/lib/" + versionedWarFileName, geodeHome + "/tools/Extensions/" + unversionedWarFileName, geodeHome + "/tools/Pulse/" + unversionedWarFileName, geodeHome + "/lib/" + unversionedWarFileName};
        }
        return this.findPossibleWarLocationFromStream(Arrays.stream(possibleFiles));
    }

    private URI findPossibleWarLocationFromStream(Stream<String> stream) {
        return stream.filter(possiblePath -> new File((String)possiblePath).isFile()).findFirst().map(s -> new File((String)s).toURI()).orElse(null);
    }

    private URI lookupWarLocationFromClasspath(String versionedWarFileName, String unversionedWarFileName) {
        return Arrays.stream(System.getProperty("java.class.path").split(File.pathSeparator)).filter(pathString -> pathString.endsWith(versionedWarFileName) || pathString.endsWith(unversionedWarFileName)).findFirst().map(s -> new File((String)s).toURI()).orElse(null);
    }

    boolean isAnyWarFileAvailable(URI ... warFileLocations) {
        return Arrays.stream(warFileLocations).anyMatch(Objects::nonNull);
    }

    private String getGeodeHome() {
        String geodeHome = System.getenv(GEODE_HOME);
        logger.info("GEODE_HOME:" + geodeHome);
        if (StringUtils.isBlank((CharSequence)geodeHome)) {
            geodeHome = System.getProperty("gemfire.home");
            logger.info("Reading gemfire.home System Property -> {}", (Object)geodeHome);
            if (StringUtils.isBlank((CharSequence)geodeHome)) {
                logger.info("GEODE_HOME environment variable not set; HTTP service will not start.");
                geodeHome = null;
            }
        }
        return geodeHome;
    }

    public boolean isGemfireHomeDefined() {
        String gemfireHome = this.getGeodeHome();
        return StringUtils.isNotBlank((CharSequence)gemfireHome);
    }
}

