/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.logging.internal.log4j;

import java.util.logging.Handler;
import org.apache.geode.LogWriter;
import org.apache.geode.i18n.LogWriterI18n;
import org.apache.geode.i18n.StringId;
import org.apache.geode.internal.logging.GemFireHandler;
import org.apache.geode.internal.logging.InternalLogWriter;
import org.apache.geode.logging.internal.log4j.GemFireLogger;
import org.apache.geode.logging.internal.log4j.LogWriterLevelConverter;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.logging.internal.spi.LogWriterLevel;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.spi.ExtendedLoggerWrapper;

public class LogWriterLogger
extends ExtendedLoggerWrapper
implements InternalLogWriter,
GemFireLogger {
    public static final String SECURITY_PREFIX = "security-";
    private final ExtendedLoggerWrapper logWrapper = this;
    private final String connectionName;
    private final String loggerName;
    private final boolean isSecure;

    private LogWriterLogger(Logger logger, String connectionName, boolean isSecure) {
        super((ExtendedLogger)logger, logger.getName(), logger.getMessageFactory());
        this.connectionName = connectionName;
        this.loggerName = this.getName();
        this.isSecure = isSecure;
    }

    public static LogWriterLogger create(String name, boolean isSecure) {
        return LogWriterLogger.create(name, null, isSecure);
    }

    public static LogWriterLogger create(String name, String connectionName, boolean isSecure) {
        Logger wrapped = LogService.getLogger((String)name);
        return new LogWriterLogger(wrapped, connectionName, isSecure);
    }

    public static LogWriterLogger create(Logger logger) {
        return new LogWriterLogger(logger, null, false);
    }

    public Logger getExtendedLogger() {
        return this.logger;
    }

    @Override
    public void finest(Marker marker, Message message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, marker, message, null);
    }

    @Override
    public void finest(Marker marker, Message message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, marker, message, throwable);
    }

    @Override
    public void finest(Marker marker, Object message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, marker, message, null);
    }

    @Override
    public void finest(Marker marker, Object message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, marker, message, throwable);
    }

    @Override
    public void finest(Marker marker, String message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, marker, message, (Throwable)null);
    }

    @Override
    public void finest(Marker marker, String message, Object ... parameters) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, marker, message, parameters);
    }

    @Override
    public void finest(Marker marker, String message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, marker, message, throwable);
    }

    @Override
    public void finest(Message message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, null, message, null);
    }

    @Override
    public void finest(Message message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, null, message, throwable);
    }

    @Override
    public void finest(Object message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, null, message, null);
    }

    @Override
    public void finest(Object message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, null, message, throwable);
    }

    @Override
    public void finest(String message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, null, message, (Throwable)null);
    }

    @Override
    public void finest(String message, Object ... parameters) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, null, message, parameters);
    }

    @Override
    public void finest(String message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, null, message, throwable);
    }

    @Override
    public void finer(Marker marker, Message message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, marker, message, null);
    }

    @Override
    public void finer(Marker marker, Message message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, marker, message, throwable);
    }

    @Override
    public void finer(Marker marker, Object message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, marker, message, null);
    }

    @Override
    public void finer(Marker marker, Object message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, marker, message, throwable);
    }

    @Override
    public void finer(Marker marker, String message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, marker, message, (Throwable)null);
    }

    @Override
    public void finer(Marker marker, String message, Object ... parameters) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, marker, message, parameters);
    }

    @Override
    public void finer(Marker marker, String message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, marker, message, throwable);
    }

    @Override
    public void finer(Message message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, null, message, null);
    }

    @Override
    public void finer(Message message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, null, message, throwable);
    }

    @Override
    public void finer(Object message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, null, message, null);
    }

    @Override
    public void finer(Object message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, null, message, throwable);
    }

    @Override
    public void finer(String message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, null, message, (Throwable)null);
    }

    @Override
    public void finer(String message, Object ... parameters) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, null, message, parameters);
    }

    @Override
    public void finer(String message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, null, message, throwable);
    }

    @Override
    public void fine(Marker marker, Message message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.DEBUG, marker, message, null);
    }

    @Override
    public void fine(Marker marker, Message message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.DEBUG, marker, message, throwable);
    }

    @Override
    public void fine(Marker marker, Object message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.DEBUG, marker, message, null);
    }

    @Override
    public void fine(Marker marker, Object message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.DEBUG, marker, message, throwable);
    }

    @Override
    public void fine(Marker marker, String message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.DEBUG, marker, message, (Throwable)null);
    }

    @Override
    public void fine(Marker marker, String message, Object ... parameters) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.DEBUG, marker, message, parameters);
    }

    @Override
    public void fine(Marker marker, String message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.DEBUG, marker, message, throwable);
    }

    @Override
    public void fine(Message message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.DEBUG, null, message, null);
    }

    @Override
    public void fine(Message message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.DEBUG, null, message, throwable);
    }

    @Override
    public void fine(Object message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.DEBUG, null, message, null);
    }

    @Override
    public void fine(Object message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.DEBUG, null, message, throwable);
    }

    @Override
    public void fine(String message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.DEBUG, null, message, (Throwable)null);
    }

    @Override
    public void fine(String message, Object ... parameters) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.DEBUG, null, message, parameters);
    }

    @Override
    public void fine(String message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.DEBUG, null, message, throwable);
    }

    @Override
    public void config(Marker marker, Message message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, marker, message, null);
    }

    @Override
    public void config(Marker marker, Message message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, marker, message, throwable);
    }

    @Override
    public void config(Marker marker, Object message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, marker, message, null);
    }

    @Override
    public void config(Marker marker, Object message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, marker, message, throwable);
    }

    @Override
    public void config(Marker marker, String message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, marker, message, (Throwable)null);
    }

    @Override
    public void config(Marker marker, String message, Object ... parameters) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, marker, message, parameters);
    }

    @Override
    public void config(Marker marker, String message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, marker, message, throwable);
    }

    @Override
    public void config(Message message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, null, message, null);
    }

    @Override
    public void config(Message message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, null, message, throwable);
    }

    @Override
    public void config(Object message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, null, message, null);
    }

    @Override
    public void config(Object message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, null, message, throwable);
    }

    @Override
    public void config(String message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, null, message, (Throwable)null);
    }

    @Override
    public void config(String message, Object ... parameters) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, null, message, parameters);
    }

    @Override
    public void config(String message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, null, message, throwable);
    }

    public void info(Marker marker, Message msg) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, marker, msg, null);
    }

    public void info(Marker marker, Message msg, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, marker, msg, t);
    }

    public void info(Marker marker, Object message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, marker, message, null);
    }

    public void info(Marker marker, Object message, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, marker, message, t);
    }

    public void info(Marker marker, String message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, marker, message, (Throwable)null);
    }

    public void info(Marker marker, String message, Object ... params) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, marker, message, params);
    }

    public void info(Marker marker, String message, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, marker, message, t);
    }

    public void info(Message msg) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, null, msg, null);
    }

    public void info(Message msg, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, null, msg, t);
    }

    public void info(Object message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, null, message, null);
    }

    public void info(Object message, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, null, message, t);
    }

    @Override
    public void info(String message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, null, message, (Throwable)null);
    }

    public void info(String message, Object ... params) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, null, message, params);
    }

    @Override
    public void info(String message, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, null, message, t);
    }

    @Override
    public void warning(Marker marker, Message message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.WARN, marker, message, null);
    }

    @Override
    public void warning(Marker marker, Message message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.WARN, marker, message, throwable);
    }

    @Override
    public void warning(Marker marker, Object message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.WARN, marker, message, null);
    }

    @Override
    public void warning(Marker marker, Object message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.WARN, marker, message, throwable);
    }

    @Override
    public void warning(Marker marker, String message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.WARN, marker, message, (Throwable)null);
    }

    @Override
    public void warning(Marker marker, String message, Object ... parameters) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.WARN, marker, message, parameters);
    }

    @Override
    public void warning(Marker marker, String message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.WARN, marker, message, throwable);
    }

    @Override
    public void warning(Message message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.WARN, null, message, null);
    }

    @Override
    public void warning(Message message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.WARN, null, message, throwable);
    }

    @Override
    public void warning(Object message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.WARN, null, message, null);
    }

    @Override
    public void warning(Object message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.WARN, null, message, throwable);
    }

    @Override
    public void warning(String message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.WARN, null, message, (Throwable)null);
    }

    @Override
    public void warning(String message, Object ... parameters) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.WARN, null, message, parameters);
    }

    @Override
    public void warning(String message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.WARN, null, message, throwable);
    }

    public void error(Marker marker, Message msg) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.ERROR, marker, msg, null);
    }

    public void error(Marker marker, Message msg, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.ERROR, marker, msg, t);
    }

    public void error(Marker marker, Object message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.ERROR, marker, message, null);
    }

    public void error(Marker marker, Object message, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.ERROR, marker, message, t);
    }

    public void error(Marker marker, String message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.ERROR, marker, message, (Throwable)null);
    }

    public void error(Marker marker, String message, Object ... params) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.ERROR, marker, message, params);
    }

    public void error(Marker marker, String message, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.ERROR, marker, message, t);
    }

    public void error(Message msg) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.ERROR, null, msg, null);
    }

    public void error(Message msg, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.ERROR, null, msg, t);
    }

    public void error(Object message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.ERROR, null, message, null);
    }

    public void error(Object message, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.ERROR, null, message, t);
    }

    @Override
    public void error(String message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.ERROR, null, message, (Throwable)null);
    }

    public void error(String message, Object ... params) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.ERROR, null, message, params);
    }

    @Override
    public void error(String message, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.ERROR, null, message, t);
    }

    @Override
    public void severe(Marker marker, Message message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.FATAL, marker, message, null);
    }

    @Override
    public void severe(Marker marker, Message message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.FATAL, marker, message, throwable);
    }

    @Override
    public void severe(Marker marker, Object message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.FATAL, marker, message, null);
    }

    @Override
    public void severe(Marker marker, Object message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.FATAL, marker, message, throwable);
    }

    @Override
    public void severe(Marker marker, String message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.FATAL, marker, message, (Throwable)null);
    }

    @Override
    public void severe(Marker marker, String message, Object ... parameters) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.FATAL, marker, message, parameters);
    }

    @Override
    public void severe(Marker marker, String message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.FATAL, marker, message, throwable);
    }

    @Override
    public void severe(Message message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.FATAL, null, message, null);
    }

    @Override
    public void severe(Message message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.FATAL, null, message, throwable);
    }

    @Override
    public void severe(Object message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.FATAL, null, message, null);
    }

    @Override
    public void severe(Object message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.FATAL, null, message, throwable);
    }

    @Override
    public void severe(String message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.FATAL, null, message, (Throwable)null);
    }

    @Override
    public void severe(String message, Object ... parameters) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.FATAL, null, message, parameters);
    }

    @Override
    public void severe(String message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.FATAL, null, message, throwable);
    }

    public void log(int logWriterLevel, String message, Throwable throwable) {
        Level level = LogWriterLevelConverter.toLevel(LogWriterLevel.find(logWriterLevel));
        this.logWrapper.logIfEnabled(this.loggerName, level, null, message, throwable);
    }

    @Override
    public boolean severeEnabled() {
        return this.isEnabled(Level.FATAL);
    }

    @Override
    public boolean errorEnabled() {
        return this.isEnabled(Level.ERROR);
    }

    @Override
    public boolean warningEnabled() {
        return this.isEnabled(Level.WARN);
    }

    @Override
    public boolean infoEnabled() {
        return this.isEnabled(Level.INFO);
    }

    @Override
    public boolean configEnabled() {
        return this.isEnabled(Level.INFO);
    }

    @Override
    public boolean fineEnabled() {
        return this.isEnabled(Level.DEBUG);
    }

    @Override
    public boolean finerEnabled() {
        return this.isEnabled(Level.TRACE);
    }

    @Override
    public boolean finestEnabled() {
        return this.isEnabled(Level.TRACE);
    }

    @Override
    public void entering(String sourceClass, String sourceMethod) {
        this.finer("ENTRY {}:{}", sourceClass, sourceMethod);
    }

    @Override
    public void exiting(String sourceClass, String sourceMethod) {
        this.finer("RETURN {}:{}", sourceClass, sourceMethod);
    }

    @Override
    public void throwing(String sourceClass, String sourceMethod, Throwable thrown) {
        this.finer("THROW {}:{}", sourceClass, sourceMethod, thrown);
    }

    @Override
    public Handler getHandler() {
        return new GemFireHandler(this);
    }

    @Override
    public LogWriterI18n convertToLogWriterI18n() {
        return this;
    }

    @Override
    public void severe(Throwable throwable) {
        this.severe((String)null, throwable);
    }

    @Override
    public void error(Throwable throwable) {
        this.error((String)null, throwable);
    }

    @Override
    public void warning(Throwable throwable) {
        this.warning((String)null, throwable);
    }

    @Override
    public void info(Throwable throwable) {
        this.info((String)null, throwable);
    }

    @Override
    public void config(Throwable throwable) {
        this.config((String)null, throwable);
    }

    @Override
    public void fine(Throwable throwable) {
        this.fine((String)null, throwable);
    }

    @Override
    public void finer(Throwable throwable) {
        this.finer((String)null, throwable);
    }

    @Override
    public void finest(Throwable throwable) {
        this.finest((String)null, throwable);
    }

    @Override
    public void severe(StringId messageId, Object[] parameters, Throwable throwable) {
        if (this.isEnabled(Level.FATAL)) {
            this.severe(messageId.toLocalizedString(parameters), throwable);
        }
    }

    @Override
    public void severe(StringId messageId, Object parameter, Throwable throwable) {
        if (this.isEnabled(Level.FATAL)) {
            this.severe(messageId.toLocalizedString(parameter), throwable);
        }
    }

    @Override
    public void severe(StringId messageId, Throwable throwable) {
        if (this.isEnabled(Level.FATAL)) {
            this.severe(messageId.toLocalizedString(), throwable);
        }
    }

    @Override
    public void severe(StringId messageId, Object[] parameters) {
        if (this.isEnabled(Level.FATAL)) {
            this.severe(messageId.toLocalizedString(parameters));
        }
    }

    @Override
    public void severe(StringId messageId, Object parameter) {
        if (this.isEnabled(Level.FATAL)) {
            this.severe(messageId.toLocalizedString(parameter));
        }
    }

    @Override
    public void severe(StringId messageId) {
        if (this.isEnabled(Level.FATAL)) {
            this.severe(messageId.toLocalizedString());
        }
    }

    @Override
    public void error(StringId messageId, Object[] parameters, Throwable throwable) {
        if (this.isEnabled(Level.ERROR)) {
            this.error(messageId.toLocalizedString(parameters), throwable);
        }
    }

    @Override
    public void error(StringId messageId, Object parameter, Throwable throwable) {
        if (this.isEnabled(Level.ERROR)) {
            this.error(messageId.toLocalizedString(parameter), throwable);
        }
    }

    @Override
    public void error(StringId messageId, Throwable throwable) {
        if (this.isEnabled(Level.ERROR)) {
            this.error(messageId.toLocalizedString(), throwable);
        }
    }

    @Override
    public void error(StringId messageId, Object[] parameters) {
        if (this.isEnabled(Level.ERROR)) {
            this.error(messageId.toLocalizedString(parameters));
        }
    }

    @Override
    public void error(StringId messageId, Object parameter) {
        if (this.isEnabled(Level.ERROR)) {
            this.error(messageId.toLocalizedString(parameter));
        }
    }

    @Override
    public void error(StringId messageId) {
        if (this.isEnabled(Level.ERROR)) {
            this.error(messageId.toLocalizedString());
        }
    }

    @Override
    public void warning(StringId messageId, Object[] parameters, Throwable throwable) {
        if (this.isEnabled(Level.WARN)) {
            this.warning(messageId.toLocalizedString(parameters), throwable);
        }
    }

    @Override
    public void warning(StringId messageId, Object parameter, Throwable throwable) {
        if (this.isEnabled(Level.WARN)) {
            this.warning(messageId.toLocalizedString(parameter), throwable);
        }
    }

    @Override
    public void warning(StringId messageId, Throwable throwable) {
        if (this.isEnabled(Level.WARN)) {
            this.warning(messageId.toLocalizedString(), throwable);
        }
    }

    @Override
    public void warning(StringId messageId, Object[] parameters) {
        if (this.isEnabled(Level.WARN)) {
            this.warning(messageId.toLocalizedString(parameters));
        }
    }

    @Override
    public void warning(StringId messageId, Object parameter) {
        if (this.isEnabled(Level.WARN)) {
            this.warning(messageId.toLocalizedString(parameter));
        }
    }

    @Override
    public void warning(StringId messageId) {
        if (this.isEnabled(Level.WARN)) {
            this.warning(messageId.toLocalizedString());
        }
    }

    @Override
    public void info(StringId messageId, Object[] parameters, Throwable throwable) {
        if (this.isEnabled(Level.INFO)) {
            this.info(messageId.toLocalizedString(parameters), throwable);
        }
    }

    @Override
    public void info(StringId messageId, Object parameter, Throwable throwable) {
        if (this.isEnabled(Level.INFO)) {
            this.info(messageId.toLocalizedString(parameter), throwable);
        }
    }

    @Override
    public void info(StringId messageId, Throwable throwable) {
        if (this.isEnabled(Level.INFO)) {
            this.info(messageId.toLocalizedString(), throwable);
        }
    }

    @Override
    public void info(StringId messageId, Object[] parameters) {
        if (this.isEnabled(Level.INFO)) {
            this.info(messageId.toLocalizedString(parameters));
        }
    }

    @Override
    public void info(StringId messageId, Object parameter) {
        if (this.isEnabled(Level.INFO)) {
            this.info(messageId.toLocalizedString(parameter));
        }
    }

    @Override
    public void info(StringId messageId) {
        if (this.isEnabled(Level.INFO)) {
            this.info(messageId.toLocalizedString());
        }
    }

    @Override
    public void config(StringId messageId, Object[] parameters, Throwable throwable) {
        if (this.isEnabled(Level.INFO)) {
            this.config(messageId.toLocalizedString(parameters), throwable);
        }
    }

    @Override
    public void config(StringId messageId, Object parameter, Throwable throwable) {
        if (this.isEnabled(Level.INFO)) {
            this.config(messageId.toLocalizedString(parameter), throwable);
        }
    }

    @Override
    public void config(StringId messageId, Throwable throwable) {
        if (this.isEnabled(Level.INFO)) {
            this.config(messageId.toLocalizedString(), throwable);
        }
    }

    @Override
    public void config(StringId messageId, Object[] parameters) {
        if (this.isEnabled(Level.INFO)) {
            this.config(messageId.toLocalizedString(parameters));
        }
    }

    @Override
    public void config(StringId messageId, Object parameter) {
        if (this.isEnabled(Level.INFO)) {
            this.config(messageId.toLocalizedString(parameter));
        }
    }

    @Override
    public void config(StringId messageId) {
        if (this.isEnabled(Level.INFO)) {
            this.config(messageId.toLocalizedString());
        }
    }

    @Override
    public LogWriter convertToLogWriter() {
        return this;
    }

    @Override
    public int getLogWriterLevel() {
        Level log4jLevel = this.logWrapper.getLevel();
        if (log4jLevel == Level.OFF) {
            return LogWriterLevel.NONE.intLevel();
        }
        if (log4jLevel == Level.FATAL) {
            return LogWriterLevel.SEVERE.intLevel();
        }
        if (log4jLevel == Level.ERROR) {
            return LogWriterLevel.ERROR.intLevel();
        }
        if (log4jLevel == Level.WARN) {
            return LogWriterLevel.WARNING.intLevel();
        }
        if (log4jLevel == Level.INFO) {
            return LogWriterLevel.INFO.intLevel();
        }
        if (log4jLevel == Level.DEBUG) {
            return LogWriterLevel.FINE.intLevel();
        }
        if (log4jLevel == Level.TRACE) {
            return LogWriterLevel.FINER.intLevel();
        }
        if (log4jLevel == Level.ALL) {
            return LogWriterLevel.ALL.intLevel();
        }
        throw new IllegalStateException("Level " + String.valueOf(log4jLevel) + " could not be mapped to LogWriter level.");
    }

    @Override
    public boolean isSecure() {
        return this.isSecure;
    }

    @Override
    public void put(int messageLevel, String message, Throwable throwable) {
        this.log(messageLevel, message, throwable);
    }

    @Override
    public void put(int messageLevel, StringId messageId, Object[] parameters, Throwable throwable) {
        this.log(messageLevel, messageId.toLocalizedString(parameters), throwable);
    }

    @Override
    public String getConnectionName() {
        return this.connectionName;
    }
}

