/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.geode.DataSerializable;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.cache.Node;
import org.apache.geode.internal.util.Versionable;

public class VersionedArrayList
implements DataSerializable,
Versionable,
Iterable<Node> {
    private static final long serialVersionUID = -1455442285961593385L;
    private long version = -1L;
    private List<Node> list;

    public VersionedArrayList() {
        this.list = new ArrayList<Node>();
    }

    public VersionedArrayList(int size) {
        this.list = new ArrayList<Node>(size);
    }

    public VersionedArrayList(List<? extends Node> list) {
        this.list = Collections.unmodifiableList(list);
        this.incrementVersion();
    }

    public synchronized void add(Node obj) {
        ArrayList<Node> newList = new ArrayList<Node>(this.list);
        newList.add(obj);
        this.list = Collections.unmodifiableList(newList);
        this.incrementVersion();
    }

    public synchronized boolean remove(Node obj) {
        ArrayList<Node> newList = new ArrayList<Node>(this.list);
        boolean ret = newList.remove(obj);
        if (ret) {
            this.list = Collections.unmodifiableList(newList);
            this.incrementVersion();
        }
        return ret;
    }

    @Override
    public synchronized Iterator<Node> iterator() {
        return this.list.iterator();
    }

    public synchronized int size() {
        return this.list.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Node obj) {
        List<Node> l;
        VersionedArrayList versionedArrayList = this;
        synchronized (versionedArrayList) {
            l = this.list;
        }
        return l.contains(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(int i) {
        List<Node> l;
        VersionedArrayList versionedArrayList = this;
        synchronized (versionedArrayList) {
            l = this.list;
        }
        return l.get(i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(Object obj) {
        List<Node> l;
        VersionedArrayList versionedArrayList = this;
        synchronized (versionedArrayList) {
            l = this.list;
        }
        return l.indexOf(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Node> getListCopy() {
        List<Node> l;
        VersionedArrayList versionedArrayList = this;
        synchronized (versionedArrayList) {
            l = this.list;
        }
        return new HashSet<Node>(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        List<Node> l;
        VersionedArrayList versionedArrayList = this;
        synchronized (versionedArrayList) {
            l = this.list;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("ArrayList version = " + String.valueOf(this.getVersion()) + " Elements = { ");
        for (Node node : l) {
            sb.append(node.toString() + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void toData(DataOutput out) throws IOException {
        List<Node> l;
        long v = -1L;
        VersionedArrayList versionedArrayList = this;
        synchronized (versionedArrayList) {
            v = this.version;
            l = this.list;
        }
        out.writeLong(v);
        int s = l.size();
        out.writeInt(s);
        for (Node node : l) {
            InternalDataSerializer.invokeToData(node, out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        ArrayList<Node> l = new ArrayList<Node>();
        long v = in.readLong();
        int size = in.readInt();
        for (int k = 0; k < size; ++k) {
            l.add(new Node(in));
        }
        VersionedArrayList versionedArrayList = this;
        synchronized (versionedArrayList) {
            this.version = v;
            this.list = Collections.unmodifiableList(l);
        }
    }

    @Override
    public synchronized Comparable getVersion() {
        return Long.valueOf(this.version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isNewerThan(Versionable other) {
        if (other instanceof VersionedArrayList) {
            long v = (Long)other.getVersion();
            VersionedArrayList versionedArrayList = this;
            synchronized (versionedArrayList) {
                return this.version > v;
            }
        }
        Comparable o = other.getVersion();
        return this.getVersion().compareTo(o) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOlderThan(Versionable other) {
        if (other instanceof VersionedArrayList) {
            long v;
            Versionable versionable = other;
            synchronized (versionable) {
                v = ((VersionedArrayList)other).version;
            }
            versionable = this;
            synchronized (versionable) {
                return this.version < v;
            }
        }
        Comparable o = other.getVersion();
        return this.getVersion().compareTo(o) < 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSame(Versionable other) {
        if (other instanceof VersionedArrayList) {
            long v;
            Versionable versionable = other;
            synchronized (versionable) {
                v = ((VersionedArrayList)other).version;
            }
            versionable = this;
            synchronized (versionable) {
                return this.version == v;
            }
        }
        Comparable o = other.getVersion();
        return this.getVersion().compareTo(o) == 0;
    }

    private synchronized void incrementVersion() {
        ++this.version;
    }
}

