/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.statistics;

import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.SynchronousQueue;
import org.apache.geode.SystemFailure;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.statistics.ResourceInstance;
import org.apache.geode.internal.statistics.ResourceType;
import org.apache.geode.internal.statistics.SampleHandler;
import org.apache.geode.internal.statistics.StatisticsMonitor;
import org.apache.geode.logging.internal.executors.LoggingThread;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class StatMonitorHandler
implements SampleHandler {
    private static final Logger logger = LogService.getLogger();
    protected static final String ENABLE_MONITOR_THREAD = "gemfire.stats.enableMonitorThread";
    private final boolean enableMonitorThread;
    private final Set<StatisticsMonitor> monitors = ConcurrentHashMap.newKeySet();
    private volatile StatMonitorNotifier notifier;

    public StatMonitorHandler() {
        this.enableMonitorThread = Boolean.getBoolean(ENABLE_MONITOR_THREAD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addMonitor(StatisticsMonitor monitor) {
        StatMonitorHandler statMonitorHandler = this;
        synchronized (statMonitorHandler) {
            boolean added = false;
            if (!this.monitors.contains(monitor)) {
                added = this.monitors.add(monitor);
            }
            if (!this.monitors.isEmpty()) {
                this.startNotifier_IfEnabledAndNotRunning();
            }
            return added;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeMonitor(StatisticsMonitor monitor) {
        StatMonitorHandler statMonitorHandler = this;
        synchronized (statMonitorHandler) {
            boolean removed = false;
            if (this.monitors.contains(monitor)) {
                removed = this.monitors.remove(monitor);
            }
            if (this.monitors.isEmpty()) {
                this.stopNotifier_IfEnabledAndRunning();
            }
            return removed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        StatMonitorHandler statMonitorHandler = this;
        synchronized (statMonitorHandler) {
            this.stopNotifier_IfEnabledAndRunning();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sampled(long nanosTimeStamp, List<ResourceInstance> resourceInstances) {
        StatMonitorHandler statMonitorHandler = this;
        synchronized (statMonitorHandler) {
            if (this.enableMonitorThread) {
                StatMonitorNotifier thread = this.notifier;
                if (thread != null) {
                    try {
                        thread.monitor(new MonitorTask(System.currentTimeMillis(), resourceInstances));
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            } else {
                this.monitor(System.currentTimeMillis(), resourceInstances);
            }
        }
    }

    private void monitor(long sampleTimeMillis, List<ResourceInstance> resourceInstance) {
        for (StatisticsMonitor monitor : this.monitors) {
            try {
                monitor.monitor(sampleTimeMillis, resourceInstance);
            }
            catch (VirtualMachineError e) {
                SystemFailure.initiateFailure(e);
                throw e;
            }
            catch (Error e) {
                SystemFailure.checkFailure();
                logger.warn(LogMarker.STATISTICS_MARKER, "StatisticsMonitor {} threw {}", (Object)monitor, (Object)e.getClass().getSimpleName(), (Object)e);
            }
            catch (RuntimeException e) {
                logger.warn(LogMarker.STATISTICS_MARKER, "StatisticsMonitor {} threw {}", (Object)monitor, (Object)e.getClass().getSimpleName(), (Object)e);
            }
        }
    }

    @Override
    public void allocatedResourceType(ResourceType resourceType) {
    }

    @Override
    public void allocatedResourceInstance(ResourceInstance resourceInstance) {
    }

    @Override
    public void destroyedResourceInstance(ResourceInstance resourceInstance) {
    }

    Set<StatisticsMonitor> getMonitorsSnapshot() {
        return this.monitors;
    }

    StatMonitorNotifier getStatMonitorNotifier() {
        return this.notifier;
    }

    private void startNotifier_IfEnabledAndNotRunning() {
        if (this.enableMonitorThread && this.notifier == null) {
            this.notifier = new StatMonitorNotifier();
            this.notifier.start();
        }
    }

    private void stopNotifier_IfEnabledAndRunning() {
        if (this.enableMonitorThread && this.notifier != null) {
            this.notifier.stop();
            this.notifier = null;
        }
    }

    class StatMonitorNotifier
    implements Runnable {
        private volatile boolean alive;
        private Thread consumer;
        private boolean waiting;
        private Thread producer;
        private final SynchronousQueue<MonitorTask> task = new SynchronousQueue();

        StatMonitorNotifier() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean isDebugEnabled_STATISTICS = logger.isTraceEnabled(LogMarker.STATISTICS_VERBOSE);
            if (isDebugEnabled_STATISTICS) {
                logger.trace(LogMarker.STATISTICS_VERBOSE, "StatMonitorNotifier is starting {}", (Object)this);
            }
            try {
                this.work();
            }
            finally {
                StatMonitorNotifier statMonitorNotifier = this;
                synchronized (statMonitorNotifier) {
                    this.alive = false;
                    if (this.producer != null) {
                        this.producer.interrupt();
                    }
                }
            }
            if (isDebugEnabled_STATISTICS) {
                logger.trace(LogMarker.STATISTICS_VERBOSE, "StatMonitorNotifier is stopping {}", (Object)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void work() {
            boolean working = true;
            while (working) {
                Object object;
                try {
                    MonitorTask latestTask = null;
                    object = this;
                    synchronized (object) {
                        working = this.alive;
                        if (working) {
                            this.waiting = true;
                        }
                    }
                    if (working) {
                        try {
                            latestTask = this.task.take();
                        }
                        finally {
                            object = this;
                            synchronized (object) {
                                this.waiting = false;
                                working = this.alive;
                            }
                        }
                    }
                    if (!working || latestTask == null) continue;
                    for (StatisticsMonitor monitor : StatMonitorHandler.this.monitors) {
                        try {
                            monitor.monitor(latestTask.getSampleTimeMillis(), latestTask.getResourceInstances());
                        }
                        catch (VirtualMachineError e) {
                            SystemFailure.initiateFailure(e);
                            throw e;
                        }
                        catch (Error e) {
                            SystemFailure.checkFailure();
                            logger.warn(LogMarker.STATISTICS_MARKER, "StatisticsMonitor {} threw {}", (Object)monitor, (Object)e.getClass().getSimpleName(), (Object)e);
                        }
                        catch (RuntimeException e) {
                            logger.warn(LogMarker.STATISTICS_MARKER, "StatisticsMonitor {} threw {}", (Object)monitor, (Object)e.getClass().getSimpleName(), (Object)e);
                        }
                    }
                }
                catch (InterruptedException e) {
                    object = this;
                    synchronized (object) {
                        working = false;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void start() {
            StatMonitorNotifier statMonitorNotifier = this;
            synchronized (statMonitorNotifier) {
                if (this.consumer == null) {
                    this.consumer = new LoggingThread(this.toString(), (Runnable)this);
                    this.alive = true;
                    this.consumer.start();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stop() {
            StatMonitorNotifier statMonitorNotifier = this;
            synchronized (statMonitorNotifier) {
                if (this.consumer != null) {
                    this.alive = false;
                    this.consumer.interrupt();
                    this.consumer = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void monitor(MonitorTask task) throws InterruptedException {
            boolean isAlive = false;
            StatMonitorNotifier statMonitorNotifier = this;
            synchronized (statMonitorNotifier) {
                if (this.alive) {
                    isAlive = true;
                    this.producer = Thread.currentThread();
                }
            }
            if (isAlive) {
                try {
                    this.task.put(task);
                }
                catch (InterruptedException interruptedException) {
                    StatMonitorNotifier statMonitorNotifier2 = this;
                    synchronized (statMonitorNotifier2) {
                        this.producer = null;
                    }
                }
                finally {
                    statMonitorNotifier = this;
                    synchronized (statMonitorNotifier) {
                        this.producer = null;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isWaiting() {
            StatMonitorNotifier statMonitorNotifier = this;
            synchronized (statMonitorNotifier) {
                return this.waiting;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isAlive() {
            StatMonitorNotifier statMonitorNotifier = this;
            synchronized (statMonitorNotifier) {
                return this.alive;
            }
        }

        public String toString() {
            return this.getClass().getSimpleName() + " Thread #" + System.identityHashCode(this);
        }
    }

    static class MonitorTask {
        private final long sampleTimeMillis;
        private final List<ResourceInstance> resourceInstances;

        MonitorTask(long sampleTimeMillis, List<ResourceInstance> resourceInstances) {
            this.sampleTimeMillis = sampleTimeMillis;
            this.resourceInstances = resourceInstances;
        }

        long getSampleTimeMillis() {
            return this.sampleTimeMillis;
        }

        List<ResourceInstance> getResourceInstances() {
            return this.resourceInstances;
        }
    }
}

