/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.statistics;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.zip.GZIPOutputStream;
import org.apache.geode.GemFireIOException;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.StatisticDescriptor;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.internal.NanoTimer;
import org.apache.geode.internal.inet.LocalHostUtil;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.statistics.ResourceInstance;
import org.apache.geode.internal.statistics.ResourceType;
import org.apache.geode.internal.statistics.SampleHandler;
import org.apache.geode.internal.statistics.StatArchiveDescriptor;
import org.apache.geode.internal.statistics.StatArchiveFormat;
import org.apache.geode.internal.statistics.StatisticDescriptorImpl;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class StatArchiveWriter
implements StatArchiveFormat,
SampleHandler {
    private static final Logger logger = LogService.getLogger();
    @MakeNotStatic
    private static volatile String traceStatisticsName = null;
    @MakeNotStatic
    private static volatile String traceStatisticsTypeName = null;
    @MakeNotStatic
    private static volatile int traceResourceInstId = -1;
    private final boolean trace = Boolean.getBoolean("gemfire.stats.debug.traceStatArchiveWriter");
    private final Set<ResourceInstance> sampleWrittenForResources = new HashSet<ResourceInstance>();
    private final Set<ResourceInstance> addedResources = new HashSet<ResourceInstance>();
    private final StatArchiveDescriptor archiveDescriptor;
    private long initialDate;
    private final OutputStream outStream;
    private final MyDataOutputStream dataOut;
    private final OutputStream traceOutStream;
    private final PrintStream traceDataOut;
    private long previousMillisTimeStamp;
    private int sampleCount;

    public StatArchiveWriter(StatArchiveDescriptor archiveDescriptor) {
        this.archiveDescriptor = archiveDescriptor;
        if (archiveDescriptor.getArchiveName().endsWith(".gz")) {
            try {
                this.outStream = new GZIPOutputStream((OutputStream)new FileOutputStream(archiveDescriptor.getArchiveName()), 32768);
            }
            catch (IOException ex) {
                throw new GemFireIOException(String.format("Could not open %s", archiveDescriptor.getArchiveName()), ex);
            }
        }
        try {
            this.outStream = new BufferedOutputStream(new FileOutputStream(archiveDescriptor.getArchiveName()), 32768);
        }
        catch (IOException ex) {
            throw new GemFireIOException(String.format("Could not open %s", archiveDescriptor.getArchiveName()), ex);
        }
        this.dataOut = new MyDataOutputStream(this.outStream);
        if (this.trace) {
            String traceFileName = archiveDescriptor.getArchiveName() + ".trace";
            try {
                this.traceOutStream = new BufferedOutputStream(new FileOutputStream(traceFileName), 32768);
            }
            catch (IOException ex) {
                throw new GemFireIOException("Could not open " + traceFileName, ex);
            }
            this.traceDataOut = new PrintStream(this.traceOutStream);
        } else {
            this.traceOutStream = null;
            this.traceDataOut = null;
        }
    }

    public String getArchiveName() {
        return this.archiveDescriptor.getArchiveName();
    }

    public void initialize(long nanosTimeStamp) {
        this.previousMillisTimeStamp = this.initPreviousMillisTimeStamp(nanosTimeStamp);
        this.initialDate = this.initInitialDate();
        this.writeHeader(this.initialDate, this.archiveDescriptor);
    }

    public String toString() {
        return this.getClass().getName() + "@" + System.identityHashCode(this) + "{archiveName=" + this.archiveDescriptor.getArchiveName() + "productDescription=" + this.archiveDescriptor.getProductDescription() + "systemDirectoryPath=" + this.archiveDescriptor.getSystemDirectoryPath() + "systemId=" + this.archiveDescriptor.getSystemId() + "systemStartTime=" + this.archiveDescriptor.getSystemStartTime() + "previousMillisTimeStamp=" + this.previousMillisTimeStamp + "initialDate=" + this.initialDate;
    }

    public void close() {
        try {
            this.dataOut.flush();
            if (this.trace) {
                this.traceDataOut.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.outStream.close();
            if (this.trace) {
                this.traceOutStream.close();
            }
        }
        catch (IOException ex) {
            throw new GemFireIOException("Could not close statArchiver file", ex);
        }
        if (this.getSampleCount() == 0) {
            StatArchiveWriter.deleteFileIfPossible(new File(this.getArchiveName()));
        }
    }

    @SuppressWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"}, justification="Best effort attempt to delete a GFS file without any samples.")
    private static void deleteFileIfPossible(File file) {
        file.delete();
    }

    public long bytesWritten() {
        return this.dataOut.getBytesWritten();
    }

    protected long initPreviousMillisTimeStamp(long nanosTimeStamp) {
        return NanoTimer.nanosToMillis(nanosTimeStamp);
    }

    protected long initInitialDate() {
        return System.currentTimeMillis();
    }

    protected TimeZone getTimeZone() {
        return Calendar.getInstance().getTimeZone();
    }

    protected String getOSInfo() {
        return System.getProperty("os.name") + " " + System.getProperty("os.version");
    }

    protected String getMachineInfo() {
        Object machineInfo = System.getProperty("os.arch");
        try {
            String hostName = LocalHostUtil.getLocalHostName();
            machineInfo = (String)machineInfo + " " + hostName;
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return machineInfo;
    }

    private void writeHeader(long initialDate, StatArchiveDescriptor archiveDescriptor) {
        if (logger.isTraceEnabled(LogMarker.STATISTICS_VERBOSE)) {
            logger.trace(LogMarker.STATISTICS_VERBOSE, "StatArchiveWriter#writeHeader initialDate={} archiveDescriptor={}", (Object)initialDate, (Object)archiveDescriptor);
        }
        try {
            this.dataOut.writeByte(77);
            this.dataOut.writeByte(4);
            this.dataOut.writeLong(initialDate);
            this.dataOut.writeLong(archiveDescriptor.getSystemId());
            this.dataOut.writeLong(archiveDescriptor.getSystemStartTime());
            TimeZone timeZone = this.getTimeZone();
            this.dataOut.writeInt(timeZone.getRawOffset());
            this.dataOut.writeUTF(timeZone.getID());
            this.dataOut.writeUTF(archiveDescriptor.getSystemDirectoryPath());
            this.dataOut.writeUTF(archiveDescriptor.getProductDescription());
            this.dataOut.writeUTF(this.getOSInfo());
            this.dataOut.writeUTF(this.getMachineInfo());
            if (this.trace) {
                this.traceDataOut.println("writeHeader traceStatisticsName: " + traceStatisticsName);
                this.traceDataOut.println("writeHeader traceStatisticsTypeName: " + traceStatisticsTypeName);
                this.traceDataOut.println("writeHeader#writeByte HEADER_TOKEN: 77");
                this.traceDataOut.println("writeHeader#writeByte ARCHIVE_VERSION: 4");
                this.traceDataOut.println("writeHeader#writeLong initialDate: " + initialDate);
                this.traceDataOut.println("writeHeader#writeLong archiveDescriptor.getSystemId(): " + archiveDescriptor.getSystemId());
                this.traceDataOut.println("writeHeader#writeLong archiveDescriptor.getSystemStartTime(): " + archiveDescriptor.getSystemStartTime());
                this.traceDataOut.println("writeHeader#writeInt timeZone.getRawOffset(): " + timeZone.getRawOffset());
                this.traceDataOut.println("writeHeader#writeUTF timeZone.getID(): " + timeZone.getID());
                this.traceDataOut.println("writeHeader#writeUTF archiveDescriptor.getSystemDirectoryPath(): " + archiveDescriptor.getSystemDirectoryPath());
                this.traceDataOut.println("writeHeader#writeUTF archiveDescriptor.getProductDescription(): " + archiveDescriptor.getProductDescription());
                this.traceDataOut.println("writeHeader#writeUTF getOSInfo(): " + this.getOSInfo());
                this.traceDataOut.println("writeHeader#writeUTF getMachineInfo(): " + this.getMachineInfo());
            }
        }
        catch (IOException ex) {
            throw new GemFireIOException("Failed writing header to statistic archive", ex);
        }
    }

    @Override
    public void allocatedResourceType(ResourceType resourceType) {
        if (logger.isTraceEnabled(LogMarker.STATISTICS_VERBOSE)) {
            logger.trace(LogMarker.STATISTICS_VERBOSE, "StatArchiveWriter#allocatedResourceType resourceType={}", (Object)resourceType);
        }
        if (resourceType.getStatisticDescriptors().length >= 255) {
            throw new InternalGemFireException(String.format("Could not archive type %s because it had more than %s statistics.", resourceType.getStatisticsType().getName(), 254));
        }
        try {
            this.dataOut.writeByte(1);
            this.dataOut.writeInt(resourceType.getId());
            this.dataOut.writeUTF(resourceType.getStatisticsType().getName());
            this.dataOut.writeUTF(resourceType.getStatisticsType().getDescription());
            StatisticDescriptor[] stats = resourceType.getStatisticDescriptors();
            this.dataOut.writeShort(stats.length);
            if (this.trace && (traceStatisticsTypeName == null || traceStatisticsTypeName.equals(resourceType.getStatisticsType().getName()))) {
                this.traceDataOut.println("allocatedResourceType#writeByte RESOURCE_TYPE_TOKEN: 1");
                this.traceDataOut.println("allocatedResourceType#writeInt resourceType.getId(): " + resourceType.getId());
                this.traceDataOut.println("allocatedResourceType#writeUTF resourceType.getStatisticsType().getName(): " + resourceType.getStatisticsType().getName());
                this.traceDataOut.println("allocatedResourceType#writeUTF resourceType.getStatisticsType().getDescription(): " + resourceType.getStatisticsType().getDescription());
                this.traceDataOut.println("allocatedResourceType#writeShort stats.length: " + stats.length);
            }
            for (StatisticDescriptor stat : stats) {
                this.dataOut.writeUTF(stat.getName());
                this.dataOut.writeByte(((StatisticDescriptorImpl)stat).getTypeCode());
                this.dataOut.writeBoolean(stat.isCounter());
                this.dataOut.writeBoolean(stat.isLargerBetter());
                this.dataOut.writeUTF(stat.getUnit());
                this.dataOut.writeUTF(stat.getDescription());
                if (!this.trace || traceStatisticsTypeName != null && !traceStatisticsTypeName.equals(resourceType.getStatisticsType().getName())) continue;
                this.traceDataOut.println("allocatedResourceType#writeUTF stats[i].getName(): " + stat.getName());
                this.traceDataOut.println("allocatedResourceType#writeByte ((StatisticDescriptorImpl)stats[i]).getTypeCode(): " + ((StatisticDescriptorImpl)stat).getTypeCode());
                this.traceDataOut.println("allocatedResourceType#writeBoolean stats[i].isCounter(): " + stat.isCounter());
                this.traceDataOut.println("allocatedResourceType#writeBoolean stats[i].isLargerBetter(): " + stat.isLargerBetter());
                this.traceDataOut.println("allocatedResourceType#writeUTF stats[i].getUnit(): " + stat.getUnit());
                this.traceDataOut.println("allocatedResourceType#writeUTF stats[i].getDescription(): " + stat.getDescription());
            }
        }
        catch (IOException ex) {
            throw new GemFireIOException("Failed writing new resource type to statistic archive", ex);
        }
    }

    @Override
    @SuppressWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="This is only for debugging and there is never more than one instance being traced because there is only one stat sampler.")
    public void allocatedResourceInstance(ResourceInstance statResource) {
        if (logger.isTraceEnabled(LogMarker.STATISTICS_VERBOSE)) {
            logger.trace(LogMarker.STATISTICS_VERBOSE, "StatArchiveWriter#allocatedResourceInstance statResource={}", (Object)statResource);
        }
        if (statResource.getResourceType().getStatisticDescriptors().length >= 255) {
            throw new InternalGemFireException(String.format("Could not archive type %s because it had more than %s statistics.", statResource.getResourceType().getStatisticsType().getName(), 254));
        }
        if (statResource.getStatistics().isClosed()) {
            return;
        }
        this.addedResources.add(statResource);
        try {
            this.dataOut.writeByte(2);
            this.dataOut.writeInt(statResource.getId());
            this.dataOut.writeUTF(statResource.getStatistics().getTextId());
            this.dataOut.writeLong(statResource.getStatistics().getNumericId());
            this.dataOut.writeInt(statResource.getResourceType().getId());
            if (this.trace && (traceStatisticsName == null || traceStatisticsName.equals(statResource.getStatistics().getTextId())) && (traceStatisticsTypeName == null || traceStatisticsTypeName.equals(statResource.getResourceType().getStatisticsType().getName()))) {
                traceResourceInstId = statResource.getId();
                this.traceDataOut.println("writeHeader traceResourceInstId: " + traceResourceInstId);
                this.traceDataOut.println("allocatedResourceInstance#writeByte RESOURCE_INSTANCE_CREATE_TOKEN: 2");
                this.traceDataOut.println("allocatedResourceInstance#writeInt statResource.getId(): " + statResource.getId());
                this.traceDataOut.println("allocatedResourceInstance#writeUTF statResource.getStatistics().getTextId(): " + statResource.getStatistics().getTextId());
                this.traceDataOut.println("allocatedResourceInstance#writeLong statResource.getStatistics().getNumericId(): " + statResource.getStatistics().getNumericId());
                this.traceDataOut.println("allocatedResourceInstance#writeInt statResource.getResourceType().getId(): " + statResource.getResourceType().getId());
            }
        }
        catch (IOException ex) {
            throw new GemFireIOException("Failed writing new resource instance to statistic archive", ex);
        }
    }

    @Override
    public void destroyedResourceInstance(ResourceInstance resourceInstance) {
        if (logger.isTraceEnabled(LogMarker.STATISTICS_VERBOSE)) {
            logger.trace(LogMarker.STATISTICS_VERBOSE, "StatArchiveWriter#destroyedResourceInstance resourceInstance={}", (Object)resourceInstance);
        }
        if (!this.addedResources.contains(resourceInstance)) {
            return;
        }
        this.sampleWrittenForResources.remove(resourceInstance);
        this.addedResources.remove(resourceInstance);
        try {
            this.dataOut.writeByte(3);
            this.dataOut.writeInt(resourceInstance.getId());
            if (this.trace && (traceStatisticsName == null || traceStatisticsName.equals(resourceInstance.getStatistics().getTextId())) && (traceStatisticsTypeName == null || traceStatisticsTypeName.equals(resourceInstance.getResourceType().getStatisticsType().getName()))) {
                this.traceDataOut.println("destroyedResourceInstance#writeByte RESOURCE_INSTANCE_DELETE_TOKEN: 3");
                this.traceDataOut.println("destroyedResourceInstance#writeInt resourceInstance.getId(): " + resourceInstance.getId());
            }
        }
        catch (IOException ex) {
            throw new GemFireIOException("Failed writing delete resource instance to statistic archive", ex);
        }
    }

    static long calcDelta(long previousMillis, long currentMillis) {
        long delta = currentMillis - previousMillis;
        if (delta <= 0L) {
            throw new IllegalArgumentException("Sample timestamp must be greater than previous timestamp (millisTimeStamp is " + currentMillis + ", previousMillis is " + previousMillis + " and delta is " + delta + ").");
        }
        return delta;
    }

    private void writeTimeStamp(long nanosTimeStamp) throws IOException {
        long millisTimeStamp = NanoTimer.nanosToMillis(nanosTimeStamp);
        long delta = StatArchiveWriter.calcDelta(this.previousMillisTimeStamp, millisTimeStamp);
        if (logger.isTraceEnabled(LogMarker.STATISTICS_VERBOSE)) {
            logger.trace(LogMarker.STATISTICS_VERBOSE, "StatArchiveWriter#writeTimeStamp millisTimeStamp={}, delta={}", (Object)millisTimeStamp, (Object)((int)delta));
        }
        if (delta > 65534L) {
            if (delta > Integer.MAX_VALUE) {
                throw new InternalGemFireException(String.format("timeStamp delta %s was greater than %s", delta, Integer.MAX_VALUE));
            }
            this.dataOut.writeShort(65535);
            this.dataOut.writeInt((int)delta);
            if (this.trace) {
                this.traceDataOut.println("writeTimeStamp#writeShort INT_TIMESTAMP_TOKEN: 65535");
                this.traceDataOut.println("writeTimeStamp#writeInt (int)delta: " + (int)delta);
            }
        } else {
            this.dataOut.writeShort((int)delta);
            if (this.trace) {
                this.traceDataOut.println("writeTimeStamp#writeShort (int)delta: " + (int)delta);
            }
        }
        this.previousMillisTimeStamp = millisTimeStamp;
    }

    private void writeResourceInst(int instId) throws IOException {
        if (logger.isTraceEnabled(LogMarker.STATISTICS_VERBOSE)) {
            logger.trace(LogMarker.STATISTICS_VERBOSE, "StatArchiveWriter#writeResourceInst instId={}", (Object)instId);
        }
        if (instId > 252) {
            if (instId > 65535) {
                this.dataOut.writeByte(254);
                this.dataOut.writeInt(instId);
                if (this.trace && (traceResourceInstId == -1 || traceResourceInstId == instId)) {
                    this.traceDataOut.println("writeResourceInst#writeByte INT_RESOURCE_INST_ID_TOKEN: 254");
                    this.traceDataOut.println("writeResourceInst#writeInt instId: " + instId);
                }
            } else {
                this.dataOut.writeByte(253);
                this.dataOut.writeShort(instId);
                if (this.trace && (traceResourceInstId == -1 || traceResourceInstId == instId)) {
                    this.traceDataOut.println("writeResourceInst#writeByte SHORT_RESOURCE_INST_ID_TOKEN: 253");
                    this.traceDataOut.println("writeResourceInst#writeShort instId: " + instId);
                }
            }
        } else {
            this.dataOut.writeByte(instId);
            if (this.trace && (traceResourceInstId == -1 || traceResourceInstId == instId)) {
                if (instId == -1) {
                    this.traceDataOut.println("writeResourceInst#writeByte ILLEGAL_RESOURCE_INST_ID: -1");
                } else {
                    this.traceDataOut.println("writeResourceInst#writeByte instId: " + instId);
                }
            }
        }
    }

    @Override
    public void sampled(long nanosTimeStamp, List<ResourceInstance> resourceInstances) {
        if (logger.isTraceEnabled(LogMarker.STATISTICS_VERBOSE)) {
            logger.trace(LogMarker.STATISTICS_VERBOSE, "StatArchiveWriter#sampled nanosTimeStamp={}, resourceInstances={}", (Object)nanosTimeStamp, resourceInstances);
        }
        try {
            this.dataOut.writeByte(0);
            if (this.trace) {
                this.traceDataOut.println("sampled#writeByte SAMPLE_TOKEN: 0");
            }
            this.writeTimeStamp(nanosTimeStamp);
            for (ResourceInstance ri : resourceInstances) {
                ri.setStatValuesNotified(true);
                this.writeSample(ri);
            }
            this.writeResourceInst(-1);
            this.dataOut.flush();
            if (this.trace) {
                this.traceDataOut.flush();
            }
        }
        catch (IOException ex) {
            throw new GemFireIOException("Failed writing sample to statistic archive", ex);
        }
        ++this.sampleCount;
    }

    public int getSampleCount() {
        return this.sampleCount;
    }

    private void writeSample(ResourceInstance ri) throws IOException {
        boolean isDebugEnabled_STATISTICS = logger.isTraceEnabled(LogMarker.STATISTICS_VERBOSE);
        if (isDebugEnabled_STATISTICS) {
            logger.trace(LogMarker.STATISTICS_VERBOSE, "StatArchiveWriter#writeSample ri={}", (Object)ri);
        }
        if (this.trace && (traceStatisticsName == null || traceStatisticsName.equals(ri.getStatistics().getTextId())) && (traceStatisticsTypeName == null || traceStatisticsTypeName.equals(ri.getResourceType().getStatisticsType().getName()))) {
            this.traceDataOut.println("writeSample#writeSample for ri=" + String.valueOf(ri));
        }
        if (ri.getStatistics().isClosed()) {
            return;
        }
        StatisticDescriptor[] stats = ri.getResourceType().getStatisticDescriptors();
        if (stats.length > 254) {
            throw new Error("StatisticsType " + ri.getResourceType().getStatisticsType().getName() + " has too many stats: " + stats.length);
        }
        boolean wroteInstId = false;
        boolean checkForChange = true;
        if (!this.sampleWrittenForResources.contains(ri)) {
            checkForChange = false;
            this.sampleWrittenForResources.add(ri);
        }
        long[] previousStatValues = ri.getPreviousStatValues();
        if (isDebugEnabled_STATISTICS) {
            logger.trace(LogMarker.STATISTICS_VERBOSE, "StatArchiveWriter#writeSample checkForChange={}, previousStatValues={}, stats.length={}", (Object)checkForChange, (Object)Arrays.toString(previousStatValues), (Object)stats.length);
        }
        if (previousStatValues == null) {
            previousStatValues = new long[stats.length];
            ri.setPreviousStatValues(previousStatValues);
        }
        int statsWritten = 0;
        try {
            block7: for (int i = 0; i < stats.length; ++i) {
                long delta;
                long value = ri.getLatestStatValues()[i];
                if (checkForChange && value == previousStatValues[i]) continue;
                long l = delta = checkForChange ? value - previousStatValues[i] : value;
                if (!wroteInstId) {
                    wroteInstId = true;
                    this.writeResourceInst(ri.getId());
                }
                this.dataOut.writeByte(i);
                if (this.trace && (traceStatisticsName == null || traceStatisticsName.equals(ri.getStatistics().getTextId())) && (traceStatisticsTypeName == null || traceStatisticsTypeName.equals(ri.getResourceType().getStatisticsType().getName()))) {
                    this.traceDataOut.println("writeSample#writeByte i: " + i);
                }
                if (isDebugEnabled_STATISTICS) {
                    logger.trace(LogMarker.STATISTICS_VERBOSE, "StatArchiveWriter#writeStatValue stats[{}]={}, delta={}", (Object)i, (Object)stats[i], (Object)delta);
                }
                StatArchiveWriter.writeStatValue(stats[i], delta, (DataOutput)this.dataOut);
                if (!this.trace || traceStatisticsName != null && !traceStatisticsName.equals(ri.getStatistics().getTextId()) || traceStatisticsTypeName != null && !traceStatisticsTypeName.equals(ri.getResourceType().getStatisticsType().getName())) continue;
                byte typeCode = ((StatisticDescriptorImpl)stats[i]).getTypeCode();
                switch (typeCode) {
                    case 3: {
                        this.traceDataOut.println("writeStatValue#writeByte " + StatArchiveWriter.typeCodeToString(typeCode) + " delta: " + delta);
                        continue block7;
                    }
                    case 4: {
                        this.traceDataOut.println("writeStatValue#writeShort" + StatArchiveWriter.typeCodeToString(typeCode) + " delta: " + delta);
                        continue block7;
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        this.traceDataOut.println("writeStatValue#writeCompactValue " + StatArchiveWriter.typeCodeToString(typeCode) + " delta: " + delta);
                        continue block7;
                    }
                }
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (wroteInstId) {
            this.dataOut.writeByte(255);
            if (this.trace && (traceStatisticsName == null || traceStatisticsName.equals(ri.getStatistics().getTextId())) && (traceStatisticsTypeName == null || traceStatisticsTypeName.equals(ri.getResourceType().getStatisticsType().getName()))) {
                this.traceDataOut.println("writeSample#writeByte ILLEGAL_STAT_OFFSET: 255");
            }
        }
        if (isDebugEnabled_STATISTICS) {
            logger.trace(LogMarker.STATISTICS_VERBOSE, "StatArchiveWriter#writeSample statsWritten={}", (Object)statsWritten);
        }
    }

    public static void writeCompactValue(long v, DataOutput dataOut) throws IOException {
        if (v <= 127L && v >= -121L) {
            dataOut.writeByte((int)v);
        } else if (v <= 32767L && v >= -32768L) {
            dataOut.writeByte(-128);
            dataOut.writeShort((int)v);
        } else {
            byte[] buffer = new byte[8];
            int idx = 0;
            long originalValue = v;
            if (v < 0L) {
                while (v != -1L && v != 0L) {
                    buffer[idx++] = (byte)(v & 0xFFL);
                    v >>= 8;
                }
                if (v == 0L) {
                    while (buffer[idx - 1] == -1) {
                        --idx;
                    }
                }
                if ((buffer[idx - 1] & 0x80) == 0) {
                    buffer[idx++] = -1;
                }
            } else {
                while (v != 0L) {
                    buffer[idx++] = (byte)(v & 0xFFL);
                    v >>= 8;
                }
                if ((buffer[idx - 1] & 0x80) != 0) {
                    buffer[idx++] = 0;
                }
            }
            if (idx <= 2) {
                throw new InternalGemFireException(String.format("Expected idx to be greater than 2. It was %s for the value %s", idx, originalValue));
            }
            int token = -128 + (idx - 2);
            dataOut.writeByte(token);
            for (int i = idx - 1; i >= 0; --i) {
                dataOut.writeByte(buffer[i]);
            }
        }
    }

    public static long readCompactValue(DataInput dataIn) throws IOException {
        long v = dataIn.readByte();
        boolean dump = false;
        if (dump) {
            System.out.print("compactValue(byte1)=" + v);
        }
        if (v < -121L) {
            if (v == -128L) {
                v = dataIn.readShort();
                if (dump) {
                    System.out.print("compactValue(short)=" + v);
                }
            } else {
                int bytesToRead = (byte)v - -128 + 2;
                v = dataIn.readByte();
                if (dump) {
                    System.out.print("compactValue(" + bytesToRead + ")=" + v);
                }
                --bytesToRead;
                while (bytesToRead > 0) {
                    v <<= 8;
                    v |= (long)dataIn.readUnsignedByte();
                    --bytesToRead;
                }
            }
        }
        return v;
    }

    protected static void writeStatValue(StatisticDescriptor f, long v, DataOutput dataOut) throws IOException {
        byte typeCode = ((StatisticDescriptorImpl)f).getTypeCode();
        StatArchiveWriter.writeStatValue(typeCode, v, dataOut);
    }

    public static void writeStatValue(byte typeCode, long v, DataOutput dataOut) throws IOException {
        switch (typeCode) {
            case 3: {
                dataOut.writeByte((int)v);
                break;
            }
            case 4: {
                dataOut.writeShort((int)v);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                StatArchiveWriter.writeCompactValue(v, dataOut);
                break;
            }
            default: {
                throw new InternalGemFireException(String.format("Unexpected type code %s", typeCode));
            }
        }
    }

    protected static void setTraceFilter(String traceStatisticsName, String traceStatisticsTypeName) {
        StatArchiveWriter.traceStatisticsName = traceStatisticsName;
        StatArchiveWriter.traceStatisticsTypeName = traceStatisticsTypeName;
        traceResourceInstId = -1;
    }

    protected static void clearTraceFilter() {
        traceStatisticsName = null;
        traceStatisticsTypeName = null;
        traceResourceInstId = -1;
    }

    private static String typeCodeToString(byte typeCode) {
        switch (typeCode) {
            case 3: {
                return "BYTE_CODE";
            }
            case 4: {
                return "SHORT_CODE";
            }
            case 5: {
                return "INT_CODE";
            }
            case 7: {
                return "FLOAT_CODE";
            }
            case 6: {
                return "LONG_CODE";
            }
            case 8: {
                return "DOUBLE_CODE";
            }
        }
        return "unknown typeCode " + typeCode;
    }

    private static class MyDataOutputStream
    implements DataOutput {
        private long bytesWritten = 0L;
        private final DataOutputStream dataOut;

        public MyDataOutputStream(OutputStream out) {
            this.dataOut = new DataOutputStream(out);
        }

        public long getBytesWritten() {
            return this.bytesWritten;
        }

        public void flush() throws IOException {
            this.dataOut.flush();
        }

        public void close() throws IOException {
            this.dataOut.close();
        }

        @Override
        public void write(int b) throws IOException {
            throw new RuntimeException("method unimplemented");
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            throw new RuntimeException("method unimplemented");
        }

        @Override
        public void write(byte[] b) throws IOException {
            throw new RuntimeException("method unimplemented");
        }

        @Override
        public void writeBytes(String v) throws IOException {
            throw new RuntimeException("method unimplemented");
        }

        @Override
        public void writeChar(int v) throws IOException {
            throw new RuntimeException("method unimplemented");
        }

        @Override
        public void writeChars(String v) throws IOException {
            throw new RuntimeException("method unimplemented");
        }

        @Override
        public void writeDouble(double v) throws IOException {
            throw new RuntimeException("method unimplemented");
        }

        @Override
        public void writeFloat(float v) throws IOException {
            throw new RuntimeException("method unimplemented");
        }

        @Override
        public void writeBoolean(boolean v) throws IOException {
            this.dataOut.writeBoolean(v);
            ++this.bytesWritten;
        }

        @Override
        public void writeByte(int v) throws IOException {
            this.dataOut.writeByte(v);
            ++this.bytesWritten;
        }

        @Override
        public void writeShort(int v) throws IOException {
            this.dataOut.writeShort(v);
            this.bytesWritten += 2L;
        }

        @Override
        public void writeInt(int v) throws IOException {
            this.dataOut.writeInt(v);
            this.bytesWritten += 4L;
        }

        @Override
        public void writeLong(long v) throws IOException {
            this.dataOut.writeLong(v);
            this.bytesWritten += 8L;
        }

        @Override
        public void writeUTF(String v) throws IOException {
            this.dataOut.writeUTF(v);
            this.bytesWritten += (long)(v.length() + 2);
        }
    }
}

