/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.statistics;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.geode.CancelCriterion;
import org.apache.geode.Statistics;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.GemFireVersion;
import org.apache.geode.internal.admin.ListenerIdMap;
import org.apache.geode.internal.admin.remote.StatListenerMessage;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.statistics.HostStatSampler;
import org.apache.geode.internal.statistics.LocalStatListener;
import org.apache.geode.internal.statistics.LocalStatisticsImpl;
import org.apache.geode.internal.statistics.OsStatisticsProvider;
import org.apache.geode.internal.statistics.StatSamplerStats;
import org.apache.geode.internal.statistics.StatisticDescriptorImpl;
import org.apache.geode.internal.statistics.StatisticsConfig;
import org.apache.geode.internal.statistics.StatisticsImpl;
import org.apache.geode.internal.statistics.StatisticsManager;
import org.apache.geode.internal.statistics.platform.OsStatisticsFactory;
import org.apache.geode.internal.statistics.platform.ProcessStats;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.logging.internal.spi.LogFile;
import org.apache.logging.log4j.Logger;

public class GemFireStatSampler
extends HostStatSampler {
    private static final Logger logger = LogService.getLogger();
    private final ListenerIdMap listeners = new ListenerIdMap();
    private final Map<LocalStatListenerImpl, Boolean> localListeners = new ConcurrentHashMap<LocalStatListenerImpl, Boolean>();
    private final Map<InternalDistributedMember, List<RemoteStatListenerImpl>> recipientToListeners = new HashMap<InternalDistributedMember, List<RemoteStatListenerImpl>>();
    private final long systemId;
    private final StatisticsConfig statisticsConfig;
    private final StatisticsManager statisticsManager;
    private final DistributionManager distributionManager;
    private int nextListenerId = 1;
    private ProcessStats processStats;
    private final OsStatisticsProvider osStatisticsProvider = OsStatisticsProvider.build();

    public GemFireStatSampler(InternalDistributedSystem internalDistributedSystem) {
        this(internalDistributedSystem, null);
    }

    public GemFireStatSampler(InternalDistributedSystem internalDistributedSystem, LogFile logFile) {
        this(internalDistributedSystem.getCancelCriterion(), new StatSamplerStats(internalDistributedSystem, internalDistributedSystem.getStatisticsManager().getPid()), logFile, internalDistributedSystem.getStatisticsConfig(), internalDistributedSystem.getStatisticsManager(), internalDistributedSystem.getDistributionManager(), internalDistributedSystem.getId());
    }

    @VisibleForTesting
    public GemFireStatSampler(CancelCriterion cancelCriterion, StatSamplerStats statSamplerStats, LogFile logFile, StatisticsConfig statisticsConfig, StatisticsManager statisticsManager, DistributionManager distributionManager, long systemId) {
        super(cancelCriterion, statSamplerStats, logFile);
        this.systemId = systemId;
        this.statisticsConfig = statisticsConfig;
        this.statisticsManager = statisticsManager;
        this.distributionManager = distributionManager;
    }

    public ProcessStats getProcessStats() {
        return this.processStats;
    }

    @Override
    public String getProductDescription() {
        return "GemFire " + GemFireVersion.getGemFireVersion() + " #" + GemFireVersion.getBuildId() + " as of " + GemFireVersion.getSourceDate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addListener(InternalDistributedMember recipient, long resourceId, String statName) {
        int result = this.getNextListenerId();
        ListenerIdMap listenerIdMap = this.listeners;
        synchronized (listenerIdMap) {
            while (this.listeners.get(result) != null) {
                result = this.getNextListenerId();
            }
            RemoteStatListenerImpl remoteStatListener = RemoteStatListenerImpl.create(result, recipient, resourceId, statName, this);
            this.listeners.put(result, remoteStatListener);
            List remoteStatListenerList = this.recipientToListeners.computeIfAbsent(recipient, k -> new ArrayList());
            remoteStatListenerList.add(remoteStatListener);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListener(int listenerId) {
        ListenerIdMap listenerIdMap = this.listeners;
        synchronized (listenerIdMap) {
            RemoteStatListenerImpl remoteStatListener = (RemoteStatListenerImpl)this.listeners.remove(listenerId);
            if (remoteStatListener != null) {
                List<RemoteStatListenerImpl> remoteStatListenerList = this.recipientToListeners.get(remoteStatListener.getRecipient());
                remoteStatListenerList.remove(remoteStatListener);
            }
            return remoteStatListener != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListenersByRecipient(InternalDistributedMember recipient) {
        ListenerIdMap listenerIdMap = this.listeners;
        synchronized (listenerIdMap) {
            List<RemoteStatListenerImpl> remoteStatListenerList = this.recipientToListeners.get(recipient);
            if (remoteStatListenerList != null && remoteStatListenerList.size() != 0) {
                for (RemoteStatListenerImpl sl : remoteStatListenerList) {
                    this.listeners.remove(sl.getListenerId());
                }
                this.recipientToListeners.remove(recipient);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLocalStatListener(LocalStatListener l, Statistics stats, String statName) {
        Class<LocalStatListenerImpl> clazz = LocalStatListenerImpl.class;
        synchronized (LocalStatListenerImpl.class) {
            LocalStatListenerImpl localStatListener = LocalStatListenerImpl.create(l, stats, statName);
            // ** MonitorExit[var5_4] (shouldn't be in output)
            this.localListeners.put(localStatListener, Boolean.TRUE);
            return;
        }
    }

    public boolean removeLocalStatListener(LocalStatListener listener) {
        Iterator<Map.Entry<LocalStatListenerImpl, Boolean>> iterator = this.localListeners.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<LocalStatListenerImpl, Boolean> entry = iterator.next();
            if (!listener.equals(entry.getKey().getListener())) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public Set<LocalStatListenerImpl> getLocalListeners() {
        return this.localListeners.keySet();
    }

    @Override
    public File getArchiveFileName() {
        return this.statisticsConfig.getStatisticArchiveFile();
    }

    @Override
    public long getArchiveFileSizeLimit() {
        if (this.fileSizeLimitInKB()) {
            return (long)this.statisticsConfig.getArchiveFileSizeLimit() * 1024L;
        }
        return (long)this.statisticsConfig.getArchiveFileSizeLimit() * 0x100000L;
    }

    @Override
    public long getArchiveDiskSpaceLimit() {
        if (this.fileSizeLimitInKB()) {
            return (long)this.statisticsConfig.getArchiveDiskSpaceLimit() * 1024L;
        }
        return (long)this.statisticsConfig.getArchiveDiskSpaceLimit() * 0x100000L;
    }

    @Override
    public long getSystemId() {
        return this.systemId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void checkListeners() {
        this.checkLocalListeners();
        ListenerIdMap listenerIdMap = this.listeners;
        synchronized (listenerIdMap) {
            if (this.listeners.size() == 0) {
                return;
            }
            long timeStamp = System.currentTimeMillis();
            for (Map.Entry<InternalDistributedMember, List<RemoteStatListenerImpl>> internalDistributedMemberListEntry : this.recipientToListeners.entrySet()) {
                if (this.stopRequested()) {
                    return;
                }
                Map.Entry<InternalDistributedMember, List<RemoteStatListenerImpl>> entry = internalDistributedMemberListEntry;
                List<RemoteStatListenerImpl> remoteStatListenerList = entry.getValue();
                if (remoteStatListenerList.size() <= 0) continue;
                InternalDistributedMember recipient = entry.getKey();
                StatListenerMessage statListenerMessage = StatListenerMessage.create(timeStamp, remoteStatListenerList.size());
                statListenerMessage.setRecipient(recipient);
                for (RemoteStatListenerImpl statListener : remoteStatListenerList) {
                    if (this.getStatisticsManager().statisticsExists(statListener.getStatId())) {
                        statListener.checkForChange(statListenerMessage);
                        continue;
                    }
                    statListenerMessage.addChange(-statListener.getListenerId(), 0.0);
                }
                this.distributionManager.putOutgoing(statListenerMessage);
            }
        }
    }

    @Override
    protected int getSampleRate() {
        return this.statisticsConfig.getStatisticSampleRate();
    }

    @Override
    public boolean isSamplingEnabled() {
        return this.statisticsConfig.getStatisticSamplingEnabled();
    }

    @Override
    protected StatisticsManager getStatisticsManager() {
        return this.statisticsManager;
    }

    @Override
    protected OsStatisticsFactory getOsStatisticsFactory() {
        return this.statisticsManager;
    }

    @Override
    protected void initProcessStats(long id) {
        if (this.osStatisticsProvider.osStatsSupported()) {
            if (this.osStatsDisabled()) {
                logger.info(LogMarker.STATISTICS_MARKER, "OS statistic collection disabled by setting the osStatsDisabled system property to true.");
            } else {
                int retVal = this.osStatisticsProvider.initOSStats();
                if (retVal != 0) {
                    logger.error(LogMarker.STATISTICS_MARKER, "OS statistics failed to initialize properly, some stats may be missing. See bugnote #37160.");
                }
                this.osStatisticsProvider.newSystem(this.getOsStatisticsFactory(), id);
                Object statName = this.getStatisticsManager().getName();
                if (statName == null || ((String)statName).length() == 0) {
                    statName = "javaApp" + this.getSystemId();
                }
                Statistics stats = this.osStatisticsProvider.newProcess(this.getOsStatisticsFactory(), id, (String)statName + "-proc");
                this.processStats = this.osStatisticsProvider.newProcessStats(stats);
            }
        }
    }

    @Override
    protected void sampleProcessStats(boolean prepareOnly) {
        if (prepareOnly || this.osStatsDisabled() || !this.osStatisticsProvider.osStatsSupported()) {
            return;
        }
        List<Statistics> statisticsList = this.getStatisticsManager().getStatsList();
        if (statisticsList == null) {
            return;
        }
        if (this.stopRequested()) {
            return;
        }
        this.osStatisticsProvider.readyRefreshOSStats();
        for (Statistics statistics : statisticsList) {
            if (this.stopRequested()) {
                return;
            }
            StatisticsImpl statisticsImpl = (StatisticsImpl)statistics;
            if (!statisticsImpl.usesSystemCalls()) continue;
            this.osStatisticsProvider.refresh((LocalStatisticsImpl)statisticsImpl);
        }
    }

    @Override
    protected void closeProcessStats() {
        if (this.osStatisticsProvider.osStatsSupported() && !this.osStatsDisabled()) {
            if (this.processStats != null) {
                this.processStats.close();
            }
            this.osStatisticsProvider.closeOSStats();
        }
    }

    private void checkLocalListeners() {
        for (LocalStatListenerImpl localStatListener : this.localListeners.keySet()) {
            if (!this.getStatisticsManager().statisticsExists(localStatListener.getStatId())) continue;
            localStatListener.checkForChange();
        }
    }

    private int getNextListenerId() {
        int result = this.nextListenerId++;
        if (this.nextListenerId < 0) {
            this.nextListenerId = 1;
        }
        return result;
    }

    protected static abstract class RemoteStatListenerImpl
    extends StatListenerImpl {
        private int listenerId;
        private InternalDistributedMember recipient;

        protected RemoteStatListenerImpl() {
        }

        public int hashCode() {
            return this.listenerId;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o instanceof RemoteStatListenerImpl) {
                return this.listenerId == ((RemoteStatListenerImpl)o).listenerId;
            }
            return false;
        }

        public int getListenerId() {
            return this.listenerId;
        }

        public InternalDistributedMember getRecipient() {
            return this.recipient;
        }

        static RemoteStatListenerImpl create(int listenerId, InternalDistributedMember recipient, long resourceId, String statName, HostStatSampler sampler) {
            RemoteStatListenerImpl result = null;
            Statistics stats = sampler.getStatisticsManager().findStatisticsByUniqueId(resourceId);
            if (stats == null) {
                throw new RuntimeException("Could not find statistics instance with unique id " + resourceId);
            }
            StatisticDescriptorImpl stat = (StatisticDescriptorImpl)stats.nameToDescriptor(statName);
            switch (stat.getTypeCode()) {
                case 6: {
                    result = new LongStatListenerImpl();
                    break;
                }
                case 8: {
                    result = new DoubleStatListenerImpl();
                    break;
                }
                default: {
                    throw new RuntimeException(String.format("Illegal field type %s for statistic", stats.getType()));
                }
            }
            result.stats = stats;
            result.stat = stat;
            result.listenerId = listenerId;
            result.recipient = recipient;
            return result;
        }

        public void checkForChange(StatListenerMessage msg) {
            long currentValue = this.stats.getRawBits(this.stat);
            if (this.oldValueInitialized) {
                if (currentValue == this.oldValue) {
                    return;
                }
            } else {
                this.oldValueInitialized = true;
            }
            this.oldValue = currentValue;
            msg.addChange(this.listenerId, this.getBitsAsDouble(currentValue));
        }
    }

    protected static abstract class LocalStatListenerImpl
    extends StatListenerImpl {
        private LocalStatListener listener;

        protected LocalStatListenerImpl() {
        }

        public LocalStatListener getListener() {
            return this.listener;
        }

        static LocalStatListenerImpl create(LocalStatListener l, Statistics stats, String statName) {
            LocalStatListenerImpl result = null;
            StatisticDescriptorImpl stat = (StatisticDescriptorImpl)stats.nameToDescriptor(statName);
            switch (stat.getTypeCode()) {
                case 6: {
                    result = new LocalLongStatListenerImpl();
                    break;
                }
                case 8: {
                    result = new LocalDoubleStatListenerImpl();
                    break;
                }
                default: {
                    throw new RuntimeException("Illegal field type " + String.valueOf(stats.getType()) + " for statistic");
                }
            }
            result.stats = stats;
            result.stat = stat;
            result.listener = l;
            return result;
        }

        public void checkForChange() {
            long currentValue = this.stats.getRawBits(this.stat);
            if (this.oldValueInitialized) {
                if (currentValue == this.oldValue) {
                    return;
                }
            } else {
                this.oldValueInitialized = true;
            }
            this.oldValue = currentValue;
            this.listener.statValueChanged(this.getBitsAsDouble(currentValue));
        }
    }

    protected static class DoubleStatListenerImpl
    extends RemoteStatListenerImpl {
        protected DoubleStatListenerImpl() {
        }

        @Override
        protected double getBitsAsDouble(long bits) {
            return Double.longBitsToDouble(bits);
        }
    }

    protected static class LongStatListenerImpl
    extends RemoteStatListenerImpl {
        protected LongStatListenerImpl() {
        }

        @Override
        protected double getBitsAsDouble(long bits) {
            return bits;
        }
    }

    protected static class LocalDoubleStatListenerImpl
    extends LocalStatListenerImpl {
        protected LocalDoubleStatListenerImpl() {
        }

        @Override
        protected double getBitsAsDouble(long bits) {
            return Double.longBitsToDouble(bits);
        }
    }

    protected static class LocalLongStatListenerImpl
    extends LocalStatListenerImpl {
        protected LocalLongStatListenerImpl() {
        }

        @Override
        protected double getBitsAsDouble(long bits) {
            return bits;
        }
    }

    protected static abstract class StatListenerImpl {
        protected Statistics stats;
        protected StatisticDescriptorImpl stat;
        protected boolean oldValueInitialized;
        protected long oldValue;

        protected StatListenerImpl() {
        }

        public long getStatId() {
            if (this.stats.isClosed()) {
                return -1L;
            }
            return this.stats.getUniqueId();
        }

        protected abstract double getBitsAsDouble(long var1);
    }
}

