/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.sequencelog.visualization.text;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.geode.internal.sequencelog.GraphType;
import org.apache.geode.internal.sequencelog.io.Filter;
import org.apache.geode.internal.sequencelog.io.InputStreamReader;
import org.apache.geode.internal.sequencelog.model.GraphReaderCallback;

public class TextDisplay {
    public static void main(String[] args) throws IOException {
        File[] files;
        if (args.length > 0) {
            files = new File[args.length];
            for (int i = 0; i < args.length; ++i) {
                files[i] = new File(args[i]);
            }
        } else {
            files = new File[]{new File("states.graph")};
        }
        for (File file : files) {
            System.out.println("FILE: " + String.valueOf(file));
            try (FileInputStream fileInputStream = new FileInputStream(file);
                 BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);){
                InputStreamReader reader = new InputStreamReader(bufferedInputStream);
                reader.addToGraphs(new GraphReaderCallback(){

                    @Override
                    public void addEdge(long timestamp, GraphType graphType, String graphName, String edgeName, String state, String source, String dest) {
                        System.out.println(timestamp + ": (" + String.valueOf((Object)graphType) + ", " + graphName + ", " + edgeName + ", " + state + ", " + source + ", " + dest + ")");
                    }

                    @Override
                    public void addEdgePattern(long timestamp, GraphType graphType, Pattern graphNamePattern, String edgeName, String state, String source, String dest) {
                        System.out.println(timestamp + ": (" + String.valueOf((Object)graphType) + ", " + String.valueOf(graphNamePattern) + ", " + edgeName + ", " + state + ", " + source + ", " + dest + ")");
                    }
                }, new Filter(){

                    @Override
                    public boolean accept(GraphType graphType, String name, String edgeName, String source, String dest) {
                        return true;
                    }

                    @Override
                    public boolean acceptPattern(GraphType graphType, Pattern pattern, String edgeName, String source, String dest) {
                        return true;
                    }
                });
            }
        }
    }
}

