/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.security.shiro;

import java.security.Principal;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.remote.JMXAuthenticator;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.JMXPrincipal;
import javax.security.auth.Subject;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.internal.security.shiro.ShiroPrincipal;
import org.apache.geode.security.AuthenticationFailedException;

public class JMXShiroAuthenticator
implements JMXAuthenticator,
NotificationListener {
    private final SecurityService securityService;
    private final Map<String, org.apache.shiro.subject.Subject> connectedUsers = new ConcurrentHashMap<String, org.apache.shiro.subject.Subject>();

    public JMXShiroAuthenticator(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Override
    public Subject authenticate(Object credentials) {
        Object username;
        Properties credProps = new Properties();
        if (credentials instanceof String[]) {
            String[] aCredentials = (String[])credentials;
            username = aCredentials[0];
            credProps.setProperty("security-username", aCredentials[0]);
            credProps.setProperty("security-password", aCredentials[1]);
        } else if (credentials instanceof String) {
            username = "token-" + credentials.hashCode();
            credProps.setProperty("security-token", (String)credentials);
        } else {
            throw new AuthenticationFailedException("Missing Credentials. Please supply username/password.");
        }
        org.apache.shiro.subject.Subject shiroSubject = this.securityService.login(credProps);
        Principal principal = shiroSubject == null ? new JMXPrincipal((String)username) : new ShiroPrincipal(shiroSubject);
        return new Subject(true, Collections.singleton(principal), Collections.emptySet(), Collections.emptySet());
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        if (notification instanceof JMXConnectionNotification) {
            JMXConnectionNotification cxNotification = (JMXConnectionNotification)notification;
            String type = cxNotification.getType();
            String connectionId = cxNotification.getConnectionId();
            if ("jmx.remote.connection.opened".equals(type)) {
                this.connectedUsers.put(connectionId, this.securityService.getSubject());
            } else if ("jmx.remote.connection.closed".equals(type)) {
                org.apache.shiro.subject.Subject subject = this.connectedUsers.remove(connectionId);
                this.securityService.bindSubject(subject);
                this.securityService.logout();
            }
        }
    }
}

