/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.process;

import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.lang3.Validate;
import org.apache.geode.internal.process.ConnectionFailedException;
import org.apache.geode.internal.process.MBeanControllerParameters;
import org.apache.geode.internal.process.MBeanInvocationFailedException;
import org.apache.geode.internal.process.ProcessController;
import org.apache.geode.internal.process.UnableToControlProcessException;

class MBeanProcessController
implements ProcessController {
    private static final String PROPERTY_LOCAL_CONNECTOR_ADDRESS = "com.sun.management.jmxremote.localConnectorAddress";
    private static final Object[] PARAMS = new Object[0];
    private static final String[] SIGNATURE = new String[0];
    private final MBeanControllerParameters arguments;
    private final int pid;
    private JMXConnector jmxc;
    private MBeanServerConnection server;

    MBeanProcessController(MBeanControllerParameters arguments, int pid) {
        Validate.notNull((Object)arguments, (String)("Invalid arguments '" + String.valueOf(arguments) + "' specified"), (Object[])new Object[0]);
        Validate.isTrue((pid > 0 ? 1 : 0) != 0, (String)("Invalid pid '" + pid + "' specified"), (Object[])new Object[0]);
        this.pid = pid;
        this.arguments = arguments;
    }

    @Override
    public int getProcessId() {
        return this.pid;
    }

    @Override
    public String status() throws UnableToControlProcessException, ConnectionFailedException, IOException, MBeanInvocationFailedException {
        return this.status(this.arguments.getNamePattern(), this.arguments.getPidAttribute(), this.arguments.getStatusMethod(), this.arguments.getAttributes(), this.arguments.getValues());
    }

    @Override
    public void stop() throws UnableToControlProcessException, ConnectionFailedException, IOException, MBeanInvocationFailedException {
        this.stop(this.arguments.getNamePattern(), this.arguments.getPidAttribute(), this.arguments.getStopMethod(), this.arguments.getAttributes(), this.arguments.getValues());
    }

    @Override
    public void checkPidSupport() {
    }

    private void stop(ObjectName namePattern, String pidAttribute, String stopMethod, String[] attributes, Object[] values) throws ConnectionFailedException, IOException, MBeanInvocationFailedException {
        this.invokeOperationOnTargetMBean(namePattern, pidAttribute, stopMethod, attributes, values);
    }

    private String status(ObjectName namePattern, String pidAttribute, String statusMethod, String[] attributes, Object[] values) throws ConnectionFailedException, IOException, MBeanInvocationFailedException {
        return this.invokeOperationOnTargetMBean(namePattern, pidAttribute, statusMethod, attributes, values).toString();
    }

    private Object invokeOperationOnTargetMBean(ObjectName namePattern, String pidAttribute, String methodName, String[] attributes, Object[] values) throws ConnectionFailedException, IOException, MBeanInvocationFailedException {
        ObjectName objectName = namePattern;
        this.connect();
        try {
            QueryExp constraint = this.buildQueryExp(pidAttribute, attributes, values);
            Set<ObjectName> mbeanNames = this.server.queryNames(namePattern, constraint);
            if (mbeanNames.isEmpty()) {
                throw new MBeanInvocationFailedException("Failed to find mbean matching '" + String.valueOf(namePattern) + "' with attribute '" + pidAttribute + "' of value '" + this.pid + "'");
            }
            if (mbeanNames.size() > 1) {
                throw new MBeanInvocationFailedException("Found more than one mbean matching '" + String.valueOf(namePattern) + "' with attribute '" + pidAttribute + "' of value '" + this.pid + "'");
            }
            objectName = mbeanNames.iterator().next();
            Object object = this.invoke(objectName, methodName);
            return object;
        }
        catch (InstanceNotFoundException | MBeanException | ReflectionException e) {
            throw new MBeanInvocationFailedException("Failed to invoke " + methodName + " on " + String.valueOf(objectName), e);
        }
        finally {
            this.disconnect();
        }
    }

    private void connect() throws ConnectionFailedException, IOException {
        try {
            JMXServiceURL jmxUrl = this.getJMXServiceURL();
            this.jmxc = JMXConnectorFactory.connect(jmxUrl);
            this.server = this.jmxc.getMBeanServerConnection();
        }
        catch (AttachNotSupportedException e) {
            throw new ConnectionFailedException("Failed to connect to process '" + this.pid + "'", e);
        }
    }

    private void disconnect() {
        this.server = null;
        if (this.jmxc != null) {
            try {
                this.jmxc.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.jmxc = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JMXServiceURL getJMXServiceURL() throws AttachNotSupportedException, IOException {
        String connectorAddress;
        VirtualMachine vm = VirtualMachine.attach(String.valueOf(this.pid));
        try {
            Properties agentProps = vm.getAgentProperties();
            connectorAddress = agentProps.getProperty(PROPERTY_LOCAL_CONNECTOR_ADDRESS);
            if (connectorAddress == null) {
                vm.startLocalManagementAgent();
                agentProps = vm.getAgentProperties();
                connectorAddress = agentProps.getProperty(PROPERTY_LOCAL_CONNECTOR_ADDRESS);
            }
        }
        finally {
            vm.detach();
        }
        if (connectorAddress == null) {
            throw new IOException("Failed to find address to attach to process");
        }
        return new JMXServiceURL(connectorAddress);
    }

    private QueryExp buildQueryExp(String pidAttribute, String[] attributes, Object[] values) {
        QueryExp optionalAttributes = this.buildOptionalQueryExp(attributes, values);
        QueryExp constraint = optionalAttributes != null ? Query.and(optionalAttributes, Query.eq(Query.attr(pidAttribute), Query.value(this.pid))) : Query.eq(Query.attr(pidAttribute), Query.value(this.pid));
        return constraint;
    }

    private QueryExp buildOptionalQueryExp(String[] attributes, Object[] values) {
        QueryExp queryExp = null;
        for (int i = 0; i < attributes.length; ++i) {
            if (values[i] instanceof Boolean) {
                if (queryExp == null) {
                    queryExp = Query.eq(Query.attr(attributes[i]), Query.value((Boolean)values[i]));
                    continue;
                }
                queryExp = Query.and(queryExp, Query.eq(Query.attr(attributes[i]), Query.value((Boolean)values[i])));
                continue;
            }
            if (values[i] instanceof Number) {
                if (queryExp == null) {
                    queryExp = Query.eq(Query.attr(attributes[i]), Query.value((Number)values[i]));
                    continue;
                }
                queryExp = Query.and(queryExp, Query.eq(Query.attr(attributes[i]), Query.value((Number)values[i])));
                continue;
            }
            if (!(values[i] instanceof String)) continue;
            queryExp = queryExp == null ? Query.eq(Query.attr(attributes[i]), Query.value((String)values[i])) : Query.and(queryExp, Query.eq(Query.attr(attributes[i]), Query.value((String)values[i])));
        }
        return queryExp;
    }

    private Object invoke(ObjectName objectName, String method) throws InstanceNotFoundException, IOException, MBeanException, ReflectionException {
        return this.server.invoke(objectName, method, PARAMS, SIGNATURE);
    }
}

