/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.process;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.commons.lang3.Validate;
import org.apache.geode.distributed.AbstractLauncher;
import org.apache.geode.internal.process.ControlFileWatchdog;
import org.apache.geode.internal.process.ControlNotificationHandler;
import org.apache.geode.internal.process.ControllableProcess;
import org.apache.geode.internal.process.FileAlreadyExistsException;
import org.apache.geode.internal.process.LocalProcessLauncher;
import org.apache.geode.internal.process.PidUnavailableException;
import org.apache.geode.internal.process.ProcessType;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class FileControllableProcess
implements ControllableProcess {
    private static final Logger logger = LogService.getLogger();
    private final File directory;
    private final LocalProcessLauncher launcher;
    private final ControlFileWatchdog stopRequestFileWatchdog;
    private final ControlFileWatchdog statusRequestFileWatchdog;

    public FileControllableProcess(ControlNotificationHandler handler, File directory, ProcessType processType, boolean force) throws FileAlreadyExistsException, IOException, PidUnavailableException {
        this(directory, processType, force, FileControllableProcess.createPidFile(directory, processType), FileControllableProcess.createStopHandler(handler), FileControllableProcess.createStatusHandler(handler, directory, processType));
    }

    private FileControllableProcess(File directory, ProcessType processType, boolean force, File pidFile, ControlFileWatchdog.ControlRequestHandler stopHandler, ControlFileWatchdog.ControlRequestHandler statusHandler) throws FileAlreadyExistsException, IOException, PidUnavailableException {
        this(directory, processType, FileControllableProcess.createLocalProcessLauncher(pidFile, force), FileControllableProcess.createStopRequestFileWatchdog(directory, processType, stopHandler), FileControllableProcess.createStatusRequestFileWatchdog(directory, processType, statusHandler));
    }

    FileControllableProcess(File directory, ProcessType processType, LocalProcessLauncher launcher, ControlFileWatchdog stopRequestFileWatchdog, ControlFileWatchdog statusRequestFileWatchdog) {
        Validate.notNull((Object)directory, (String)("Invalid directory '" + String.valueOf(directory) + "' specified"), (Object[])new Object[0]);
        Validate.notNull((Object)((Object)processType), (String)("Invalid processType '" + String.valueOf((Object)processType) + "' specified"), (Object[])new Object[0]);
        Validate.notNull((Object)launcher, (String)("Invalid launcher '" + String.valueOf(launcher) + "' specified"), (Object[])new Object[0]);
        Validate.notNull((Object)stopRequestFileWatchdog, (String)("Invalid stopRequestFileWatchdog '" + String.valueOf(stopRequestFileWatchdog) + "' specified"), (Object[])new Object[0]);
        Validate.notNull((Object)statusRequestFileWatchdog, (String)("Invalid statusRequestFileWatchdog '" + String.valueOf(statusRequestFileWatchdog) + "' specified"), (Object[])new Object[0]);
        this.directory = directory;
        this.launcher = launcher;
        this.stopRequestFileWatchdog = stopRequestFileWatchdog;
        this.statusRequestFileWatchdog = statusRequestFileWatchdog;
        logger.info("Creating {} for stop and status support in {}.", (Object)this.getClass().getSimpleName(), (Object)directory);
        this.deleteFiles(directory, processType);
        stopRequestFileWatchdog.start();
        statusRequestFileWatchdog.start();
    }

    @Override
    public int getPid() {
        return this.launcher.getPid();
    }

    @Override
    public File getPidFile() {
        return this.launcher.getPidFile();
    }

    @Override
    public File getDirectory() {
        return this.directory;
    }

    @Override
    public void stop() {
        boolean interrupted = false;
        try {
            interrupted = this.stop(this.statusRequestFileWatchdog);
            interrupted = this.stop(this.stopRequestFileWatchdog) || interrupted;
            this.launcher.close();
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public void stop(boolean deletePidFileOnStop) {
        boolean interrupted = false;
        try {
            interrupted = this.stop(this.statusRequestFileWatchdog);
            interrupted = this.stop(this.stopRequestFileWatchdog) || interrupted;
            this.launcher.close(deletePidFileOnStop);
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private boolean stop(ControlFileWatchdog fileWatchdog) {
        boolean interrupted = false;
        try {
            fileWatchdog.stop();
        }
        catch (InterruptedException e) {
            interrupted = true;
            logger.warn("Interrupted while stopping status handler for controllable process.", (Throwable)e);
        }
        return interrupted;
    }

    private void deleteFiles(File directory, ProcessType processType) {
        try {
            FileControllableProcess.deleteFileWithValidation(new File(directory, processType.getStatusRequestFileName()), "statusRequestFile");
            FileControllableProcess.deleteFileWithValidation(new File(directory, processType.getStatusFileName()), "statusFile");
            FileControllableProcess.deleteFileWithValidation(new File(directory, processType.getStopRequestFileName()), "stopRequestFile");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static File createPidFile(File directory, ProcessType processType) {
        return new File(directory, processType.getPidFileName());
    }

    private static LocalProcessLauncher createLocalProcessLauncher(File pidFile, boolean force) throws FileAlreadyExistsException, IOException, PidUnavailableException {
        return new LocalProcessLauncher(pidFile, force);
    }

    private static ControlFileWatchdog.ControlRequestHandler createStopHandler(ControlNotificationHandler handler) {
        return handler::handleStop;
    }

    private static ControlFileWatchdog.ControlRequestHandler createStatusHandler(ControlNotificationHandler handler, File directory, ProcessType processType) {
        return () -> FileControllableProcess.writeStatusToFile(FileControllableProcess.fetchStatusWithValidation(handler), directory, processType);
    }

    private static ControlFileWatchdog createStopRequestFileWatchdog(File directory, ProcessType processType, ControlFileWatchdog.ControlRequestHandler stopHandler) {
        return new ControlFileWatchdog(directory, processType.getStopRequestFileName(), stopHandler, false);
    }

    private static ControlFileWatchdog createStatusRequestFileWatchdog(File directory, ProcessType processType, ControlFileWatchdog.ControlRequestHandler statusHandler) {
        return new ControlFileWatchdog(directory, processType.getStatusRequestFileName(), statusHandler, false);
    }

    static String fetchStatusWithValidation(ControlNotificationHandler handler) {
        AbstractLauncher.ServiceState<?> state = handler.handleStatus();
        if (state == null) {
            throw new IllegalStateException("Null ServiceState is invalid");
        }
        String jsonContent = state.toJson();
        if (jsonContent == null) {
            throw new IllegalStateException("Null JSON for status is invalid");
        }
        if (jsonContent.trim().isEmpty()) {
            throw new IllegalStateException("Empty JSON for status is invalid");
        }
        return jsonContent;
    }

    private static void deleteFileWithValidation(File file, String fileNameForMessage) throws IOException {
        if (file.exists() && !file.delete()) {
            throw new IOException("Unable to delete " + fileNameForMessage + "'" + file.getCanonicalPath() + "'");
        }
    }

    private static void writeStatusToFile(String jsonContent, File directory, ProcessType processType) throws IOException {
        File statusFile = new File(directory, processType.getStatusFileName());
        File statusFileTmp = new File(directory, processType.getStatusFileName() + ".tmp");
        FileControllableProcess.deleteFileWithValidation(statusFile, "statusFile");
        FileControllableProcess.deleteFileWithValidation(statusFileTmp, "statusFileTmp");
        if (!statusFileTmp.createNewFile()) {
            throw new IOException("Unable to create statusFileTmp '" + statusFileTmp.getCanonicalPath() + "'");
        }
        try (FileWriter writer = new FileWriter(statusFileTmp);){
            writer.write(jsonContent);
            writer.flush();
        }
        if (!statusFileTmp.renameTo(statusFile)) {
            throw new IOException("Unable to rename statusFileTmp '" + statusFileTmp.getCanonicalPath() + "' to '" + statusFile.getCanonicalPath() + "'");
        }
    }
}

