/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.offheap;

import org.apache.geode.internal.offheap.AddressableMemoryManager;
import org.apache.geode.internal.offheap.FreeListManager;
import org.apache.geode.internal.offheap.MemoryAllocatorImpl;
import org.apache.geode.internal.offheap.ReferenceCountHelper;

class ReferenceCounterInstance {
    ReferenceCounterInstance() {
    }

    int getRefCount(long address) {
        return AddressableMemoryManager.readInt(address + 4L) & 0xFFFF;
    }

    boolean retain(long address) {
        int usageCount;
        int rawBits;
        MemoryAllocatorImpl.validateAddress(address);
        int retryCount = 0;
        do {
            if (((rawBits = AddressableMemoryManager.readIntVolatile(address + 4L)) & 0x7000000) != 0x5000000) {
                return false;
            }
            usageCount = rawBits & 0xFFFF;
            if (usageCount == 65535) {
                throw new IllegalStateException("Maximum use count exceeded. rawBits=" + Integer.toHexString(rawBits));
            }
            if (usageCount == 0) {
                return false;
            }
            if (++retryCount <= 1000) continue;
            throw new IllegalStateException("tried to write " + (rawBits + 1) + " to @" + Long.toHexString(address) + " 1,000 times.");
        } while (!AddressableMemoryManager.writeIntVolatile(address + 4L, rawBits, rawBits + 1));
        if (ReferenceCountHelper.trackReferenceCounts()) {
            ReferenceCountHelper.refCountChanged(address, false, usageCount + 1);
        }
        return true;
    }

    void release(long address) {
        this.release(address, null);
    }

    void release(long address, FreeListManager freeListManager) {
        boolean returnToAllocator;
        int newCount;
        int rawBits;
        MemoryAllocatorImpl.validateAddress(address);
        do {
            returnToAllocator = false;
            rawBits = AddressableMemoryManager.readIntVolatile(address + 4L);
            if ((rawBits & 0x7000000) != 0x5000000) {
                String message = "It looks like off heap memory @" + Long.toHexString(address) + " was already freed. rawBits=" + Integer.toHexString(rawBits) + " history=" + String.valueOf(ReferenceCountHelper.getFreeRefCountInfo(address));
                throw new IllegalStateException(message);
            }
            int currentCount = rawBits & 0xFFFF;
            if (currentCount == 0) {
                throw new IllegalStateException("Memory has already been freed. history=" + String.valueOf(ReferenceCountHelper.getFreeRefCountInfo(address)));
            }
            if (currentCount == 1) {
                newCount = 0;
                returnToAllocator = true;
                continue;
            }
            newCount = rawBits - 1;
        } while (!AddressableMemoryManager.writeIntVolatile(address + 4L, rawBits, newCount));
        if (returnToAllocator) {
            if (ReferenceCountHelper.trackReferenceCounts()) {
                if (ReferenceCountHelper.trackFreedReferenceCounts()) {
                    ReferenceCountHelper.refCountChanged(address, true, newCount & 0xFFFF);
                }
                ReferenceCountHelper.freeRefCountInfo(address);
            }
            if (freeListManager == null) {
                freeListManager = MemoryAllocatorImpl.getAllocator().getFreeListManager();
            }
            freeListManager.free(address);
        } else if (ReferenceCountHelper.trackReferenceCounts()) {
            ReferenceCountHelper.refCountChanged(address, true, newCount & 0xFFFF);
        }
    }
}

