/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.geode.SystemFailure;
import org.apache.geode.internal.SystemDescription;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.util.ArgumentRedactor;
import org.apache.geode.internal.util.ProductVersionUtil;
import org.apache.geode.logging.internal.ConfigurationInfo;
import org.apache.geode.logging.internal.OSProcess;

public class Banner {
    public static final String SEPARATOR = "---------------------------------------------------------------------------";
    private final String configurationInfo;

    @Deprecated
    public Banner() {
        this(ConfigurationInfo.getConfigurationInfo());
    }

    public Banner(String configurationInfo) {
        this.configurationInfo = configurationInfo;
    }

    public String getString() {
        return this.getString(null);
    }

    public String getString(String[] args) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.print(pw, args);
        pw.close();
        return sw.toString();
    }

    private void prettyPrintPath(String path, PrintWriter out) {
        if (path != null) {
            StringTokenizer st = new StringTokenizer(path, System.getProperty("path.separator"));
            while (st.hasMoreTokens()) {
                out.println("  " + st.nextToken());
            }
        }
    }

    private void print(PrintWriter out, String[] args) {
        TreeMap<Object, Object> sp = new TreeMap<Object, Object>((Properties)System.getProperties().clone());
        Object userName = sp.get("user.name");
        Object userDir = sp.get("user.dir");
        Object userHome = sp.get("user.home");
        Object javaClassPath = sp.get("java.class.path");
        Object javaLibraryPath = sp.get("java.library.path");
        sp.remove("user.name");
        sp.remove("user.dir");
        sp.remove("user.home");
        sp.remove("java.class.path");
        sp.remove("java.library.path");
        sp.remove("os.name");
        sp.remove("os.arch");
        int processId = this.attemptToReadProcessId();
        short currentOrdinal = KnownVersion.CURRENT_ORDINAL;
        ArrayList<String> commandLineArguments = new ArrayList<String>();
        RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
        if (runtimeBean != null) {
            commandLineArguments.addAll(runtimeBean.getInputArguments());
        }
        if (args != null && args.length != 0) {
            Collections.addAll(commandLineArguments, args);
        }
        out.println();
        out.println(SEPARATOR);
        this.printASFLicense(out);
        out.println(SEPARATOR);
        out.println(ProductVersionUtil.getFullVersion());
        out.println("Running on: " + SystemDescription.getRunningOnInfo());
        out.println(SEPARATOR);
        out.println(BannerHeader.COMMUNICATIONS_VERSION.displayValue() + ": " + currentOrdinal);
        out.println(BannerHeader.PROCESS_ID.displayValue() + ": " + processId);
        out.println(BannerHeader.USER.displayValue() + ": " + String.valueOf(userName));
        out.println(BannerHeader.CURRENT_DIR.displayValue() + ": " + String.valueOf(userDir));
        out.println(BannerHeader.HOME_DIR.displayValue() + ": " + String.valueOf(userHome));
        if (!commandLineArguments.isEmpty()) {
            out.println(BannerHeader.COMMAND_LINE_PARAMETERS.displayValue() + ":");
            for (String string : commandLineArguments) {
                out.println("  " + ArgumentRedactor.redact(string));
            }
        }
        out.println(BannerHeader.CLASS_PATH.displayValue() + ":");
        this.prettyPrintPath((String)javaClassPath, out);
        out.println(BannerHeader.LIBRARY_PATH.displayValue() + ":");
        this.prettyPrintPath((String)javaLibraryPath, out);
        if (Boolean.getBoolean("gemfire.disableSystemPropertyLogging")) {
            out.println("System property logging disabled.");
        } else {
            out.println(BannerHeader.SYSTEM_PROPERTIES.displayValue() + ":");
            for (Object object : sp.entrySet()) {
                Map.Entry me = (Map.Entry)object;
                String key = me.getKey().toString();
                String value = ArgumentRedactor.redactArgumentIfNecessary(key, String.valueOf(me.getValue()));
                out.println("    " + key + " = " + value);
            }
            out.println(BannerHeader.LOG4J2_CONFIGURATION.displayValue() + ":");
            out.println("    " + this.configurationInfo);
        }
        out.println(SEPARATOR);
    }

    private int attemptToReadProcessId() {
        int processId = -1;
        try {
            processId = OSProcess.getId();
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
        }
        return processId;
    }

    private void printASFLicense(PrintWriter out) {
        out.println("  ");
        out.println("  " + BannerHeader.LICENSE_START.displayValue());
        out.println("  contributor license agreements.  See the NOTICE file distributed with this");
        out.println("  work for additional information regarding copyright ownership.");
        out.println("   ");
        out.println("  The ASF licenses this file to You under the Apache License, Version 2.0");
        out.println("  (the \"License\"); you may not use this file except in compliance with the");
        out.println("  License.  You may obtain a copy of the License at");
        out.println("  ");
        out.println("  http://www.apache.org/licenses/LICENSE-2.0");
        out.println("  ");
        out.println("  Unless required by applicable law or agreed to in writing, software");
        out.println("  distributed under the License is distributed on an \"AS IS\" BASIS, WITHOUT");
        out.println("  WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the");
        out.println("  License for the specific language governing permissions and limitations");
        out.println("  under the License.");
        out.println("  ");
    }

    public static enum BannerHeader {
        LICENSE_START("Licensed to the Apache Software Foundation (ASF) under one or more"),
        BUILD_ID("Build-Id"),
        BUILD_JAVA_VERSION("Build-Java-Version"),
        BUILD_PLATFORM("Build-Platform"),
        PRODUCT_NAME("Product-Name"),
        PRODUCT_VERSION("Product-Version"),
        SOURCE_DATE("Source-Date"),
        SOURCE_REPOSITORY("Source-Repository"),
        SOURCE_REVISION("Source-Revision"),
        RUNNING_ON("Running on"),
        COMMUNICATIONS_VERSION("Communications version"),
        PROCESS_ID("Process ID"),
        USER("User"),
        CURRENT_DIR("Current dir"),
        HOME_DIR("Home dir"),
        COMMAND_LINE_PARAMETERS("Command Line Parameters"),
        CLASS_PATH("Class Path"),
        LIBRARY_PATH("Library Path"),
        SYSTEM_PROPERTIES("System Properties"),
        LOG4J2_CONFIGURATION("Log4J 2 Configuration");

        private final String displayValue;

        private BannerHeader(String displayValue) {
            this.displayValue = displayValue;
        }

        public String displayValue() {
            return this.displayValue;
        }

        public static String[] displayValues() {
            String[] headerValues = new String[BannerHeader.values().length];
            int i = 0;
            for (BannerHeader bannerHeader : BannerHeader.values()) {
                headerValues[i] = bannerHeader.displayValue();
                ++i;
            }
            return headerValues;
        }
    }
}

