/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.jta;

import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.InvalidTransactionException;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.geode.CancelException;
import org.apache.geode.LogWriter;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.internal.jta.GlobalTransaction;
import org.apache.geode.internal.jta.TransactionImpl;
import org.apache.geode.internal.jta.TransactionUtils;
import org.apache.geode.logging.internal.executors.LoggingThread;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

@Deprecated
public class TransactionManagerImpl
implements TransactionManager,
Serializable {
    private static final long serialVersionUID = 5033392316185449821L;
    private static final Logger logger = LogService.getLogger();
    private final Map transactionMap = new ConcurrentHashMap();
    private final Map globalTransactionMap = Collections.synchronizedMap(new HashMap());
    protected SortedSet gtxSet = Collections.synchronizedSortedSet(new TreeSet(new GlobalTransactionComparator()));
    private final transient TransactionTimeOutThread cleaner;
    @MakeNotStatic
    private static TransactionManagerImpl transactionManager = null;
    private transient Thread cleanUpThread = null;
    static final int DEFAULT_TRANSACTION_TIMEOUT = Integer.getInteger("jta.defaultTimeout", 600);
    private static final int MARKED_ROLLBACK = 1;
    private static final int EXCEPTION_IN_NOTIFY_BEFORE_COMPLETION = 2;
    private static final int COMMIT_FAILED_SO_ROLLEDBAK = 3;
    private static final int COMMIT_FAILED_ROLLBAK_ALSO_FAILED = 4;
    private static final int ROLLBAK_FAILED = 5;
    private static final boolean VERBOSE = Boolean.getBoolean("jta.VERBOSE");
    private boolean isActive = true;
    private final transient AtomicBoolean loggedJTATransactionManagerDeprecatedWarning = new AtomicBoolean(false);

    private TransactionManagerImpl() {
        this.cleaner = new TransactionTimeOutThread();
        this.cleanUpThread = new LoggingThread("GlobalTXTimeoutMonitor", (Runnable)this.cleaner);
        this.cleanUpThread.start();
    }

    public static TransactionManagerImpl getTransactionManager() {
        if (transactionManager == null) {
            TransactionManagerImpl.createTransactionManager();
        }
        return transactionManager;
    }

    private static synchronized void createTransactionManager() {
        if (transactionManager == null) {
            transactionManager = new TransactionManagerImpl();
        }
    }

    public void begin() throws NotSupportedException, SystemException {
        Thread thread;
        if (this.loggedJTATransactionManagerDeprecatedWarning.compareAndSet(false, true)) {
            logger.warn("Geode JTA transaction manager is deprecated since 1.2.0, please use a third party JTA transaction manager instead");
        }
        if (!this.isActive) {
            throw new SystemException("TransactionManager invalid");
        }
        LogWriter log = TransactionUtils.getLogWriter();
        if (log.fineEnabled()) {
            log.fine("TransactionManager.begin() invoked");
        }
        if (this.transactionMap.get(thread = Thread.currentThread()) != null) {
            String exception = "Nested transaction is not supported";
            if (VERBOSE) {
                log.fine(exception);
            }
            throw new NotSupportedException(exception);
        }
        try {
            TransactionImpl transaction = new TransactionImpl();
            this.transactionMap.put(thread, transaction);
            GlobalTransaction globalTransaction = new GlobalTransaction();
            this.globalTransactionMap.put(transaction, globalTransaction);
            globalTransaction.addTransaction(transaction);
            globalTransaction.setStatus(0);
        }
        catch (Exception e) {
            String exception = String.format("SystemException due to %s", e);
            if (log.severeEnabled()) {
                log.severe(String.format("SystemException due to %s", e));
            }
            throw new SystemException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws HeuristicRollbackException, RollbackException, HeuristicMixedException, SystemException {
        LogWriter writer;
        Throwable e;
        int status;
        GlobalTransaction gtx;
        int cozOfException;
        block46: {
            if (!this.isActive) {
                throw new SystemException("TransactionManager invalid");
            }
            cozOfException = -1;
            Transaction transactionImpl = this.getTransaction();
            if (transactionImpl == null) {
                String exception = "Transaction is null, cannot commit a null transaction";
                LogWriter writer2 = TransactionUtils.getLogWriter();
                if (VERBOSE) {
                    writer2.fine(exception);
                }
                throw new IllegalStateException(exception);
            }
            gtx = this.getGlobalTransaction(transactionImpl);
            if (gtx == null) {
                String exception = "Global Transaction is null, cannot commit a null global transaction";
                LogWriter writer3 = TransactionUtils.getLogWriter();
                if (VERBOSE) {
                    writer3.fine(exception);
                }
                throw new SystemException(exception);
            }
            boolean isCommit = false;
            status = -1;
            status = gtx.getStatus();
            if (status == 0 || status == 1) {
                GlobalTransaction globalTransaction = gtx;
                synchronized (globalTransaction) {
                    status = gtx.getStatus();
                    if (status == 0) {
                        gtx.setStatus(8);
                        isCommit = true;
                    } else if (status == 1) {
                        gtx.setStatus(9);
                        cozOfException = 1;
                    } else {
                        String exception = String.format("transaction not active, cannot be committed. Transaction Status= %s", status);
                        LogWriter writer4 = TransactionUtils.getLogWriter();
                        if (VERBOSE) {
                            writer4.fine(exception);
                        }
                        throw new IllegalStateException(exception);
                    }
                }
            } else {
                String exception = "transaction is not active and cannot be committed";
                LogWriter writer5 = TransactionUtils.getLogWriter();
                if (VERBOSE) {
                    writer5.fine(exception);
                }
                throw new IllegalStateException(exception);
            }
            boolean isClean = false;
            e = null;
            try {
                ((TransactionImpl)transactionImpl).notifyBeforeCompletion();
                isClean = true;
            }
            catch (Exception ge) {
                this.setRollbackOnly();
                cozOfException = 2;
                e = ge;
            }
            if (isCommit) {
                GlobalTransaction ge = gtx;
                synchronized (ge) {
                    status = gtx.getStatus();
                    if (status == 8) {
                        try {
                            gtx.commit();
                        }
                        catch (RollbackException rbe) {
                            e = rbe;
                            cozOfException = 3;
                        }
                        catch (SystemException se) {
                            e = se;
                            cozOfException = 4;
                        }
                    } else if (status == 9) {
                        try {
                            gtx.rollback();
                            if (isClean) {
                                cozOfException = 1;
                            }
                        }
                        catch (SystemException se) {
                            e = se;
                            cozOfException = 5;
                        }
                    }
                }
            }
            try {
                gtx.rollback();
            }
            catch (SystemException se) {
                e = se;
                cozOfException = 5;
            }
            try {
                status = gtx.getStatus();
                ((TransactionImpl)transactionImpl).notifyAfterCompletion(status);
            }
            catch (Exception ge) {
                writer = TransactionUtils.getLogWriter();
                if (!writer.infoEnabled()) break block46;
                writer.info(String.format("Exception in notify after completion due to %s", ge.getMessage()), ge);
            }
        }
        Thread thread = Thread.currentThread();
        this.transactionMap.remove(thread);
        this.gtxSet.remove(gtx);
        if (status != 3) {
            switch (cozOfException) {
                case 2: {
                    String exception = "Transaction rolled back because of Exception in notifyBeforeCompletion processing";
                    LogWriter writer6 = TransactionUtils.getLogWriter();
                    if (VERBOSE) {
                        writer6.fine(exception, e);
                    }
                    RollbackException re = new RollbackException(exception);
                    re.initCause(e);
                    throw re;
                }
                case 1: {
                    String exception = "Transaction rolled back because a user marked it for Rollback";
                    LogWriter writer7 = TransactionUtils.getLogWriter();
                    if (VERBOSE) {
                        writer7.fine(exception, e);
                    }
                    throw new RollbackException(exception);
                }
                case 3: {
                    writer = TransactionUtils.getLogWriter();
                    if (VERBOSE) {
                        writer.fine(e);
                    }
                    throw (RollbackException)e;
                }
                case 4: 
                case 5: {
                    writer = TransactionUtils.getLogWriter();
                    if (VERBOSE) {
                        writer.fine(e);
                    }
                    throw (SystemException)e;
                }
            }
        }
        gtx.setStatus(6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        SystemException se;
        GlobalTransaction gtx;
        LogWriter writer;
        block20: {
            if (!this.isActive) {
                throw new SystemException("TransactionManager invalid");
            }
            writer = TransactionUtils.getLogWriter();
            Transaction transactionImpl = this.getTransaction();
            if (transactionImpl == null) {
                String exception = "no transaction exists";
                if (VERBOSE) {
                    writer.fine(exception);
                }
                throw new IllegalStateException(exception);
            }
            gtx = this.getGlobalTransaction(transactionImpl);
            if (gtx == null) {
                String exception = "no global transaction exists";
                if (VERBOSE) {
                    writer.fine(exception);
                }
                throw new SystemException(exception);
            }
            int status = gtx.getStatus();
            if (status != 0 && status != 1) {
                String exception = String.format("Transaction status does not allow Rollback .Transactional status, %s", status);
                if (VERBOSE) {
                    writer.fine(exception);
                }
                throw new IllegalStateException(exception);
            }
            status = -1;
            GlobalTransaction exception = gtx;
            synchronized (exception) {
                status = gtx.getStatus();
                if (status != 0 && status != 1) {
                    if (gtx.getStatus() == 9) {
                        String exception2 = String.format("Transaction already in a Rolling Back state.Transactional status, %s", status);
                        if (VERBOSE) {
                            writer.fine(exception2);
                        }
                        throw new IllegalStateException(exception2);
                    }
                    String exception3 = "Transaction status does not allow Rollback";
                    if (VERBOSE) {
                        writer.fine(exception3);
                    }
                    throw new IllegalStateException(exception3);
                }
                gtx.setStatus(9);
            }
            se = null;
            try {
                gtx.rollback();
            }
            catch (SystemException se1) {
                se = se1;
            }
            try {
                ((TransactionImpl)transactionImpl).notifyAfterCompletion(gtx.getStatus());
            }
            catch (Exception e1) {
                if (!writer.infoEnabled()) break block20;
                writer.info(String.format("Exception in notify after completion due to %s", e1.getMessage()), e1);
            }
        }
        Thread thread = Thread.currentThread();
        this.transactionMap.remove(thread);
        this.gtxSet.remove(gtx);
        if (se != null) {
            if (VERBOSE) {
                writer.fine(se);
            }
            throw se;
        }
        gtx.setStatus(6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRollbackOnly() throws IllegalStateException, SystemException {
        if (!this.isActive) {
            throw new SystemException("TransactionManager invalid");
        }
        GlobalTransaction gtx = this.getGlobalTransaction();
        if (gtx == null) {
            String exception = "no global transaction exists";
            LogWriter writer = TransactionUtils.getLogWriter();
            if (VERBOSE) {
                writer.fine(exception);
            }
            throw new SystemException(exception);
        }
        GlobalTransaction exception = gtx;
        synchronized (exception) {
            int status = gtx.getStatus();
            if (status == 0) {
                gtx.setRollbackOnly();
            } else if (status == 8) {
                gtx.setStatus(9);
            } else if (status != 9) {
                String exception2 = String.format("Transaction cannot be marked for rollback. Transcation status, %s", status);
                LogWriter writer = TransactionUtils.getLogWriter();
                if (VERBOSE) {
                    writer.fine(exception2);
                }
                throw new IllegalStateException(exception2);
            }
        }
        LogWriter writer = TransactionUtils.getLogWriter();
        if (VERBOSE) {
            writer.fine("Transaction Set to Rollback only");
        }
    }

    public int getStatus() throws SystemException {
        if (!this.isActive) {
            throw new SystemException("TransactionManager invalid");
        }
        GlobalTransaction gtx = this.getGlobalTransaction();
        if (gtx == null) {
            return 6;
        }
        return gtx.getStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransactionTimeout(int seconds) throws SystemException {
        if (!this.isActive) {
            throw new SystemException("TransactionManager invalid");
        }
        GlobalTransaction gtx = this.getGlobalTransaction();
        if (gtx == null) {
            String exception = "no global transaction exists";
            LogWriter writer = TransactionUtils.getLogWriter();
            if (VERBOSE) {
                writer.fine(exception);
            }
            throw new SystemException(exception);
        }
        long newExpiry = gtx.setTransactionTimeoutForXARes(seconds);
        if (newExpiry > 0L) {
            this.gtxSet.remove(gtx);
            int status = gtx.getStatus();
            if (status != 6 && status != 3 && status != 4 && !gtx.isExpired()) {
                boolean toAdd = false;
                Object object = gtx;
                synchronized (object) {
                    if (!gtx.isExpired()) {
                        gtx.setTimeoutValue(newExpiry);
                        toAdd = true;
                    }
                }
                if (toAdd) {
                    object = this.gtxSet;
                    synchronized (object) {
                        this.gtxSet.add(gtx);
                        if (this.gtxSet.first() == gtx) {
                            this.gtxSet.notify();
                        }
                    }
                }
            } else {
                String exception = "Transaction has either expired or rolledback or committed";
                LogWriter writer = TransactionUtils.getLogWriter();
                if (VERBOSE) {
                    writer.fine(exception);
                }
                throw new SystemException(exception);
            }
        }
    }

    public Transaction suspend() throws SystemException {
        if (!this.isActive) {
            throw new SystemException("TransactionManager invalid");
        }
        Transaction txn = this.getTransaction();
        if (null != txn) {
            GlobalTransaction gtx = this.getGlobalTransaction(txn);
            gtx.suspend();
            this.transactionMap.remove(Thread.currentThread());
            LogWriter writer = TransactionUtils.getLogWriter();
            if (writer.infoEnabled()) {
                writer.info("Transaction suspended");
            }
        }
        return txn;
    }

    public void resume(Transaction txn) throws InvalidTransactionException, IllegalStateException, SystemException {
        if (!this.isActive) {
            throw new SystemException("TransactionManager invalid");
        }
        if (txn == null) {
            String exception = "cannot resume a null transaction";
            LogWriter writer = TransactionUtils.getLogWriter();
            if (VERBOSE) {
                writer.fine(exception);
            }
            throw new InvalidTransactionException(exception);
        }
        GlobalTransaction gtx = this.getGlobalTransaction(txn);
        if (gtx == null) {
            String exception = "cannot resume a null transaction";
            LogWriter writer = TransactionUtils.getLogWriter();
            if (VERBOSE) {
                writer.fine(exception);
            }
            throw new InvalidTransactionException(exception);
        }
        gtx.resume();
        try {
            Thread thread = Thread.currentThread();
            this.transactionMap.put(thread, txn);
            LogWriter writer = TransactionUtils.getLogWriter();
            if (writer.infoEnabled()) {
                writer.info("Transaction resumed");
            }
        }
        catch (Exception e) {
            String exception = String.format("Error in listing thread to transaction map due to %s", e);
            LogWriter writer = TransactionUtils.getLogWriter();
            if (VERBOSE) {
                writer.fine(exception);
            }
            throw new SystemException(exception);
        }
    }

    public Transaction getTransaction() throws SystemException {
        if (!this.isActive) {
            throw new SystemException("TransactionManager invalid");
        }
        Thread thread = Thread.currentThread();
        Transaction txn = (Transaction)this.transactionMap.get(thread);
        return txn;
    }

    GlobalTransaction getGlobalTransaction() throws SystemException {
        Transaction txn = this.getTransaction();
        if (txn == null) {
            return null;
        }
        GlobalTransaction gtx = (GlobalTransaction)this.globalTransactionMap.get(txn);
        return gtx;
    }

    GlobalTransaction getGlobalTransaction(Transaction txn) throws SystemException {
        if (txn == null) {
            String exception = "no transaction exists";
            LogWriter writer = TransactionUtils.getLogWriter();
            if (VERBOSE) {
                writer.fine(exception);
            }
            throw new SystemException(exception);
        }
        GlobalTransaction gtx = (GlobalTransaction)this.globalTransactionMap.get(txn);
        return gtx;
    }

    Map getGlobalTransactionMap() {
        return this.globalTransactionMap;
    }

    Map getTransactionMap() {
        return this.transactionMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanGlobalTransactionMap(List tranxns) {
        List list = tranxns;
        synchronized (list) {
            for (Object tranxn : tranxns) {
                this.globalTransactionMap.remove(tranxn);
            }
        }
    }

    void removeTranxnMappingsAndRollbackExpiredTransaction(List tranxns) {
        Object[] threads = this.transactionMap.keySet().toArray();
        int len = threads.length;
        Object tx = null;
        boolean removed = false;
        Object temp = null;
        for (Object thread : threads) {
            temp = thread;
            tx = this.transactionMap.get(temp);
            removed = tranxns.remove(tx);
            if (!removed) continue;
            this.transactionMap.remove(temp);
            GlobalTransaction globalTransaction = (GlobalTransaction)this.globalTransactionMap.remove(tx);
            try {
                globalTransaction.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void refresh() {
        block2: {
            TransactionManagerImpl.getTransactionManager();
            TransactionManagerImpl.transactionManager.isActive = false;
            TransactionManagerImpl.transactionManager.cleaner.toContinueRunning = false;
            try {
                TransactionManagerImpl.transactionManager.cleanUpThread.interrupt();
            }
            catch (Exception e) {
                LogWriter writer = TransactionUtils.getLogWriter();
                if (!writer.infoEnabled()) break block2;
                writer.info("Exception While cleaning thread before re startup");
            }
        }
        transactionManager = null;
    }

    static class GlobalTransactionComparator
    implements Comparator,
    Serializable {
        GlobalTransactionComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            GlobalTransaction gtx1 = (GlobalTransaction)obj1;
            GlobalTransaction gtx2 = (GlobalTransaction)obj2;
            return gtx1.compare(gtx2);
        }
    }

    class TransactionTimeOutThread
    implements Runnable {
        protected volatile boolean toContinueRunning = true;

        TransactionTimeOutThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            GlobalTransaction currentGtx = null;
            long lag = 0L;
            LogWriter logger = TransactionUtils.getLogWriter();
            while (this.toContinueRunning) {
                try {
                    SortedSet sortedSet = TransactionManagerImpl.this.gtxSet;
                    synchronized (sortedSet) {
                        while (TransactionManagerImpl.this.gtxSet.isEmpty() && this.toContinueRunning) {
                            TransactionManagerImpl.this.gtxSet.wait();
                        }
                        if (!this.toContinueRunning) {
                            continue;
                        }
                        currentGtx = (GlobalTransaction)TransactionManagerImpl.this.gtxSet.first();
                    }
                    boolean continueInner = true;
                    do {
                        Object object = currentGtx;
                        synchronized (object) {
                            lag = System.currentTimeMillis() - currentGtx.getExpirationTime();
                            if (lag >= 0L) {
                                currentGtx.expireGTX();
                                TransactionManagerImpl.this.gtxSet.remove(currentGtx);
                            }
                        }
                        object = TransactionManagerImpl.this.gtxSet;
                        synchronized (object) {
                            if (TransactionManagerImpl.this.gtxSet.isEmpty()) {
                                continueInner = false;
                            } else {
                                currentGtx = (GlobalTransaction)TransactionManagerImpl.this.gtxSet.first();
                                boolean isGTXExp = false;
                                lag = System.currentTimeMillis() - currentGtx.getExpirationTime();
                                if (lag < 0L) {
                                    isGTXExp = false;
                                } else {
                                    isGTXExp = true;
                                    if (!currentGtx.isExpired()) {
                                        currentGtx.expireGTX();
                                    }
                                    TransactionManagerImpl.this.gtxSet.remove(currentGtx);
                                    if (TransactionManagerImpl.this.gtxSet.isEmpty()) {
                                        continueInner = false;
                                    } else {
                                        currentGtx = (GlobalTransaction)TransactionManagerImpl.this.gtxSet.first();
                                    }
                                }
                                if (!isGTXExp && this.toContinueRunning) {
                                    TransactionManagerImpl.this.gtxSet.wait(-lag);
                                    if (TransactionManagerImpl.this.gtxSet.isEmpty()) {
                                        continueInner = false;
                                    } else {
                                        currentGtx = (GlobalTransaction)TransactionManagerImpl.this.gtxSet.first();
                                    }
                                }
                                if (!this.toContinueRunning) {
                                    continueInner = false;
                                }
                            }
                        }
                    } while (continueInner);
                }
                catch (InterruptedException e) {
                    if (this.toContinueRunning) {
                        logger.fine("TransactionTimeOutThread: unexpected exception", e);
                    }
                    return;
                }
                catch (CancelException e) {
                    return;
                }
                catch (Exception e) {
                    if (!logger.severeEnabled() || !this.toContinueRunning) continue;
                    logger.severe("Exception occurred while inspecting global transaction for expiry", e);
                }
            }
        }
    }
}

