/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.xmlcache;

import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.geode.cache.ClientSession;
import org.apache.geode.cache.InterestRegistrationListener;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.cache.server.ClientSubscriptionConfig;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.AbstractCacheServer;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.tier.Acceptor;
import org.apache.geode.internal.cache.tier.OverflowAttributes;
import org.apache.geode.internal.cache.tier.sockets.CacheClientNotifier;
import org.apache.geode.internal.cache.tier.sockets.ClientHealthMonitor;
import org.apache.geode.internal.cache.tier.sockets.ConnectionListener;
import org.apache.geode.internal.net.SocketCreator;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.internal.statistics.StatisticsClock;

public class CacheServerCreation
extends AbstractCacheServer {
    CacheServerCreation(InternalCache cache) {
        super(cache);
    }

    CacheServerCreation(InternalCache cache, boolean attachListener) {
        super(cache, attachListener);
    }

    public CacheServerCreation(InternalCache cache, CacheServer other) {
        super(cache);
        this.setPort(other.getPort());
        this.setBindAddress(other.getBindAddress());
        this.setHostnameForClients(other.getHostnameForClients());
        this.setMaxConnections(other.getMaxConnections());
        this.setMaxThreads(other.getMaxThreads());
        this.setNotifyBySubscription(other.getNotifyBySubscription());
        this.setSocketBufferSize(other.getSocketBufferSize());
        this.setTcpNoDelay(other.getTcpNoDelay());
        this.setMaximumTimeBetweenPings(other.getMaximumTimeBetweenPings());
        this.setMaximumMessageCount(other.getMaximumMessageCount());
        this.setMessageTimeToLive(other.getMessageTimeToLive());
        this.setGroups(other.getGroups());
        this.setLoadProbe(other.getLoadProbe());
        this.setLoadPollInterval(other.getLoadPollInterval());
        ClientSubscriptionConfig cscOther = other.getClientSubscriptionConfig();
        ClientSubscriptionConfig cscThis = this.getClientSubscriptionConfig();
        cscThis.setEvictionPolicy(cscOther.getEvictionPolicy());
        cscThis.setCapacity(cscOther.getCapacity());
        String diskStoreName = cscOther.getDiskStoreName();
        if (diskStoreName != null) {
            cscThis.setDiskStoreName(diskStoreName);
        } else {
            cscThis.setOverflowDirectory(cscOther.getOverflowDirectory());
        }
    }

    @Override
    public void start() throws IOException {
    }

    @Override
    public void setNotifyBySubscription(boolean b) {
        this.notifyBySubscription = b;
    }

    @Override
    public boolean getNotifyBySubscription() {
        return this.notifyBySubscription;
    }

    @Override
    public void setSocketBufferSize(int socketBufferSize) {
        this.socketBufferSize = socketBufferSize;
    }

    @Override
    public int getSocketBufferSize() {
        return this.socketBufferSize;
    }

    @Override
    public void setTcpNoDelay(boolean setting) {
        this.tcpNoDelay = setting;
    }

    @Override
    public boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    @Override
    public void setMaximumTimeBetweenPings(int maximumTimeBetweenPings) {
        this.maximumTimeBetweenPings = maximumTimeBetweenPings;
    }

    @Override
    public int getMaximumTimeBetweenPings() {
        return this.maximumTimeBetweenPings;
    }

    @Override
    public int getMaximumMessageCount() {
        return this.maximumMessageCount;
    }

    @Override
    public void setMaximumMessageCount(int maximumMessageCount) {
        this.maximumMessageCount = maximumMessageCount;
    }

    @Override
    public int getMessageTimeToLive() {
        return this.messageTimeToLive;
    }

    @Override
    public void setMessageTimeToLive(int messageTimeToLive) {
        this.messageTimeToLive = messageTimeToLive;
    }

    @Override
    public boolean isRunning() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public void stop() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public boolean sameAs(CacheServer other) {
        ClientSubscriptionConfig cscThis = this.getClientSubscriptionConfig();
        ClientSubscriptionConfig cscOther = other.getClientSubscriptionConfig();
        boolean result = this.isCacheServerPortEquals(other) && this.getSocketBufferSize() == other.getSocketBufferSize() && this.getMaximumTimeBetweenPings() == other.getMaximumTimeBetweenPings() && this.getNotifyBySubscription() == other.getNotifyBySubscription() && this.getMaxConnections() == other.getMaxConnections() && this.getMaxThreads() == other.getMaxThreads() && this.getMaximumMessageCount() == other.getMaximumMessageCount() && this.getMessageTimeToLive() == other.getMessageTimeToLive() && this.getTcpNoDelay() == other.getTcpNoDelay() && cscThis.getCapacity() == cscOther.getCapacity() && cscThis.getEvictionPolicy().equals(cscOther.getEvictionPolicy());
        String diskStoreName = cscThis.getDiskStoreName();
        result = diskStoreName != null ? result && diskStoreName.equals(cscOther.getDiskStoreName()) : result && cscThis.getOverflowDirectory().equals(cscOther.getOverflowDirectory());
        return result;
    }

    private boolean isCacheServerPortEquals(CacheServer other) {
        return this.getPort() == 0 || this.getPort() == other.getPort();
    }

    public String toString() {
        return "BridgeServerCreation on port " + this.getPort() + " notify by subscription " + this.getNotifyBySubscription() + " maximum time between pings " + this.getMaximumTimeBetweenPings() + " socket buffer size " + this.getSocketBufferSize() + " maximum connections " + this.getMaxConnections() + " maximum threads " + this.getMaxThreads() + " maximum message count " + this.getMaximumMessageCount() + " message time to live " + this.getMessageTimeToLive() + " groups " + String.valueOf(Arrays.asList(this.getGroups())) + " loadProbe " + String.valueOf(this.loadProbe) + " loadPollInterval " + this.loadPollInterval + this.getClientSubscriptionConfig().toString();
    }

    @Override
    public ClientSubscriptionConfig getClientSubscriptionConfig() {
        return this.clientSubscriptionConfig;
    }

    public Set getInterestRegistrationListeners() {
        return null;
    }

    @Override
    public void registerInterestRegistrationListener(InterestRegistrationListener listener) {
    }

    @Override
    public void unregisterInterestRegistrationListener(InterestRegistrationListener listener) {
    }

    public Set getAllClientSessions() {
        throw new UnsupportedOperationException("Shouldn't be invoked");
    }

    @Override
    public ClientSession getClientSession(DistributedMember member) {
        throw new UnsupportedOperationException("Shouldn't be invoked");
    }

    @Override
    public ClientSession getClientSession(String durableClientId) {
        throw new UnsupportedOperationException("Shouldn't be invoked");
    }

    @Override
    public Acceptor getAcceptor() {
        throw new UnsupportedOperationException("Shouldn't be invoked");
    }

    @Override
    public Acceptor createAcceptor(OverflowAttributes overflowAttributes) throws IOException {
        throw new UnsupportedOperationException("Shouldn't be invoked");
    }

    @Override
    public String getExternalAddress() {
        throw new UnsupportedOperationException("Shouldn't be invoked");
    }

    @Override
    public ConnectionListener getConnectionListener() {
        throw new UnsupportedOperationException("Shouldn't be invoked");
    }

    @Override
    public long getTimeLimitMillis() {
        throw new UnsupportedOperationException("Shouldn't be invoked");
    }

    @Override
    public SecurityService getSecurityService() {
        throw new UnsupportedOperationException("Shouldn't be invoked");
    }

    @Override
    public Supplier<SocketCreator> getSocketCreatorSupplier() {
        throw new UnsupportedOperationException("Shouldn't be invoked");
    }

    @Override
    public CacheClientNotifier.CacheClientNotifierProvider getCacheClientNotifierProvider() {
        throw new UnsupportedOperationException("Shouldn't be invoked");
    }

    @Override
    public ClientHealthMonitor.ClientHealthMonitorProvider getClientHealthMonitorProvider() {
        throw new UnsupportedOperationException("Shouldn't be invoked");
    }

    @Override
    public String[] getCombinedGroups() {
        throw new UnsupportedOperationException("Shouldn't be invoked");
    }

    @Override
    public StatisticsClock getStatisticsClock() {
        throw new UnsupportedOperationException("Shouldn't be invoked");
    }
}

