/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.wan;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.geode.DataSerializer;
import org.apache.geode.internal.cache.WrappedCallbackArgument;
import org.apache.geode.internal.serialization.DataSerializableFixedID;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.SerializationContext;

public class GatewaySenderEventCallbackArgument
extends WrappedCallbackArgument
implements DataSerializableFixedID {
    private int originatingDSId = -1;
    private IntOpenHashSet receipientDSIds;

    public GatewaySenderEventCallbackArgument() {
    }

    public GatewaySenderEventCallbackArgument(Object originalCallbackArg) {
        super(originalCallbackArg);
    }

    public GatewaySenderEventCallbackArgument(GatewaySenderEventCallbackArgument geca) {
        super(geca.getOriginalCallbackArg());
        this.originatingDSId = geca.originatingDSId;
        if (geca.receipientDSIds != null) {
            this.receipientDSIds = new IntOpenHashSet((IntCollection)geca.receipientDSIds);
        }
    }

    public GatewaySenderEventCallbackArgument(Object originalCallbackArg, int originatingDSId, List<Integer> originalReceivers) {
        super(originalCallbackArg);
        this.originatingDSId = originatingDSId;
        this.initializeReceipientDSIds(originalReceivers);
    }

    public int getOriginatingDSId() {
        return this.originatingDSId;
    }

    public void setOriginatingDSId(int originatingDSId) {
        this.originatingDSId = originatingDSId;
    }

    public IntOpenHashSet getRecipientDSIds() {
        return this.receipientDSIds;
    }

    public void initializeReceipientDSIds(List<Integer> originalGatewaysReceivers) {
        this.receipientDSIds = new IntOpenHashSet(2);
        for (Integer id : originalGatewaysReceivers) {
            this.receipientDSIds.add(id);
        }
    }

    public int getDSFID() {
        return -135;
    }

    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out);
        DataSerializer.writeInteger(this.originatingDSId, out);
        if (this.receipientDSIds != null) {
            out.writeInt(this.receipientDSIds.size());
            for (Integer gateway : this.receipientDSIds) {
                out.writeInt(gateway);
            }
        } else {
            out.writeInt(0);
        }
    }

    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.originatingDSId = DataSerializer.readInteger(in);
        this.receipientDSIds = new IntOpenHashSet(2);
        int numberOfRecipientGateways = in.readInt();
        for (int i = 0; i < numberOfRecipientGateways; ++i) {
            this.receipientDSIds.add(in.readInt());
        }
    }

    public String toString() {
        return "GatewaySenderEventCallbackArgument [originalCallbackArg=" + String.valueOf(this.getOriginalCallbackArg()) + ";originatingSenderId=" + this.originatingDSId + ";recipientGatewayReceivers=" + String.valueOf(this.receipientDSIds) + "]";
    }

    public KnownVersion[] getSerializationVersions() {
        return null;
    }
}

