/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tx;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.geode.CancelException;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.EntryExistsException;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.TransactionDataNotColocatedException;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DirectReplyProcessor;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.ReplySender;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.NanoTimer;
import org.apache.geode.internal.cache.DistributedPutAllOperation;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.RemoteOperationException;
import org.apache.geode.internal.cache.partitioned.PutAllPRMessage;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.VersionedObjectList;
import org.apache.geode.internal.cache.tx.RemoteOperationMessage;
import org.apache.geode.internal.cache.tx.RemoteOperationMessageWithDirectReply;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.serialization.ByteArrayDataInput;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.internal.serialization.StaticSerialization;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class RemotePutAllMessage
extends RemoteOperationMessageWithDirectReply {
    private static final Logger logger = LogService.getLogger();
    private DistributedPutAllOperation.PutAllEntryData[] putAllData;
    private int putAllDataCount = 0;
    ClientProxyMembershipID bridgeContext;
    private boolean posDup;
    protected static final short HAS_BRIDGE_CONTEXT = 64;
    protected static final short SKIP_CALLBACKS = 128;
    private EventID eventId;
    private boolean skipCallbacks;
    private Object callbackArg;

    public void addEntry(DistributedPutAllOperation.PutAllEntryData entry) {
        this.putAllData[this.putAllDataCount++] = entry;
    }

    public int getSize() {
        return this.putAllDataCount;
    }

    public static boolean distribute(EntryEventImpl event, DistributedPutAllOperation.PutAllEntryData[] data, int dataCount) {
        boolean successful = false;
        DistributedRegion r = (DistributedRegion)event.getRegion();
        Collection<InternalDistributedMember> replicates = r.getCacheDistributionAdvisor().adviseInitializedReplicates();
        if (replicates.isEmpty()) {
            return false;
        }
        if (replicates.size() > 1) {
            ArrayList<InternalDistributedMember> l = new ArrayList<InternalDistributedMember>(replicates);
            Collections.shuffle(l);
            replicates = l;
        }
        int attempts = 0;
        for (InternalDistributedMember replicate : replicates) {
            try {
                boolean posDup = ++attempts > 1;
                PutAllResponse response = RemotePutAllMessage.send(replicate, event, data, dataCount, false, posDup);
                response.waitForRemoteResponse();
                VersionedObjectList result = response.getResponse();
                List<Object> successfulKeys = result.getKeys();
                List<VersionTag> versions = result.getVersionTags();
                for (DistributedPutAllOperation.PutAllEntryData putAllEntry : data) {
                    Object key = putAllEntry.getKey();
                    if (!successfulKeys.contains(key)) continue;
                    int index = successfulKeys.indexOf(key);
                    putAllEntry.versionTag = versions.get(index);
                }
                return true;
            }
            catch (TransactionDataNotColocatedException enfe) {
                throw enfe;
            }
            catch (CancelException e) {
                event.getRegion().getCancelCriterion().checkCancelInProgress(e);
            }
            catch (CacheException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("RemotePutAllMessage caught CacheException during distribution", (Throwable)e);
                }
                successful = true;
            }
            catch (RegionDestroyedException | RemoteOperationException e) {
                if (!logger.isTraceEnabled(LogMarker.DM_VERBOSE)) continue;
                logger.trace(LogMarker.DM_VERBOSE, "RemotePutAllMessage caught an exception during distribution; retrying to another member", (Throwable)e);
            }
        }
        return successful;
    }

    RemotePutAllMessage(EntryEventImpl event, DistributedMember recipient, DirectReplyProcessor p, DistributedPutAllOperation.PutAllEntryData[] putAllData, int putAllDataCount, boolean useOriginRemote, boolean possibleDuplicate, boolean skipCallbacks) {
        super((InternalDistributedMember)recipient, event.getRegion().getFullPath(), p);
        this.processor = p;
        int n = this.processorId = p == null ? 0 : p.getProcessorId();
        if (p != null && this.isSevereAlertCompatible()) {
            p.enableSevereAlertProcessing();
        }
        this.putAllData = putAllData;
        this.putAllDataCount = putAllDataCount;
        this.posDup = possibleDuplicate;
        this.eventId = event.getEventId();
        this.skipCallbacks = skipCallbacks;
        this.callbackArg = event.getCallbackArgument();
    }

    public RemotePutAllMessage() {
    }

    public static PutAllResponse send(DistributedMember recipient, EntryEventImpl event, DistributedPutAllOperation.PutAllEntryData[] putAllData, int putAllDataCount, boolean useOriginRemote, boolean possibleDuplicate) throws RemoteOperationException {
        PutAllResponse p = new PutAllResponse(event.getRegion().getSystem(), recipient);
        RemotePutAllMessage msg = new RemotePutAllMessage(event, recipient, p, putAllData, putAllDataCount, useOriginRemote, possibleDuplicate, !event.isGenerateCallbacks());
        Set<InternalDistributedMember> failures = event.getRegion().getDistributionManager().putOutgoing(msg);
        if (failures != null && failures.size() > 0) {
            throw new RemoteOperationException(String.format("Failed sending < %s >", msg));
        }
        return p;
    }

    public void setBridgeContext(ClientProxyMembershipID contx) {
        Assert.assertTrue(contx != null);
        this.bridgeContext = contx;
    }

    public int getDSFID() {
        return -119;
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.eventId = (EventID)DataSerializer.readObject(in);
        this.callbackArg = DataSerializer.readObject(in);
        boolean bl = this.posDup = (this.flags & 8) != 0;
        if ((this.flags & 0x40) != 0) {
            this.bridgeContext = (ClientProxyMembershipID)DataSerializer.readObject(in);
        }
        this.skipCallbacks = (this.flags & 0x80) != 0;
        this.putAllDataCount = (int)InternalDataSerializer.readUnsignedVL(in);
        this.putAllData = new DistributedPutAllOperation.PutAllEntryData[this.putAllDataCount];
        if (this.putAllDataCount > 0) {
            KnownVersion version = StaticSerialization.getVersionForDataStreamOrNull((DataInput)in);
            ByteArrayDataInput bytesIn = new ByteArrayDataInput();
            for (int i = 0; i < this.putAllDataCount; ++i) {
                this.putAllData[i] = new DistributedPutAllOperation.PutAllEntryData(in, context, this.eventId, i);
            }
            boolean hasTags = in.readBoolean();
            if (hasTags) {
                DistributedPutAllOperation.EntryVersionsList versionTags = DistributedPutAllOperation.EntryVersionsList.create(in);
                for (int i = 0; i < this.putAllDataCount; ++i) {
                    this.putAllData[i].versionTag = (VersionTag)versionTags.get(i);
                }
            }
        }
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        DataSerializer.writeObject(this.eventId, out);
        DataSerializer.writeObject(this.callbackArg, out);
        if (this.bridgeContext != null) {
            DataSerializer.writeObject(this.bridgeContext, out);
        }
        InternalDataSerializer.writeUnsignedVL(this.putAllDataCount, out);
        if (this.putAllDataCount > 0) {
            DistributedPutAllOperation.EntryVersionsList versionTags = new DistributedPutAllOperation.EntryVersionsList(this.putAllDataCount);
            boolean hasTags = false;
            for (int i = 0; i < this.putAllDataCount; ++i) {
                if (!hasTags && this.putAllData[i].versionTag != null) {
                    hasTags = true;
                }
                VersionTag tag = this.putAllData[i].versionTag;
                versionTags.add(tag);
                this.putAllData[i].versionTag = null;
                this.putAllData[i].toData(out, context);
                this.putAllData[i].versionTag = tag;
            }
            out.writeBoolean(hasTags);
            if (hasTags) {
                InternalDataSerializer.invokeToData(versionTags, out);
            }
        }
    }

    @Override
    protected short computeCompressedShort() {
        short flags = super.computeCompressedShort();
        if (this.posDup) {
            flags = (short)(flags | 8);
        }
        if (this.bridgeContext != null) {
            flags = (short)(flags | 0x40);
        }
        if (this.skipCallbacks) {
            flags = (short)(flags | 0x80);
        }
        return flags;
    }

    @Override
    public EventID getEventID() {
        return this.eventId;
    }

    @Override
    protected boolean operateOnRegion(ClusterDistributionManager dm, LocalRegion r, long startTime) throws RemoteOperationException {
        boolean sendReply;
        InternalDistributedMember eventSender = this.getSender();
        long lastModified = 0L;
        try {
            sendReply = this.doLocalPutAll(r, eventSender, lastModified);
        }
        catch (RemoteOperationException e) {
            this.sendReply(this.getSender(), this.getProcessorId(), dm, new ReplyException(e), r, startTime);
            return false;
        }
        if (sendReply) {
            this.sendReply(this.getSender(), this.getProcessorId(), dm, null, r, startTime);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doLocalPutAll(LocalRegion r, InternalDistributedMember eventSender, long lastModified) throws EntryExistsException, RemoteOperationException {
        DistributedRegion dr = (DistributedRegion)r;
        EntryEventImpl baseEvent = EntryEventImpl.create(r, Operation.PUTALL_CREATE, null, null, this.callbackArg, false, eventSender, !this.skipCallbacks);
        try {
            baseEvent.setCausedByMessage(this);
            baseEvent.setEventId(this.eventId);
            if (this.bridgeContext != null) {
                baseEvent.setContext(this.bridgeContext);
            }
            baseEvent.setPossibleDuplicate(this.posDup);
            if (logger.isDebugEnabled()) {
                logger.debug("RemotePutAllMessage.doLocalPutAll: eventSender is {}, baseEvent is {}, msg is {}", (Object)eventSender, (Object)baseEvent, (Object)this);
            }
            DistributedPutAllOperation dpao = new DistributedPutAllOperation(baseEvent, this.putAllDataCount, false);
            try {
                r.lockRVVForBulkOp();
                VersionedObjectList versions = new VersionedObjectList(this.putAllDataCount, true, dr.getConcurrencyChecksEnabled());
                dr.syncBulkOp(() -> {
                    InternalDistributedMember myId = r.getDistributionManager().getDistributionManagerId();
                    for (int i = 0; i < this.putAllDataCount; ++i) {
                        EntryEventImpl ev = PutAllPRMessage.getEventFromEntry(r, myId, eventSender, i, this.putAllData, false, this.bridgeContext, this.posDup, !this.skipCallbacks);
                        try {
                            ev.setPutAllOperation(dpao);
                            if (logger.isDebugEnabled()) {
                                logger.debug("invoking basicPut with {}", (Object)ev);
                            }
                            if (!dr.basicPut(ev, false, false, null, false)) continue;
                            this.putAllData[i].versionTag = ev.getVersionTag();
                            versions.addKeyAndVersion(this.putAllData[i].getKey(), ev.getVersionTag());
                            continue;
                        }
                        finally {
                            ev.release();
                        }
                    }
                }, baseEvent.getEventId());
                if (this.getTXUniqId() != -1 || dr.getConcurrencyChecksEnabled()) {
                    dr.getDataView().postPutAll(dpao, versions, dr);
                }
                PutAllReplyMessage.send(this.getSender(), this.processorId, this.getReplySender(r.getDistributionManager()), versions, this.putAllData, this.putAllDataCount);
                boolean bl = false;
                r.unlockRVVForBulkOp();
                dpao.freeOffHeapResources();
                return bl;
            }
            catch (Throwable throwable) {
                r.unlockRVVForBulkOp();
                dpao.freeOffHeapResources();
                throw throwable;
            }
        }
        finally {
            baseEvent.release();
        }
    }

    @Override
    protected void appendFields(StringBuilder buff) {
        super.appendFields(buff);
        buff.append("; putAllDataCount=").append(this.putAllDataCount);
        if (this.bridgeContext != null) {
            buff.append("; bridgeContext=").append(this.bridgeContext);
        }
        for (int i = 0; i < this.putAllDataCount; ++i) {
            buff.append("; entry" + i + ":").append(this.putAllData[i] == null ? "null" : this.putAllData[i].getKey());
        }
    }

    public static class PutAllResponse
    extends RemoteOperationMessage.RemoteOperationResponse {
        private VersionedObjectList versions;

        public PutAllResponse(InternalDistributedSystem ds, DistributedMember recipient) {
            super(ds, (InternalDistributedMember)recipient, false);
        }

        public void setResponse(PutAllReplyMessage putAllReplyMessage) {
            if (putAllReplyMessage.versions != null) {
                this.versions = putAllReplyMessage.versions;
                this.versions.replaceNullIDs(putAllReplyMessage.getSender());
            }
        }

        public VersionedObjectList getResponse() {
            return this.versions;
        }
    }

    public static class PutAllReplyMessage
    extends ReplyMessage {
        private VersionedObjectList versions;

        @Override
        public boolean getInlineProcess() {
            return true;
        }

        private PutAllReplyMessage(int processorId, VersionedObjectList versionList, DistributedPutAllOperation.PutAllEntryData[] putAllData, int putAllCount) {
            this.versions = versionList;
            this.setProcessorId(processorId);
        }

        public static void send(InternalDistributedMember recipient, int processorId, ReplySender dm, VersionedObjectList versions, DistributedPutAllOperation.PutAllEntryData[] putAllData, int putAllDataCount) {
            Assert.assertTrue(recipient != null, "PutAllReplyMessage NULL reply message");
            PutAllReplyMessage m = new PutAllReplyMessage(processorId, versions, putAllData, putAllDataCount);
            m.setRecipient(recipient);
            dm.putOutgoing(m);
        }

        @Override
        public void process(DistributionManager dm, ReplyProcessor21 rp) {
            long startTime = this.getTimestamp();
            if (rp == null) {
                if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                    logger.trace(LogMarker.DM_VERBOSE, "PutAllReplyMessage processor not found");
                }
                return;
            }
            if (rp instanceof PutAllResponse) {
                PutAllResponse processor = (PutAllResponse)rp;
                processor.setResponse(this);
            }
            rp.process(this);
            if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                logger.trace(LogMarker.DM_VERBOSE, "{} processed {}", (Object)rp, (Object)this);
            }
            dm.getStats().incReplyMessageTime(NanoTimer.getTime() - startTime);
        }

        @Override
        public int getDSFID() {
            return -121;
        }

        public PutAllReplyMessage() {
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            super.fromData(in, context);
            this.versions = (VersionedObjectList)DataSerializer.readObject(in);
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            super.toData(out, context);
            DataSerializer.writeObject(this.versions, out);
        }

        @Override
        public String toString() {
            return "PutAllReplyMessage  processorid=" + this.processorId + " returning versionTags=" + String.valueOf(this.versions);
        }
    }
}

