/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.DynamicRegionFactory;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.ResourceException;
import org.apache.geode.cache.operations.PutAllOperationContext;
import org.apache.geode.cache.operations.internal.UpdateOnlyMap;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.internal.cache.CachedDeserializableFactory;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PutAllPartialResultException;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.ha.ThreadIdentifier;
import org.apache.geode.internal.cache.tier.CachedRegionHelper;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.internal.cache.tier.sockets.ChunkedMessage;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.cache.tier.sockets.VersionedObjectList;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.security.AuthorizeRequest;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.internal.util.Breadcrumbs;
import org.apache.geode.security.ResourcePermission;
import org.apache.geode.util.internal.UncheckedUtils;
import org.jetbrains.annotations.NotNull;

public class PutAll80
extends BaseCommand {
    @Immutable
    private static final PutAll80 singleton = new PutAll80();

    public static Command getCommand() {
        return singleton;
    }

    protected PutAll80() {
    }

    protected String putAllClassName() {
        return "putAll80";
    }

    protected Object getOptionalCallbackArg(Message msg) throws ClassNotFoundException, IOException {
        return null;
    }

    protected int getBasePartCount() {
        return 5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cmdExecute(@NotNull Message clientMessage, @NotNull ServerConnection serverConnection, @NotNull SecurityService securityService, long startp) throws IOException, InterruptedException {
        VersionedObjectList response;
        String regionName;
        long start = startp;
        StringBuilder errMessage = new StringBuilder();
        CachedRegionHelper crHelper = serverConnection.getCachedRegionHelper();
        CacheServerStats stats = serverConnection.getCacheServerStats();
        serverConnection.setAsTrue(2);
        serverConnection.setAsTrue(3);
        long oldStart = start;
        start = DistributionStats.getStatTime();
        stats.incReadPutAllRequestTime(start - oldStart);
        boolean replyWithMetaData = false;
        try {
            PartitionedRegion pr;
            Part regionNamePart = clientMessage.getPart(0);
            regionName = regionNamePart.getCachedString();
            if (regionName == null) {
                String putAllMsg = "The input region name for the putAll request is null";
                logger.warn("{}: {}", (Object)serverConnection.getName(), (Object)putAllMsg);
                errMessage.append(putAllMsg);
                PutAll80.writeChunkedErrorResponse(clientMessage, 8, errMessage.toString(), serverConnection);
                serverConnection.setAsTrue(1);
                return;
            }
            LocalRegion region = (LocalRegion)crHelper.getRegion(regionName);
            if (region == null) {
                String reason = " was not found during putAll request";
                PutAll80.writeRegionDestroyedEx(clientMessage, regionName, reason, serverConnection);
                serverConnection.setAsTrue(1);
                return;
            }
            int BASE_PART_COUNT = this.getBasePartCount();
            Part eventPart = clientMessage.getPart(1);
            ByteBuffer eventIdPartsBuffer = ByteBuffer.wrap(eventPart.getSerializedForm());
            long threadId = EventID.readEventIdPartsFromOptimizedByteArray(eventIdPartsBuffer);
            long sequenceId = EventID.readEventIdPartsFromOptimizedByteArray(eventIdPartsBuffer);
            EventID eventId = new EventID(serverConnection.getEventMemberIDByteArray(), threadId, sequenceId);
            Breadcrumbs.setEventId(eventId);
            Part callbacksPart = clientMessage.getPart(2);
            boolean skipCallbacks = callbacksPart.getInt() == 1;
            int flags = clientMessage.getPart(3).getInt();
            boolean clientIsEmpty = (flags & 1) != 0;
            boolean clientHasCCEnabled = (flags & 2) != 0;
            Part numberOfKeysPart = clientMessage.getPart(4);
            int numberOfKeys = numberOfKeysPart.getInt();
            Object callbackArg = this.getOptionalCallbackArg(clientMessage);
            if (logger.isDebugEnabled()) {
                String buffer = serverConnection.getName() + ": Received " + this.putAllClassName() + " request from " + serverConnection.getSocketString() + " for region " + regionName + (String)(callbackArg != null ? " callbackArg " + String.valueOf(callbackArg) : "") + " with " + numberOfKeys + " entries.";
                logger.debug(buffer);
            }
            Map<Object, byte[]> map = new LinkedHashMap();
            LinkedHashMap retryVersions = new LinkedHashMap();
            for (int i = 0; i < numberOfKeys; ++i) {
                String putAllMsg;
                Part keyPart = clientMessage.getPart(BASE_PART_COUNT + i * 2);
                Object key = keyPart.getStringOrObject();
                if (key == null) {
                    putAllMsg = "One of the input keys for the putAll request is null";
                    logger.warn("{}: {}", (Object)serverConnection.getName(), (Object)putAllMsg);
                    errMessage.append(putAllMsg);
                    PutAll80.writeChunkedErrorResponse(clientMessage, 8, errMessage.toString(), serverConnection);
                    serverConnection.setAsTrue(1);
                    return;
                }
                Part valuePart = clientMessage.getPart(BASE_PART_COUNT + i * 2 + 1);
                if (valuePart.isNull()) {
                    putAllMsg = "One of the input values for the putAll request is null";
                    logger.warn("{}: {}", (Object)serverConnection.getName(), (Object)putAllMsg);
                    errMessage.append(putAllMsg);
                    PutAll80.writeChunkedErrorResponse(clientMessage, 8, errMessage.toString(), serverConnection);
                    serverConnection.setAsTrue(1);
                    return;
                }
                Object value = valuePart.isObject() ? (skipCallbacks && Token.INVALID.isSerializedValue(valuePart.getSerializedForm()) ? (Object)Token.INVALID : (Object)CachedDeserializableFactory.create(valuePart.getSerializedForm(), region.getCache())) : valuePart.getSerializedForm();
                if (clientMessage.isRetry()) {
                    VersionTag<?> tag;
                    EventID entryEventId = new EventID(eventId, i);
                    if (region instanceof PartitionedRegion) {
                        PartitionedRegion pr2 = (PartitionedRegion)region;
                        int bucketId = pr2.getKeyInfo(key).getBucketId();
                        long entryThreadId = ThreadIdentifier.createFakeThreadIDForBulkOp(bucketId, entryEventId.getThreadID());
                        entryEventId = new EventID(entryEventId.getMembershipID(), entryThreadId, entryEventId.getSequenceID());
                    }
                    if ((tag = this.findVersionTagsForRetriedBulkOp(region, entryEventId)) != null) {
                        retryVersions.put(key, tag);
                    }
                }
                map.put(key, (byte[])value);
            }
            if (clientMessage.getNumberOfParts() == BASE_PART_COUNT + 2 * numberOfKeys + 1) {
                int timeout = clientMessage.getPart(BASE_PART_COUNT + 2 * numberOfKeys).getInt();
                serverConnection.setRequestSpecificTimeout(timeout);
            }
            securityService.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.WRITE, regionName);
            AuthorizeRequest authzRequest = serverConnection.getAuthzRequest();
            if (authzRequest != null) {
                if (DynamicRegionFactory.regionIsDynamicRegionList(regionName)) {
                    authzRequest.createRegionAuthorize(regionName);
                } else {
                    PutAllOperationContext putAllContext = authzRequest.putAllAuthorize(regionName, map, callbackArg);
                    if ((map = putAllContext.getMap()) instanceof UpdateOnlyMap) {
                        map = (Map)UncheckedUtils.uncheckedCast((Object)((UpdateOnlyMap)map).getInternalMap());
                    }
                    callbackArg = putAllContext.getCallbackArg();
                }
            }
            response = region.basicBridgePutAll(map, (Map)UncheckedUtils.uncheckedCast(retryVersions), serverConnection.getProxyID(), eventId, skipCallbacks, callbackArg, clientMessage.isRetry());
            if (!region.getConcurrencyChecksEnabled() || clientIsEmpty || !clientHasCCEnabled) {
                if (logger.isTraceEnabled()) {
                    logger.trace("setting response to null. region-cc-enabled={}; clientIsEmpty={}; client-cc-enabled={}", (Object)region.getConcurrencyChecksEnabled(), (Object)clientIsEmpty, (Object)clientHasCCEnabled);
                }
                response = null;
            }
            if (region instanceof PartitionedRegion && (pr = (PartitionedRegion)region).getNetworkHopType() != 0) {
                this.writeReplyWithRefreshMetadata(clientMessage, response, serverConnection, pr, pr.getNetworkHopType());
                pr.clearNetworkHopData();
                replyWithMetaData = true;
            }
        }
        catch (RegionDestroyedException | ResourceException | PutAllPartialResultException rde) {
            PutAll80.writeChunkedException(clientMessage, rde, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        catch (Exception ce) {
            PutAll80.checkForInterrupt(serverConnection, ce);
            PutAll80.writeChunkedException(clientMessage, ce, serverConnection);
            serverConnection.setAsTrue(1);
            logger.warn(String.format("%s: Unexpected Exception", serverConnection.getName()), (Throwable)ce);
            return;
        }
        finally {
            long oldStart2 = start;
            start = DistributionStats.getStatTime();
            stats.incProcessPutAllTime(start - oldStart2);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Sending {} response back to {} for regin {} {}", (Object)serverConnection.getName(), (Object)this.putAllClassName(), (Object)serverConnection.getSocketString(), (Object)regionName, logger.isTraceEnabled() ? ": " + String.valueOf(response) : "");
        }
        if (!replyWithMetaData) {
            this.writeReply(clientMessage, response, serverConnection);
        }
        serverConnection.setAsTrue(1);
        stats.incWritePutAllResponseTime(DistributionStats.getStatTime() - start);
    }

    @Override
    protected void writeReply(@NotNull Message origMsg, @NotNull ServerConnection serverConnection) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected void writeReply(Message origMsg, VersionedObjectList response, ServerConnection servConn) throws IOException {
        int listSize;
        servConn.getCache().getCancelCriterion().checkCancelInProgress(null);
        ChunkedMessage replyMsg = servConn.getChunkedResponseMessage();
        replyMsg.setMessageType(1);
        replyMsg.setTransactionId(origMsg.getTransactionId());
        int n = listSize = response == null ? 0 : response.size();
        if (response != null) {
            response.setKeys(null);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("sending chunked response header.  version list size={}{}", (Object)listSize, logger.isTraceEnabled() ? " list=" + String.valueOf(response) : "");
        }
        replyMsg.sendHeader();
        if (listSize > 0) {
            int chunkSize = 2 * MAXIMUM_CHUNK_SIZE;
            VersionedObjectList.Chunker chunk = new VersionedObjectList.Chunker(response, chunkSize, false, false);
            for (int i = 0; i < listSize; i += chunkSize) {
                boolean lastChunk = i + chunkSize >= listSize;
                replyMsg.setNumberOfParts(1);
                replyMsg.setMessageType(1);
                replyMsg.setLastChunk(lastChunk);
                replyMsg.setTransactionId(origMsg.getTransactionId());
                replyMsg.addObjPart(chunk);
                if (logger.isDebugEnabled()) {
                    logger.debug("sending chunk at index {} last chunk={} numParts={}", (Object)i, (Object)lastChunk, (Object)replyMsg.getNumberOfParts());
                }
                replyMsg.sendChunk(servConn);
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("sending only header");
            }
            replyMsg.addObjPart(null);
            replyMsg.setLastChunk(true);
            replyMsg.sendChunk(servConn);
        }
        servConn.setAsTrue(1);
        if (logger.isTraceEnabled()) {
            logger.trace("{}: rpl tx: {}", (Object)servConn.getName(), (Object)origMsg.getTransactionId());
        }
    }

    private void writeReplyWithRefreshMetadata(Message origMsg, VersionedObjectList response, ServerConnection servConn, PartitionedRegion pr, byte nwHop) throws IOException {
        int listSize;
        servConn.getCache().getCancelCriterion().checkCancelInProgress(null);
        ChunkedMessage replyMsg = servConn.getChunkedResponseMessage();
        replyMsg.setMessageType(1);
        replyMsg.setTransactionId(origMsg.getTransactionId());
        replyMsg.sendHeader();
        int n = listSize = response == null ? 0 : response.size();
        if (logger.isDebugEnabled()) {
            logger.debug("sending chunked response header with metadata refresh status. Version list size = {}{}", (Object)listSize, logger.isTraceEnabled() ? "; list=" + String.valueOf(response) : "");
        }
        if (response != null) {
            response.setKeys(null);
        }
        replyMsg.setNumberOfParts(1);
        replyMsg.setTransactionId(origMsg.getTransactionId());
        replyMsg.addBytesPart(new byte[]{pr.getMetadataVersion(), nwHop});
        if (listSize > 0) {
            replyMsg.setLastChunk(false);
            replyMsg.sendChunk(servConn);
            int chunkSize = 2 * MAXIMUM_CHUNK_SIZE;
            VersionedObjectList.Chunker chunk = new VersionedObjectList.Chunker(response, chunkSize, false, false);
            for (int i = 0; i < listSize; i += chunkSize) {
                boolean lastChunk = i + chunkSize >= listSize;
                replyMsg.setNumberOfParts(1);
                replyMsg.setMessageType(1);
                replyMsg.setLastChunk(lastChunk);
                replyMsg.setTransactionId(origMsg.getTransactionId());
                replyMsg.addObjPart(chunk);
                if (logger.isDebugEnabled()) {
                    logger.debug("sending chunk at index {} last chunk={} numParts={}", (Object)i, (Object)lastChunk, (Object)replyMsg.getNumberOfParts());
                }
                replyMsg.sendChunk(servConn);
            }
        } else {
            replyMsg.setLastChunk(true);
            if (logger.isDebugEnabled()) {
                logger.debug("sending first and only part of chunked message");
            }
            replyMsg.sendChunk(servConn);
        }
        pr.getPrStats().incPRMetaDataSentCount();
        if (logger.isTraceEnabled()) {
            logger.trace("{}: rpl with REFRESH_METADATA tx: {}", (Object)servConn.getName(), (Object)origMsg.getTransactionId());
        }
    }
}

