/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.TransactionException;
import org.apache.geode.cache.operations.KeySetOperationContext;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.ChunkedMessage;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.security.AuthorizeRequest;
import org.apache.geode.internal.security.AuthorizeRequestPP;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.security.NotAuthorizedException;
import org.apache.geode.security.ResourcePermission;
import org.jetbrains.annotations.NotNull;

public class KeySet
extends BaseCommand {
    @Immutable
    private static final KeySet singleton = new KeySet();

    public static Command getCommand() {
        return singleton;
    }

    @Override
    public void cmdExecute(@NotNull Message clientMessage, @NotNull ServerConnection serverConnection, @NotNull SecurityService securityService, long start) throws IOException, InterruptedException {
        Part regionNamePart = null;
        String regionName = null;
        serverConnection.setAsTrue(2);
        serverConnection.setAsTrue(3);
        regionNamePart = clientMessage.getPart(0);
        regionName = regionNamePart.getCachedString();
        ChunkedMessage chunkedResponseMsg = serverConnection.getChunkedResponseMessage();
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (isDebugEnabled) {
            logger.debug("{}: Received key set request ({} bytes) from {} for region {}", (Object)serverConnection.getName(), (Object)clientMessage.getPayloadLength(), (Object)serverConnection.getSocketString(), (Object)regionName);
        }
        if (regionName == null) {
            String message = null;
            message = String.format("%s: The input region name for the key set request is null", serverConnection.getName());
            logger.warn("{}: The input region name for the key set request is null", (Object)serverConnection.getName());
            KeySet.writeKeySetErrorResponse(clientMessage, 41, message, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        LocalRegion region = (LocalRegion)serverConnection.getCache().getRegion(regionName);
        if (region == null) {
            String reason = " was not found during key set request";
            KeySet.writeRegionDestroyedEx(clientMessage, regionName, reason, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        if (this.isInTransaction() && region.getPartitionAttributes() != null && clientMessage.isRetry()) {
            this.keySetWriteChunkedException(clientMessage, new TransactionException("Failover on a set operation of a partitioned region is not allowed in a transaction."), serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        try {
            securityService.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.READ, regionName);
        }
        catch (NotAuthorizedException ex) {
            this.keySetWriteChunkedException(clientMessage, ex, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        KeySetOperationContext keySetContext = null;
        AuthorizeRequest authzRequest = serverConnection.getAuthzRequest();
        if (authzRequest != null) {
            try {
                keySetContext = authzRequest.keySetAuthorize(regionName);
            }
            catch (NotAuthorizedException ex) {
                KeySet.writeChunkedException(clientMessage, ex, serverConnection);
                serverConnection.setAsTrue(1);
                return;
            }
        }
        chunkedResponseMsg.setMessageType(1);
        chunkedResponseMsg.setTransactionId(clientMessage.getTransactionId());
        chunkedResponseMsg.sendHeader();
        try {
            this.fillAndSendKeySetResponseChunks(region, regionName, keySetContext, serverConnection);
            serverConnection.setAsTrue(1);
        }
        catch (Exception e) {
            KeySet.checkForInterrupt(serverConnection, e);
            KeySet.writeChunkedException(clientMessage, e, serverConnection, serverConnection.getChunkedResponseMessage());
            serverConnection.setAsTrue(1);
            return;
        }
        if (isDebugEnabled) {
            logger.debug("{}: Sent key set response for the region {}", (Object)serverConnection.getName(), (Object)regionName);
        }
    }

    protected void keySetWriteChunkedException(Message clientMessage, Throwable ex, ServerConnection serverConnection) throws IOException {
        KeySet.writeChunkedException(clientMessage, ex, serverConnection);
    }

    private void fillAndSendKeySetResponseChunks(LocalRegion region, String regionName, KeySetOperationContext context, ServerConnection servConn) throws IOException {
        Set keySet = region.keys();
        KeySetOperationContext keySetContext = context;
        AuthorizeRequestPP postAuthzRequest = servConn.getPostAuthzRequest();
        if (postAuthzRequest != null) {
            keySetContext = postAuthzRequest.keySetAuthorize(regionName, keySet, keySetContext);
            keySet = keySetContext.getKeySet();
        }
        ArrayList keyList = new ArrayList(MAXIMUM_CHUNK_SIZE);
        boolean isTraceEnabled = logger.isTraceEnabled();
        for (Object entryKey : keySet) {
            keyList.add(entryKey);
            if (isTraceEnabled) {
                logger.trace("{}: fillAndSendKeySetResponseKey <{}>; list size was {}; region: {}", (Object)servConn.getName(), entryKey, (Object)keyList.size(), (Object)region.getFullPath());
            }
            if (keyList.size() != MAXIMUM_CHUNK_SIZE) continue;
            KeySet.sendKeySetResponseChunk(region, keyList, false, servConn);
            keyList.clear();
        }
        KeySet.sendKeySetResponseChunk(region, keyList, true, servConn);
    }

    private static void sendKeySetResponseChunk(Region region, List list, boolean lastChunk, ServerConnection servConn) throws IOException {
        ChunkedMessage chunkedResponseMsg = servConn.getChunkedResponseMessage();
        chunkedResponseMsg.setNumberOfParts(1);
        chunkedResponseMsg.setLastChunk(lastChunk);
        chunkedResponseMsg.addObjPart(list, false);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Sending {} key set response chunk for region={}{}", (Object)servConn.getName(), (Object)(lastChunk ? " last " : " "), (Object)region.getFullPath(), logger.isTraceEnabled() ? " keys=" + String.valueOf(list) + " chunk=<" + String.valueOf(chunkedResponseMsg) + ">" : "");
        }
        chunkedResponseMsg.sendChunk(servConn);
    }

    boolean isInTransaction() {
        return TXManagerImpl.getCurrentTXState() != null;
    }
}

