/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.geode.internal.cache.tier.sockets.SubjectIdGenerator;
import org.apache.geode.internal.cache.tier.sockets.UserAuthAttributes;
import org.apache.geode.internal.security.AuthorizeRequest;
import org.apache.geode.internal.security.AuthorizeRequestPP;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;
import org.apache.shiro.subject.Subject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public class ClientUserAuths {
    private static final Logger logger = LogService.getLogger();
    private static final Logger secureLogger = LogService.getLogger((String)"org.apache.geode.security");
    private final ConcurrentMap<Long, UserAuthAttributes> uniqueIdVsUserAuth = new ConcurrentHashMap<Long, UserAuthAttributes>();
    private final ConcurrentMap<String, UserAuthAttributes> cqNameVsUserAuth = new ConcurrentHashMap<String, UserAuthAttributes>();
    private final ConcurrentMap<Long, List<Subject>> uniqueIdVsSubjects = new ConcurrentHashMap<Long, List<Subject>>();
    private final ConcurrentMap<String, Long> cqNameVsUniqueId = new ConcurrentHashMap<String, Long>();
    private final SubjectIdGenerator idGenerator;

    public Long putUserAuth(UserAuthAttributes userAuthAttr) {
        Long newId = this.getNextID();
        this.uniqueIdVsUserAuth.put(newId, userAuthAttr);
        return newId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long putSubject(@NotNull Subject subject, long existingUniqueId) {
        long newId = existingUniqueId == 0L || existingUniqueId == -1L ? this.getNextID() : existingUniqueId;
        ClientUserAuths clientUserAuths = this;
        synchronized (clientUserAuths) {
            List<Subject> subjects;
            if (!this.uniqueIdVsSubjects.containsKey(newId)) {
                secureLogger.debug("Subject of {} added.", (Object)newId);
                subjects = new ArrayList();
                this.uniqueIdVsSubjects.put(newId, subjects);
            } else {
                secureLogger.debug("Subject of {} replaced.", (Object)newId);
                subjects = (List)this.uniqueIdVsSubjects.get(newId);
            }
            subjects.add(0, subject);
        }
        return newId;
    }

    public ClientUserAuths(SubjectIdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    private synchronized long getNextID() {
        OptionalLong maybeId = this.idGenerator.generateId();
        if (!maybeId.isPresent()) {
            this.uniqueIdVsUserAuth.clear();
            return this.getNextID();
        }
        long id = maybeId.getAsLong();
        if (id == 0L | id == -1L) {
            return this.getNextID();
        }
        return id;
    }

    public UserAuthAttributes getUserAuthAttributes(Long userId) {
        return (UserAuthAttributes)this.uniqueIdVsUserAuth.get(userId);
    }

    @TestOnly
    protected synchronized Collection<Subject> getAllSubjects() {
        List all = this.uniqueIdVsSubjects.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        return Collections.unmodifiableCollection(all);
    }

    public synchronized Subject getSubject(Long userId) {
        List subjects = (List)this.uniqueIdVsSubjects.get(userId);
        if (subjects == null || subjects.isEmpty()) {
            return null;
        }
        return (Subject)subjects.get(0);
    }

    public synchronized void removeSubject(Long userId) {
        List subjects = (List)this.uniqueIdVsSubjects.remove(userId);
        if (subjects == null) {
            return;
        }
        secureLogger.debug("{} Subjects of {} removed.", (Object)subjects.size(), (Object)userId);
        subjects.forEach(Subject::logout);
    }

    public UserAuthAttributes getUserAuthAttributes(String cqName) {
        return (UserAuthAttributes)this.cqNameVsUserAuth.get(cqName);
    }

    public Subject getSubject(String cqName) {
        Long uniqueId = (Long)this.cqNameVsUniqueId.get(cqName);
        if (uniqueId == null) {
            return null;
        }
        return this.getSubject(uniqueId);
    }

    public void setUserAuthAttributesForCq(String cqName, Long uniqueId, boolean isDurable) {
        UserAuthAttributes uaa = (UserAuthAttributes)this.uniqueIdVsUserAuth.get(uniqueId);
        if (uaa != null) {
            if (!isDurable) {
                this.cqNameVsUserAuth.put(cqName, uaa);
            } else {
                UserAuthAttributes oldUaa = this.cqNameVsUserAuth.put(cqName, uaa);
                if (oldUaa != null) {
                    if (oldUaa != uaa) {
                        this.cleanUserAuth(oldUaa);
                        uaa.setDurable();
                    }
                } else {
                    uaa.setDurable();
                }
            }
        }
        this.cqNameVsUniqueId.put(cqName, uniqueId);
    }

    public void removeUserAuthAttributesForCq(String cqName, boolean isDurable) {
        UserAuthAttributes uaa = (UserAuthAttributes)this.cqNameVsUserAuth.remove(cqName);
        if (uaa != null && isDurable) {
            uaa.unsetDurable();
        }
        this.cqNameVsUniqueId.remove(cqName);
    }

    public void removeUserId(Long userId, boolean keepAlive) {
        UserAuthAttributes uaa = (UserAuthAttributes)this.uniqueIdVsUserAuth.get(userId);
        if (!(uaa == null || uaa.isDurable() && keepAlive)) {
            uaa = (UserAuthAttributes)this.uniqueIdVsUserAuth.remove(userId);
            logger.debug("UserAuth of {} removed.", (Object)userId);
            if (uaa != null) {
                this.cleanUserAuth(uaa);
            }
        }
    }

    public void cleanUserAuth(UserAuthAttributes userAuth) {
        if (userAuth != null) {
            AuthorizeRequest authReq = userAuth.getAuthzRequest();
            try {
                if (authReq != null) {
                    authReq.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                AuthorizeRequestPP postAuthzReq = userAuth.getPostAuthzRequest();
                if (postAuthzReq != null) {
                    postAuthzReq.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup(boolean fromCacheClientProxy) {
        for (UserAuthAttributes userAuth : this.uniqueIdVsUserAuth.values()) {
            if (!fromCacheClientProxy && !userAuth.isDurable()) {
                this.cleanUserAuth(userAuth);
                continue;
            }
            if (!fromCacheClientProxy || !userAuth.isDurable()) continue;
            this.cleanUserAuth(userAuth);
        }
        ClientUserAuths clientUserAuths = this;
        synchronized (clientUserAuths) {
            for (Long subjectId : this.uniqueIdVsSubjects.keySet()) {
                this.removeSubject(subjectId);
            }
        }
    }

    public void fillPreviousCQAuth(ClientUserAuths previousClientUserAuths) {
        for (Map.Entry ent : previousClientUserAuths.cqNameVsUserAuth.entrySet()) {
            UserAuthAttributes prevUaa;
            String cqName = (String)ent.getKey();
            UserAuthAttributes newUaa = this.cqNameVsUserAuth.putIfAbsent(cqName, prevUaa = (UserAuthAttributes)ent.getValue());
            if (newUaa == null) continue;
            previousClientUserAuths.cleanUserAuth(prevUaa);
        }
    }
}

