/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.operations.QueryOperationContext;
import org.apache.geode.cache.query.Query;
import org.apache.geode.cache.query.QueryException;
import org.apache.geode.cache.query.QueryExecutionLowMemoryException;
import org.apache.geode.cache.query.QueryExecutionTimeoutException;
import org.apache.geode.cache.query.QueryInvalidException;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.Struct;
import org.apache.geode.cache.query.internal.CqEntry;
import org.apache.geode.cache.query.internal.DefaultQuery;
import org.apache.geode.cache.query.internal.QueryExecutionCanceledException;
import org.apache.geode.cache.query.internal.cq.ServerCQ;
import org.apache.geode.cache.query.internal.types.CollectionTypeImpl;
import org.apache.geode.cache.query.internal.types.StructTypeImpl;
import org.apache.geode.cache.query.types.CollectionType;
import org.apache.geode.cache.query.types.ObjectType;
import org.apache.geode.distributed.DistributedSystemDisconnectedException;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.internal.cache.CachedDeserializable;
import org.apache.geode.internal.cache.tier.CachedRegionHelper;
import org.apache.geode.internal.cache.tier.MessageType;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.internal.cache.tier.sockets.ChunkedMessage;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.ObjectPartList;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.security.AuthorizeRequestPP;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.security.ResourcePermission;

public abstract class BaseCommandQuery
extends BaseCommand {
    protected boolean processQuery(Message msg, Query query, String queryString, Set<String> regionNames, long start, ServerCQ cqQuery, QueryOperationContext queryContext, ServerConnection servConn, boolean sendResults, SecurityService securityService) throws IOException, InterruptedException {
        return this.processQueryUsingParams(msg, query, queryString, regionNames, start, cqQuery, queryContext, servConn, sendResults, null, securityService);
    }

    protected boolean processQueryUsingParams(Message msg, Query query, String queryString, Set<String> regionNames, long start, ServerCQ cqQuery, QueryOperationContext queryContext, ServerConnection servConn, boolean sendResults, Object[] params, SecurityService securityService) throws IOException, InterruptedException {
        ChunkedMessage queryResponseMsg = servConn.getQueryResponseMessage();
        CacheServerStats stats = servConn.getCacheServerStats();
        CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
        long oldStart = start;
        start = DistributionStats.getStatTime();
        stats.incReadQueryRequestTime(start - oldStart);
        ((DefaultQuery)query).setRemoteQuery(true);
        try {
            for (String string : regionNames) {
                securityService.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.READ, string.toString());
            }
            Object result = params != null ? query.execute(params) : query.execute();
            for (String regionName : regionNames) {
                if (crHelper.getRegion(regionName) != null) continue;
                throw new RegionDestroyedException("Region destroyed during the execution of the query", regionName);
            }
            AuthorizeRequestPP authorizeRequestPP = servConn.getPostAuthzRequest();
            if (authorizeRequestPP != null) {
                queryContext = cqQuery == null ? authorizeRequestPP.queryAuthorize(queryString, regionNames, result, queryContext, params) : authorizeRequestPP.executeCQAuthorize(cqQuery.getName(), queryString, regionNames, result, queryContext);
                result = queryContext.getQueryResult();
            }
            if (result instanceof SelectResults) {
                SelectResults selectResults = (SelectResults)result;
                if (logger.isDebugEnabled()) {
                    logger.debug("Query Result size for : {} is {}", (Object)query.getQueryString(), (Object)selectResults.size());
                }
                boolean hasSerializedObjects = ((DefaultQuery)query).isKeepSerialized();
                if (logger.isDebugEnabled()) {
                    logger.debug("Query Result for :{} has serialized objects: {}", (Object)query.getQueryString(), (Object)hasSerializedObjects);
                }
                CollectionType collectionType = this.getCollectionType(selectResults);
                boolean isStructs = collectionType.getElementType().isStructType();
                if (cqQuery != null) {
                    collectionType = new CollectionTypeImpl(Collection.class, (ObjectType)new StructTypeImpl(new String[]{"key", "value"}));
                    isStructs = collectionType.getElementType().isStructType();
                }
                int numberOfChunks = (int)Math.ceil((double)selectResults.size() * 1.0 / (double)MAXIMUM_CHUNK_SIZE);
                if (logger.isTraceEnabled()) {
                    logger.trace("{}: Query results size: {}: Entries in chunk: {}: Number of chunks: {}", (Object)servConn.getName(), (Object)selectResults.size(), (Object)MAXIMUM_CHUNK_SIZE, (Object)numberOfChunks);
                }
                long oldStart2 = start;
                start = DistributionStats.getStatTime();
                stats.incProcessQueryTime(start - oldStart2);
                if (sendResults) {
                    queryResponseMsg.setMessageType(1);
                    queryResponseMsg.setTransactionId(msg.getTransactionId());
                    queryResponseMsg.sendHeader();
                }
                if (sendResults && numberOfChunks == 0) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("{}: Creating chunk: 0", (Object)servConn.getName());
                    }
                    BaseCommandQuery.writeQueryResponseChunk(new Object[0], collectionType, true, servConn);
                    if (logger.isDebugEnabled()) {
                        logger.debug("{}: Sent chunk (1 of 1) of query response for query {}", (Object)servConn.getName(), (Object)queryString);
                    }
                } else if (hasSerializedObjects) {
                    this.sendResultsAsObjectPartList(numberOfChunks, servConn, selectResults.asList(), isStructs, collectionType, queryString, cqQuery, sendResults, securityService);
                } else {
                    this.sendResultsAsObjectArray(selectResults, numberOfChunks, servConn, isStructs, collectionType, queryString, cqQuery, sendResults);
                }
                if (cqQuery != null) {
                    cqQuery.setCqResultsCacheInitialized();
                }
            } else if (result instanceof Integer) {
                if (sendResults) {
                    queryResponseMsg.setMessageType(1);
                    queryResponseMsg.setTransactionId(msg.getTransactionId());
                    queryResponseMsg.sendHeader();
                    BaseCommandQuery.writeQueryResponseChunk(result, null, true, servConn);
                }
            } else {
                throw new QueryInvalidException(String.format("Unknown result type: %s", result.getClass()));
            }
            msg.clearParts();
        }
        catch (QueryInvalidException e) {
            logger.warn(String.format("Unexpected QueryInvalidException while processing query %s", queryString), (Throwable)e);
            QueryInvalidException queryInvalidException = new QueryInvalidException(String.format("%s : QueryString is: %s.", e.getLocalizedMessage(), queryString));
            BaseCommandQuery.writeQueryResponseException(msg, queryInvalidException, servConn);
            return false;
        }
        catch (DistributedSystemDisconnectedException se) {
            if (msg != null && logger.isDebugEnabled()) {
                logger.debug("{}: ignoring message of type {} from client {} because shutdown occurred during message processing.", (Object)servConn.getName(), (Object)MessageType.getString(msg.getMessageType()), (Object)servConn.getProxyID());
            }
            servConn.setFlagProcessMessagesAsFalse();
            servConn.setClientDisconnectedException(se);
            return false;
        }
        catch (Exception e22) {
            QueryException e22;
            BaseCommandQuery.checkForInterrupt(servConn, e22);
            if (e22 instanceof QueryExecutionLowMemoryException || e22 instanceof QueryExecutionTimeoutException || e22 instanceof QueryExecutionCanceledException) {
                e22 = new QueryException(e22.getMessage(), e22.getCause());
            }
            BaseCommandQuery.writeQueryResponseException(msg, e22, servConn);
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Sent query response for query {}", (Object)servConn.getName(), (Object)queryString);
        }
        stats.incWriteQueryResponseTime(DistributionStats.getStatTime() - start);
        return true;
    }

    protected CollectionType getCollectionType(SelectResults<?> results) {
        return results.getCollectionType();
    }

    protected void sendCqResponse(int msgType, String msgStr, int txId, Throwable e, ServerConnection servConn) throws IOException {
        ChunkedMessage cqMsg = servConn.getChunkedResponseMessage();
        if (logger.isDebugEnabled()) {
            logger.debug("CQ Response message :{}", msgStr);
        }
        switch (msgType) {
            case 6: {
                cqMsg.setNumberOfParts(1);
                break;
            }
            case 47: {
                logger.warn((String)msgStr);
                cqMsg.setNumberOfParts(1);
                break;
            }
            case 50: {
                String exMsg = "";
                if (e != null) {
                    exMsg = e.getLocalizedMessage();
                }
                logger.info((String)msgStr + exMsg, e);
                msgStr = (String)msgStr + exMsg;
                cqMsg.setNumberOfParts(1);
                break;
            }
            default: {
                msgType = 50;
                cqMsg.setNumberOfParts(1);
                msgStr = (String)msgStr + "Uknown query Exception.";
            }
        }
        cqMsg.setMessageType(msgType);
        cqMsg.setTransactionId(txId);
        cqMsg.sendHeader();
        cqMsg.addStringPart((String)msgStr);
        cqMsg.setLastChunk(true);
        cqMsg.sendChunk(servConn);
        cqMsg.setLastChunk(true);
        if (logger.isDebugEnabled()) {
            logger.debug("CQ Response sent successfully");
        }
    }

    private void sendResultsAsObjectArray(SelectResults<?> selectResults, int numberOfChunks, ServerConnection servConn, boolean isStructs, CollectionType collectionType, String queryString, ServerCQ cqQuery, boolean sendResults) throws IOException {
        int resultIndex = 0;
        int cqResultIndex = 0;
        Object[] objs = selectResults.toArray();
        for (int j = 0; j < numberOfChunks; ++j) {
            boolean incompleteArray = false;
            if (logger.isTraceEnabled()) {
                logger.trace("{}: Creating chunk: {}", (Object)servConn.getName(), (Object)j);
            }
            Object[] results = new Object[MAXIMUM_CHUNK_SIZE];
            for (int i = 0; i < MAXIMUM_CHUNK_SIZE; ++i) {
                if (resultIndex == objs.length) {
                    incompleteArray = true;
                    break;
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("{}: Adding entry [{}] to query results: {}", (Object)servConn.getName(), (Object)resultIndex, objs[resultIndex]);
                }
                if (cqQuery != null) {
                    CqEntry e = (CqEntry)objs[resultIndex];
                    if (e.getValue() == null) {
                        ++resultIndex;
                        --i;
                        continue;
                    }
                    if (!cqQuery.isPR()) {
                        cqQuery.addToCqResultKeys(e.getKey());
                    }
                    results[i] = e.getKeyValuePair();
                } else {
                    results[i] = isStructs && objs[resultIndex] instanceof Struct ? ((Struct)objs[resultIndex]).getFieldValues() : objs[resultIndex];
                }
                ++resultIndex;
                ++cqResultIndex;
            }
            if (incompleteArray) {
                Object[] newResults = cqQuery == null ? new Object[resultIndex % MAXIMUM_CHUNK_SIZE] : new Object[cqResultIndex % MAXIMUM_CHUNK_SIZE];
                System.arraycopy(results, 0, newResults, 0, newResults.length);
                results = newResults;
            }
            if (sendResults) {
                BaseCommandQuery.writeQueryResponseChunk(results, collectionType, resultIndex == objs.length, servConn);
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: Sent chunk ({} of {}) of query response for query: {}", (Object)servConn.getName(), (Object)(j + 1), (Object)numberOfChunks, (Object)queryString);
                }
            }
            if (resultIndex == objs.length) break;
        }
    }

    private void sendResultsAsObjectPartList(int numberOfChunks, ServerConnection servConn, List<?> objs, boolean isStructs, CollectionType collectionType, String queryString, ServerCQ cqQuery, boolean sendResults, SecurityService securityService) throws IOException {
        int resultIndex = 0;
        for (int j = 0; j < numberOfChunks; ++j) {
            if (logger.isTraceEnabled()) {
                logger.trace("{}: Creating chunk: {}", (Object)servConn.getName(), (Object)j);
            }
            ObjectPartList serializedObjs = new ObjectPartList(MAXIMUM_CHUNK_SIZE, false);
            for (int i = 0; i < MAXIMUM_CHUNK_SIZE && resultIndex != objs.size(); ++i) {
                Object result;
                if (logger.isTraceEnabled()) {
                    logger.trace("{}: Adding entry [{}] to query results: {}", (Object)servConn.getName(), (Object)resultIndex, objs.get(resultIndex));
                }
                if (cqQuery != null) {
                    CqEntry e = (CqEntry)objs.get(resultIndex);
                    if (e.getValue() == null) {
                        ++resultIndex;
                        continue;
                    }
                    if (!cqQuery.isPR()) {
                        cqQuery.addToCqResultKeys(e.getKey());
                    }
                    result = e.getKeyValuePair();
                } else {
                    result = objs.get(resultIndex);
                }
                if (sendResults) {
                    this.addToObjectPartList(serializedObjs, result, isStructs, securityService);
                }
                ++resultIndex;
            }
            if (!sendResults) continue;
            BaseCommandQuery.writeQueryResponseChunk(serializedObjs, collectionType, j + 1 == numberOfChunks, servConn);
            if (!logger.isDebugEnabled()) continue;
            logger.debug("{}: Sent chunk ({} of {}) of query response for query: {}", (Object)servConn.getName(), (Object)(j + 1), (Object)numberOfChunks, (Object)queryString);
        }
    }

    private void addToObjectPartList(ObjectPartList serializedObjs, Object res, boolean isStructs, SecurityService securityService) {
        if (isStructs && res instanceof Struct) {
            Object[] values = ((Struct)res).getFieldValues();
            ObjectPartList serializedValueObjs = new ObjectPartList(values.length, false);
            for (Object value : values) {
                this.addObjectToPartList(serializedValueObjs, null, value, securityService);
            }
            serializedObjs.addPart(null, serializedValueObjs, (byte)1, null);
        } else if (res instanceof Object[]) {
            Object[] values = (Object[])res;
            ObjectPartList serializedValueObjs = new ObjectPartList(values.length, false);
            for (int i = 0; i < values.length - 1; i += 2) {
                Object key = values[i];
                Object value = values[i + 1];
                this.addObjectToPartList(serializedValueObjs, key, value, securityService);
            }
            serializedObjs.addPart(null, serializedValueObjs, (byte)1, null);
        } else {
            this.addObjectToPartList(serializedObjs, null, res, securityService);
        }
    }

    private void addObjectToPartList(ObjectPartList objPartList, Object key, Object value, SecurityService securityService) {
        Object object = value;
        boolean isObject = true;
        if (value instanceof CachedDeserializable) {
            object = ((CachedDeserializable)value).getSerializedValue();
        } else if (value instanceof byte[]) {
            isObject = false;
        }
        object = securityService.postProcess(null, key, object, isObject);
        if (key != null) {
            objPartList.addPart(null, key, (byte)1, null);
        }
        objPartList.addPart(null, object, isObject ? (byte)1 : 0, null);
    }
}

