/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.geode.CancelException;
import org.apache.geode.SystemFailure;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.annotations.internal.MutableForTesting;
import org.apache.geode.cache.client.Pool;
import org.apache.geode.cache.client.PoolManager;
import org.apache.geode.cache.client.internal.Endpoint;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DistributedSystemDisconnectedException;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.distributed.internal.ServerLocationAndMemberId;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.CacheClientStatus;
import org.apache.geode.internal.cache.IncomingGatewayStatus;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalCacheServer;
import org.apache.geode.internal.cache.tier.Acceptor;
import org.apache.geode.internal.cache.tier.sockets.ClientHealthMonitor;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.logging.internal.executors.LoggingExecutors;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.membership.ClientMembershipEvent;
import org.apache.geode.management.membership.ClientMembershipListener;
import org.apache.logging.log4j.Logger;

public class InternalClientMembership {
    private static final Logger logger = LogService.getLogger();
    @MakeNotStatic
    private static volatile List<ClientMembershipListener> clientMembershipListeners = Collections.emptyList();
    private static final Object membershipLock = new Object();
    @MakeNotStatic
    private static ExecutorService executor;
    @MakeNotStatic
    private static final List systems;
    @MakeNotStatic
    private static boolean isMonitoring;
    @MutableForTesting
    private static boolean forceSynchronous;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void startMonitoring() {
        if (isMonitoring) {
            return;
        }
        List list = systems;
        synchronized (list) {
            List existingSystems = InternalDistributedSystem.addConnectListener(InternalClientMembership::addInternalDistributedSystem);
            isMonitoring = true;
            for (Object existingSystem : existingSystems) {
                InternalDistributedSystem sys = (InternalDistributedSystem)existingSystem;
                try {
                    if (!sys.isConnected()) continue;
                    InternalClientMembership.addInternalDistributedSystem(sys);
                }
                catch (DistributedSystemDisconnectedException distributedSystemDisconnectedException) {}
            }
        }
    }

    private InternalClientMembership() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerClientMembershipListener(ClientMembershipListener listener) {
        InternalClientMembership.startMonitoring();
        Object object = membershipLock;
        synchronized (object) {
            List<ClientMembershipListener> oldListeners = clientMembershipListeners;
            if (!oldListeners.contains(listener)) {
                ArrayList<ClientMembershipListener> newListeners = new ArrayList<ClientMembershipListener>(oldListeners);
                newListeners.add(listener);
                clientMembershipListeners = newListeners;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterClientMembershipListener(ClientMembershipListener listener) {
        InternalClientMembership.startMonitoring();
        Object object = membershipLock;
        synchronized (object) {
            ArrayList<ClientMembershipListener> newListeners;
            List<ClientMembershipListener> oldListeners = clientMembershipListeners;
            if (oldListeners.contains(listener) && (newListeners = new ArrayList<ClientMembershipListener>(oldListeners)).remove(listener)) {
                clientMembershipListeners = newListeners;
            }
        }
    }

    public static ClientMembershipListener[] getClientMembershipListeners() {
        InternalClientMembership.startMonitoring();
        List<ClientMembershipListener> l = clientMembershipListeners;
        return l.toArray(new ClientMembershipListener[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterAllListeners() {
        InternalClientMembership.startMonitoring();
        Object object = membershipLock;
        synchronized (object) {
            clientMembershipListeners = new ArrayList<ClientMembershipListener>();
        }
    }

    public static Map getConnectedClients(boolean onlyClientsNotifiedByThisServer, InternalCache cache) {
        ClientHealthMonitor chMon = ClientHealthMonitor.getInstance();
        Set<ClientProxyMembershipID> filterProxyIDs = null;
        if (onlyClientsNotifiedByThisServer) {
            for (CacheServer server : cache.getCacheServers()) {
                InternalCacheServer cacheServer = (InternalCacheServer)server;
                Acceptor acceptor = cacheServer.getAcceptor();
                if (acceptor == null || acceptor.getCacheClientNotifier() == null) continue;
                if (filterProxyIDs != null) {
                    filterProxyIDs.addAll(acceptor.getCacheClientNotifier().getActiveClients());
                    continue;
                }
                filterProxyIDs = acceptor.getCacheClientNotifier().getActiveClients();
            }
        }
        return chMon.getConnectedClients(filterProxyIDs);
    }

    public static Map getStatusForAllClientsIgnoreSubscriptionStatus() {
        Map<Object, Object> result = new HashMap();
        if (ClientHealthMonitor.getInstance() != null) {
            result = ClientHealthMonitor.getInstance().getStatusForAllClients();
        }
        return result;
    }

    public static Map getConnectedClients(InternalCache cache) {
        HashMap<ClientProxyMembershipID, CacheClientStatus> allClients = new HashMap<ClientProxyMembershipID, CacheClientStatus>();
        for (CacheServer server : cache.getCacheServers()) {
            InternalCacheServer cacheServer = (InternalCacheServer)server;
            Acceptor acceptor = cacheServer.getAcceptor();
            if (acceptor == null || acceptor.getCacheClientNotifier() == null) continue;
            allClients.putAll(acceptor.getCacheClientNotifier().getAllClients());
        }
        if (ClientHealthMonitor.getInstance() != null) {
            ClientHealthMonitor.getInstance().fillInClientInfo(allClients);
        }
        return allClients;
    }

    public static Map getClientQueueSizes(InternalCache cache) {
        if (cache == null) {
            return Collections.emptyMap();
        }
        HashMap<ClientProxyMembershipID, Integer> clientQueueSizes = new HashMap<ClientProxyMembershipID, Integer>();
        for (CacheServer cacheServer : cache.getCacheServers()) {
            InternalCacheServer internalCacheServer = (InternalCacheServer)cacheServer;
            Acceptor acceptor = internalCacheServer.getAcceptor();
            if (acceptor == null || acceptor.getCacheClientNotifier() == null) continue;
            clientQueueSizes.putAll(acceptor.getCacheClientNotifier().getClientQueueSizes());
        }
        return clientQueueSizes;
    }

    public static Map getConnectedServers() {
        HashMap<CallSite, Integer> map = new HashMap<CallSite, Integer>();
        Map<String, Pool> poolMap = PoolManager.getAll();
        for (Pool value : poolMap.values()) {
            PoolImpl pi = (PoolImpl)value;
            Map<ServerLocationAndMemberId, Endpoint> eps = pi.getEndpointMap();
            Iterator<Map.Entry<ServerLocationAndMemberId, Endpoint>> iterator = eps.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ServerLocationAndMemberId, Endpoint> o;
                Map.Entry<ServerLocationAndMemberId, Endpoint> entry = o = iterator.next();
                ServerLocation loc = entry.getKey().getServerLocation();
                Endpoint ep = entry.getValue();
                String server = loc.getHostName() + "[" + loc.getPort() + "]";
                Integer count = (Integer)map.get(server);
                if (count == null) {
                    map.put((CallSite)((Object)server), 1);
                    continue;
                }
                map.put((CallSite)((Object)server), count + 1);
            }
        }
        return map;
    }

    public static Map getConnectedIncomingGateways() {
        Map<String, IncomingGatewayStatus> connectedIncomingGateways = null;
        ClientHealthMonitor chMon = ClientHealthMonitor.getInstance();
        connectedIncomingGateways = chMon == null ? new HashMap<String, IncomingGatewayStatus>() : chMon.getConnectedIncomingGateways();
        return connectedIncomingGateways;
    }

    public static void notifyClientJoined(DistributedMember clientId) {
        InternalClientMembership.notifyListeners(clientId, true, EventType.JOINED);
    }

    public static void notifyClientLeft(DistributedMember clientId) {
        InternalClientMembership.notifyListeners(clientId, true, EventType.LEFT);
    }

    public static void notifyClientCrashed(DistributedMember clientId) {
        InternalClientMembership.notifyListeners(clientId, true, EventType.CRASHED);
    }

    public static void notifyServerJoined(ServerLocation location) {
        InternalDistributedMember id = new InternalDistributedMember(location);
        InternalClientMembership.notifyListeners(id, false, EventType.JOINED);
    }

    public static void notifyServerLeft(ServerLocation location) {
        InternalDistributedMember id = new InternalDistributedMember(location);
        InternalClientMembership.notifyListeners(id, false, EventType.LEFT);
    }

    public static void notifyServerCrashed(ServerLocation location) {
        InternalDistributedMember id = new InternalDistributedMember(location);
        InternalClientMembership.notifyListeners(id, false, EventType.CRASHED);
    }

    private static void notifyListeners(DistributedMember member, boolean client, EventType typeOfEvent) {
        InternalClientMembership.startMonitoring();
        ExecutorService queuedExecutor = executor;
        if (queuedExecutor == null) {
            return;
        }
        InternalClientMembershipEvent event = new InternalClientMembershipEvent(member, client);
        if (forceSynchronous) {
            InternalClientMembership.doNotifyClientMembershipListener(member, client, event, typeOfEvent);
        } else {
            try {
                queuedExecutor.execute(() -> InternalClientMembership.doNotifyClientMembershipListener(member, client, event, typeOfEvent));
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }

    private static void doNotifyClientMembershipListener(DistributedMember member, boolean client, ClientMembershipEvent clientMembershipEvent, EventType eventType) {
        for (ClientMembershipListener listener : clientMembershipListeners) {
            try {
                if (eventType.equals((Object)EventType.JOINED)) {
                    listener.memberJoined(clientMembershipEvent);
                    continue;
                }
                if (eventType.equals((Object)EventType.LEFT)) {
                    listener.memberLeft(clientMembershipEvent);
                    continue;
                }
                listener.memberCrashed(clientMembershipEvent);
            }
            catch (CancelException e) {
                return;
            }
            catch (VirtualMachineError e) {
                SystemFailure.initiateFailure(e);
                throw e;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                logger.warn("unexpected exception", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void addInternalDistributedSystem(InternalDistributedSystem s) {
        List list = systems;
        synchronized (list) {
            s.addDisconnectListener(new InternalDistributedSystem.DisconnectListener(){

                public String toString() {
                    return "Disconnect listener for InternalClientMembership";
                }

                @Override
                public void onDisconnect(InternalDistributedSystem ss) {
                    InternalClientMembership.removeInternalDistributedSystem(ss);
                }
            });
            systems.add(s);
            InternalClientMembership.ensureExecutorIsRunning();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void removeInternalDistributedSystem(InternalDistributedSystem sys) {
        List list = systems;
        synchronized (list) {
            systems.remove(sys);
            if (systems.isEmpty()) {
                if (executor != null) {
                    executor.shutdown();
                }
                executor = null;
            }
        }
    }

    private static void ensureExecutorIsRunning() {
        if (executor == null) {
            executor = LoggingExecutors.newFixedThreadPoolWithTimeout((int)1, (int)15, (TimeUnit)TimeUnit.SECONDS, (String)"ClientMembership Event Invoker");
        }
    }

    public static void setForceSynchronous(boolean value) {
        forceSynchronous = value;
    }

    static {
        systems = new ArrayList(1);
        isMonitoring = false;
        forceSynchronous = false;
    }

    private static enum EventType {
        JOINED,
        LEFT,
        CRASHED;

    }

    protected static class InternalClientMembershipEvent
    implements ClientMembershipEvent {
        private final DistributedMember member;
        private final boolean client;

        protected InternalClientMembershipEvent(DistributedMember member, boolean isClient) {
            this.member = member;
            this.client = isClient;
        }

        @Override
        public DistributedMember getMember() {
            return this.member;
        }

        @Override
        public String getMemberId() {
            return this.member == null ? "unknown" : this.member.getId();
        }

        @Override
        public boolean isClient() {
            return this.client;
        }

        public String toString() {
            return "[ClientMembershipEvent: member=" + String.valueOf(this.member) + ", isClient=" + this.client + "]";
        }
    }
}

