/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.persistence;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.MessageWithReply;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.cache.persistence.PersistentMembershipView;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class MembershipViewRequest
extends DistributionMessage
implements MessageWithReply {
    private static final Logger logger = LogService.getLogger();
    private String regionPath;
    private int processorId;
    private boolean targetReinitializing;

    public MembershipViewRequest() {
    }

    public MembershipViewRequest(String regionPath, int processorId, boolean targetReinitializing) {
        this.regionPath = regionPath;
        this.processorId = processorId;
        this.targetReinitializing = targetReinitializing;
    }

    public static PersistentMembershipView send(InternalDistributedMember recipient, DistributionManager dm, String regionPath, boolean targetReinitializing) throws ReplyException {
        MembershipViewRequestReplyProcessor processor = new MembershipViewRequestReplyProcessor(dm, recipient);
        MembershipViewRequest msg = new MembershipViewRequest(regionPath, processor.getProcessorId(), targetReinitializing);
        msg.setRecipient(recipient);
        dm.putOutgoing(msg);
        return processor.getResult();
    }

    public static Set<PersistentMembershipView> send(Set<InternalDistributedMember> recipients, DistributionManager dm, String regionPath) throws ReplyException {
        MembershipViewRequestReplyProcessor processor = new MembershipViewRequestReplyProcessor(dm, recipients);
        MembershipViewRequest msg = new MembershipViewRequest(regionPath, processor.getProcessorId(), false);
        msg.setRecipients(recipients);
        dm.putOutgoing(msg);
        return processor.getResults();
    }

    @Override
    public int getProcessorType() {
        return this.targetReinitializing ? 77 : 75;
    }

    /*
     * Exception decompiling
     */
    @Override
    protected void process(ClusterDistributionManager dm) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int getDSFID() {
        return 2100;
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.processorId = in.readInt();
        this.regionPath = DataSerializer.readString(in);
        this.targetReinitializing = in.readBoolean();
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        out.writeInt(this.processorId);
        DataSerializer.writeString(this.regionPath, out);
        out.writeBoolean(this.targetReinitializing);
    }

    private static class MembershipViewRequestReplyProcessor
    extends ReplyProcessor21 {
        private final Set<PersistentMembershipView> views = new HashSet<PersistentMembershipView>();

        public MembershipViewRequestReplyProcessor(DistributionManager dm, InternalDistributedMember member) {
            super(dm, member);
        }

        public MembershipViewRequestReplyProcessor(DistributionManager dm, Set<InternalDistributedMember> members) {
            super(dm, members);
        }

        public PersistentMembershipView getResult() {
            this.waitForRepliesUninterruptibly();
            if (this.views.isEmpty()) {
                throw new ReplyException("Member departed");
            }
            return this.views.iterator().next();
        }

        public Set<PersistentMembershipView> getResults() {
            this.waitForRepliesUninterruptibly();
            return this.views;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process(DistributionMessage msg) {
            if (msg instanceof MembershipViewReplyMessage) {
                PersistentMembershipView view = ((MembershipViewReplyMessage)msg).view;
                if (logger.isDebugEnabled()) {
                    logger.debug("MembershipViewReplyProcessor received {}", (Object)view);
                }
                if (view != null) {
                    MembershipViewRequestReplyProcessor membershipViewRequestReplyProcessor = this;
                    synchronized (membershipViewRequestReplyProcessor) {
                        this.views.add(view);
                    }
                }
            }
            super.process(msg);
        }
    }

    public static class MembershipViewReplyMessage
    extends ReplyMessage {
        private PersistentMembershipView view;

        @Override
        public int getDSFID() {
            return 2101;
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            super.fromData(in, context);
            boolean hasView = in.readBoolean();
            if (hasView) {
                this.view = new PersistentMembershipView();
                InternalDataSerializer.invokeFromData(this.view, in);
            }
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            super.toData(out, context);
            if (this.view == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                InternalDataSerializer.invokeToData(this.view, out);
            }
        }
    }
}

