/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.InvalidDeltaException;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.EntryExistsException;
import org.apache.geode.cache.Operation;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DirectReplyProcessor;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.ReplySender;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.NanoTimer;
import org.apache.geode.internal.cache.CachedDeserializable;
import org.apache.geode.internal.cache.DataLocationException;
import org.apache.geode.internal.cache.DistributedCacheOperation;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.EnumListenerEvent;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.FilterRoutingInfo;
import org.apache.geode.internal.cache.ForceReattemptException;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PartitionedRegionDataStore;
import org.apache.geode.internal.cache.PrimaryBucketException;
import org.apache.geode.internal.cache.partitioned.PRLocallyDestroyedException;
import org.apache.geode.internal.cache.partitioned.PartitionMessage;
import org.apache.geode.internal.cache.partitioned.PartitionMessageWithDirectReply;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tx.RemotePutMessage;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class PutMessage
extends PartitionMessageWithDirectReply
implements EntryEventImpl.NewValueImporter {
    private static final Logger logger = LogService.getLogger();
    private Object key;
    private byte[] valBytes;
    private transient Object valObj;
    private Object cbArg;
    protected long lastModified;
    private Operation op;
    ClientProxyMembershipID bridgeContext;
    EventID eventId;
    InternalDistributedMember originalSender;
    protected byte deserializationPolicy = 0;
    private boolean ifNew;
    private boolean ifOld;
    private boolean requireOldValue;
    private Object expectedOldValue;
    private transient InternalDistributedSystem internalDs;
    transient boolean result = false;
    private FilterRoutingInfo filterInfo;
    private boolean hasFilterInfo;
    private boolean hasDelta = false;
    private transient boolean isDeltaApplied = false;
    private transient boolean sendDelta = false;
    private EntryEventImpl event = null;
    private byte[] deltaBytes = null;
    private VersionTag versionTag;
    private boolean generateCallbacks = true;
    protected static final short CACHE_WRITE = 4096;
    protected static final short HAS_EXPECTED_OLD_VAL = 8192;
    protected static final short HAS_VERSION_TAG = 16384;
    protected static final int HAS_BRIDGE_CONTEXT = PutMessage.getNextByteMask(DistributedCacheOperation.DESERIALIZATION_POLICY_END);
    protected static final int HAS_ORIGINAL_SENDER = PutMessage.getNextByteMask(HAS_BRIDGE_CONTEXT);
    protected static final int HAS_DELTA_WITH_FULL_VALUE = PutMessage.getNextByteMask(HAS_ORIGINAL_SENDER);
    protected static final int DO_NOT_GENERATE_CALLBACKS = PutMessage.getNextByteMask(HAS_DELTA_WITH_FULL_VALUE);

    public PutMessage() {
    }

    PutMessage(PutMessage original, EntryEventImpl event, Set members) {
        super(original, event);
        this.key = original.key;
        if (original.valBytes != null) {
            this.valBytes = original.valBytes;
        } else if (original.valObj instanceof CachedDeserializable) {
            CachedDeserializable cd = (CachedDeserializable)original.valObj;
            if (!cd.isSerialized()) {
                this.valObj = cd.getDeserializedForReading();
            } else {
                Object val = cd.getValue();
                if (val instanceof byte[]) {
                    this.valBytes = (byte[])val;
                } else {
                    this.valObj = val;
                }
            }
        } else {
            this.valObj = original.valObj;
        }
        this.cbArg = original.cbArg;
        this.lastModified = original.lastModified;
        this.op = original.op;
        this.bridgeContext = original.bridgeContext;
        this.deserializationPolicy = original.deserializationPolicy;
        this.originalSender = original.getSender();
        Assert.assertTrue(original.eventId != null);
        this.eventId = original.eventId;
        this.result = original.result;
        this.ifNew = original.ifNew;
        this.ifOld = original.ifOld;
        this.internalDs = original.internalDs;
        this.requireOldValue = original.requireOldValue;
        this.expectedOldValue = original.expectedOldValue;
        this.processor = original.processor;
        this.event = event;
        this.versionTag = event.getVersionTag();
    }

    PutMessage(PutMessage original) {
        super(original, null);
        this.bridgeContext = original.bridgeContext;
        this.cbArg = original.cbArg;
        this.deserializationPolicy = original.deserializationPolicy;
        this.event = original.event;
        this.eventId = original.eventId;
        this.expectedOldValue = original.expectedOldValue;
        this.hasDelta = original.hasDelta;
        this.ifNew = original.ifNew;
        this.ifOld = original.ifOld;
        this.internalDs = original.internalDs;
        this.isDeltaApplied = original.isDeltaApplied;
        this.key = original.key;
        this.lastModified = original.lastModified;
        this.notificationOnly = original.notificationOnly;
        this.op = original.op;
        this.originalSender = original.originalSender;
        this.requireOldValue = original.requireOldValue;
        this.result = original.result;
        this.sendDelta = original.sendDelta;
        this.sender = original.sender;
        this.valBytes = original.valBytes;
        this.valObj = original.valObj;
        this.filterInfo = original.filterInfo;
        this.versionTag = original.versionTag;
    }

    @Override
    public PartitionMessage getMessageForRelayToListeners(EntryEventImpl ev, Set members) {
        PutMessage msg = new PutMessage(this, ev, members);
        msg.requireOldValue = false;
        msg.expectedOldValue = null;
        return msg;
    }

    public static Set notifyListeners(Set cacheOpReceivers, Set adjunctRecipients, FilterRoutingInfo filterInfo, PartitionedRegion r, EntryEventImpl event, boolean ifNew, boolean ifOld, DirectReplyProcessor processor, boolean sendDeltaWithFullValue) {
        PutMessage msg = new PutMessage(Collections.EMPTY_SET, true, r.getPRId(), processor, event, 0L, ifNew, ifOld, null, false);
        msg.setTransactionDistributed(r.getCache().getTxManager().isDistributed());
        msg.setInternalDs(r.getSystem());
        msg.versionTag = event.getVersionTag();
        msg.setSendDeltaWithFullValue(sendDeltaWithFullValue);
        return msg.relayToListeners(cacheOpReceivers, adjunctRecipients, filterInfo, event, r, processor);
    }

    PutMessage(Set recipients, boolean notifyOnly, int regionId, DirectReplyProcessor processor, EntryEventImpl event, long lastModified, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue) {
        super(recipients, regionId, processor, event);
        this.processor = processor;
        this.notificationOnly = notifyOnly;
        this.requireOldValue = requireOldValue;
        this.expectedOldValue = expectedOldValue;
        this.key = event.getKey();
        if (event.hasNewValue()) {
            this.deserializationPolicy = (byte)2;
            event.exportNewValue(this);
        } else assert (this.deserializationPolicy == 0) : this.deserializationPolicy;
        this.event = event;
        this.cbArg = event.getRawCallbackArgument();
        this.lastModified = lastModified;
        this.op = event.getOperation();
        this.bridgeContext = event.getContext();
        this.eventId = event.getEventId();
        this.versionTag = event.getVersionTag();
        Assert.assertTrue(this.eventId != null);
        this.ifNew = ifNew;
        this.ifOld = ifOld;
    }

    @Override
    public boolean isSevereAlertCompatible() {
        return true;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public static PartitionMessage.PartitionResponse send(DistributedMember recipient, PartitionedRegion r, EntryEventImpl event, long lastModified, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue) throws ForceReattemptException {
        Set<DistributedMember> recipients = Collections.singleton(recipient);
        PutResponse processor = new PutResponse(r.getSystem(), recipients, event.getKey());
        PutMessage m = new PutMessage(recipients, false, r.getPRId(), processor, event, lastModified, ifNew, ifOld, expectedOldValue, requireOldValue);
        m.setInternalDs(r.getSystem());
        m.setSendDelta(true);
        m.setTransactionDistributed(r.getCache().getTxManager().isDistributed());
        processor.setPutMessage(m);
        Set<InternalDistributedMember> failures = r.getDistributionManager().putOutgoing(m);
        if (failures != null && failures.size() > 0) {
            throw new ForceReattemptException(String.format("Failed sending < %s >", m));
        }
        return processor;
    }

    EntryEventImpl createListenerEvent(EntryEventImpl sourceEvent, PartitionedRegion r, InternalDistributedMember member) {
        EntryEventImpl e2;
        if (this.notificationOnly && this.bridgeContext == null) {
            e2 = sourceEvent;
        } else {
            e2 = new EntryEventImpl(sourceEvent);
            if (this.bridgeContext != null) {
                e2.setContext(this.bridgeContext);
            }
        }
        e2.setRegion(r);
        e2.setOriginRemote(true);
        e2.setInvokePRCallbacks(!this.notificationOnly);
        if (!sourceEvent.hasOldValue()) {
            e2.oldValueNotAvailable();
        }
        if (this.filterInfo != null) {
            e2.setLocalFilterInfo(this.filterInfo.getFilterInfo(member));
        }
        if (this.versionTag != null) {
            this.versionTag.replaceNullIDs(this.getSender());
            e2.setVersionTag(this.versionTag);
        }
        return e2;
    }

    public Object getKey() {
        return this.key;
    }

    public void setKey(Object key) {
        this.key = key;
    }

    public byte[] getValBytes() {
        return this.valBytes;
    }

    private void setValBytes(byte[] valBytes) {
        this.valBytes = valBytes;
    }

    private void setValObj(Object o) {
        this.valObj = o;
    }

    public void setDeltaValObj(Object o) {
        if (this.valObj == null) {
            this.valObj = o;
        }
    }

    public Object getCallbackArg() {
        return this.cbArg;
    }

    protected Operation getOperation() {
        return this.op;
    }

    @Override
    public void setOperation(Operation operation) {
        this.op = operation;
    }

    @Override
    public void setFilterInfo(FilterRoutingInfo filterInfo) {
        if (filterInfo != null) {
            this.filterInfo = filterInfo;
        }
    }

    public int getDSFID() {
        return 100;
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        int extraFlags = in.readUnsignedByte();
        this.setKey(DataSerializer.readObject(in));
        this.cbArg = DataSerializer.readObject(in);
        this.lastModified = in.readLong();
        this.op = Operation.fromOrdinal(in.readByte());
        if ((extraFlags & HAS_BRIDGE_CONTEXT) != 0) {
            this.bridgeContext = ClientProxyMembershipID.readCanonicalized(in);
        }
        if ((extraFlags & HAS_ORIGINAL_SENDER) != 0) {
            this.originalSender = (InternalDistributedMember)DataSerializer.readObject(in);
        }
        if ((extraFlags & DO_NOT_GENERATE_CALLBACKS) != 0) {
            this.generateCallbacks = false;
        }
        this.eventId = new EventID();
        InternalDataSerializer.invokeFromData(this.eventId, in);
        if ((this.flags & 0x2000) != 0) {
            this.expectedOldValue = DataSerializer.readObject(in);
        }
        if (this.hasFilterInfo) {
            this.filterInfo = new FilterRoutingInfo();
            InternalDataSerializer.invokeFromData(this.filterInfo, in);
        }
        this.deserializationPolicy = (byte)(extraFlags & DistributedCacheOperation.DESERIALIZATION_POLICY_MASK);
        if (this.hasDelta) {
            this.deltaBytes = DataSerializer.readByteArray(in);
        } else {
            this.setValBytes(DataSerializer.readByteArray(in));
            if ((extraFlags & HAS_DELTA_WITH_FULL_VALUE) != 0) {
                this.deltaBytes = DataSerializer.readByteArray(in);
            }
        }
        if ((this.flags & 0x4000) != 0) {
            this.versionTag = (VersionTag)DataSerializer.readObject(in);
        }
    }

    @Override
    public EventID getEventID() {
        return this.eventId;
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        PartitionedRegion region = null;
        try {
            boolean flag = this.internalDs.getConfig().getDeltaPropagation();
            this.hasDelta = this.event.getDeltaBytes() != null && flag && this.sendDelta;
        }
        catch (RuntimeException re) {
            throw new InvalidDeltaException(re);
        }
        super.toData(out, context);
        int extraFlags = this.deserializationPolicy;
        if (this.bridgeContext != null) {
            extraFlags |= HAS_BRIDGE_CONTEXT;
        }
        if (this.deserializationPolicy != 0 && (this.valObj != null || this.getValBytes() != null) && this.sendDeltaWithFullValue && this.event.getDeltaBytes() != null) {
            extraFlags |= HAS_DELTA_WITH_FULL_VALUE;
        }
        if (this.originalSender != null) {
            extraFlags |= HAS_ORIGINAL_SENDER;
        }
        if (!this.event.isGenerateCallbacks()) {
            extraFlags |= DO_NOT_GENERATE_CALLBACKS;
        }
        out.writeByte(extraFlags);
        DataSerializer.writeObject(this.getKey(), out);
        DataSerializer.writeObject(this.getCallbackArg(), out);
        out.writeLong(this.lastModified);
        out.writeByte(this.op.ordinal);
        if (this.bridgeContext != null) {
            DataSerializer.writeObject(this.bridgeContext, out);
        }
        if (this.originalSender != null) {
            DataSerializer.writeObject(this.originalSender, out);
        }
        InternalDataSerializer.invokeToData(this.eventId, out);
        if (this.expectedOldValue != null) {
            DataSerializer.writeObject(this.expectedOldValue, out);
        }
        if (this.hasFilterInfo) {
            InternalDataSerializer.invokeToData(this.filterInfo, out);
        }
        if (this.hasDelta) {
            try {
                region = PartitionedRegion.getPRFromId(this.regionId);
            }
            catch (PRLocallyDestroyedException e) {
                throw new IOException("Delta can not be extracted as region is locally destroyed");
            }
            if (region == null || region.getCachePerfStats() == null) {
                throw new IOException("Delta can not be extracted as region can't be found or is in an invalid state");
            }
            DataSerializer.writeByteArray(this.event.getDeltaBytes(), out);
            region.getCachePerfStats().incDeltasSent();
        } else {
            DistributedCacheOperation.writeValue(this.deserializationPolicy, this.valObj, this.getValBytes(), out);
            if ((extraFlags & HAS_DELTA_WITH_FULL_VALUE) != 0) {
                DataSerializer.writeByteArray(this.event.getDeltaBytes(), out);
            }
        }
        if (this.versionTag != null) {
            DataSerializer.writeObject(this.versionTag, out);
        }
    }

    @Override
    protected short computeCompressedShort(short s) {
        s = super.computeCompressedShort(s);
        if (this.ifNew) {
            s = (short)(s | 0x80);
        }
        if (this.ifOld) {
            s = (short)(s | 0x100);
        }
        if (this.requireOldValue) {
            s = (short)(s | 0x200);
        }
        if (this.expectedOldValue != null) {
            s = (short)(s | 0x2000);
        }
        if (this.filterInfo != null) {
            s = (short)(s | 0x400);
            this.hasFilterInfo = true;
        }
        if (this.hasDelta) {
            s = (short)(s | 0x800);
            if (this.bridgeContext != null) {
                this.deserializationPolicy = (byte)2;
            }
        }
        if (this.versionTag != null) {
            s = (short)(s | 0x4000);
        }
        return s;
    }

    @Override
    protected void setBooleans(short s, DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.setBooleans(s, in, context);
        this.ifNew = (s & 0x80) != 0;
        this.ifOld = (s & 0x100) != 0;
        this.requireOldValue = (s & 0x200) != 0;
        this.hasFilterInfo = (s & 0x400) != 0;
        this.hasDelta = (s & 0x800) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected boolean operateOnPartitionedRegion(ClusterDistributionManager dm, PartitionedRegion r, long startTime) throws EntryExistsException, DataLocationException, IOException {
        this.setInternalDs(r.getSystem());
        PartitionedRegionDataStore ds = r.getDataStore();
        boolean sendReply = true;
        InternalDistributedMember eventSender = this.originalSender;
        if (eventSender == null) {
            eventSender = this.getSender();
        }
        EntryEventImpl ev = EntryEventImpl.create((InternalRegion)r, this.getOperation(), this.getKey(), null, this.getCallbackArg(), false, (DistributedMember)eventSender, this.generateCallbacks, false);
        try {
            if (this.versionTag != null) {
                this.versionTag.replaceNullIDs(this.getSender());
                ev.setVersionTag(this.versionTag);
            }
            if (this.bridgeContext != null) {
                ev.setContext(this.bridgeContext);
            }
            Assert.assertTrue(this.eventId != null);
            ev.setEventId(this.eventId);
            ev.setCausedByMessage(this);
            ev.setInvokePRCallbacks(!this.notificationOnly);
            ev.setPossibleDuplicate(this.posDup);
            ev.setDeltaBytes(this.deltaBytes);
            if (this.hasDelta) {
                this.valObj = null;
                ev.setNewValue(this.valObj);
            } else {
                switch (this.deserializationPolicy) {
                    case 2: {
                        ev.setSerializedNewValue(this.getValBytes());
                        break;
                    }
                    case 0: {
                        ev.setNewValue(this.getValBytes());
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("unknown deserialization policy: " + this.deserializationPolicy));
                    }
                }
            }
            if (!this.notificationOnly) {
                if (ds == null) {
                    throw new AssertionError((Object)("This process should have storage for this operation: " + String.valueOf(this)));
                }
                try {
                    ev.setOriginRemote(false);
                    this.result = r.getDataView().putEntryOnRemote(ev, this.ifNew, this.ifOld, this.expectedOldValue, this.requireOldValue, this.lastModified, true);
                    if (!this.result) {
                        r.checkReadiness();
                    }
                }
                catch (CacheWriterException | PrimaryBucketException cwe) {
                    this.sendReply(this.getSender(), this.getProcessorId(), dm, new ReplyException(cwe), r, startTime);
                    boolean bl = false;
                    ev.release();
                    return bl;
                }
                catch (InvalidDeltaException ide) {
                    this.sendReply(this.getSender(), this.getProcessorId(), dm, new ReplyException(ide), r, startTime);
                    r.getCachePerfStats().incDeltaFullValuesRequested();
                    boolean bl = false;
                    ev.release();
                    return bl;
                }
                if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                    logger.trace(LogMarker.DM_VERBOSE, "PutMessage {} with key: {} val: {}", (Object)(this.result ? "updated bucket" : "did not update bucket"), this.getKey(), this.getValBytes() == null ? "null" : "(" + this.getValBytes().length + " bytes)");
                }
            } else {
                EntryEventImpl e2 = this.createListenerEvent(ev, r, dm.getDistributionManagerId());
                try {
                    EnumListenerEvent le = e2.getOperation().isCreate() ? EnumListenerEvent.AFTER_CREATE : EnumListenerEvent.AFTER_UPDATE;
                    r.invokePutCallbacks(le, e2, r.isInitialized(), true);
                }
                finally {
                    if (e2 != ev) {
                        e2.release();
                    }
                }
                this.result = true;
            }
            this.setOperation(ev.getOperation());
            if (sendReply) {
                this.sendReply(this.getSender(), this.getProcessorId(), dm, null, r, startTime, ev);
            }
            boolean bl = false;
            return bl;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            ev.release();
        }
    }

    PartitionMessage.PartitionResponse createReplyProcessor(PartitionedRegion r, Set recipients, Object k) {
        return new PutResponse(r.getSystem(), recipients, k);
    }

    protected void sendReply(InternalDistributedMember member, int procId, DistributionManager dm, ReplyException ex, PartitionedRegion pr, long startTime, EntryEventImpl ev) {
        if (pr != null && startTime > 0L) {
            pr.getPrStats().endPartitionMessagesProcessing(startTime);
            pr.getCancelCriterion().checkCancelInProgress(null);
        }
        PutReplyMessage.send(member, procId, this.getReplySender(dm), this.result, this.getOperation(), ex, this, ev);
    }

    @Override
    protected void appendFields(StringBuilder buff) {
        super.appendFields(buff);
        buff.append("; key=").append(this.getKey()).append("; value=");
        buff.append(this.getValBytes() == null ? this.valObj : "(" + this.getValBytes().length + " bytes)");
        buff.append("; callback=").append(this.cbArg).append("; op=").append(this.op);
        if (this.originalSender != null) {
            buff.append("; originalSender=").append(this.originalSender);
        }
        if (this.bridgeContext != null) {
            buff.append("; bridgeContext=").append(this.bridgeContext);
        }
        if (this.eventId != null) {
            buff.append("; eventId=").append(this.eventId);
        }
        buff.append("; ifOld=").append(this.ifOld).append("; ifNew=").append(this.ifNew).append("; op=").append(this.getOperation());
        if (this.versionTag != null) {
            buff.append("; version=").append(this.versionTag);
        }
        buff.append("; deserializationPolicy=");
        buff.append(DistributedCacheOperation.deserializationPolicyToString(this.deserializationPolicy));
        if (this.hasDelta) {
            buff.append("; hasDelta=");
            buff.append(this.hasDelta);
        }
        if (this.sendDelta) {
            buff.append("; sendDelta=");
            buff.append(this.sendDelta);
        }
        if (this.isDeltaApplied) {
            buff.append("; isDeltaApplied=");
            buff.append(this.isDeltaApplied);
        }
        if (this.filterInfo != null) {
            buff.append("; ");
            buff.append(this.filterInfo);
        }
    }

    public InternalDistributedSystem getInternalDs() {
        return this.internalDs;
    }

    public void setInternalDs(InternalDistributedSystem internalDs) {
        this.internalDs = internalDs;
    }

    @Override
    protected boolean mayNotifySerialGatewaySender(ClusterDistributionManager dm) {
        return this.notifiesSerialGatewaySender(dm);
    }

    public void setSendDelta(boolean sendDelta) {
        this.sendDelta = sendDelta;
    }

    @Override
    public boolean prefersNewSerialized() {
        return true;
    }

    @Override
    public boolean isUnretainedNewReferenceOk() {
        return true;
    }

    private void setDeserializationPolicy(boolean isSerialized) {
        if (!isSerialized) {
            this.deserializationPolicy = 0;
        }
    }

    @Override
    public void importNewObject(Object nv, boolean isSerialized) {
        this.setDeserializationPolicy(isSerialized);
        this.setValObj(nv);
    }

    @Override
    public void importNewBytes(byte[] nv, boolean isSerialized) {
        this.setDeserializationPolicy(isSerialized);
        this.setValBytes(nv);
    }

    public static class PutResponse
    extends PartitionMessage.PartitionResponse {
        private volatile boolean returnValue;
        private volatile Operation op;
        private volatile Object oldValue;
        private final Object key;
        private PutMessage putMessage;
        private VersionTag versionTag;

        public PutResponse(InternalDistributedSystem ds, Set recipients, Object key) {
            super(ds, recipients, false);
            this.key = key;
        }

        public void setPutMessage(PutMessage putMessage) {
            this.putMessage = putMessage;
        }

        public void setResponse(PutReplyMessage response) {
            this.returnValue = response.result;
            this.op = response.op;
            this.oldValue = response.oldValue;
            this.versionTag = response.versionTag;
            if (this.versionTag != null) {
                this.versionTag.replaceNullIDs(response.getSender());
            }
        }

        public PutResult waitForResult() throws CacheException, ForceReattemptException {
            try {
                this.waitForCacheException();
            }
            catch (ForceReattemptException e) {
                e.checkKey(this.key);
                throw e;
            }
            if (this.op == null) {
                throw new ForceReattemptException("did not receive a valid reply");
            }
            return new PutResult(this.returnValue, this.op, this.oldValue, this.versionTag);
        }

        @Override
        public void process(final DistributionMessage msg) {
            if (msg instanceof ReplyMessage) {
                ReplyException ex = ((ReplyMessage)msg).getException();
                if (this.putMessage.bridgeContext == null && ex != null && ex.getCause() instanceof InvalidDeltaException) {
                    final PutMessage putMsg = new PutMessage(this.putMessage);
                    final DistributionManager dm = this.getDistributionManager();
                    Runnable sendFullObject = new Runnable(){

                        @Override
                        public void run() {
                            putMsg.resetRecipients();
                            putMsg.setRecipient(msg.getSender());
                            putMsg.setSendDelta(false);
                            if (logger.isDebugEnabled()) {
                                logger.debug("Sending full object({}) to {}", (Object)putMsg, (Object)putMsg.getRecipientsDescription());
                            }
                            dm.putOutgoing(putMsg);
                            try {
                                PartitionedRegion.getPRFromId(putMsg.regionId).getCachePerfStats().incDeltaFullValuesSent();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }

                        public String toString() {
                            return "Sending full object {" + String.valueOf(putMsg) + "}";
                        }
                    };
                    if (this.isExpectingDirectReply()) {
                        sendFullObject.run();
                    } else {
                        this.getDistributionManager().getExecutors().getWaitingThreadPool().execute(sendFullObject);
                    }
                    return;
                }
            }
            super.process(msg);
        }
    }

    public static class PutReplyMessage
    extends ReplyMessage
    implements EntryEventImpl.OldValueImporter {
        boolean result;
        Operation op;
        Object oldValue;
        VersionTag versionTag;
        private transient boolean oldValueIsSerialized;

        @Override
        public boolean getInlineProcess() {
            return true;
        }

        public PutReplyMessage() {
        }

        PutReplyMessage(int processorId, boolean result, Operation op, ReplyException ex, Object oldValue, VersionTag version) {
            this.op = op;
            this.result = result;
            this.setProcessorId(processorId);
            this.setException(ex);
            this.oldValue = oldValue;
            this.versionTag = version;
        }

        public static void send(InternalDistributedMember recipient, int processorId, ReplySender dm, boolean result, Operation op, ReplyException ex, PutMessage sourceMessage, EntryEventImpl ev) {
            Assert.assertTrue(recipient != null, "PutReplyMessage NULL reply message");
            PutReplyMessage m = new PutReplyMessage(processorId, result, op, ex, null, ev.getVersionTag());
            if (!sourceMessage.notificationOnly && sourceMessage.requireOldValue) {
                ev.exportOldValue(m);
            }
            m.setRecipient(recipient);
            dm.putOutgoing(m);
        }

        @Override
        public void process(DistributionManager dm, ReplyProcessor21 rp) {
            long startTime = this.getTimestamp();
            if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                logger.trace(LogMarker.DM_VERBOSE, "PutReplyMessage process invoking reply processor with processorId: {}", (Object)this.processorId);
            }
            if (rp == null) {
                if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                    logger.trace(LogMarker.DM_VERBOSE, "PutReplyMessage processor not found");
                }
                return;
            }
            if (rp instanceof PutResponse) {
                PutResponse processor = (PutResponse)rp;
                processor.setResponse(this);
            }
            rp.process(this);
            if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                logger.trace(LogMarker.DM_VERBOSE, "{} processed {}", (Object)rp, (Object)this);
            }
            dm.getStats().incReplyMessageTime(NanoTimer.getTime() - startTime);
        }

        public Object getOldValue() {
            return this.oldValue;
        }

        @Override
        public int getDSFID() {
            return 57;
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            super.fromData(in, context);
            this.result = in.readBoolean();
            this.op = Operation.fromOrdinal(in.readByte());
            this.oldValue = DataSerializer.readObject(in);
            this.versionTag = (VersionTag)DataSerializer.readObject(in);
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            super.toData(out, context);
            out.writeBoolean(this.result);
            out.writeByte(this.op.ordinal);
            Object ov = this.getOldValue();
            RemotePutMessage.PutReplyMessage.oldValueToData(out, this.getOldValue(), this.oldValueIsSerialized);
            DataSerializer.writeObject(this.versionTag, out);
        }

        @Override
        public String toString() {
            return "PutReplyMessage processorid=" + this.processorId + " returning " + this.result + " op=" + String.valueOf(this.op) + " exception=" + String.valueOf(this.getException()) + " oldValue=" + (this.oldValue == null ? "null" : "not null") + " version=" + String.valueOf(this.versionTag);
        }

        @Override
        public boolean prefersOldSerialized() {
            return true;
        }

        @Override
        public boolean isUnretainedOldReferenceOk() {
            return true;
        }

        @Override
        public boolean isCachedDeserializableValueOk() {
            return true;
        }

        @Override
        public void importOldObject(Object ov, boolean isSerialized) {
            this.oldValue = ov;
            this.oldValueIsSerialized = isSerialized;
        }

        @Override
        public void importOldBytes(byte[] ov, boolean isSerialized) {
            this.importOldObject(ov, isSerialized);
        }
    }

    public static class PutResult {
        public boolean returnValue;
        public Operation op;
        public Object oldValue;
        public VersionTag versionTag;

        public PutResult(boolean flag, Operation actualOperation, Object oldValue, VersionTag version) {
            this.returnValue = flag;
            this.op = actualOperation;
            this.oldValue = oldValue;
            this.versionTag = version;
        }
    }
}

