/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned;

import java.io.Serializable;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.partitioned.InternalPartitionDetails;
import org.apache.geode.internal.cache.partitioned.PRLoad;

public class PartitionMemberInfoImpl
implements InternalPartitionDetails,
Serializable {
    private static final long serialVersionUID = 8245020687604034289L;
    private final DistributedMember distributedMember;
    private final long configuredMaxMemory;
    private final long size;
    private final int bucketCount;
    private final int primaryCount;
    private final transient PRLoad prLoad;
    private final transient long[] bucketSizes;

    public PartitionMemberInfoImpl(DistributedMember distributedMember, long configuredMaxMemory, long size, int bucketCount, int primaryCount) {
        this.distributedMember = distributedMember;
        this.configuredMaxMemory = configuredMaxMemory;
        this.size = size;
        this.bucketCount = bucketCount;
        this.primaryCount = primaryCount;
        this.prLoad = null;
        this.bucketSizes = null;
    }

    public PartitionMemberInfoImpl(DistributedMember distributedMember, long configuredMaxMemory, long size, int bucketCount, int primaryCount, PRLoad prLoad, long[] bucketSizes) {
        this.distributedMember = distributedMember;
        this.configuredMaxMemory = configuredMaxMemory;
        this.size = size;
        this.bucketCount = bucketCount;
        this.primaryCount = primaryCount;
        this.prLoad = prLoad;
        this.bucketSizes = bucketSizes;
    }

    @Override
    public int getBucketCount() {
        return this.bucketCount;
    }

    @Override
    public long getConfiguredMaxMemory() {
        return this.configuredMaxMemory;
    }

    @Override
    public DistributedMember getDistributedMember() {
        return this.distributedMember;
    }

    @Override
    public int getPrimaryCount() {
        return this.primaryCount;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public PRLoad getPRLoad() {
        return this.prLoad;
    }

    @Override
    public long getBucketSize(int bucketId) {
        if (this.bucketSizes == null) {
            throw new IllegalStateException(String.valueOf(this) + " has no bucketSizes");
        }
        if (bucketId < 0 || bucketId >= this.bucketSizes.length) {
            throw new IllegalArgumentException("bucketId must be between 0 and " + (this.bucketSizes.length - 1));
        }
        return this.bucketSizes[bucketId];
    }

    public long[] getBucketSizes() {
        return this.bucketSizes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[PartitionMemberInfoImpl: ");
        sb.append("distributedMember=").append(this.distributedMember);
        sb.append(", configuredMaxMemory=").append(this.configuredMaxMemory);
        sb.append(", size=").append(this.size);
        sb.append(", bucketCount=").append(this.bucketCount);
        sb.append(", primaryCount=").append(this.primaryCount);
        if (this.prLoad != null) {
            sb.append(", prLoad=").append(this.prLoad);
            sb.append(", bucketSizes=[");
            if (this.bucketSizes == null) {
                sb.append("null");
            } else {
                for (long bucketSize : this.bucketSizes) {
                    sb.append(bucketSize).append(", ");
                }
                sb.append("]");
            }
        }
        sb.append("]");
        return sb.toString();
    }

    public int hashCode() {
        return this.distributedMember.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof PartitionMemberInfoImpl)) {
            return false;
        }
        PartitionMemberInfoImpl o = (PartitionMemberInfoImpl)other;
        return this.distributedMember.equals(o.distributedMember);
    }

    @Override
    public int compareTo(InternalPartitionDetails other) {
        return this.distributedMember.compareTo(other.getDistributedMember());
    }
}

