/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.execute;

import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.execute.ResultSender;
import org.apache.geode.internal.cache.InternalCache;

public class FunctionContextImpl
implements FunctionContext {
    private Object args = null;
    private String functionId = null;
    private Cache cache = null;
    private ResultSender resultSender = null;
    private final boolean isPossDup;
    private final Object principal;

    public FunctionContextImpl(Cache cache, String functionId, Object args, ResultSender resultSender) {
        this(cache, functionId, args, resultSender, false);
    }

    public FunctionContextImpl(Cache cache, String functionId, Object args, ResultSender resultSender, boolean isPossibleDuplicate) {
        this.cache = cache;
        this.functionId = functionId;
        this.args = args;
        this.resultSender = resultSender;
        this.isPossDup = isPossibleDuplicate;
        Object tmpPrincipal = null;
        if (cache != null && ((InternalCache)cache).getSecurityService() != null) {
            tmpPrincipal = ((InternalCache)cache).getSecurityService().getPrincipal();
        }
        this.principal = tmpPrincipal;
    }

    public Object getArguments() {
        return this.args;
    }

    @Override
    public String getFunctionId() {
        return this.functionId;
    }

    public String toString() {
        return "[FunctionContextImpl:functionId=" + this.functionId + ";args=" + String.valueOf(this.args) + ";principal=" + String.valueOf(this.getPrincipal()) + "]";
    }

    public ResultSender getResultSender() {
        return this.resultSender;
    }

    @Override
    public boolean isPossibleDuplicate() {
        return this.isPossDup;
    }

    @Override
    public Cache getCache() throws CacheClosedException {
        if (this.cache == null) {
            throw new CacheClosedException("FunctionContext does not have a valid Cache");
        }
        return this.cache;
    }

    @Override
    public Object getPrincipal() {
        return this.principal;
    }
}

