/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.event;

import java.util.HashMap;
import java.util.Map;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.versions.VersionTag;

public class BulkOperationHolder {
    private boolean removed;
    private final Map<EventID, VersionTag> entryVersionTags = new HashMap<EventID, VersionTag>();
    private transient long endOfLifeTimestamp;

    BulkOperationHolder() {
    }

    void putVersionTag(EventID eventId, VersionTag versionTag) {
        this.entryVersionTags.put(eventId, versionTag);
        this.endOfLifeTimestamp = 0L;
    }

    public Map<EventID, VersionTag> getEntryVersionTags() {
        return this.entryVersionTags;
    }

    public String toString() {
        return "BulkOperationHolder tags=" + String.valueOf(this.entryVersionTags);
    }

    public synchronized boolean expire(long now, long expirationTime) {
        if (this.endOfLifeTimestamp == 0L) {
            this.endOfLifeTimestamp = now;
        }
        boolean expired = false;
        if (this.endOfLifeTimestamp <= expirationTime) {
            this.removed = true;
            expired = true;
        }
        return expired;
    }

    public boolean isRemoved() {
        return this.removed;
    }
}

