/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.control;

import java.util.HashSet;
import java.util.Set;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.cache.control.RegionFilter;

public class FilterByPath
implements RegionFilter {
    private final Set<String> included;
    private final Set<String> excluded;

    public FilterByPath(Set<String> included, Set<String> excluded) {
        if (included != null) {
            this.included = new HashSet<String>();
            for (String regionName : included) {
                this.included.add((String)(!regionName.startsWith("/") ? "/" + regionName : regionName));
            }
        } else {
            this.included = null;
        }
        if (excluded != null) {
            this.excluded = new HashSet<String>();
            for (String regionName : excluded) {
                this.excluded.add((String)(!regionName.startsWith("/") ? "/" + regionName : regionName));
            }
        } else {
            this.excluded = null;
        }
    }

    @Override
    public boolean include(Region<?, ?> region) {
        String fullPath = region.getFullPath();
        if (this.included != null) {
            return this.included.contains(fullPath);
        }
        if (this.excluded != null) {
            return !this.excluded.contains(fullPath);
        }
        return true;
    }
}

