/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.backup;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import org.apache.geode.internal.cache.backup.ScriptGenerator;

class WindowsScriptGenerator
implements ScriptGenerator {
    static final String ROBOCOPY_NO_JOB_HEADER = "/njh";
    static final String EXIT_MARKER = "Exit Functions";
    private static final String ERROR_CHECK = "IF %ERRORLEVEL% GEQ 4 GOTO Exit_Bad";
    private static final String ROBOCOPY_COMMAND = "Robocopy.exe";
    private static final String ROBOCOPY_NO_JOB_SUMMARY = "/njs";
    private static final String ROBOCOPY_COPY_SUBDIRS = "/e";
    private static final String SCRIPT_FILE_NAME = "restore.bat";
    private static final String ECHO_OFF = "echo off";
    private static final String CD_TO_SCRIPT_DIR = "cd %~dp0";
    private static final String MKDIR = "mkdir";
    private static final String EXIT_BLOCK = ":Exit_Good\nexit /B 0\n\n:Exit_Bad\nexit /B 1";

    WindowsScriptGenerator() {
    }

    @Override
    public void writePreamble(BufferedWriter writer) throws IOException {
        writer.write(ECHO_OFF);
        writer.newLine();
        writer.write(CD_TO_SCRIPT_DIR);
        writer.newLine();
    }

    @Override
    public void writeComment(BufferedWriter writer, String string) throws IOException {
        writer.write("rem " + string);
        writer.newLine();
    }

    @Override
    public void writeCopyDirectoryContents(BufferedWriter writer, File backup, File original, boolean backupHasFiles) throws IOException {
        if (backupHasFiles) {
            writer.write("mkdir \"" + String.valueOf(original) + "\"");
            writer.newLine();
            writer.write("Robocopy.exe \"" + String.valueOf(backup) + "\" \"" + String.valueOf(original) + "\" /e /njh /njs");
            writer.newLine();
            writer.write(ERROR_CHECK);
            writer.newLine();
        }
    }

    @Override
    public void writeCopyFile(BufferedWriter writer, File source, File destination) throws IOException {
        String fileName = source.getName();
        String sourcePath = source.getParent() == null ? "." : source.getParent();
        String destinationPath = destination.getParent() == null ? "." : destination.getParent();
        writer.write("Robocopy.exe \"" + sourcePath + "\" \"" + destinationPath + "\" " + fileName + " /njh /njs");
        writer.newLine();
        writer.write(ERROR_CHECK);
        writer.newLine();
    }

    @Override
    public void writeExistenceTest(BufferedWriter writer, File file) throws IOException {
        writer.write("IF EXIST \"" + String.valueOf(file) + "\" echo \"Backup not restored. Refusing to overwrite " + String.valueOf(file) + "\" && exit /B 1 ");
        writer.newLine();
    }

    @Override
    public void writeExit(BufferedWriter writer) throws IOException {
        this.writeComment(writer, EXIT_MARKER);
        writer.write(EXIT_BLOCK);
        writer.newLine();
    }

    @Override
    public String getScriptName() {
        return SCRIPT_FILE_NAME;
    }
}

