/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.geode.DataSerializer;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.locks.TXRegionLockRequest;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.StaticSerialization;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class TXRegionLockRequestImpl
implements TXRegionLockRequest {
    private static final long serialVersionUID = 5840033961584078082L;
    private static final Logger logger = LogService.getLogger();
    private transient InternalCache cache;
    private transient InternalRegion r;
    private String regionPath;
    private Map<Object, Boolean> entryKeys;

    public TXRegionLockRequestImpl() {
        this.cache = null;
    }

    public TXRegionLockRequestImpl(InternalCache cache, InternalRegion r) {
        this.cache = cache;
        this.r = r;
        this.regionPath = null;
        this.entryKeys = null;
    }

    @VisibleForTesting
    public TXRegionLockRequestImpl(String regionPath, Map<Object, Boolean> entryKeys) {
        this.cache = null;
        this.regionPath = regionPath;
        this.entryKeys = entryKeys;
    }

    public boolean isEmpty() {
        return this.entryKeys == null || this.entryKeys.isEmpty();
    }

    @Override
    public void addEntryKeys(Map<Object, Boolean> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        if (this.entryKeys == null) {
            HashMap<Object, Boolean> tmp = new HashMap<Object, Boolean>(map.size());
            tmp.putAll(map);
            this.entryKeys = tmp;
        } else {
            HashMap<Object, Boolean> tmp = new HashMap<Object, Boolean>(this.entryKeys.size() + map.size());
            tmp.putAll(this.entryKeys);
            this.entryKeys = tmp;
            for (Map.Entry<Object, Boolean> entry : map.entrySet()) {
                this.addEntryKey(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public void addEntryKey(Object key, Boolean isEvent) {
        if (this.entryKeys == null) {
            this.entryKeys = new HashMap<Object, Boolean>();
        }
        if (!this.entryKeys.getOrDefault(key, Boolean.FALSE).booleanValue()) {
            this.entryKeys.put(key, isEvent);
        }
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.regionPath = DataSerializer.readString(in);
        this.cache = GemFireCacheImpl.getInstance();
        try {
            int size = InternalDataSerializer.readArrayLength(in);
            if (this.cache != null && size > 0) {
                this.r = (LocalRegion)this.cache.getRegion(this.regionPath);
            }
            this.entryKeys = StaticSerialization.getVersionForDataStream((DataInput)in).isNotOlderThan((Version)KnownVersion.GEODE_1_10_0) ? this.readEntryKeyMap(size, in) : this.readEntryKeySet(size, in);
        }
        catch (CacheClosedException ignore) {
            this.entryKeys = null;
        }
    }

    private Map<Object, Boolean> readEntryKeyMap(int size, DataInput in) throws IOException, ClassNotFoundException {
        if (logger.isTraceEnabled(LogMarker.SERIALIZER_VERBOSE)) {
            logger.trace(LogMarker.SERIALIZER_VERBOSE, "Reading HashMap with size {}", (Object)size);
        }
        if (size == -1) {
            return null;
        }
        HashMap<Object, Boolean> map = new HashMap<Object, Boolean>(size);
        for (int i = 0; i < size; ++i) {
            Object key = DataSerializer.readObject(in);
            Boolean value = (Boolean)DataSerializer.readObject(in);
            map.put(key, value);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Read HashMap with {} elements: {}", (Object)size, map);
        }
        return map;
    }

    private Map<Object, Boolean> readEntryKeySet(int size, DataInput in) throws IOException, ClassNotFoundException {
        if (logger.isTraceEnabled(LogMarker.SERIALIZER_VERBOSE)) {
            logger.trace(LogMarker.SERIALIZER_VERBOSE, "Reading HashSet with size {}", (Object)size);
        }
        HashMap<Object, Boolean> map = new HashMap<Object, Boolean>(size);
        for (int i = 0; i < size; ++i) {
            Object key = DataSerializer.readObject(in);
            Boolean value = true;
            map.put(key, value);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Read HashSet with {} elements: {}", (Object)size, map);
        }
        return map;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeString(this.getRegionFullPath(), out);
        if (StaticSerialization.getVersionForDataStream((DataOutput)out).isNotOlderThan((Version)KnownVersion.GEODE_1_10_0)) {
            InternalDataSerializer.writeHashMap(this.entryKeys, out);
        } else {
            HashSet<Object> hashset = new HashSet<Object>(this.entryKeys.keySet());
            InternalDataSerializer.writeHashSet(hashset, out);
        }
    }

    public static TXRegionLockRequestImpl createFromData(DataInput in) throws IOException, ClassNotFoundException {
        TXRegionLockRequestImpl result = new TXRegionLockRequestImpl();
        InternalDataSerializer.invokeFromData(result, in);
        return result;
    }

    @Override
    public String getRegionFullPath() {
        if (this.regionPath == null) {
            this.regionPath = this.r.getFullPath();
        }
        return this.regionPath;
    }

    @Override
    public Map<Object, Boolean> getKeys() {
        if (this.entryKeys == null) {
            this.cache.getCancelCriterion().checkCancelInProgress(null);
        }
        return this.entryKeys;
    }

    public InternalRegion getLocalRegion() {
        return this.r;
    }

    public String toString() {
        return "regionPath=" + this.getRegionFullPath() + " keys=" + String.valueOf(this.entryKeys);
    }
}

