/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.DiskAccessException;
import org.apache.geode.cache.EntryDestroyedException;
import org.apache.geode.distributed.OplogCancelledException;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.BytesAndBitsForCompactor;
import org.apache.geode.internal.cache.CacheObserverHolder;
import org.apache.geode.internal.cache.CompactableOplog;
import org.apache.geode.internal.cache.DirectoryHolder;
import org.apache.geode.internal.cache.DiskId;
import org.apache.geode.internal.cache.DiskRegion;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.internal.cache.DiskStoreStats;
import org.apache.geode.internal.cache.EntryBits;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.Oplog;
import org.apache.geode.internal.cache.OverflowOplogSet;
import org.apache.geode.internal.cache.entries.DiskEntry;
import org.apache.geode.internal.cache.persistence.BytesAndBits;
import org.apache.geode.internal.cache.persistence.DiskRegionView;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

class OverflowOplog
implements CompactableOplog,
DiskEntry.Helper.Flushable {
    private static final Logger logger = LogService.getLogger();
    public final String WRITE_BUFFER_SIZE_SYS_PROP_NAME = "WRITE_BUF_SIZE";
    static final String CRF_FILE_EXT = ".crf";
    private final File diskFile;
    private volatile boolean closed;
    private final OplogFile crf = new OplogFile();
    private final ByteBuffer[] bbArray = new ByteBuffer[2];
    private final DiskStoreStats stats;
    private final DiskStoreImpl parent;
    private final OverflowOplogSet oplogSet;
    protected final int oplogId;
    private final DirectoryHolder dirHolder;
    private long maxOplogSize;
    private final OpState opState;
    private boolean doneAppending = false;
    private final Oplog.OplogDiskEntry liveEntries = new Oplog.OplogDiskEntry();
    private static final int MAX_CHANNEL_RETRIES = 5;
    private final AtomicBoolean deleted = new AtomicBoolean();
    private final AtomicLong totalCount = new AtomicLong(0L);
    private final AtomicLong totalLiveCount = new AtomicLong(0L);
    private boolean compacting;
    private static final ThreadLocal isCompactorThread = new ThreadLocal();
    private final Lock compactorLock = new ReentrantLock();

    OverflowOplog(int oplogId, OverflowOplogSet parent, DirectoryHolder dirHolder, long minSize) {
        long availableSpace;
        this.oplogId = oplogId;
        this.parent = parent.getParent();
        this.oplogSet = parent;
        this.dirHolder = dirHolder;
        this.opState = new OpState();
        long maxOplogSizeParam = this.parent.getMaxOplogSizeInBytes();
        if (maxOplogSizeParam < minSize) {
            maxOplogSizeParam = minSize;
        }
        if ((availableSpace = this.dirHolder.getAvailableSpace()) < minSize && !this.parent.isCompactionEnabled()) {
            availableSpace = minSize;
        }
        this.maxOplogSize = availableSpace < maxOplogSizeParam && !this.parent.isCompactionEnabled() && availableSpace > 0L ? availableSpace : maxOplogSizeParam;
        this.stats = this.parent.getStats();
        this.closed = false;
        String n = this.parent.getName();
        this.diskFile = new File(this.dirHolder.getDir(), "OVERFLOW" + n + "_" + oplogId);
        try {
            this.createCrf(parent.getActiveOverflowOplog());
        }
        catch (IOException ex) {
            throw new DiskAccessException(String.format("Failed creating operation log because: %s", ex), this.parent);
        }
    }

    DiskStoreImpl getParent() {
        return this.parent;
    }

    private OverflowOplogSet getOplogSet() {
        return this.oplogSet;
    }

    private void preblow() {
        this.dirHolder.incrementTotalOplogSize(this.maxOplogSize);
        OplogFile olf = this.getOLF();
        try {
            olf.raf.setLength(this.maxOplogSize);
            olf.raf.seek(0L);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void createCrf(OverflowOplog previous) throws IOException {
        File f = new File(this.diskFile.getPath() + CRF_FILE_EXT);
        if (logger.isDebugEnabled()) {
            logger.debug("Creating operation log file {}", (Object)f);
        }
        this.crf.f = f;
        this.crf.raf = new RandomAccessFile(f, "rw");
        this.crf.writeBuf = this.allocateWriteBuf(previous);
        this.preblow();
        logger.info("Created {} {} for disk store {}.", new Object[]{this.toString(), "crf", this.parent.getName()});
        this.crf.channel = this.crf.raf.getChannel();
        this.stats.incOpenOplogs();
    }

    @VisibleForTesting
    Integer getWriteBufferSizeProperty() {
        return Integer.getInteger("WRITE_BUF_SIZE");
    }

    @VisibleForTesting
    Integer getWriteBufferCapacity() {
        Integer writeBufferSizeProperty = this.getWriteBufferSizeProperty();
        if (writeBufferSizeProperty != null) {
            return writeBufferSizeProperty;
        }
        return this.getParent().getWriteBufferSize();
    }

    private ByteBuffer allocateWriteBuf(OverflowOplog previous) {
        ByteBuffer result = null;
        if (previous != null) {
            result = previous.consumeWriteBuf();
        }
        if (result == null) {
            return ByteBuffer.allocateDirect(this.getWriteBufferCapacity());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer consumeWriteBuf() {
        OplogFile oplogFile = this.crf;
        synchronized (oplogFile) {
            ByteBuffer result = this.crf.writeBuf;
            this.crf.writeBuf = null;
            return result;
        }
    }

    public DiskStoreStats getStats() {
        return this.stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    File getOplogFile() throws IOException {
        OplogFile oplogFile = this.crf;
        synchronized (oplogFile) {
            if (!this.crf.RAFClosed) {
                this.crf.raf.getFD().sync();
            }
            return this.crf.f;
        }
    }

    public int getOplogId() {
        return this.oplogId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BytesAndBits getBytesAndBits(DiskRegionView dr, DiskId id, boolean faultingIn, boolean bitOnly) {
        OverflowOplog retryOplog = null;
        long offset = 0L;
        DiskId diskId = id;
        synchronized (diskId) {
            int opId = (int)id.getOplogId();
            if (opId != this.getOplogId()) {
                retryOplog = this.getOplogSet().getChild(opId);
            } else {
                offset = id.getOffsetInOplog();
            }
        }
        if (retryOplog != null) {
            return retryOplog.getBytesAndBits(dr, id, faultingIn, bitOnly);
        }
        BytesAndBits bb = null;
        long start = this.stats.startRead();
        if (offset == -1L) {
            offset = id.getOffsetInOplog();
        }
        try {
            bb = this.basicGet(dr, offset, bitOnly, id.getValueLength(), id.getUserBits());
        }
        catch (DiskAccessException dae) {
            logger.error(String.format("Oplog::basicGet: Error in reading the data from disk for Disk ID %s", id), (Throwable)dae);
            throw dae;
        }
        if (bb == null) {
            throw new EntryDestroyedException(String.format("No value was found for entry with disk Id %s on a region  with synchronous writing set to %s", id, dr.isSync()));
        }
        if (bitOnly) {
            dr.endRead(start, this.stats.endRead(start, 1L), 1L);
        } else {
            dr.endRead(start, this.stats.endRead(start, bb.getBytes().length), bb.getBytes().length);
        }
        return bb;
    }

    @Override
    public BytesAndBits getNoBuffer(DiskRegion dr, DiskId id) {
        if (logger.isTraceEnabled()) {
            logger.trace("Oplog::getNoBuffer:Before invoking Oplog.basicGet for DiskID ={}", (Object)id);
        }
        try {
            return this.basicGet(dr, id.getOffsetInOplog(), false, id.getValueLength(), id.getUserBits());
        }
        catch (DiskAccessException dae) {
            logger.error(String.format("Oplog::getNoBuffer:Exception in retrieving value from disk for diskId=%s", id), (Throwable)dae);
            throw dae;
        }
        catch (IllegalStateException ise) {
            logger.error(String.format("Oplog::getNoBuffer:Exception in retrieving value from disk for diskId=%s", id), (Throwable)ise);
            throw ise;
        }
    }

    void freeEntry(DiskEntry de) {
        this.rmLive(de);
    }

    public void close() {
        if (this.closed) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Oplog::close: Store name ={} Oplog ID = {}", (Object)this.parent.getName(), (Object)this.oplogId);
        }
        this.basicClose();
    }

    public void testClose() {
        try {
            this.crf.channel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.crf.raf.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void basicClose() {
        this.flushAll();
        OplogFile oplogFile = this.crf;
        synchronized (oplogFile) {
            if (!this.crf.RAFClosed) {
                try {
                    this.crf.channel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    this.crf.raf.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.crf.RAFClosed = true;
                this.stats.decOpenOplogs();
            }
            this.closed = true;
        }
        this.deleteFiles();
    }

    public void destroy() {
        if (!this.closed) {
            this.lockCompactor();
            try {
                this.basicClose();
            }
            finally {
                this.unlockCompactor();
            }
        }
    }

    private void checkClosed() {
        this.parent.getCancelCriterion().checkCancelInProgress(null);
        if (!this.closed) {
            return;
        }
        throw new OplogCancelledException("This Oplog has been closed.");
    }

    static long abs(long v) {
        if (v < 0L) {
            return -v;
        }
        return v;
    }

    private void initOpState(DiskEntry entry, DiskEntry.Helper.ValueWrapper value, byte userBits) {
        this.opState.initialize(entry, value, userBits);
    }

    private void clearOpState() {
        this.opState.clear();
    }

    private int getOpStateSize() {
        return this.opState.getSize();
    }

    private byte calcUserBits(DiskEntry.Helper.ValueWrapper value) {
        return value.getUserBits();
    }

    public boolean modify(DiskRegion dr, DiskEntry entry, DiskEntry.Helper.ValueWrapper value, boolean async) {
        try {
            byte userBits = this.calcUserBits(value);
            return this.basicModify(entry, value, userBits, async);
        }
        catch (IOException ex) {
            throw new DiskAccessException(String.format("Failed writing key to %s", this.diskFile.getPath()), (Throwable)ex, dr.getName());
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            dr.getCancelCriterion().checkCancelInProgress(ie);
            throw new DiskAccessException(String.format("Failed writing key to %s due to failure in acquiring read lock for asynch writing", this.diskFile.getPath()), (Throwable)ie, dr.getName());
        }
    }

    public boolean copyForwardForOverflowCompact(DiskEntry entry, byte[] value, int length, byte userBits) {
        try {
            DiskEntry.Helper.CompactorValueWrapper vw = new DiskEntry.Helper.CompactorValueWrapper(value, length);
            return this.basicModify(entry, vw, userBits, true);
        }
        catch (IOException ex) {
            throw new DiskAccessException(String.format("Failed writing key to %s", this.diskFile.getPath()), (Throwable)ex, this.getParent().getName());
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            this.getParent().getCancelCriterion().checkCancelInProgress(ie);
            throw new DiskAccessException(String.format("Failed writing key to %s due to failure in acquiring read lock for asynch writing", this.diskFile.getPath()), (Throwable)ie, this.getParent().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean basicModify(DiskEntry entry, DiskEntry.Helper.ValueWrapper value, byte userBits, boolean async) throws IOException, InterruptedException {
        DiskId id = entry.getDiskId();
        long startPosForSynchOp = -1L;
        OverflowOplog emptyOplog = null;
        OplogFile oplogFile = this.crf;
        synchronized (oplogFile) {
            OverflowOplog oldOplog;
            int oldOplogId;
            this.initOpState(entry, value, userBits);
            int adjustment = this.getOpStateSize();
            assert (adjustment > 0);
            startPosForSynchOp = this.writeOpLogBytes(async);
            if (startPosForSynchOp == -1L) {
                return false;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("Oplog::basicModify:Released ByteBuffer with data for Disk ID = {}", (Object)id);
            }
            DiskId diskId = id;
            synchronized (diskId) {
                oldOplogId = (int)id.setOplogId(this.getOplogId());
                id.setOffsetInOplog(startPosForSynchOp);
                if (EntryBits.isNeedsValue(userBits)) {
                    id.setValueLength(value.getLength());
                } else {
                    id.setValueLength(0);
                }
                id.setUserBits(userBits);
            }
            if (oldOplogId > 0 && (oldOplog = this.getOplogSet().getChild(oldOplogId)) != null && oldOplog.rmLive(entry) && oldOplogId != this.getOplogId()) {
                emptyOplog = oldOplog;
            }
            this.addLive(entry);
            this.clearOpState();
        }
        if (LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER) {
            CacheObserverHolder.getInstance().afterSettingOplogOffSet(startPosForSynchOp);
        }
        if (emptyOplog != null && (!emptyOplog.isCompacting() || emptyOplog.calledByCompactorThread())) {
            if (emptyOplog.calledByCompactorThread() && emptyOplog.hasNoLiveValues()) {
                this.flushAll();
            }
            emptyOplog.handleNoLiveValues();
        }
        return true;
    }

    public void remove(DiskRegion dr, DiskEntry entry) {
        try {
            this.basicRemove(dr, entry);
        }
        catch (IOException ex) {
            throw new DiskAccessException(String.format("Failed writing key to %s", this.diskFile.getPath()), (Throwable)ex, dr.getName());
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            dr.getCancelCriterion().checkCancelInProgress(ie);
            throw new DiskAccessException(String.format("Failed writing key to %s due to failure in acquiring read lock for asynch writing", this.diskFile.getPath()), (Throwable)ie, dr.getName());
        }
    }

    private void basicRemove(DiskRegion dr, DiskEntry entry) throws IOException, InterruptedException {
        long oldOffset;
        DiskId id = entry.getDiskId();
        if (EntryBits.isNeedsValue(id.getUserBits()) && (oldOffset = id.getOffsetInOplog()) != -1L) {
            id.setOffsetInOplog(-1L);
            if (this.rmLive(entry) && (!this.isCompacting() || this.calledByCompactorThread())) {
                this.handleNoLiveValues();
            }
        }
    }

    public ByteBuffer getWriteBuf() {
        return this.crf.writeBuf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        OplogFile olf;
        OplogFile oplogFile = olf = this.crf;
        synchronized (oplogFile) {
            if (olf.RAFClosed) {
                return;
            }
            try {
                ByteBuffer bb = olf.writeBuf;
                if (bb != null && bb.position() != 0) {
                    bb.flip();
                    int flushed = 0;
                    int numChannelRetries = 0;
                    do {
                        int channelBytesWritten = 0;
                        int bbStartPos = bb.position();
                        long channelStartPos = olf.channel.position();
                        channelBytesWritten = olf.channel.write(bb);
                        if (channelBytesWritten != bb.position() - bbStartPos) {
                            if (numChannelRetries++ < 5) {
                                channelBytesWritten = (int)(olf.channel.position() - channelStartPos);
                                bb.position(bbStartPos + channelBytesWritten);
                            } else {
                                throw new IOException("Failed to write Oplog entry to " + olf.f.getName() + ": channel.write() returned " + channelBytesWritten + ", change in channel position = " + (olf.channel.position() - channelStartPos) + ", change in source buffer position = " + (bb.position() - bbStartPos));
                            }
                        }
                        flushed += channelBytesWritten;
                    } while (bb.hasRemaining());
                    olf.bytesFlushed += (long)flushed;
                    bb.clear();
                }
            }
            catch (ClosedChannelException closedChannelException) {
                // empty catch block
            }
        }
    }

    FileChannel testSetCrfChannel(FileChannel ch) {
        FileChannel chPrev = this.crf.channel;
        this.crf.channel = ch;
        return chPrev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(ByteBuffer b1, ByteBuffer b2) throws IOException {
        OplogFile olf;
        OplogFile oplogFile = olf = this.crf;
        synchronized (oplogFile) {
            if (olf.RAFClosed) {
                return;
            }
            try {
                this.bbArray[0] = b1;
                this.bbArray[1] = b2;
                b1.flip();
                long flushed = 0L;
                do {
                    flushed += olf.channel.write(this.bbArray);
                } while (b2.hasRemaining());
                this.bbArray[0] = null;
                this.bbArray[1] = null;
                olf.bytesFlushed += flushed;
                b1.clear();
            }
            catch (ClosedChannelException closedChannelException) {
                // empty catch block
            }
        }
    }

    public void flushAll() {
        try {
            this.flush();
        }
        catch (IOException ex) {
            throw new DiskAccessException(String.format("Failed writing key to %s", this.diskFile.getPath()), (Throwable)ex, this.parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long writeOpLogBytes(boolean async) throws IOException {
        OplogFile olf;
        long startPos = -1L;
        OplogFile oplogFile = olf = this.crf;
        synchronized (oplogFile) {
            long curFileOffset;
            if (this.doneAppending) {
                return -1L;
            }
            if (this.closed) {
                Assert.assertTrue(false, String.valueOf(this) + " for store " + this.parent.getName() + " has been closed for synch mode while writing is going on. This should not happen");
            }
            if ((startPos = this.allocate(curFileOffset = olf.channel.position() + (long)olf.writeBuf.position(), this.getOpStateSize())) != -1L) {
                if (startPos != curFileOffset) {
                    this.flush();
                    olf.channel.position(startPos);
                    olf.bytesFlushed = startPos;
                    this.stats.incOplogSeeks();
                }
                if (logger.isTraceEnabled(LogMarker.PERSIST_WRITES_VERBOSE)) {
                    logger.trace(LogMarker.PERSIST_WRITES_VERBOSE, "writeOpLogBytes startPos={} oplog#{}", (Object)startPos, (Object)this.getOplogId());
                }
                long oldBytesFlushed = olf.bytesFlushed;
                long bytesWritten = this.opState.write();
                if (startPos + bytesWritten > olf.currSize) {
                    olf.currSize = startPos + bytesWritten;
                }
                if (logger.isTraceEnabled(LogMarker.PERSIST_WRITES_VERBOSE)) {
                    logger.trace(LogMarker.PERSIST_WRITES_VERBOSE, "writeOpLogBytes bytesWritten={} oldBytesFlushed={} byteFlushed={} oplog#{}", (Object)bytesWritten, (Object)oldBytesFlushed, (Object)olf.bytesFlushed, (Object)this.getOplogId());
                }
                if (oldBytesFlushed != olf.bytesFlushed) {
                    this.flush();
                }
                this.getStats().incWrittenBytes(bytesWritten, async);
            }
        }
        return startPos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BytesAndBits attemptGet(DiskRegionView dr, long offsetInOplog, int valueLength, byte userBits) throws IOException {
        OplogFile oplogFile = this.crf;
        synchronized (oplogFile) {
            assert (offsetInOplog >= 0L);
            RandomAccessFile myRAF = this.crf.raf;
            BytesAndBits bb = null;
            long writePosition = 0L;
            if (!this.doneAppending && (bb = this.attemptWriteBufferGet(writePosition = myRAF.getFilePointer(), offsetInOplog, valueLength, userBits)) == null && offsetInOplog + (long)valueLength > this.crf.bytesFlushed && !this.closed) {
                this.flushAll();
                writePosition = myRAF.getFilePointer();
            }
            if (bb == null) {
                myRAF.seek(offsetInOplog);
                try {
                    this.stats.incOplogSeeks();
                    byte[] valueBytes = new byte[valueLength];
                    myRAF.readFully(valueBytes);
                    this.stats.incOplogReads();
                    bb = new BytesAndBits(valueBytes, userBits);
                }
                finally {
                    if (!this.doneAppending) {
                        myRAF.seek(writePosition);
                        this.stats.incOplogSeeks();
                    }
                }
            }
            return bb;
        }
    }

    private BytesAndBits attemptWriteBufferGet(long writePosition, long readPosition, int valueLength, byte userBits) {
        BytesAndBits bb = null;
        ByteBuffer writeBuf = this.crf.writeBuf;
        int curWriteBufPos = writeBuf.position();
        if (writePosition <= readPosition && writePosition + (long)curWriteBufPos >= readPosition + (long)valueLength) {
            int bufOffset = (int)(readPosition - writePosition);
            byte[] valueBytes = new byte[valueLength];
            int oldLimit = writeBuf.limit();
            writeBuf.limit(curWriteBufPos);
            writeBuf.position(bufOffset);
            writeBuf.get(valueBytes);
            writeBuf.position(curWriteBufPos);
            writeBuf.limit(oldLimit);
            bb = new BytesAndBits(valueBytes, userBits);
        }
        return bb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BytesAndBits basicGet(DiskRegionView dr, long offsetInOplog, boolean bitOnly, int valueLength, byte userBits) {
        BytesAndBits bb = null;
        if (EntryBits.isAnyInvalid(userBits) || EntryBits.isTombstone(userBits) || bitOnly || valueLength == 0) {
            bb = EntryBits.isInvalid(userBits) ? new BytesAndBits(DiskEntry.INVALID_BYTES, userBits) : (EntryBits.isTombstone(userBits) ? new BytesAndBits(DiskEntry.TOMBSTONE_BYTES, userBits) : new BytesAndBits(DiskEntry.LOCAL_INVALID_BYTES, userBits));
        } else {
            if (offsetInOplog == -1L) {
                return null;
            }
            try {
                while (true) {
                    dr.getCancelCriterion().checkCancelInProgress(null);
                    boolean interrupted = Thread.interrupted();
                    try {
                        bb = this.attemptGet(dr, offsetInOplog, valueLength, userBits);
                        break;
                    }
                    catch (InterruptedIOException interruptedIOException) {}
                    continue;
                    finally {
                        if (!interrupted) continue;
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException ex) {
                throw new DiskAccessException(String.format("Failed reading from %s.  oplogID, %s Offset being read= %s Current Oplog Size= %s Actual File Size, %s IS ASYNCH MODE, %s IS ASYNCH WRITER ALIVE= %s", this.diskFile.getPath(), (long)this.oplogId, offsetInOplog, this.crf.currSize, this.crf.bytesFlushed, !dr.isSync(), false), (Throwable)ex, dr.getName());
            }
            catch (IllegalStateException ex) {
                this.checkClosed();
                throw ex;
            }
        }
        return bb;
    }

    void deleteFiles() {
        boolean needsDestroy = this.deleted.compareAndSet(false, true);
        if (needsDestroy) {
            this.getOplogSet().removeOverflow(this);
            this.deleteFile();
        }
    }

    private void deleteFile() {
        OplogFile olf = this.getOLF();
        if (this.maxOplogSize != 0L) {
            this.dirHolder.decrementTotalOplogSize(this.maxOplogSize);
            this.maxOplogSize = 0L;
            olf.currSize = 0L;
        }
        if (olf.f == null) {
            return;
        }
        if (!olf.f.exists()) {
            return;
        }
        if (!olf.f.delete() && olf.f.exists()) {
            throw new DiskAccessException(String.format("Could not delete %s.", olf.f.getAbsolutePath()), this.parent);
        }
        logger.info("Deleted {} {} for disk store {}.", (Object)this.toString(), (Object)"crf", (Object)this.parent.getName());
    }

    FileChannel getFileChannel() {
        return this.crf.channel;
    }

    DirectoryHolder getDirectoryHolder() {
        return this.dirHolder;
    }

    long getOplogSize() {
        return this.crf.currSize;
    }

    private long allocate(long suggestedOffset, int length) {
        if (suggestedOffset + (long)length > this.maxOplogSize) {
            this.flushAll();
            this.doneAppending = true;
            return -1L;
        }
        return suggestedOffset;
    }

    private void addLive(DiskEntry de) {
        this.totalCount.incrementAndGet();
        this.totalLiveCount.incrementAndGet();
        if (this.isCompactionPossible()) {
            this.liveEntries.insert(de);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean rmLive(DiskEntry de) {
        if (this.isCompactionPossible()) {
            Oplog.OplogDiskEntry oplogDiskEntry = this.liveEntries;
            synchronized (oplogDiskEntry) {
                if (this.liveEntries.remove(de)) {
                    this.totalLiveCount.decrementAndGet();
                    return true;
                }
                return false;
            }
        }
        this.totalLiveCount.decrementAndGet();
        return true;
    }

    private boolean isCompactionPossible() {
        return this.getParent().isCompactionPossible();
    }

    boolean needsCompaction() {
        if (!this.isCompactionPossible()) {
            return false;
        }
        if (this.getParent().getCompactionThreshold() == 100) {
            return true;
        }
        if (this.getParent().getCompactionThreshold() == 0) {
            return false;
        }
        long rvHWMtmp = this.totalCount.get();
        if (rvHWMtmp > 0L) {
            double rv;
            long tlc = this.totalLiveCount.get();
            if (tlc < 0L) {
                tlc = 0L;
            }
            return (rv = (double)tlc) / (double)rvHWMtmp * 100.0 <= (double)this.parent.getCompactionThreshold();
        }
        return true;
    }

    public boolean hasNoLiveValues() {
        return this.totalLiveCount.get() <= 0L;
    }

    private void handleEmpty(boolean calledByCompactor) {
        if (!calledByCompactor) {
            logger.info("Closing {} early since it is empty. It is for disk store {}.", new Object[]{this.parent.getName(), this.toString()});
        }
        this.destroy();
    }

    private void handleNoLiveValues() {
        if (!this.doneAppending) {
            return;
        }
        if (this.hasNoLiveValues()) {
            this.getOplogSet().removeOverflow(this);
            if (this.calledByCompactorThread()) {
                this.handleEmpty(true);
            } else {
                this.getParent().executeDiskStoreTask(() -> this.handleEmpty(false));
            }
        } else if (!this.isCompacting() && this.needsCompaction()) {
            this.addToBeCompacted();
        }
    }

    private void addToBeCompacted() {
        this.getOplogSet().addOverflowToBeCompacted(this);
    }

    long testGetOplogFileLength() throws IOException {
        long result = 0L;
        if (this.crf.raf != null) {
            result += this.crf.raf.length();
        }
        return result;
    }

    private OplogFile getOLF() {
        return this.crf;
    }

    private DiskEntry getNextLiveEntry() {
        DiskEntry result = this.liveEntries.getPrev();
        if (result == this.liveEntries) {
            result = null;
        }
        return result;
    }

    public String toString() {
        return "oplog#OV" + this.getOplogId();
    }

    private boolean isCompacting() {
        return this.compacting;
    }

    @Override
    public void prepareForCompact() {
        this.compacting = true;
    }

    private boolean calledByCompactorThread() {
        if (!this.compacting) {
            return false;
        }
        Object v = isCompactorThread.get();
        return v != null && v == Boolean.TRUE;
    }

    private void lockCompactor() {
        this.compactorLock.lock();
    }

    private void unlockCompactor() {
        this.compactorLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int compact(DiskStoreImpl.OplogCompactor compactor) {
        if (!this.needsCompaction()) {
            return 0;
        }
        isCompactorThread.set(Boolean.TRUE);
        this.getParent().acquireCompactorReadLock();
        try {
            block30: {
                this.lockCompactor();
                if (!this.hasNoLiveValues()) break block30;
                this.handleNoLiveValues();
                int n = 0;
                this.unlockCompactor();
                isCompactorThread.remove();
                return n;
            }
            try {
                DiskEntry de;
                long opStart = this.getStats().getStatTime();
                BytesAndBitsForCompactor wrapper = new BytesAndBitsForCompactor();
                DiskEntry lastDe = null;
                boolean compactFailed = !compactor.keepCompactorRunning();
                int totalCount = 0;
                boolean didCompact = false;
                while ((de = this.getNextLiveEntry()) != null) {
                    if (!compactor.keepCompactorRunning()) {
                        compactFailed = true;
                        break;
                    }
                    if (lastDe != null) {
                        if (lastDe == de) {
                            throw new IllegalStateException("compactor would have gone into infinite loop");
                        }
                        assert (lastDe != de);
                    }
                    lastDe = de;
                    didCompact = false;
                    DiskEntry diskEntry = de;
                    synchronized (diskEntry) {
                        DiskId did = de.getDiskId();
                        assert (did != null);
                        DiskId diskId = did;
                        synchronized (diskId) {
                            long oplogId = did.getOplogId();
                            if (oplogId != (long)this.getOplogId()) {
                                if (oplogId == -1L) {
                                    this.rmLive(de);
                                }
                                continue;
                            }
                            boolean toCompact = this.getBytesAndBitsForCompaction(de, wrapper);
                            if (toCompact) {
                                byte[] valueBytes = wrapper.getBytes();
                                int length = wrapper.getValidLength();
                                byte userBits = wrapper.getBits();
                                if (oplogId != did.getOplogId()) {
                                    if (did.getOplogId() == -1L) {
                                        this.rmLive(de);
                                    }
                                    if (!wrapper.isReusable()) {
                                        wrapper = new BytesAndBitsForCompactor();
                                    }
                                    continue;
                                }
                                if (EntryBits.isAnyInvalid(userBits)) {
                                    this.rmLive(de);
                                    if (!wrapper.isReusable()) {
                                        wrapper = new BytesAndBitsForCompactor();
                                    }
                                    continue;
                                }
                                this.getOplogSet().copyForwardForOverflowCompact(de, valueBytes, length, userBits);
                                didCompact = true;
                            }
                        }
                    }
                    if (!didCompact) continue;
                    ++totalCount;
                    this.getStats().endCompactionUpdate(opStart);
                    opStart = this.getStats().getStatTime();
                    if (wrapper.isReusable()) continue;
                    wrapper = new BytesAndBitsForCompactor();
                }
                if (!compactFailed) {
                    this.handleNoLiveValues();
                }
                int n = totalCount;
                this.unlockCompactor();
                isCompactorThread.remove();
                return n;
            }
            catch (Throwable throwable) {
                this.unlockCompactor();
                isCompactorThread.remove();
                throw throwable;
            }
        }
        finally {
            this.getParent().releaseCompactorReadLock();
        }
    }

    private boolean getBytesAndBitsForCompaction(DiskEntry entry, BytesAndBitsForCompactor wrapper) {
        DiskId did = entry.getDiskId();
        byte userBits = 0;
        long oplogOffset = did.getOffsetInOplog();
        boolean foundData = false;
        if (entry.isValueNull()) {
            foundData = this.basicGetForCompactor(oplogOffset, false, did.getValueLength(), did.getUserBits(), wrapper);
            if (did.getOplogId() != (long)this.getOplogId()) {
                return false;
            }
            assert (foundData) : "compactor get failed on oplog#" + this.getOplogId();
            userBits = wrapper.getBits();
            if (EntryBits.isAnyInvalid(userBits)) {
                if (EntryBits.isInvalid(userBits)) {
                    wrapper.setData(DiskEntry.INVALID_BYTES, userBits, DiskEntry.INVALID_BYTES.length, false);
                } else {
                    wrapper.setData(DiskEntry.LOCAL_INVALID_BYTES, userBits, DiskEntry.LOCAL_INVALID_BYTES.length, false);
                }
            } else if (EntryBits.isTombstone(userBits)) {
                wrapper.setData(DiskEntry.TOMBSTONE_BYTES, userBits, DiskEntry.TOMBSTONE_BYTES.length, false);
            }
        } else {
            entry.getDiskId().markForWriting();
            this.rmLive(entry);
            foundData = false;
        }
        if (foundData) {
            entry.getDiskId().setPendingAsync(false);
        }
        return foundData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean basicGetForCompactor(long offsetInOplog, boolean bitOnly, int valueLength, byte userBits, BytesAndBitsForCompactor wrapper) {
        if (EntryBits.isAnyInvalid(userBits) || EntryBits.isTombstone(userBits) || bitOnly || valueLength == 0) {
            if (EntryBits.isInvalid(userBits)) {
                wrapper.setData(DiskEntry.INVALID_BYTES, userBits, DiskEntry.INVALID_BYTES.length, false);
            } else if (EntryBits.isTombstone(userBits)) {
                wrapper.setData(DiskEntry.TOMBSTONE_BYTES, userBits, DiskEntry.TOMBSTONE_BYTES.length, false);
            } else {
                wrapper.setData(DiskEntry.LOCAL_INVALID_BYTES, userBits, DiskEntry.LOCAL_INVALID_BYTES.length, false);
            }
        } else {
            try {
                OplogFile oplogFile = this.crf;
                synchronized (oplogFile) {
                    long writePosition;
                    if (offsetInOplog + (long)valueLength > this.crf.bytesFlushed && !this.closed) {
                        this.flushAll();
                    }
                    long l = writePosition = this.doneAppending ? this.crf.bytesFlushed : this.crf.raf.getFilePointer();
                    if (offsetInOplog + (long)valueLength > writePosition) {
                        throw new DiskAccessException(String.format("Tried to seek to %s, but the file length is %s. Oplog File object used for reading=%s", offsetInOplog + (long)valueLength, writePosition, this.crf.raf), this.getParent().getName());
                    }
                    if (offsetInOplog < 0L) {
                        throw new DiskAccessException(String.format("Cannot find record %s when reading from %s", offsetInOplog, this.diskFile.getPath()), this.getParent().getName());
                    }
                    try {
                        this.crf.raf.seek(offsetInOplog);
                        this.stats.incOplogSeeks();
                        byte[] valueBytes = null;
                        if (wrapper.getBytes().length < valueLength) {
                            valueBytes = new byte[valueLength];
                            this.crf.raf.readFully(valueBytes);
                        } else {
                            valueBytes = wrapper.getBytes();
                            this.crf.raf.readFully(valueBytes, 0, valueLength);
                        }
                        this.stats.incOplogReads();
                        wrapper.setData(valueBytes, userBits, valueLength, true);
                    }
                    finally {
                        if (!this.doneAppending) {
                            this.crf.raf.seek(writePosition);
                            this.stats.incOplogSeeks();
                        }
                    }
                }
            }
            catch (IOException ex) {
                throw new DiskAccessException(String.format("Failed reading from %s.  oplogID, %s Offset being read=%s Current Oplog Size=%s Actual File Size,%s IS ASYNCH MODE,%s IS ASYNCH WRITER ALIVE=%s", this.diskFile.getPath(), (long)this.oplogId, offsetInOplog, this.crf.currSize, this.crf.bytesFlushed, false, false), (Throwable)ex, this.getParent().getName());
            }
            catch (IllegalStateException ex) {
                this.checkClosed();
                throw ex;
            }
        }
        return true;
    }

    private static class OplogFile {
        public File f;
        public RandomAccessFile raf;
        public boolean RAFClosed;
        public FileChannel channel;
        public ByteBuffer writeBuf;
        public long currSize;
        public long bytesFlushed;

        private OplogFile() {
        }
    }

    private class OpState {
        private byte userBits;
        private int size;
        private boolean needsValue;
        private DiskEntry.Helper.ValueWrapper value;

        private OpState() {
        }

        public int getSize() {
            return this.size;
        }

        public void clear() {
            this.value = null;
        }

        private void write(DiskEntry.Helper.ValueWrapper vw) throws IOException {
            vw.sendTo(OverflowOplog.this.getOLF().writeBuf, OverflowOplog.this);
        }

        public void initialize(DiskEntry entry, DiskEntry.Helper.ValueWrapper value, byte userBits) {
            this.userBits = userBits;
            this.value = value;
            this.size = 0;
            this.needsValue = EntryBits.isNeedsValue(this.userBits);
            if (this.needsValue) {
                this.size += this.value.getLength();
            }
        }

        public long write() throws IOException {
            int valueLength;
            long bytesWritten = 0L;
            if (this.needsValue && (valueLength = this.value.getLength()) > 0) {
                this.write(this.value);
                bytesWritten += (long)valueLength;
            }
            return bytesWritten;
        }
    }
}

