/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import org.apache.geode.cache.CacheLoaderException;
import org.apache.geode.cache.LoaderHelper;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.SearchLoadAndWriteProcessor;

public class LoaderHelperImpl
implements LoaderHelper {
    public static final String NET_SEARCH_LOCAL = "Cannot netSearch for a Scope.LOCAL object";
    private final Object key;
    private final boolean netSearchAllowed;
    private final boolean netLoadAllowed;
    private final Region region;
    private final Object aCallbackArgument;
    private SearchLoadAndWriteProcessor searcher = null;

    public LoaderHelperImpl(Region region, Object key, Object aCallbackArgument, boolean netSearchAllowed, SearchLoadAndWriteProcessor searcher) {
        this.region = region;
        this.key = key;
        this.aCallbackArgument = aCallbackArgument;
        this.netSearchAllowed = netSearchAllowed;
        this.netLoadAllowed = true;
        this.searcher = searcher;
    }

    public LoaderHelperImpl(Region region, Object key, Object aCallbackArgument, boolean netSearchAllowed, boolean netLoadAllowed, SearchLoadAndWriteProcessor searcher) {
        this.region = region;
        this.key = key;
        this.aCallbackArgument = aCallbackArgument;
        this.netSearchAllowed = netSearchAllowed;
        this.netLoadAllowed = netLoadAllowed;
        this.searcher = searcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object netSearch(boolean doNetLoad) throws CacheLoaderException, TimeoutException {
        if (this.region.getAttributes().getScope().isLocal()) {
            throw new CacheLoaderException(NET_SEARCH_LOCAL);
        }
        boolean removeSearcher = false;
        if (this.searcher == null) {
            this.searcher = SearchLoadAndWriteProcessor.getProcessor();
            removeSearcher = true;
        }
        try {
            if (removeSearcher) {
                this.searcher.initialize((LocalRegion)this.region, this.key, this.aCallbackArgument);
            }
            Object obj = null;
            if (this.netSearchAllowed) {
                obj = this.searcher.doNetSearch();
                if (this.searcher.resultIsSerialized()) {
                    obj = EntryEventImpl.deserialize((byte[])obj);
                }
            }
            if (doNetLoad && obj == null && this.netLoadAllowed) {
                obj = this.searcher.doNetLoad();
                if (this.searcher.resultIsSerialized()) {
                    obj = EntryEventImpl.deserialize((byte[])obj);
                }
            }
            Object object = obj;
            return object;
        }
        finally {
            if (removeSearcher) {
                this.searcher.remove();
            }
        }
    }

    public Object getKey() {
        return this.key;
    }

    public Region getRegion() {
        return this.region;
    }

    @Override
    public Object getArgument() {
        return this.aCallbackArgument;
    }

    public String toString() {
        return "LoaderHelper region: " + String.valueOf(this.getRegion()) + " key: " + String.valueOf(this.getKey()) + " argument: " + String.valueOf(this.getArgument());
    }
}

