/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.geode.DataSerializable;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.ClientSession;
import org.apache.geode.cache.InterestRegistrationEvent;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.cache.tier.InterestType;
import org.apache.geode.internal.cache.tier.sockets.CacheClientProxy;
import org.jetbrains.annotations.NotNull;

public class InterestRegistrationEventImpl
implements InterestRegistrationEvent,
DataSerializable {
    private static final long serialVersionUID = -5791294858933070049L;
    private String regionName;
    private Set<?> keysOfInterest;
    private int interestType;
    private boolean isRegister;
    private transient ClientSession clientSession;
    private transient Cache cache;

    public InterestRegistrationEventImpl() {
    }

    public InterestRegistrationEventImpl(@NotNull CacheClientProxy clientSession, @NotNull String regionName, @NotNull Set<?> keysOfInterest, @NotNull InterestType interestType2, boolean isRegister) {
        this.cache = clientSession.getCache();
        this.clientSession = clientSession;
        this.regionName = regionName;
        this.keysOfInterest = keysOfInterest;
        this.interestType = interestType2.ordinal();
        this.isRegister = isRegister;
    }

    @Override
    public ClientSession getClientSession() {
        return this.clientSession;
    }

    @Override
    public String getRegionName() {
        return this.regionName;
    }

    @Override
    public Region<?, ?> getRegion() {
        return this.cache.getRegion(this.regionName);
    }

    @Override
    public Set<?> getKeysOfInterest() {
        return this.keysOfInterest;
    }

    @Override
    public int getInterestType() {
        return this.interestType;
    }

    @Override
    public boolean isRegister() {
        return this.isRegister;
    }

    @Override
    public boolean isKey() {
        return this.interestType == InterestType.KEY.ordinal();
    }

    @Override
    public boolean isRegularExpression() {
        return this.interestType == InterestType.REGULAR_EXPRESSION.ordinal();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeString(this.regionName, out);
        DataSerializer.writeHashSet((HashSet)this.keysOfInterest, out);
        DataSerializer.writePrimitiveInt(this.interestType, out);
        DataSerializer.writePrimitiveBoolean(this.isRegister, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.regionName = DataSerializer.readString(in);
        this.keysOfInterest = DataSerializer.readHashSet(in);
        this.interestType = DataSerializer.readPrimitiveInt(in);
        this.isRegister = DataSerializer.readPrimitiveBoolean(in);
    }

    public String toString() {
        return "InterestRegistrationEvent [isRegister=" + this.isRegister + "clientSession=" + String.valueOf(this.clientSession) + "; isRegister=; regionName=" + this.regionName + "; keysOfInterest=" + String.valueOf(this.keysOfInterest) + "; interestType=" + InterestType.getString(InterestType.valueOf(this.interestType)) + "]";
    }
}

