/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.apache.geode.CancelException;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.HighPriorityDistributionMessage;
import org.apache.geode.distributed.internal.MessageWithReply;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class FindVersionTagOperation {
    private static final Logger logger = LogService.getLogger();

    public static VersionTag findVersionTag(InternalRegion r, EventID eventId, boolean isBulkOp) {
        DistributionManager dm = r.getDistributionManager();
        Set<InternalDistributedMember> recipients = r instanceof DistributedRegion ? ((DistributedRegion)r).getDistributionAdvisor().adviseCacheOp() : ((PartitionedRegion)r).getRegionAdvisor().adviseDataStore();
        ResultReplyProcessor processor = new ResultReplyProcessor(dm, recipients);
        FindVersionTagMessage msg = new FindVersionTagMessage(recipients, processor.getProcessorId(), r.getFullPath(), eventId, isBulkOp);
        dm.putOutgoing(msg);
        try {
            processor.waitForReplies();
        }
        catch (InterruptedException e) {
            dm.getCancelCriterion().checkCancelInProgress(e);
            Thread.currentThread().interrupt();
            return null;
        }
        return processor.getVersionTag();
    }

    public static class ResultReplyProcessor
    extends ReplyProcessor21 {
        VersionTag versionTag;

        public ResultReplyProcessor(DistributionManager dm, Collection initMembers) {
            super(dm, initMembers);
        }

        @Override
        public void process(DistributionMessage msg) {
            if (msg instanceof VersionTagReply) {
                VersionTagReply reply = (VersionTagReply)msg;
                if (reply.versionTag != null) {
                    this.versionTag = reply.versionTag;
                    this.versionTag.replaceNullIDs(reply.getSender());
                }
            }
            super.process(msg);
        }

        public VersionTag getVersionTag() {
            return this.versionTag;
        }

        @Override
        public boolean stillWaiting() {
            return this.versionTag == null && super.stillWaiting();
        }
    }

    public static class FindVersionTagMessage
    extends HighPriorityDistributionMessage
    implements MessageWithReply {
        int processorId;
        String regionName;
        EventID eventId;
        private boolean isBulkOp;

        protected FindVersionTagMessage(Collection recipients, int processorId, String regionName, EventID eventId, boolean isBulkOp) {
            this.setRecipients(recipients);
            this.processorId = processorId;
            this.regionName = regionName;
            this.eventId = eventId;
            this.isBulkOp = isBulkOp;
        }

        public FindVersionTagMessage() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected void process(ClusterDistributionManager dm) {
            VersionTagReply reply;
            VersionTag result = null;
            try {
                LocalRegion r = (LocalRegion)this.findRegion(dm);
                if (r == null) {
                    if (!logger.isDebugEnabled()) return;
                    logger.debug("Region not found, so ignoring version tag request: {}", (Object)this);
                    return;
                }
                result = this.isBulkOp ? r.findVersionTagForClientBulkOp(this.eventId) : r.findVersionTagForEvent(this.eventId);
                if (result != null) {
                    result.replaceNullIDs(r.getVersionMember());
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Found version tag {}", (Object)result);
                }
                reply = new VersionTagReply(result);
            }
            catch (RuntimeException e) {
                logger.warn("Exception thrown while searching for a version tag", (Throwable)e);
                return;
            }
            reply.setProcessorId(this.processorId);
            reply.setRecipient(this.getSender());
            try {
                dm.putOutgoing(reply);
                return;
            }
            catch (CancelException cancelException) {
                return;
            }
            finally {
                reply = new VersionTagReply(result);
                reply.setProcessorId(this.processorId);
                reply.setRecipient(this.getSender());
                try {
                    dm.putOutgoing(reply);
                }
                catch (CancelException cancelException) {}
            }
        }

        private InternalRegion findRegion(ClusterDistributionManager dm) {
            try {
                InternalCache cache = dm.getCache();
                if (cache != null) {
                    return cache.getRegionByPathForProcessing(this.regionName);
                }
            }
            catch (CancelException cancelException) {
                // empty catch block
            }
            return null;
        }

        public int getDSFID() {
            return 5;
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            super.toData(out, context);
            out.writeInt(this.processorId);
            out.writeUTF(this.regionName);
            InternalDataSerializer.invokeToData(this.eventId, out);
            out.writeBoolean(this.isBulkOp);
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            super.fromData(in, context);
            this.processorId = in.readInt();
            this.regionName = in.readUTF();
            this.eventId = new EventID();
            InternalDataSerializer.invokeFromData(this.eventId, in);
            this.isBulkOp = in.readBoolean();
        }

        @Override
        public String toString() {
            return this.getShortClassName() + "(processorId=" + this.processorId + ";region=" + this.regionName + ";eventId=" + String.valueOf(this.eventId) + ";isBulkOp=" + this.isBulkOp + ")";
        }
    }

    public static class VersionTagReply
    extends ReplyMessage {
        VersionTag versionTag;

        VersionTagReply(VersionTag result) {
            this.versionTag = result;
        }

        public VersionTagReply() {
        }

        @Override
        public String toString() {
            return "VersionTagReply(" + String.valueOf(this.versionTag) + ")";
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            super.toData(out, context);
            DataSerializer.writeObject(this.versionTag, out);
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            super.fromData(in, context);
            this.versionTag = (VersionTag)DataSerializer.readObject(in);
        }

        @Override
        public int getDSFID() {
            return 6;
        }
    }
}

