/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.MessageWithReply;
import org.apache.geode.distributed.internal.PooledDistributionMessage;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.distributed.internal.ServerLocator;
import org.apache.geode.internal.cache.CacheServerImpl;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.GridAdvisor;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class FindDurableQueueProcessor
extends ReplyProcessor21 {
    private static final Logger logger = LogService.getLogger();
    final ArrayList durableLocations = new ArrayList();

    public static ArrayList sendAndFind(ServerLocator locator, ClientProxyMembershipID proxyId, DistributionManager dm) {
        HashSet members = ((GridAdvisor)locator.getDistributionAdvisor()).adviseBridgeServers();
        if (members.contains(dm.getId())) {
            HashSet remoteMembers = new HashSet(members);
            remoteMembers.remove(dm.getId());
            members = remoteMembers;
        }
        FindDurableQueueProcessor processor = new FindDurableQueueProcessor(dm, members);
        FindDurableQueueMessage.send(proxyId, dm, members, processor);
        try {
            processor.waitForRepliesUninterruptibly();
        }
        catch (ReplyException e) {
            e.handleCause();
        }
        ArrayList locations = processor.durableLocations;
        FindDurableQueueProcessor.findLocalDurableQueues(proxyId, locations);
        return locations;
    }

    private static void findLocalDurableQueues(ClientProxyMembershipID proxyId, ArrayList<ServerLocation> matches) {
        List<CacheServer> l;
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        if (cache != null && (l = cache.getCacheServers()) != null) {
            for (CacheServer o : l) {
                CacheServerImpl bs = (CacheServerImpl)o;
                if (bs.getAcceptor().getCacheClientNotifier().getClientProxy(proxyId) == null) continue;
                ServerLocation loc = new ServerLocation(bs.getExternalAddress(), bs.getPort());
                matches.add(loc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(DistributionMessage msg) {
        if (msg instanceof FindDurableQueueReply) {
            FindDurableQueueReply reply = (FindDurableQueueReply)msg;
            ArrayList arrayList = this.durableLocations;
            synchronized (arrayList) {
                this.durableLocations.addAll(reply.getMatches());
            }
        }
        super.process(msg);
    }

    private FindDurableQueueProcessor(DistributionManager dm, Set members) {
        super(dm, (Collection)members);
    }

    public static class FindDurableQueueMessage
    extends PooledDistributionMessage
    implements MessageWithReply {
        private int processorId;
        private ClientProxyMembershipID proxyId;

        protected static void send(ClientProxyMembershipID proxyId, DistributionManager dm, Set members, ReplyProcessor21 proc) {
            FindDurableQueueMessage msg = new FindDurableQueueMessage();
            msg.processorId = proc.getProcessorId();
            msg.proxyId = proxyId;
            msg.setRecipients(members);
            if (logger.isDebugEnabled()) {
                logger.debug("FindDurableQueueMessage sending {} to {}", (Object)msg, (Object)members);
            }
            dm.putOutgoing(msg);
        }

        @Override
        public int getProcessorId() {
            return this.processorId;
        }

        public ClientProxyMembershipID getProxyId() {
            return this.proxyId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void process(ClusterDistributionManager dm) {
            FindDurableQueueReply reply;
            ArrayList<ServerLocation> matches = new ArrayList<ServerLocation>();
            try {
                FindDurableQueueProcessor.findLocalDurableQueues(this.proxyId, matches);
                reply = new FindDurableQueueReply();
            }
            catch (Throwable throwable) {
                FindDurableQueueReply reply2 = new FindDurableQueueReply();
                reply2.setProcessorId(this.getProcessorId());
                reply2.matches = matches;
                reply2.setRecipient(this.getSender());
                if (dm.getId().equals(this.getSender())) {
                    reply2.setSender(this.getSender());
                    reply2.dmProcess(dm);
                } else {
                    dm.putOutgoing(reply2);
                }
                throw throwable;
            }
            reply.setProcessorId(this.getProcessorId());
            reply.matches = matches;
            reply.setRecipient(this.getSender());
            if (dm.getId().equals(this.getSender())) {
                reply.setSender(this.getSender());
                reply.dmProcess(dm);
            } else {
                dm.putOutgoing(reply);
            }
        }

        public int getDSFID() {
            return 22;
        }

        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            super.fromData(in, context);
            this.processorId = in.readInt();
            this.proxyId = ClientProxyMembershipID.readCanonicalized(in);
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            super.toData(out, context);
            out.writeInt(this.processorId);
            DataSerializer.writeObject(this.proxyId, out);
        }

        @Override
        public String toString() {
            return "FindDurableQueueMessage (proxyId='" + String.valueOf(this.proxyId) + "' processorId=" + this.processorId + ")";
        }
    }

    public static class FindDurableQueueReply
    extends ReplyMessage {
        protected ArrayList matches = null;

        public ArrayList getMatches() {
            return this.matches;
        }

        @Override
        public int getDSFID() {
            return 23;
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            super.fromData(in, context);
            this.matches = DataSerializer.readArrayList(in);
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            super.toData(out, context);
            DataSerializer.writeArrayList(this.matches, out);
        }

        @Override
        public String toString() {
            return "FindDurableQueueReply (matches='" + String.valueOf(this.matches) + "' processorId=" + this.processorId + ")";
        }
    }
}

