/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.geode.DataSerializer;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.HeapDataOutputStream;
import org.apache.geode.internal.cache.ha.ThreadIdentifier;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.serialization.ByteArrayDataInput;
import org.apache.geode.internal.serialization.DataSerializableFixedID;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.internal.serialization.StaticSerialization;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.internal.util.Breadcrumbs;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class EventID
implements DataSerializableFixedID,
Serializable,
Externalizable {
    private static final Logger logger = LogService.getLogger();
    private static final boolean LOG_ID_BYTES = Boolean.getBoolean("gemfire.log-event-member-id-bytes");
    private byte[] membershipID;
    private long threadID;
    private long sequenceID;
    private int bucketID;
    private byte breadcrumbCounter = 0;
    @Immutable
    private static final KnownVersion[] dsfidVersions = new KnownVersion[0];
    private static final ThreadLocal<ThreadAndSequenceIDWrapper> threadIDLocal = ThreadLocal.withInitial(ThreadAndSequenceIDWrapper::new);
    private transient int hashCode = 0;
    @MakeNotStatic
    private static volatile DistributedSystem system = null;
    @MakeNotStatic
    private static DistributedMember systemMemberId;
    @MakeNotStatic
    private static volatile byte[] client_side_event_identity;
    @Immutable
    static final List<AbstractEventIDByteArrayFiller> fillerArray;
    private static final int NULL_90_MEMBER_DATA_LENGTH = 17;
    private static final int MINIMUM_ID_LENGTH = 19;

    public void incBreadcrumbCounter() {
        this.breadcrumbCounter = (byte)(this.breadcrumbCounter + 1);
    }

    private EventID(byte[] membershipID) {
        this.membershipID = membershipID;
        ThreadAndSequenceIDWrapper wrapper = threadIDLocal.get();
        this.threadID = wrapper.threadID;
        this.sequenceID = wrapper.getAndIncrementSequenceID();
        this.bucketID = -1;
    }

    public EventID(DistributedSystem sys) {
        this(EventID.initializeAndGetDSEventIdentity(sys));
    }

    public static byte[] getMembershipId(DistributedSystem sys) {
        return EventID.initializeAndGetDSEventIdentity(sys);
    }

    public static void unsetDS() {
        system = null;
    }

    public static byte[] getMembershipId(ClientProxyMembershipID client) {
        try {
            HeapDataOutputStream hdos = new HeapDataOutputStream(256, client.getClientVersion());
            ((InternalDistributedMember)client.getDistributedMember()).writeEssentialData(hdos);
            return hdos.toByteArray();
        }
        catch (IOException ioe) {
            throw new InternalGemFireException("Unable to serialize identity", ioe);
        }
    }

    public static long getThreadId() {
        ThreadAndSequenceIDWrapper wrapper = threadIDLocal.get();
        return wrapper.threadID;
    }

    public static long getSequenceId() {
        ThreadAndSequenceIDWrapper wrapper = threadIDLocal.get();
        return wrapper.sequenceID;
    }

    public static long reserveSequenceId() {
        ThreadAndSequenceIDWrapper wrapper = threadIDLocal.get();
        return wrapper.getAndIncrementSequenceID();
    }

    public void reserveSequenceId(int count) {
        ThreadAndSequenceIDWrapper wrapper = threadIDLocal.get();
        wrapper.reserveSequenceID(count);
    }

    public EventID(EventID eventId, int offset) {
        assert (eventId != null);
        this.membershipID = eventId.getMembershipID();
        this.threadID = eventId.getThreadID();
        this.sequenceID = eventId.getSequenceID() + (long)offset;
        this.bucketID = -1;
    }

    public EventID(byte[] memId, long threadId, long seqId) {
        this.membershipID = memId;
        this.threadID = threadId;
        this.sequenceID = seqId;
        this.bucketID = -1;
    }

    public EventID(byte[] memId, long threadId, long seqId, int bucketId) {
        this.membershipID = memId;
        this.threadID = threadId;
        this.sequenceID = seqId;
        this.bucketID = bucketId;
    }

    public static Object getThreadLocalDataForHydra() {
        ThreadAndSequenceIDWrapper result = threadIDLocal.get();
        threadIDLocal.set(null);
        return result;
    }

    public static void setThreadLocalDataForHydra(Object wrapper) {
        if (!(wrapper instanceof ThreadAndSequenceIDWrapper)) {
            throw new IllegalArgumentException("Expected a ThreadAndSequenceIdWrapper but received " + String.valueOf(wrapper));
        }
        threadIDLocal.set((ThreadAndSequenceIDWrapper)wrapper);
    }

    public EventID() {
    }

    public long getThreadID() {
        return this.threadID;
    }

    public void setThreadID(long threadID) {
        this.threadID = threadID;
    }

    public byte[] getMembershipID() {
        return this.membershipID;
    }

    public int getBucketID() {
        return this.bucketID;
    }

    public InternalDistributedMember getDistributedMember() {
        return this.getDistributedMember(KnownVersion.CURRENT);
    }

    public InternalDistributedMember getDistributedMember(KnownVersion targetVersion) {
        KnownVersion disVersion = null;
        if (targetVersion.isOlderThan((Version)KnownVersion.GEODE_1_1_0)) {
            disVersion = KnownVersion.GFE_90;
        }
        InternalDistributedMember result = null;
        try (ByteArrayDataInput dis = new ByteArrayDataInput(this.membershipID, disVersion);){
            result = InternalDistributedMember.readEssentialData((DataInput)dis);
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return result;
    }

    public long getSequenceID() {
        return this.sequenceID;
    }

    public byte[] calcBytes() {
        return EventID.getOptimizedByteArrayForEventID(this.getThreadID(), this.getSequenceID());
    }

    public int getDSFID() {
        return 36;
    }

    public void toData(DataOutput dop, SerializationContext context) throws IOException {
        KnownVersion version = StaticSerialization.getVersionForDataStream((DataOutput)dop);
        if (this.membershipID != null && version.isOlderThan((Version)KnownVersion.GEODE_1_1_0)) {
            InternalDistributedMember member = this.getDistributedMember(KnownVersion.GFE_90);
            HeapDataOutputStream hdos = new HeapDataOutputStream(KnownVersion.GFE_90);
            member.writeEssentialData(hdos);
            DataSerializer.writeByteArray(hdos.toByteArray(), dop);
        } else {
            DataSerializer.writeByteArray(this.membershipID, dop);
        }
        DataSerializer.writeByteArray(EventID.getOptimizedByteArrayForEventID(this.threadID, this.sequenceID), dop);
        dop.writeInt(this.bucketID);
        dop.writeByte(this.breadcrumbCounter);
    }

    public void fromData(DataInput di, DeserializationContext context) throws IOException, ClassNotFoundException {
        this.membershipID = DataSerializer.readByteArray(di);
        ByteBuffer eventIdParts = ByteBuffer.wrap(DataSerializer.readByteArray(di));
        this.threadID = EventID.readEventIdPartsFromOptimizedByteArray(eventIdParts);
        this.sequenceID = EventID.readEventIdPartsFromOptimizedByteArray(eventIdParts);
        this.bucketID = di.readInt();
        this.breadcrumbCounter = di.readByte();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        DataSerializer.writeByteArray(this.membershipID, out);
        DataSerializer.writeByteArray(EventID.getOptimizedByteArrayForEventID(this.threadID, this.sequenceID), out);
        out.writeInt(this.bucketID);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.membershipID = DataSerializer.readByteArray(in);
        ByteBuffer eventIdParts = ByteBuffer.wrap(DataSerializer.readByteArray(in));
        this.threadID = EventID.readEventIdPartsFromOptimizedByteArray(eventIdParts);
        this.sequenceID = EventID.readEventIdPartsFromOptimizedByteArray(eventIdParts);
        this.bucketID = in.readInt();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EventID other = (EventID)obj;
        if (this.sequenceID != other.sequenceID) {
            return false;
        }
        if (this.threadID != other.threadID) {
            return false;
        }
        return EventID.equalMembershipIds(this.membershipID, other.membershipID);
    }

    public static boolean equalMembershipIds(byte[] m1, byte[] m2) {
        int sizeDifference = Math.abs(m1.length - m2.length);
        if (sizeDifference != 0 && sizeDifference != 17) {
            return false;
        }
        for (int i = 0; i < m1.length; ++i) {
            if (i >= m2.length) {
                return EventID.nullUUIDCheck(m1, i);
            }
            if (m1[i] == m2[i]) continue;
            return false;
        }
        if (m1.length != m2.length) {
            return EventID.nullUUIDCheck(m2, m1.length);
        }
        return true;
    }

    private static boolean nullUUIDCheck(byte[] memberID, int position) {
        if (position < 0) {
            return false;
        }
        if (memberID.length - position != 17) {
            return false;
        }
        for (int i = position; i < memberID.length; ++i) {
            if (memberID[i] == 0) continue;
            return false;
        }
        return true;
    }

    public static int hashCodeMemberId(byte[] memberID) {
        if (memberID.length < 36 || !EventID.nullUUIDCheck(memberID, memberID.length - 17)) {
            return Arrays.hashCode(memberID);
        }
        byte[] newID = new byte[memberID.length - 17];
        System.arraycopy(memberID, 0, newID, 0, newID.length);
        return Arrays.hashCode(newID);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int prime = 31;
            int result = 1;
            result = 31 * result + EventID.hashCodeMemberId(this.membershipID);
            result = 31 * result + (int)(this.sequenceID ^ this.sequenceID >>> 32);
            this.hashCode = result = 31 * result + (int)(this.threadID ^ this.threadID >>> 32);
        }
        return this.hashCode;
    }

    String getShortClassName() {
        String cname = this.getClass().getName();
        return cname.substring(this.getClass().getPackage().getName().length() + 1);
    }

    public String expensiveToString() {
        Object mbr;
        try (ByteArrayDataInput in = new ByteArrayDataInput(this.membershipID);){
            mbr = InternalDistributedMember.readEssentialData((DataInput)in);
        }
        catch (Exception e) {
            mbr = this.membershipID;
        }
        return "EventID[" + String.valueOf(mbr) + ";threadID=" + ThreadIdentifier.toDisplayString(this.threadID) + ";sequenceID=" + this.sequenceID + (String)(Breadcrumbs.ENABLED ? ";bcrumb=" + this.breadcrumbCounter : "") + (String)(this.bucketID >= 0 ? ";bucketID=" + this.bucketID : "") + "]";
    }

    public String toString() {
        if (logger.isDebugEnabled()) {
            return this.expensiveToString();
        }
        return this.cheapToString();
    }

    public String cheapToString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getShortClassName());
        if (LOG_ID_BYTES) {
            buf.append("[membershipID=");
            for (int i = 0; i < this.membershipID.length; ++i) {
                buf.append(this.membershipID[i]);
                if (i >= this.membershipID.length - 1) continue;
                buf.append(',');
            }
            buf.append(";");
        } else {
            buf.append("[id=").append(this.membershipID.length).append(" bytes;");
        }
        buf.append("threadID=");
        buf.append(ThreadIdentifier.toDisplayString(this.threadID));
        buf.append(";sequenceID=");
        buf.append(this.sequenceID);
        if (Breadcrumbs.ENABLED) {
            buf.append(";bcrumb=").append(this.breadcrumbCounter);
        }
        if (this.bucketID >= 0) {
            buf.append(";bucketId=");
            buf.append(this.bucketID);
        }
        buf.append("]");
        return buf.toString();
    }

    private static byte[] initializeAndGetDSEventIdentity(DistributedSystem sys) {
        if (sys == null) {
            throw new IllegalStateException("Attempting to handshake with CacheServer before creating DistributedSystem and Cache.");
        }
        if (system != sys) {
            systemMemberId = sys.getDistributedMember();
            try (HeapDataOutputStream hdos = new HeapDataOutputStream(256, KnownVersion.CURRENT);){
                ((InternalDistributedMember)systemMemberId).writeEssentialData(hdos);
                client_side_event_identity = hdos.toByteArray();
            }
            catch (IOException ioe) {
                throw new InternalGemFireException("Unable to serialize identity", ioe);
            }
            if (((InternalDistributedMember)systemMemberId).getMembershipPort() != 0) {
                system = sys;
            }
        }
        return client_side_event_identity;
    }

    public static int getByteSizeForValue(long id) {
        int length = id <= 127L ? 1 : (id <= 32767L ? 2 : (id <= Integer.MAX_VALUE ? 4 : 8));
        return length;
    }

    public static byte[] getOptimizedByteArrayForEventID(long threadId, long sequenceId) {
        int threadIdLength = EventID.getByteSizeForValue(threadId);
        int threadIdIndex = threadIdLength == 1 ? 0 : threadIdLength / 4 + 1;
        int sequenceIdLength = EventID.getByteSizeForValue(sequenceId);
        int sequenceIdIndex = sequenceIdLength == 1 ? 0 : sequenceIdLength / 4 + 1;
        int byteBufferLength = 2 + threadIdLength + sequenceIdLength;
        ByteBuffer buffer = ByteBuffer.allocate(byteBufferLength);
        fillerArray.get(threadIdIndex).fill(buffer, threadId);
        fillerArray.get(sequenceIdIndex).fill(buffer, sequenceId);
        return buffer.array();
    }

    public static long readEventIdPartsFromOptimizedByteArray(ByteBuffer buffer) {
        byte byteType = buffer.get();
        return fillerArray.get(byteType).read(buffer);
    }

    public KnownVersion[] getSerializationVersions() {
        return dsfidVersions;
    }

    static {
        client_side_event_identity = null;
        fillerArray = Collections.unmodifiableList(Arrays.asList(new ByteEventIDByteArrayFiller(), new ShortEventIDByteArrayFiller(), new IntegerEventIDByteArrayFiller(), new LongEventIDByteArrayFiller()));
    }

    static class ThreadAndSequenceIDWrapper {
        final long threadID;
        long sequenceID = 0L;
        @MakeNotStatic
        private static final AtomicLong atmLong = new AtomicLong(System.currentTimeMillis() % 1000000L);

        ThreadAndSequenceIDWrapper() {
            long id = atmLong.incrementAndGet();
            if (id < 1000000L) {
                this.threadID = id;
            } else if (id == 1000000L) {
                atmLong.set(0L);
                this.threadID = atmLong.incrementAndGet();
            } else {
                id = atmLong.incrementAndGet();
                while (id > 1000000L) {
                    id = atmLong.incrementAndGet();
                }
                this.threadID = id;
            }
        }

        long getAndIncrementSequenceID() {
            return this.sequenceID++;
        }

        void reserveSequenceID(int size) {
            this.sequenceID += (long)size;
        }
    }

    protected static abstract class AbstractEventIDByteArrayFiller {
        protected AbstractEventIDByteArrayFiller() {
        }

        public abstract void fill(ByteBuffer var1, long var2);

        public abstract long read(ByteBuffer var1);
    }

    protected static class ByteEventIDByteArrayFiller
    extends AbstractEventIDByteArrayFiller {
        private static final byte EVENTID_BYTE = 0;

        protected ByteEventIDByteArrayFiller() {
        }

        @Override
        public void fill(ByteBuffer buffer, long id) {
            buffer.put((byte)0);
            buffer.put((byte)id);
        }

        @Override
        public long read(ByteBuffer buffer) {
            return buffer.get();
        }
    }

    protected static class ShortEventIDByteArrayFiller
    extends AbstractEventIDByteArrayFiller {
        private static final byte EVENTID_SHORT = 1;

        protected ShortEventIDByteArrayFiller() {
        }

        @Override
        public void fill(ByteBuffer buffer, long id) {
            buffer.put((byte)1);
            buffer.putShort((short)id);
        }

        @Override
        public long read(ByteBuffer buffer) {
            return buffer.getShort();
        }
    }

    protected static class IntegerEventIDByteArrayFiller
    extends AbstractEventIDByteArrayFiller {
        private static final byte EVENTID_INT = 2;

        protected IntegerEventIDByteArrayFiller() {
        }

        @Override
        public void fill(ByteBuffer buffer, long id) {
            buffer.put((byte)2);
            buffer.putInt((int)id);
        }

        @Override
        public long read(ByteBuffer buffer) {
            return buffer.getInt();
        }
    }

    protected static class LongEventIDByteArrayFiller
    extends AbstractEventIDByteArrayFiller {
        private static final byte EVENTID_LONG = 3;

        protected LongEventIDByteArrayFiller() {
        }

        @Override
        public void fill(ByteBuffer buffer, long id) {
            buffer.put((byte)3);
            buffer.putLong(id);
        }

        @Override
        public long read(ByteBuffer buffer) {
            return buffer.getLong();
        }
    }
}

