/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializable;
import org.apache.geode.cache.CacheStatistics;
import org.apache.geode.cache.EntryDestroyedException;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.StatisticsDisabledException;
import org.apache.geode.internal.cache.CacheStatisticsImpl;
import org.apache.geode.internal.cache.CachedDeserializable;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.NonLocalRegionEntry;
import org.apache.geode.internal.cache.NonLocalRegionEntryWithStats;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.versions.VersionStamp;
import org.apache.geode.internal.cache.versions.VersionTag;

public class EntrySnapshot
implements Region.Entry,
DataSerializable {
    private static final long serialVersionUID = -2139749921655693280L;
    private boolean startedLocal;
    private boolean entryDestroyed;
    private transient LocalRegion region = null;
    private transient NonLocalRegionEntry regionEntry;

    public EntrySnapshot(RegionEntry regionEntry, LocalRegion dataRegion, LocalRegion region, boolean allowTombstones) {
        this.region = region;
        if (regionEntry instanceof NonLocalRegionEntry) {
            this.regionEntry = (NonLocalRegionEntry)regionEntry;
            this.startedLocal = false;
        } else {
            this.startedLocal = true;
            this.regionEntry = regionEntry.hasStats() ? new NonLocalRegionEntryWithStats(regionEntry, dataRegion, allowTombstones) : new NonLocalRegionEntry(regionEntry, dataRegion, allowTombstones);
        }
    }

    public boolean wasInitiallyLocal() {
        return this.startedLocal;
    }

    @Override
    public Object getKey() {
        this.checkEntryDestroyed();
        return this.regionEntry.getKey();
    }

    public VersionTag getVersionTag() {
        VersionStamp stamp = this.regionEntry.getVersionStamp();
        if (stamp != null) {
            return stamp.asVersionTag();
        }
        return null;
    }

    public Object getRawValue() {
        return this.getRawValue(false);
    }

    public Object getRawValue(boolean forceCopy) {
        Object v = this.regionEntry.getValue(null);
        if (v == null) {
            return null;
        }
        if (v instanceof CachedDeserializable) {
            v = this.region.isCopyOnRead() || forceCopy ? ((CachedDeserializable)v).getDeserializedWritableCopy(null, null) : ((CachedDeserializable)v).getDeserializedValue(null, null);
            if (v == Token.INVALID || v == Token.LOCAL_INVALID) {
                v = null;
            }
        } else {
            v = v == Token.INVALID || v == Token.LOCAL_INVALID ? null : this.conditionalCopy(v);
        }
        return v;
    }

    public Object getValuePreferringCachedDeserializable() {
        this.checkEntryDestroyed();
        Object value = this.regionEntry.getValue(null);
        if (value instanceof CachedDeserializable) {
            return value;
        }
        return this.getRawValue();
    }

    @Override
    public Object getValue() {
        this.checkEntryDestroyed();
        return this.getRawValue();
    }

    private Object conditionalCopy(Object o) {
        return o;
    }

    @Override
    public Object getUserAttribute() {
        this.checkEntryDestroyed();
        return this.region.getEntryUserAttributes().get(this.regionEntry.getKey());
    }

    @Override
    public Object setUserAttribute(Object value) {
        this.checkEntryDestroyed();
        return this.region.getEntryUserAttributes().put(this.regionEntry.getKey(), value);
    }

    @Override
    public boolean isDestroyed() {
        if (this.entryDestroyed) {
            return true;
        }
        if (this.region.isDestroyed()) {
            this.entryDestroyed = true;
        } else if (this.regionEntry.isRemoved()) {
            this.entryDestroyed = true;
        }
        return this.entryDestroyed;
    }

    public Region getRegion() {
        this.checkEntryDestroyed();
        return this.region;
    }

    @Override
    public CacheStatistics getStatistics() throws StatisticsDisabledException {
        this.checkEntryDestroyed();
        if (!this.regionEntry.hasStats() || !this.region.statisticsEnabled) {
            throw new StatisticsDisabledException(String.format("Statistics disabled for region ' %s '", this.region.getFullPath()));
        }
        return new CacheStatisticsImpl(this.regionEntry, this.region);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof EntrySnapshot)) {
            return false;
        }
        EntrySnapshot ent = (EntrySnapshot)obj;
        return this.regionEntry.getKey().equals(ent.getKey());
    }

    @Override
    public int hashCode() {
        return this.regionEntry.getKey().hashCode();
    }

    @Override
    public Object setValue(Object arg) {
        Object returnValue = this.region.put(this.getKey(), arg);
        this.regionEntry.setCachedValue(arg);
        return returnValue;
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    public String toString() {
        if (this.isDestroyed()) {
            return "EntrySnapshot(#destroyed#" + String.valueOf(this.regionEntry.getKey()) + "; version=" + String.valueOf(this.getVersionTag()) + ")";
        }
        return "EntrySnapshot(" + String.valueOf(this.regionEntry) + ")";
    }

    public RegionEntry getRegionEntry() {
        return this.regionEntry;
    }

    private void checkEntryDestroyed() throws EntryDestroyedException {
        if (this.isDestroyed()) {
            throw new EntryDestroyedException("entry destroyed");
        }
    }

    public EntrySnapshot() {
    }

    public EntrySnapshot(DataInput in, LocalRegion region) throws IOException, ClassNotFoundException {
        this.fromData(in);
        this.region = region;
    }

    public void setRegion(LocalRegion r) {
        this.region = r;
    }

    public void setRegionEntry(NonLocalRegionEntry re) {
        this.regionEntry = re;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        out.writeBoolean(this.regionEntry instanceof NonLocalRegionEntryWithStats);
        this.regionEntry.toData(out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.startedLocal = false;
        boolean hasStats = in.readBoolean();
        this.regionEntry = hasStats ? new NonLocalRegionEntryWithStats() : new NonLocalRegionEntry();
        this.regionEntry.fromData(in);
    }
}

