/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.HighPriorityDistributionMessage;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.tier.sockets.ClientHealthMonitor;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.SerializationContext;

public class DistributedPingMessage
extends HighPriorityDistributionMessage {
    private ClientProxyMembershipID proxyID;

    public DistributedPingMessage() {
    }

    public DistributedPingMessage(DistributedMember targetServer, ClientProxyMembershipID proxyID) {
        this.proxyID = proxyID;
        this.setRecipient((InternalDistributedMember)targetServer);
    }

    @Override
    protected void process(ClusterDistributionManager dm) {
        ClientHealthMonitor chm = ClientHealthMonitor.getInstance();
        if (chm != null) {
            chm.receivedPing(this.proxyID);
        }
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        context.getSerializer().writeObject((Object)this.proxyID, out);
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.proxyID = (ClientProxyMembershipID)context.getDeserializer().readObject(in);
    }

    public int getDSFID() {
        return -162;
    }

    @Override
    public KnownVersion[] getSerializationVersions() {
        return null;
    }

    @Override
    public String toString() {
        return super.toString() + "; proxyId=" + String.valueOf(this.proxyID);
    }

    @VisibleForTesting
    protected ClientProxyMembershipID getProxyID() {
        return this.proxyID;
    }
}

