/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.geode.DataSerializer;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.cache.CacheEvent;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.ClientRegionEventImpl;
import org.apache.geode.internal.cache.DistributedCacheOperation;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.InternalCacheEvent;
import org.apache.geode.internal.cache.RegionEventImpl;
import org.apache.geode.internal.cache.ReleaseClearLockMessage;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.versions.RegionVersionVector;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;

public class DistributedClearOperation
extends DistributedCacheOperation {
    private final RegionVersionVector rvv;
    private final OperationType operation;
    private final Set<InternalDistributedMember> recipients;
    private VersionTag<?> operationTag;
    @MakeNotStatic
    private static final ConcurrentHashMap<LockKey, DistributedRegion> lockedRegions = new ConcurrentHashMap();

    public static void regionLocked(InternalDistributedMember locker, String regionPath, DistributedRegion region) {
        lockedRegions.put(new LockKey(locker, regionPath), region);
    }

    public static DistributedRegion regionUnlocked(InternalDistributedMember locker, String regionPath) {
        return lockedRegions.remove(new LockKey(locker, regionPath));
    }

    public static void clear(RegionEventImpl regionEvent, RegionVersionVector rvv, Set<InternalDistributedMember> recipients) {
        new DistributedClearOperation(OperationType.OP_CLEAR, regionEvent, rvv, recipients).distribute();
    }

    public static void lockAndFlushToOthers(RegionEventImpl regionEvent, Set<InternalDistributedMember> recipients) {
        DistributedClearOperation dco = new DistributedClearOperation(OperationType.OP_LOCK_FOR_CLEAR, regionEvent, null, recipients);
        dco.distribute();
    }

    @Override
    public String toString() {
        String cname = this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1);
        return cname + "(op=" + String.valueOf((Object)this.operation) + ", tag=" + String.valueOf(this.operationTag) + "event=" + String.valueOf(this.event) + ")";
    }

    public static void releaseLocks(RegionEventImpl regionEvent, Set<InternalDistributedMember> recipients) {
        DistributedRegion region = (DistributedRegion)regionEvent.getRegion();
        ReleaseClearLockMessage.send(recipients, region.getDistributionManager(), region.getFullPath());
    }

    @Override
    protected boolean shouldAck() {
        return true;
    }

    @Override
    public boolean containsRegionContentChange() {
        return this.operation == OperationType.OP_CLEAR;
    }

    private DistributedClearOperation(OperationType op, RegionEventImpl event, RegionVersionVector rvv, Set<InternalDistributedMember> recipients) {
        super(event);
        this.rvv = rvv;
        this.operation = op;
        this.recipients = recipients;
        if (event != null) {
            this.operationTag = event.getVersionTag();
        }
    }

    @Override
    protected void initProcessor(DistributedCacheOperation.CacheOperationReplyProcessor p, DistributedCacheOperation.CacheOperationMessage msg) {
        super.initProcessor(p, msg);
    }

    @Override
    protected boolean supportsAdjunctMessaging() {
        return false;
    }

    @Override
    public boolean supportsMulticast() {
        return false;
    }

    @Override
    protected DistributedCacheOperation.CacheOperationMessage createMessage() {
        ClearRegionMessage mssg;
        if (this.event instanceof ClientRegionEventImpl) {
            mssg = new ClearRegionWithContextMessage();
            mssg.context = this.event.getContext();
        } else {
            mssg = new ClearRegionMessage();
        }
        mssg.clearOp = this.operation;
        mssg.eventID = this.event.getEventId();
        ((ClearRegionMessage)mssg).rvv = this.rvv;
        mssg.owner = this;
        mssg.operationTag = this.operationTag;
        return mssg;
    }

    protected Set getRecipients() {
        return this.recipients;
    }

    public static class LockKey {
        private final InternalDistributedMember locker;
        private final String regionPath;

        public LockKey(InternalDistributedMember locker, String regionPath) {
            this.locker = locker;
            this.regionPath = regionPath;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.locker == null ? 0 : this.locker.hashCode());
            result = 31 * result + (this.regionPath == null ? 0 : this.regionPath.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LockKey other = (LockKey)obj;
            if (this.locker == null ? other.locker != null : !this.locker.equals(other.locker)) {
                return false;
            }
            if (this.regionPath == null) {
                return other.regionPath == null;
            }
            return this.regionPath.equals(other.regionPath);
        }
    }

    public static enum OperationType {
        OP_LOCK_FOR_CLEAR,
        OP_CLEAR;

    }

    public static class ClearRegionWithContextMessage
    extends ClearRegionMessage {
        protected transient Object context;
        protected RegionVersionVector rvv;

        @Override
        public RegionEventImpl createRegionEvent(DistributedRegion rgn) {
            ClientRegionEventImpl event = new ClientRegionEventImpl(rgn, this.getOperation(), this.callbackArg, true, (DistributedMember)this.getSender(), (ClientProxyMembershipID)this.context);
            return event;
        }

        @Override
        protected void appendFields(StringBuilder buff) {
            super.appendFields(buff);
            buff.append("; context=").append(this.context);
        }

        @Override
        public int getDSFID() {
            return 34;
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            super.fromData(in, context);
            this.context = DataSerializer.readObject(in);
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            super.toData(out, context);
            DataSerializer.writeObject(this.context, out);
        }
    }

    public static class ClearRegionMessage
    extends DistributedCacheOperation.CacheOperationMessage {
        protected EventID eventID;
        protected RegionVersionVector rvv;
        protected OperationType clearOp;
        protected VersionTag operationTag;
        protected transient DistributedClearOperation owner;

        @Override
        public boolean containsRegionContentChange() {
            return this.clearOp == OperationType.OP_CLEAR;
        }

        @Override
        public int getProcessorType() {
            return 75;
        }

        @Override
        protected InternalCacheEvent createEvent(DistributedRegion rgn) throws EntryNotFoundException {
            RegionEventImpl event = this.createRegionEvent(rgn);
            event.setEventID(this.eventID);
            if (this.filterRouting != null) {
                event.setLocalFilterInfo(this.filterRouting.getFilterInfo(rgn.getMyId()));
            }
            return event;
        }

        protected RegionEventImpl createRegionEvent(DistributedRegion rgn) {
            RegionEventImpl event = new RegionEventImpl(rgn, this.getOperation(), this.callbackArg, true, this.getSender());
            event.setVersionTag(this.operationTag);
            return event;
        }

        protected boolean operateOnRegion(CacheEvent event, ClusterDistributionManager dm) throws EntryNotFoundException {
            DistributedRegion region = (DistributedRegion)event.getRegion();
            switch (this.clearOp) {
                case OP_CLEAR: {
                    region.clearRegionLocally((RegionEventImpl)event, false, this.rvv);
                    region.notifyBridgeClients(event);
                    this.appliedOperation = true;
                    break;
                }
                case OP_LOCK_FOR_CLEAR: {
                    if (region.getDataPolicy().withStorage()) {
                        DistributedClearOperation.regionLocked(this.getSender(), region.getFullPath(), region);
                        region.lockLocallyForClear(dm, this.getSender(), event);
                    }
                    this.appliedOperation = true;
                }
            }
            return true;
        }

        public int getDSFID() {
            return -83;
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            super.fromData(in, context);
            this.clearOp = OperationType.values()[in.readByte()];
            this.eventID = (EventID)DataSerializer.readObject(in);
            this.rvv = (RegionVersionVector)DataSerializer.readObject(in);
            this.operationTag = (VersionTag)DataSerializer.readObject(in);
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            super.toData(out, context);
            out.writeByte(this.clearOp.ordinal());
            DataSerializer.writeObject(this.eventID, out);
            DataSerializer.writeObject(this.rvv, out);
            DataSerializer.writeObject(this.operationTag, out);
        }

        @Override
        protected void appendFields(StringBuilder buff) {
            super.appendFields(buff);
            buff.append("; op=").append((Object)this.clearOp);
            buff.append("; eventID=").append(this.eventID);
            buff.append("; tag=").append(this.operationTag);
            buff.append("; rvv=").append(this.rvv);
        }
    }
}

