/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.PartitionAttributes;
import org.apache.geode.cache.Scope;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionAdvisee;
import org.apache.geode.distributed.internal.DistributionAdvisor;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.HighPriorityDistributionMessage;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.MessageWithReply;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.CacheDistributionAdvisee;
import org.apache.geode.internal.cache.CacheDistributionAdvisor;
import org.apache.geode.internal.cache.CacheServiceProfile;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.EventStateHelper;
import org.apache.geode.internal.cache.FilterProfile;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.ProfileExchangeProcessor;
import org.apache.geode.internal.cache.event.EventSequenceNumberHolder;
import org.apache.geode.internal.cache.ha.ThreadIdentifier;
import org.apache.geode.internal.cache.partitioned.Bucket;
import org.apache.geode.internal.cache.partitioned.RegionAdvisor;
import org.apache.geode.internal.cache.persistence.PersistentMemberID;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class CreateRegionProcessor
implements ProfileExchangeProcessor {
    private static final Logger logger = LogService.getLogger();
    protected CacheDistributionAdvisee newRegion;

    public CreateRegionProcessor(CacheDistributionAdvisee newRegion) {
        this.newRegion = newRegion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void initializeRegion() {
        InternalDistributedSystem system = this.newRegion.getSystem();
        for (int retry = 0; retry < 5; ++retry) {
            Set recps = this.getRecipients();
            if (logger.isDebugEnabled()) {
                logger.debug("Creating region {}", (Object)this.newRegion);
            }
            if (recps.isEmpty()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("CreateRegionProcessor.initializeRegion, no recipients, msg not sent");
                }
                this.newRegion.getDistributionAdvisor().setInitialized();
                ((LocalRegion)((Object)this.newRegion)).getEventTracker().setInitialized();
                return;
            }
            CreateRegionReplyProcessor replyProc = new CreateRegionReplyProcessor(recps);
            this.newRegion.registerCreateRegionReplyProcessor(replyProc);
            boolean useMcast = false;
            CreateRegionMessage msg = this.getCreateRegionMessage(recps, replyProc, useMcast);
            if (((LocalRegion)((Object)this.newRegion)).isUsedForPartitionedRegionBucket()) {
                replyProc.enableSevereAlertProcessing();
                msg.severeAlertCompatible = true;
            }
            this.newRegion.getDistributionManager().putOutgoing(msg);
            this.newRegion.getCache().getCancelCriterion().checkCancelInProgress(null);
            try {
                replyProc.waitForRepliesUninterruptibly();
                if (replyProc.needRetry()) continue;
            }
            catch (ReplyException e) {
                Throwable t = e.getCause();
                if (t instanceof IllegalStateException) {
                    throw (IllegalStateException)t;
                }
                e.handleCause();
                break;
            }
            replyProc.cleanup();
            ((LocalRegion)((Object)this.newRegion)).getEventTracker().setInitialized();
            if (!((LocalRegion)((Object)this.newRegion)).isUsedForPartitionedRegionBucket() || !logger.isDebugEnabled()) break;
            logger.debug("initialized bucket event tracker: {}", (Object)((LocalRegion)((Object)this.newRegion)).getEventTracker());
            break;
        }
        this.newRegion.getDistributionAdvisor().setInitialized();
    }

    protected Set getRecipients() {
        DistributionAdvisee parent = this.newRegion.getParentAdvisee();
        Set<InternalDistributedMember> recps = null;
        if (parent == null) {
            InternalDistributedSystem system = this.newRegion.getSystem();
            recps = system.getDistributionManager().getOtherDistributionManagerIds();
        } else {
            recps = this.getAdvice();
        }
        return recps;
    }

    @Override
    public CacheDistributionAdvisor.InitialImageAdvice getInitialImageAdvice(CacheDistributionAdvisor.InitialImageAdvice previousAdvice) {
        return this.newRegion.getCacheDistributionAdvisor().adviseInitialImage(previousAdvice);
    }

    private Set getAdvice() {
        if (this.newRegion instanceof BucketRegion) {
            return ((Bucket)this.newRegion).getBucketAdvisor().adviseProfileExchange();
        }
        DistributionAdvisee rgn = this.newRegion.getParentAdvisee();
        DistributionAdvisor advisor = rgn.getDistributionAdvisor();
        return advisor.adviseGeneric();
    }

    protected CreateRegionMessage getCreateRegionMessage(Set recps, ReplyProcessor21 proc, boolean useMcast) {
        CreateRegionMessage msg = new CreateRegionMessage();
        msg.regionPath = this.newRegion.getFullPath();
        msg.profile = (CacheDistributionAdvisor.CacheProfile)this.newRegion.getProfile();
        msg.processorId = proc.getProcessorId();
        msg.concurrencyChecksEnabled = this.newRegion.getAttributes().getConcurrencyChecksEnabled();
        msg.setMulticast(useMcast);
        msg.setRecipients(recps);
        return msg;
    }

    @Override
    public void setOnline(InternalDistributedMember target) {
    }

    class CreateRegionReplyProcessor
    extends ReplyProcessor21 {
        private final Map<DistributedMember, Map<ThreadIdentifier, EventSequenceNumberHolder>> remoteEventStates;
        private boolean allMembersSkippedChecks;

        CreateRegionReplyProcessor(Set members) {
            super((InternalDistributedSystem)CreateRegionProcessor.this.newRegion.getCache().getDistributedSystem(), (Collection)members);
            this.remoteEventStates = new ConcurrentHashMap<DistributedMember, Map<ThreadIdentifier, EventSequenceNumberHolder>>();
            this.allMembersSkippedChecks = true;
        }

        public Map<ThreadIdentifier, EventSequenceNumberHolder> getEventState(InternalDistributedMember provider) {
            return this.remoteEventStates.get(provider);
        }

        public boolean needRetry() {
            return this.allMembersSkippedChecks;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process(DistributionMessage msg) {
            Assert.assertTrue(msg instanceof CreateRegionReplyMessage, "CreateRegionProcessor is unable to process message of type " + String.valueOf(msg.getClass()));
            CreateRegionReplyMessage reply = (CreateRegionReplyMessage)msg;
            LocalRegion lr = (LocalRegion)((Object)CreateRegionProcessor.this.newRegion);
            if (logger.isDebugEnabled()) {
                logger.debug("CreateRegionProcessor processing {}", (Object)msg);
            }
            try {
                DistributedRegion dr;
                if (reply.profile != null) {
                    FilterProfile localFP;
                    FilterProfile remoteFP;
                    if (CreateRegionProcessor.this.newRegion instanceof DistributedRegion && !(dr = (DistributedRegion)CreateRegionProcessor.this.newRegion).getDataPolicy().withPersistence() && reply.profile.isPersistent) {
                        dr.setGeneratedVersionTag(false);
                    }
                    if (CreateRegionMessage.isLocalAccessor(CreateRegionProcessor.this.newRegion) && reply.profile.isPersistent) {
                        lr.enableConcurrencyChecks();
                    }
                    CacheDistributionAdvisor cda = CreateRegionProcessor.this.newRegion.getCacheDistributionAdvisor();
                    cda.putProfile(reply.profile);
                    if (reply.bucketProfiles != null) {
                        RegionAdvisor ra = (RegionAdvisor)cda;
                        ra.putBucketRegionProfiles(reply.bucketProfiles);
                    }
                    if (reply.eventState != null) {
                        this.remoteEventStates.put(reply.getSender(), (Map)reply.eventState);
                    }
                    if (lr.isUsedForPartitionedRegionBucket()) {
                        ((BucketRegion)lr).updateEventSeqNum(reply.seqKeyForWan);
                    }
                    if ((remoteFP = reply.profile.filterProfile) != null && (localFP = ((LocalRegion)((Object)CreateRegionProcessor.this.newRegion)).filterProfile) != null) {
                        List messages = localFP.getQueuedFilterProfileMsgs(reply.getSender());
                        LocalRegion.InitializationLevel oldLevel = LocalRegion.setThreadInitLevelRequirement(LocalRegion.InitializationLevel.ANY_INIT);
                        try {
                            remoteFP.processQueuedFilterProfileMsgs(messages);
                        }
                        finally {
                            LocalRegion.setThreadInitLevelRequirement(oldLevel);
                            localFP.removeQueuedFilterProfileMsgs(reply.getSender());
                        }
                    }
                }
                if (reply.destroyedId != null && CreateRegionProcessor.this.newRegion instanceof DistributedRegion) {
                    dr = (DistributedRegion)CreateRegionProcessor.this.newRegion;
                    dr.getPersistenceAdvisor().removeMember(reply.destroyedId);
                }
                if (!reply.skippedCompatibilityChecks) {
                    this.allMembersSkippedChecks = false;
                }
            }
            finally {
                if (logger.isDebugEnabled()) {
                    logger.debug("CreateRegionProcessor invoking super.process()");
                }
                super.process(msg);
            }
        }

        @Override
        protected boolean logMultipleExceptions() {
            return false;
        }
    }

    public static class CreateRegionMessage
    extends HighPriorityDistributionMessage
    implements MessageWithReply {
        public boolean concurrencyChecksEnabled;
        protected String regionPath;
        protected CacheDistributionAdvisor.CacheProfile profile;
        protected int processorId;
        private transient boolean incompatible = false;
        private transient ReplyException replyException;
        private transient CacheDistributionAdvisor.CacheProfile replyProfile;
        private transient ArrayList replyBucketProfiles;
        private transient Object eventState;
        protected transient boolean severeAlertCompatible;
        private transient boolean skippedCompatibilityChecks;

        @Override
        public int getProcessorId() {
            return this.processorId;
        }

        @Override
        public boolean isSevereAlertCompatible() {
            return this.severeAlertCompatible;
        }

        @Override
        public boolean sendViaUDP() {
            return true;
        }

        /*
         * Exception decompiling
         */
        @Override
        protected void process(ClusterDistributionManager dm) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK]], but top level block is 5[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void handleCacheDistributionAdvisee(CacheDistributionAdvisee cda, boolean isRealRegion) {
            if (cda == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("<lclRgn is null> {}", (Object)this);
                }
                return;
            }
            String errorMsg = null;
            if (isRealRegion) {
                errorMsg = this.checkCompatibility(cda, this.profile);
            }
            if (errorMsg != null) {
                this.incompatible = true;
                if (logger.isDebugEnabled()) {
                    logger.debug("{} <replyProfile not set because errorMsg={}", (Object)this, (Object)errorMsg);
                }
                this.replyException = new ReplyException(new IllegalStateException(errorMsg));
            } else {
                if (isRealRegion && CreateRegionMessage.isLocalAccessor(cda) && this.profile.isPersistent) {
                    DistributedRegion dr;
                    if (cda instanceof DistributedRegion && !(dr = (DistributedRegion)cda).getDataPolicy().withPersistence()) {
                        dr.setGeneratedVersionTag(false);
                    }
                    assert (cda instanceof LocalRegion);
                    LocalRegion lr = (LocalRegion)((Object)cda);
                    lr.enableConcurrencyChecks();
                }
                cda.getDistributionAdvisor().putProfile(this.profile);
                if (isRealRegion) {
                    this.replyProfile = (CacheDistributionAdvisor.CacheProfile)cda.getProfile();
                    if (cda instanceof PartitionedRegion) {
                        PartitionedRegion pr = (PartitionedRegion)cda;
                        this.replyBucketProfiles = pr.getRegionAdvisor().getBucketRegionProfiles();
                    } else if (((LocalRegion)((Object)cda)).isUsedForPartitionedRegionBucket()) {
                        this.eventState = ((LocalRegion)((Object)cda)).getEventState();
                    }
                }
            }
        }

        protected String checkCompatibility(CacheDistributionAdvisee rgn, CacheDistributionAdvisor.CacheProfile profile) {
            CacheServiceProfile remoteProfile2;
            CacheServiceProfile localProfile;
            boolean thisIsRemoteAccessor;
            PartitionAttributes pa;
            Set<String> myGatewaySenderIds;
            Set<String> otherGatewaySenderIds;
            Scope otherScope = rgn.getAttributes().getScope();
            String result = null;
            InternalDistributedMember myId = rgn.getDistributionManager().getId();
            boolean otherCCEnabled = rgn.getAttributes().getConcurrencyChecksEnabled();
            boolean skipCheckForAccessor = this.skipCheckForAccessor(rgn, profile);
            boolean skipConcurrencyChecks = this.skipChecksForInternalRegion(rgn);
            boolean initializing = this.skipDuringInitialization(rgn);
            if (initializing) {
                this.skippedCompatibilityChecks = true;
            }
            if (!initializing && !skipCheckForAccessor && rgn.getAttributes().getDataPolicy().withPersistence() != profile.dataPolicy.withPersistence()) {
                if (!rgn.getAttributes().getDataPolicy().withPersistence()) {
                    result = String.format("Cannot create region %s DataPolicy withPersistence=true because another cache (%s) has the same region DataPolicy withPersistence=false. Persistent members must be started before non-persistent members", this.regionPath, myId);
                    skipConcurrencyChecks = true;
                } else {
                    skipConcurrencyChecks = true;
                }
            }
            if (!(initializing || skipCheckForAccessor || skipConcurrencyChecks || this.concurrencyChecksEnabled == otherCCEnabled)) {
                result = String.format("Cannot create region %s concurrency-checks-enabled=%s because another cache (%s) has the same region concurrency-checks-enabled=%s", this.regionPath, this.concurrencyChecksEnabled, myId, otherCCEnabled);
            }
            if (!(otherGatewaySenderIds = ((LocalRegion)((Object)rgn)).getGatewaySenderIds()).equals(myGatewaySenderIds = profile.gatewaySenderIds) && !rgn.getFullPath().contains("__DynamicRegions")) {
                result = String.format("Cannot create Region %s with %s gateway sender ids because another cache has the same region defined with %s gateway sender ids", this.regionPath, myGatewaySenderIds, otherGatewaySenderIds);
            }
            Set<String> otherAsynEventQueueIds = ((LocalRegion)((Object)rgn)).getVisibleAsyncEventQueueIds();
            Set<String> myAsyncEventQueueIds = profile.asyncEventQueueIds;
            if (!CreateRegionMessage.isLocalOrRemoteAccessor(rgn, profile) && !otherAsynEventQueueIds.equals(myAsyncEventQueueIds)) {
                result = String.format("Cannot create Region %s with %s async event ids because another cache has the same region defined with %s async event ids", this.regionPath, myAsyncEventQueueIds, otherAsynEventQueueIds);
            }
            if ((pa = rgn.getAttributes().getPartitionAttributes()) == null && profile.isPartitioned) {
                result = String.format("Cannot create PartitionedRegion %s because another cache (%s) has the same region defined as a non PartitionedRegion.", this.regionPath, myId);
            } else if (pa != null && !profile.isPartitioned) {
                result = String.format("Cannot create the non PartitionedRegion %s because another cache (%s) has a Partitioned Region defined with the same name.", this.regionPath, myId);
            } else if (profile.scope.isDistributed() && otherScope.isDistributed() && profile.scope != otherScope) {
                result = String.format("Cannot create region %s with %s scope because another cache (%s) has same region with %s scope.", this.regionPath, profile.scope, myId, otherScope);
            }
            boolean otherIsOffHeap = rgn.getAttributes().getOffHeap();
            boolean bl = thisIsRemoteAccessor = !rgn.getAttributes().getDataPolicy().withStorage() || pa != null && pa.getLocalMaxMemory() == 0;
            if (!CreateRegionMessage.isRemoteAccessor(profile) && !thisIsRemoteAccessor && profile.isOffHeap != otherIsOffHeap) {
                result = String.format("Cannot create region %s with off-heap=%s because another cache (%s) has the same region with off-heap=%s.", this.regionPath, profile.isOffHeap, myId, otherIsOffHeap);
            }
            String cspResult = null;
            Map<String, CacheServiceProfile> myProfiles = ((LocalRegion)((Object)rgn)).getCacheServiceProfiles();
            Iterator<CacheServiceProfile> iterator = profile.cacheServiceProfiles.iterator();
            while (iterator.hasNext() && (cspResult = (localProfile = myProfiles.get((remoteProfile2 = iterator.next()).getId())) == null ? this.getMissingProfileMessage(remoteProfile2, true) : remoteProfile2.checkCompatibility(rgn.getFullPath(), localProfile)) == null) {
            }
            if (cspResult == null && myProfiles.size() > profile.cacheServiceProfiles.size()) {
                for (CacheServiceProfile localProfile2 : myProfiles.values()) {
                    if (profile.cacheServiceProfiles.stream().anyMatch(remoteProfile -> remoteProfile.getId().equals(localProfile2.getId()))) continue;
                    cspResult = this.getMissingProfileMessage(localProfile2, false);
                    break;
                }
            }
            if (cspResult != null) {
                result = cspResult;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("CreateRegionProcessor.checkCompatibility: this={}; other={}; result={}", (Object)rgn, (Object)profile, (Object)result);
            }
            return result;
        }

        protected String getMissingProfileMessage(CacheServiceProfile profile, boolean existsInThisMember) {
            return profile.getMissingProfileMessage(existsInThisMember);
        }

        private boolean skipDuringInitialization(CacheDistributionAdvisee rgn) {
            LocalRegion lr;
            boolean skip = false;
            if (rgn instanceof LocalRegion && !(lr = (LocalRegion)((Object)rgn)).isInitialized()) {
                Set recipients = new CreateRegionProcessor(rgn).getRecipients();
                recipients.remove(this.getSender());
                if (!recipients.isEmpty()) {
                    skip = true;
                }
            }
            return skip;
        }

        private boolean skipChecksForInternalRegion(CacheDistributionAdvisee rgn) {
            boolean skip = false;
            if (rgn instanceof LocalRegion) {
                LocalRegion lr = (LocalRegion)((Object)rgn);
                skip = lr.isInternalRegion();
            }
            return skip;
        }

        private boolean skipCheckForAccessor(CacheDistributionAdvisee rgn, CacheDistributionAdvisor.CacheProfile profile) {
            boolean skip = false;
            if (rgn instanceof DistributedRegion) {
                DistributedRegion dr = (DistributedRegion)rgn;
                skip = !dr.getGenerateVersionTag();
            }
            return skip || CreateRegionMessage.isLocalOrRemoteAccessor(rgn, profile);
        }

        protected static boolean isLocalOrRemoteAccessor(CacheDistributionAdvisee region, CacheDistributionAdvisor.CacheProfile profile) {
            return CreateRegionMessage.isLocalAccessor(region) || CreateRegionMessage.isRemoteAccessor(profile);
        }

        protected static boolean isLocalAccessor(CacheDistributionAdvisee region) {
            if (!region.getAttributes().getDataPolicy().withStorage()) {
                return true;
            }
            return region.getAttributes().getPartitionAttributes() != null && region.getAttributes().getPartitionAttributes().getLocalMaxMemory() == 0;
        }

        protected static boolean isRemoteAccessor(CacheDistributionAdvisor.CacheProfile profile) {
            if (!profile.dataPolicy.withStorage()) {
                return true;
            }
            if (profile.isPartitioned) {
                RegionAdvisor.PartitionProfile prProfile = (RegionAdvisor.PartitionProfile)profile;
                return prProfile.localMaxMemory == 0;
            }
            return false;
        }

        @Override
        public void reset() {
            super.reset();
            this.regionPath = null;
            this.profile = null;
            this.processorId = -1;
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            super.fromData(in, context);
            this.regionPath = DataSerializer.readString(in);
            this.profile = (CacheDistributionAdvisor.CacheProfile)DataSerializer.readObject(in);
            this.processorId = in.readInt();
            this.concurrencyChecksEnabled = in.readBoolean();
        }

        public int getDSFID() {
            return -89;
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            super.toData(out, context);
            DataSerializer.writeString(this.regionPath, out);
            DataSerializer.writeObject(this.profile, out);
            out.writeInt(this.processorId);
            out.writeBoolean(this.concurrencyChecksEnabled);
        }

        @Override
        public String toString() {
            return "CreateRegionMessage (region='" + this.regionPath + "'; processorId=" + this.processorId + "; concurrencyChecksEnabled=" + this.concurrencyChecksEnabled + "; profile=" + String.valueOf(this.profile) + ")";
        }
    }

    public static class CreateRegionReplyMessage
    extends ReplyMessage {
        protected CacheDistributionAdvisor.CacheProfile profile;
        protected ArrayList bucketProfiles;
        protected Object eventState;
        protected PersistentMemberID destroyedId;
        protected boolean skippedCompatibilityChecks;
        long seqKeyForWan = -1L;

        @Override
        public int getDSFID() {
            return 74;
        }

        @Override
        public boolean sendViaUDP() {
            return true;
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            int size;
            super.fromData(in, context);
            if (in.readBoolean()) {
                this.profile = (CacheDistributionAdvisor.CacheProfile)DataSerializer.readObject(in);
            }
            if ((size = in.readInt()) == 0) {
                this.bucketProfiles = null;
            } else {
                this.bucketProfiles = new ArrayList(size);
                for (int i = 0; i < size; ++i) {
                    RegionAdvisor.BucketProfileAndId bp = new RegionAdvisor.BucketProfileAndId();
                    InternalDataSerializer.invokeFromData(bp, in);
                    this.bucketProfiles.add(bp);
                }
            }
            if (in.readBoolean()) {
                this.eventState = EventStateHelper.deDataSerialize(in, false);
            }
            if (in.readBoolean()) {
                this.destroyedId = new PersistentMemberID();
                InternalDataSerializer.invokeFromData(this.destroyedId, in);
            }
            this.skippedCompatibilityChecks = in.readBoolean();
            this.seqKeyForWan = in.readLong();
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            super.toData(out, context);
            out.writeBoolean(this.profile != null);
            if (this.profile != null) {
                DataSerializer.writeObject(this.profile, out);
            }
            if (this.bucketProfiles == null) {
                out.writeInt(0);
            } else {
                int size = this.bucketProfiles.size();
                out.writeInt(size);
                for (Object bucketProfile : this.bucketProfiles) {
                    RegionAdvisor.BucketProfileAndId bp = (RegionAdvisor.BucketProfileAndId)bucketProfile;
                    InternalDataSerializer.invokeToData(bp, out);
                }
            }
            if (this.eventState != null) {
                out.writeBoolean(true);
                EventStateHelper.dataSerialize(out, (Map)this.eventState, false, this.getSender());
            } else {
                out.writeBoolean(false);
            }
            if (this.destroyedId != null) {
                out.writeBoolean(true);
                InternalDataSerializer.invokeToData(this.destroyedId, out);
            } else {
                out.writeBoolean(false);
            }
            out.writeBoolean(this.skippedCompatibilityChecks);
            out.writeLong(this.seqKeyForWan);
        }

        @Override
        public String toString() {
            StringBuilder buff = new StringBuilder();
            buff.append("CreateRegionReplyMessage");
            buff.append("(sender=").append(this.getSender());
            buff.append("; processorId=");
            buff.append(this.processorId);
            buff.append("; profile=");
            buff.append(this.profile);
            if (this.bucketProfiles != null) {
                buff.append("; bucketProfiles=");
                buff.append(this.bucketProfiles);
            }
            if (this.eventState != null) {
                buff.append("; eventState=<not null>");
            }
            buff.append("; skippedCompatibilityChecks=");
            buff.append(this.skippedCompatibilityChecks);
            buff.append("; seqKeyForWan=");
            buff.append(this.seqKeyForWan);
            if (this.getException() != null) {
                buff.append("; with exception {").append(this.getException().getMessage()).append("}");
            }
            buff.append(")");
            return buff.toString();
        }
    }
}

