/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.versions.RegionVersionVector;
import org.apache.geode.internal.cache.versions.VersionTag;

public class BucketDump {
    private final RegionVersionVector rvv;
    private final Map<Object, Object> values;
    private final Map<Object, VersionTag> versions;
    private final int bucketId;
    private final InternalDistributedMember member;

    public BucketDump(int bucketId, InternalDistributedMember member, RegionVersionVector rvv, Map<Object, Object> values, Map<Object, VersionTag> versions) {
        this.bucketId = bucketId;
        this.member = member;
        this.rvv = rvv;
        this.values = values;
        this.versions = versions;
    }

    public RegionVersionVector getRvv() {
        return this.rvv;
    }

    public Map<Object, Object> getValues() {
        return this.values;
    }

    public Map<Object, VersionTag> getVersions() {
        return this.versions;
    }

    public Map<Object, ArrayList<Object>> getValuesWithVersions() {
        HashMap<Object, ArrayList<Object>> result = new HashMap<Object, ArrayList<Object>>();
        if (this.values == null) {
            return result;
        }
        for (Map.Entry<Object, Object> e : this.values.entrySet()) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(e.getValue());
            list.add(this.versions.get(e.getKey()));
            result.put(e.getKey(), list);
        }
        return result;
    }

    public int getBucketId() {
        return this.bucketId;
    }

    public InternalDistributedMember getMember() {
        return this.member;
    }

    public String toString() {
        return "Bucket id = " + this.bucketId + " from member = " + String.valueOf(this.member) + ": " + super.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.values == null ? 0 : this.values.hashCode());
        result = 31 * result + (this.versions == null ? 0 : this.versions.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BucketDump other = (BucketDump)obj;
        if (this.values == null ? other.values != null : !this.values.equals(other.values)) {
            return false;
        }
        if (this.versions == null) {
            return other.versions == null;
        }
        return this.versions.equals(other.versions);
    }
}

