/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializable;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.admin.EntrySnapshot;
import org.apache.geode.internal.admin.remote.RemoteCacheStatistics;
import org.apache.geode.internal.admin.remote.RemoteObjectName;

public class RemoteEntrySnapshot
implements EntrySnapshot,
DataSerializable {
    private static final long serialVersionUID = 1360498801579593535L;
    private Object name;
    private Object value;
    private Object userAttribute;
    private RemoteCacheStatistics stats;

    public RemoteEntrySnapshot(Region.Entry entry, boolean statsEnabled) throws CacheException {
        Object entryName = entry.getKey();
        this.name = entryName instanceof String || entryName instanceof Number ? entryName : new RemoteObjectName(entryName);
        Object val = entry.getValue();
        this.value = val != null ? val.getClass().getName() + "\"" + String.valueOf(val) + "\"" : null;
        Object attr = entry.getUserAttribute();
        this.userAttribute = attr != null ? attr.getClass().getName() + "\"" + String.valueOf(attr) + "\"" : null;
        this.stats = statsEnabled ? new RemoteCacheStatistics(entry.getStatistics()) : new RemoteCacheStatistics();
    }

    public RemoteEntrySnapshot() {
    }

    @Override
    public Object getName() {
        return this.name;
    }

    @Override
    public long getLastModifiedTime() {
        return this.stats.getLastModifiedTime();
    }

    @Override
    public long getLastAccessTime() {
        return this.stats.getLastAccessedTime();
    }

    @Override
    public long getNumberOfHits() {
        return this.stats.getHitCount();
    }

    @Override
    public long getNumberOfMisses() {
        return this.stats.getMissCount();
    }

    @Override
    public float getHitRatio() {
        return this.stats.getHitRatio();
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public Object getUserAttribute() {
        return this.userAttribute;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof RemoteEntrySnapshot) {
            RemoteEntrySnapshot snap = (RemoteEntrySnapshot)other;
            return this.name.equals(snap.name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.getName().toString();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeObject(this.name, out);
        DataSerializer.writeObject(this.value, out);
        DataSerializer.writeObject(this.stats, out);
        DataSerializer.writeObject(this.userAttribute, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.name = DataSerializer.readObject(in);
        this.value = DataSerializer.readObject(in);
        this.stats = (RemoteCacheStatistics)DataSerializer.readObject(in);
        this.userAttribute = DataSerializer.readObject(in);
    }
}

