/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.admin.RegionSubRegionSnapshot;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.Region;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.admin.remote.AdminResponse;
import org.apache.geode.internal.admin.remote.Cancellable;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class RegionSubRegionsSizeResponse
extends AdminResponse
implements Cancellable {
    private static final Logger logger = LogService.getLogger();
    private RegionSubRegionSnapshot snapshot;
    private boolean cancelled;

    public RegionSubRegionSnapshot getSnapshot() {
        return this.snapshot;
    }

    public static RegionSubRegionsSizeResponse create(DistributionManager dm, InternalDistributedMember recipient) {
        RegionSubRegionsSizeResponse m = new RegionSubRegionsSizeResponse();
        m.setRecipient(recipient);
        m.snapshot = null;
        m.cancelled = false;
        return m;
    }

    void populateSnapshot(DistributionManager dm) {
        if (this.cancelled) {
            return;
        }
        InternalDistributedSystem sys = dm.getSystem();
        InternalCache cache = (InternalCache)CacheFactory.getInstance(sys);
        if (this.cancelled) {
            return;
        }
        RegionSubRegionSnapshot root = new RegionSubRegionSnapshot();
        root.setName("Root");
        root.setParent(null);
        root.setEntryCount(0);
        Set<Region<?, ?>> rootRegions = cache.rootRegions();
        this.snapshot = root;
        this.populateRegionSubRegions(root, rootRegions, cache);
    }

    private void populateRegionSubRegions(RegionSubRegionSnapshot parentSnapShot, Set regions, InternalCache cache) {
        if (this.cancelled) {
            return;
        }
        for (Object region : regions) {
            Region subRegion = (Region)region;
            try {
                RegionSubRegionSnapshot subRegionSnapShot = new RegionSubRegionSnapshot(subRegion);
                parentSnapShot.addSubRegion(subRegionSnapShot);
                Set<Region<?, ?>> subRegions = subRegion.subregions(false);
                this.populateRegionSubRegions(subRegionSnapShot, subRegions, cache);
            }
            catch (Exception e) {
                logger.debug("Failed to create snapshot for region: {}. Continuing with next region.", (Object)subRegion.getFullPath(), (Object)e);
            }
        }
    }

    @Override
    public synchronized void cancel() {
        this.cancelled = true;
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        out.writeBoolean(this.cancelled);
        DataSerializer.writeObject(this.snapshot, out);
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.cancelled = in.readBoolean();
        this.snapshot = (RegionSubRegionSnapshot)DataSerializer.readObject(in);
    }

    public int getDSFID() {
        return 1070;
    }

    @Override
    public String toString() {
        return "RegionSubRegionsSizeResponse [from=" + String.valueOf(this.getRecipient()) + " " + (this.snapshot == null ? "null" : this.snapshot.toString());
    }
}

