/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.distributed.internal.InternalLocator;
import org.apache.geode.distributed.internal.tcpserver.HostAndPort;
import org.apache.geode.internal.inet.LocalHostUtil;
import org.apache.geode.internal.net.SSLConfig;
import org.apache.geode.internal.net.SocketCreator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DistributionLocatorId
implements Serializable {
    private static final long serialVersionUID = 6587390186971937865L;
    private final InetAddress host;
    private final int port;
    @NotNull
    private final String bindAddress;
    @NotNull
    private transient SSLConfig sslConfig;
    @Deprecated
    private final boolean peerLocator = true;
    @Deprecated
    private final boolean serverLocator = true;
    private final String hostnameForClients;
    private String hostname;
    @NotNull
    private String memberName;
    private final long timestamp;

    public DistributionLocatorId(@NotNull InetAddress host, int port, @Nullable String bindAddress, @Nullable SSLConfig sslConfig) {
        this(host, null, port, bindAddress, sslConfig, null, null);
    }

    public DistributionLocatorId(int port, @Nullable String bindAddress, @Nullable String hostnameForClients, @Nullable String memberName) {
        this(DistributionLocatorId.getLocalHostOrThrow(), null, port, bindAddress, null, hostnameForClients, memberName);
    }

    public DistributionLocatorId(@NotNull InetAddress address, @NotNull InternalLocator locator) {
        this(address, null, locator.getPort(), locator.getBindAddressString() != null ? locator.getBindAddressString() : (locator.getBindAddress() != null ? locator.getBindAddress().getHostAddress() : null), null, locator.getHostnameForClients(), null);
    }

    private DistributionLocatorId(@Nullable InetAddress host, @Nullable String hostname, int port, @Nullable String bindAddress, @Nullable SSLConfig sslConfig, @Nullable String hostnameForClients, @Nullable String memberName) {
        this.host = host;
        this.hostname = hostname;
        this.port = port;
        this.bindAddress = DistributionLocatorId.bindAddressOrDefault(bindAddress);
        this.sslConfig = DistributionLocatorId.sslConfigOrDefault(sslConfig);
        this.hostnameForClients = hostnameForClients;
        this.memberName = DistributionLocatorId.memberNameOrDefault(memberName);
        this.timestamp = System.currentTimeMillis();
    }

    @NotNull
    public static DistributionLocatorId unmarshal(@NotNull String marshalled) {
        return DistributionLocatorId.unmarshal(marshalled, null);
    }

    @NotNull
    public static DistributionLocatorId unmarshal(@NotNull String marshalled, @Nullable String memberName) {
        int port;
        String hostname;
        int portStartIndex = marshalled.indexOf(91);
        int portEndIndex = marshalled.indexOf(93);
        if (portStartIndex < 0 || portEndIndex < portStartIndex) {
            throw new IllegalArgumentException(String.format("%s is not in the form hostname[port].", marshalled));
        }
        int bindAddressIndex = marshalled.lastIndexOf(64);
        if (bindAddressIndex < 0) {
            bindAddressIndex = marshalled.lastIndexOf(58);
        }
        if ((hostname = marshalled.substring(0, bindAddressIndex > -1 ? bindAddressIndex : portStartIndex)).indexOf(58) >= 0) {
            bindAddressIndex = marshalled.lastIndexOf(64);
            hostname = marshalled.substring(0, bindAddressIndex > -1 ? bindAddressIndex : portStartIndex);
        }
        InetAddress host = DistributionLocatorId.getInetAddressOrNull(hostname);
        try {
            port = Integer.parseInt(marshalled.substring(portStartIndex + 1, portEndIndex));
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException(String.format("%s does not contain a valid port number", marshalled));
        }
        String bindAddress = DistributionLocatorId.substringAfterFoundOrNull(marshalled, bindAddressIndex, portStartIndex);
        String hostnameForClients = DistributionLocatorId.parseHostnameForClients(marshalled);
        return new DistributionLocatorId(host, hostname, port, bindAddress, null, hostnameForClients, memberName);
    }

    @Nullable
    private static String parseHostnameForClients(@NotNull String marshalled) {
        int optionsIndex = marshalled.indexOf(44);
        if (optionsIndex > 0) {
            String[] options;
            block9: for (String option : options = marshalled.substring(optionsIndex).split(",")) {
                String fieldName;
                String[] optionFields = option.split("=");
                if (optionFields.length != 2) continue;
                switch (fieldName = optionFields[0].toLowerCase()) {
                    case "hostname-for-clients": {
                        return optionFields[1];
                    }
                    case "peer": 
                    case "server": {
                        continue block9;
                    }
                    default: {
                        throw new IllegalArgumentException(marshalled + " invalid option " + fieldName + ". valid options are \"peer\", \"server\" and \"hostname-for-clients\"");
                    }
                }
            }
        }
        return null;
    }

    @NotNull
    public String marshal() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.host.getHostAddress());
        if (!this.bindAddress.isEmpty()) {
            if (this.bindAddress.contains(":")) {
                sb.append('@');
            } else {
                sb.append(':');
            }
            sb.append(this.bindAddress);
        }
        sb.append('[').append(this.port).append(']');
        return sb.toString();
    }

    @NotNull
    public String marshalForClients() {
        StringBuilder sb = new StringBuilder();
        if (!StringUtils.isEmpty((CharSequence)this.hostnameForClients)) {
            sb.append(this.hostnameForClients);
        } else if (!StringUtils.isEmpty((CharSequence)this.bindAddress)) {
            sb.append(this.bindAddress);
        } else if (null != this.host) {
            if (this.isMcastId()) {
                sb.append(this.host.getHostAddress());
            } else {
                sb.append(SocketCreator.getHostName(this.host));
            }
        } else {
            sb.append(this.hostname);
        }
        sb.append("[").append(this.port).append("]");
        return sb.toString();
    }

    @NotNull
    public SSLConfig getSSLConfig() {
        return this.sslConfig;
    }

    public int getPort() {
        return this.port;
    }

    @NotNull
    public HostAndPort getHost() throws UnknownHostException {
        if (this.host == null && this.hostname == null) {
            throw new UnknownHostException("locator ID has no hostname or resolved inet address");
        }
        return new HostAndPort(null == this.host ? this.hostname : this.host.getHostName(), this.port);
    }

    @NotNull
    public String getHostName() {
        if (this.hostname == null) {
            this.hostname = this.host.getHostName();
        }
        return this.hostname;
    }

    public boolean isMcastId() {
        return this.host.isMulticastAddress();
    }

    @NotNull
    public String getBindAddress() {
        return this.bindAddress;
    }

    @NotNull
    public String getHostnameForClients() {
        return this.hostnameForClients;
    }

    @NotNull
    public String getMemberName() {
        return this.memberName;
    }

    public long getTimeStamp() {
        return this.timestamp;
    }

    public String toString() {
        return "DistributionLocatorId{host=" + String.valueOf(this.host) + ", port=" + this.port + ", bindAddress='" + this.bindAddress + "', hostnameForClients='" + this.hostnameForClients + "', hostname='" + this.hostname + "', memberName='" + this.memberName + "', timestamp=" + this.timestamp + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DistributionLocatorId)) {
            return false;
        }
        DistributionLocatorId that = (DistributionLocatorId)o;
        return this.port == that.port && Objects.equals(this.host, that.host) && this.bindAddress.equals(that.bindAddress);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port, this.bindAddress);
    }

    public boolean detailCompare(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof DistributionLocatorId)) {
            return false;
        }
        DistributionLocatorId that = (DistributionLocatorId)other;
        if (!StringUtils.equals((CharSequence)this.hostnameForClients, (CharSequence)that.hostnameForClients)) {
            return false;
        }
        if (!Objects.equals(this.host, that.host)) {
            return false;
        }
        if (this.port != that.port) {
            return false;
        }
        return StringUtils.equals((CharSequence)this.bindAddress, (CharSequence)that.bindAddress);
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.sslConfig = DistributionLocatorId.sslConfigOrDefault(null);
        this.memberName = DistributionLocatorId.memberNameOrDefault(this.memberName);
    }

    @NotNull
    private static String bindAddressOrDefault(@Nullable String bindAddress) {
        return (String)ObjectUtils.defaultIfNull((Object)bindAddress, (Object)"");
    }

    @NotNull
    private static SSLConfig sslConfigOrDefault(@Nullable SSLConfig sslConfig) {
        return (SSLConfig)ObjectUtils.getIfNull((Object)sslConfig, () -> SSLConfig.builder().build());
    }

    @NotNull
    private static String memberNameOrDefault(@Nullable String memberName) {
        return (String)ObjectUtils.defaultIfNull((Object)memberName, (Object)"");
    }

    @NotNull
    private static InetAddress getLocalHostOrThrow() {
        try {
            return LocalHostUtil.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw new InternalGemFireException("Failed getting local host", e);
        }
    }

    @Nullable
    private static InetAddress getInetAddressOrNull(@NotNull String hostname) {
        try {
            return InetAddress.getByName(hostname);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    @Nullable
    private static String substringAfterFoundOrNull(@NotNull String value, int found, int end) {
        return found < 0 ? null : value.substring(found + 1, end);
    }
}

