/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.admin.remote.AdminResponse;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;

public class AdminFailureResponse
extends AdminResponse {
    private Exception cause;

    public static AdminFailureResponse create(InternalDistributedMember recipient, Exception cause) {
        AdminFailureResponse message = new AdminFailureResponse();
        message.setRecipient(recipient);
        message.cause = cause;
        return message;
    }

    public Exception getCause() {
        return this.cause;
    }

    public int getDSFID() {
        return 1006;
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        DataSerializer.writeObject(this.cause, out);
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.cause = (Exception)DataSerializer.readObject(in);
    }

    @Override
    public String toString() {
        return "AdminFailureResponse from " + String.valueOf(this.getRecipient()) + " cause=" + String.valueOf(this.cause);
    }
}

