/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin;

import java.util.ArrayList;
import java.util.List;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.internal.admin.ApplicationVM;
import org.apache.geode.internal.admin.CacheSnapshot;
import org.apache.geode.internal.admin.CompoundEntrySnapshot;
import org.apache.geode.internal.admin.CompoundRegionSnapshot;
import org.apache.geode.internal.admin.EntrySnapshot;
import org.apache.geode.internal.admin.GemFireVM;
import org.apache.geode.internal.admin.GfManagerAgent;
import org.apache.geode.internal.admin.RegionSnapshot;
import org.apache.geode.internal.admin.SnapshotClient;

public class CacheCollector {
    private List notHeardFrom;
    private List heardFrom;
    private final GfManagerAgent systemAgent;
    private final SnapshotClient view;
    @MakeNotStatic
    private static int snapshotCount;
    private CacheSnapshot snaps;

    public CacheCollector(GfManagerAgent agent, SnapshotClient view) {
        this.view = view;
        this.systemAgent = agent;
        this.systemAgent.setCacheCollector(this);
    }

    public synchronized void takeSnapshot(String regionName) {
        ApplicationVM[] apps;
        this.flush();
        for (ApplicationVM app : apps = this.systemAgent.listApplications()) {
            this.notHeardFrom.add(app);
            app.takeRegionSnapshot(regionName, snapshotCount);
        }
    }

    public synchronized void flush() {
        ++snapshotCount;
        this.clear();
    }

    public void close() {
        this.flush();
        this.systemAgent.setCacheCollector(null);
    }

    private synchronized void clear() {
        this.snaps = null;
        this.notHeardFrom = new ArrayList();
        this.heardFrom = new ArrayList();
    }

    private CacheSnapshot updateResultSet(CacheSnapshot update, GemFireVM poster) {
        this.noteResponse(poster);
        if (update instanceof EntrySnapshot) {
            if (this.snaps instanceof CompoundRegionSnapshot) {
                throw new IllegalStateException("Unable to mix region and entry snapshots in CacheCollector.");
            }
            if (this.snaps == null) {
                this.snaps = new CompoundEntrySnapshot(update.getName());
            }
            ((CompoundEntrySnapshot)this.snaps).addCache(poster, (EntrySnapshot)update);
        } else if (update instanceof RegionSnapshot) {
            if (this.snaps instanceof CompoundEntrySnapshot) {
                throw new IllegalStateException("Unable to mix region and entry snapshots in CacheCollector.");
            }
            if (this.snaps == null) {
                this.snaps = new CompoundRegionSnapshot(update.getName().toString());
            }
            ((CompoundRegionSnapshot)this.snaps).addCache(poster, (RegionSnapshot)update);
        }
        return this.snaps;
    }

    private void noteResponse(GemFireVM responder) {
        if (this.notHeardFrom.remove(responder)) {
            this.heardFrom.add(responder);
        }
    }

    public synchronized void resultsReturned(CacheSnapshot snap, GemFireVM member, int snapshotId) {
        if (snapshotId == snapshotCount) {
            if (snap == null) {
                this.noteResponse(member);
            } else {
                this.view.updateSnapshot(this.updateResultSet(snap, member), new ArrayList(this.heardFrom));
            }
        }
    }
}

