/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UTFDataFormatException;
import java.lang.invoke.StringConcatFactory;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.SocketException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.CancelException;
import org.apache.geode.CanonicalInstantiator;
import org.apache.geode.DataSerializable;
import org.apache.geode.DataSerializer;
import org.apache.geode.GemFireIOException;
import org.apache.geode.GemFireRethrowable;
import org.apache.geode.Instantiator;
import org.apache.geode.SerializationException;
import org.apache.geode.SystemFailure;
import org.apache.geode.ToDataException;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.annotations.internal.MutableForTesting;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DMStats;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.LonerDistributionManager;
import org.apache.geode.distributed.internal.SerialDistributionMessage;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.DSFIDFactory;
import org.apache.geode.internal.HeapDataOutputStream;
import org.apache.geode.internal.InternalInstantiator;
import org.apache.geode.internal.PdxSerializerObject;
import org.apache.geode.internal.Sendable;
import org.apache.geode.internal.VersionedObjectInput;
import org.apache.geode.internal.VersionedObjectOutput;
import org.apache.geode.internal.cache.EnumListenerEvent;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.PoolManagerImpl;
import org.apache.geode.internal.cache.tier.sockets.CacheClientNotifier;
import org.apache.geode.internal.cache.tier.sockets.CacheServerHelper;
import org.apache.geode.internal.cache.tier.sockets.ClientDataSerializerMessage;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.OldClientSupportService;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.classloader.ClassPathLoader;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.serialization.BasicSerializable;
import org.apache.geode.internal.serialization.DSCODE;
import org.apache.geode.internal.serialization.DSFIDSerializer;
import org.apache.geode.internal.serialization.DSFIDSerializerFactory;
import org.apache.geode.internal.serialization.DataSerializableFixedID;
import org.apache.geode.internal.serialization.DataSerializableFixedIdRegistrant;
import org.apache.geode.internal.serialization.DataSerializableFixedIdRegistrar;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.DscodeHelper;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.ObjectDeserializer;
import org.apache.geode.internal.serialization.ObjectSerializer;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.internal.serialization.SerializationVersions;
import org.apache.geode.internal.serialization.StaticSerialization;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.internal.serialization.VersionedDataStream;
import org.apache.geode.internal.serialization.filter.NullStreamSerialFilter;
import org.apache.geode.internal.serialization.filter.ReflectiveFacadeStreamSerialFilterFactory;
import org.apache.geode.internal.serialization.filter.SanctionedSerializables;
import org.apache.geode.internal.serialization.filter.SanctionedSerializablesService;
import org.apache.geode.internal.serialization.filter.SerializableObjectConfig;
import org.apache.geode.internal.serialization.filter.StreamSerialFilter;
import org.apache.geode.internal.serialization.filter.UnableToSetSerialFilterException;
import org.apache.geode.internal.util.concurrent.CopyOnWriteHashMap;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.pdx.NonPortableClassException;
import org.apache.geode.pdx.PdxInstance;
import org.apache.geode.pdx.PdxSerializable;
import org.apache.geode.pdx.PdxSerializer;
import org.apache.geode.pdx.internal.AutoSerializableManager;
import org.apache.geode.pdx.internal.EnumInfo;
import org.apache.geode.pdx.internal.PdxInputStream;
import org.apache.geode.pdx.internal.PdxInstanceEnum;
import org.apache.geode.pdx.internal.PdxInstanceImpl;
import org.apache.geode.pdx.internal.PdxOutputStream;
import org.apache.geode.pdx.internal.PdxReaderImpl;
import org.apache.geode.pdx.internal.PdxType;
import org.apache.geode.pdx.internal.PdxWriterImpl;
import org.apache.geode.pdx.internal.TypeRegistry;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.TestOnly;

public abstract class InternalDataSerializer
extends DataSerializer {
    public static final boolean LOAD_CLASS_EACH_TIME = Boolean.getBoolean("gemfire.loadClassOnEveryDeserialization");
    private static final Logger logger = LogService.getLogger();
    @MakeNotStatic
    private static final Map<String, DataSerializer> classesToSerializers = new ConcurrentHashMap<String, DataSerializer>();
    private static final String SANCTIONED_SERIALIZABLES_DEPENDENCIES_PATTERN = "java.**;javax.management.**;javax.print.attribute.EnumSyntax;antlr.**;org.apache.commons.modeler.AttributeInfo;org.apache.commons.modeler.FeatureInfo;org.apache.commons.modeler.ManagedBean;org.apache.geode.distributed.internal.DistributionConfigSnapshot;org.apache.geode.distributed.internal.RuntimeDistributionConfigImpl;org.apache.geode.distributed.internal.DistributionConfigImpl;org.apache.geode.distributed.internal.membership.InternalDistributedMember;org.apache.geode.internal.cache.persistence.PersistentMemberID;org.apache.geode.internal.cache.persistence.DiskStoreID;org.apache.geode.internal.cache.tier.sockets.VersionedObjectList;org.apache.shiro.**;org.apache.logging.log4j.Level;org.apache.logging.log4j.spi.StandardLevel;com.sun.proxy.$Proxy*;com.healthmarketscience.rmiio.RemoteInputStream;javax.rmi.ssl.SslRMIClientSocketFactory;javax.net.ssl.SSLHandshakeException;javax.net.ssl.SSLException;sun.security.validator.ValidatorException;sun.security.provider.certpath.SunCertPathBuilderException;org.apache.geode.modules.util.SessionCustomExpiry;";
    private static final String serializationVersionTxt = System.getProperty("gemfire.serializationVersion");
    @Immutable
    private static final SERIALIZATION_VERSION latestVersion = SERIALIZATION_VERSION.v662;
    @Immutable
    private static final SERIALIZATION_VERSION serializationVersion = InternalDataSerializer.calculateSerializationVersion();
    @MakeNotStatic
    private static final ConcurrentMap<Integer, Object> idsToSerializers = new ConcurrentHashMap<Integer, Object>();
    @MakeNotStatic
    private static final ConcurrentHashMap<String, SerializerAttributesHolder> dsClassesToHolders = new ConcurrentHashMap();
    @MakeNotStatic
    private static final ConcurrentHashMap<Integer, SerializerAttributesHolder> idsToHolders = new ConcurrentHashMap();
    @MakeNotStatic
    private static final ConcurrentHashMap<String, SerializerAttributesHolder> supportedClassesToHolders = new ConcurrentHashMap();
    private static final Object listenersSync = new Object();
    private static final ThreadLocal<Boolean> pdxSerializationInProgress = new ThreadLocal();
    @MakeNotStatic
    private static final CopyOnWriteHashMap<String, WeakReference<Class<?>>> classCache = LOAD_CLASS_EACH_TIME ? null : new CopyOnWriteHashMap();
    private static final Object cacheAccessLock = new Object();
    private static final String POST_GEODE_190_SERVER_CQIMPL = "org.apache.geode.cache.query.cq.internal.ServerCQImpl";
    private static final String PRE_GEODE_190_SERVER_CQIMPL = "org.apache.geode.cache.query.internal.cq.ServerCQImpl";
    @Immutable
    private static final StreamSerialFilter defaultSerializationFilter;
    @MakeNotStatic
    private static StreamSerialFilter serializationFilter;
    @MakeNotStatic
    private static OldClientSupportService oldClientSupportService;
    @MakeNotStatic
    private static final DSFIDSerializer dsfidSerializer;
    @MakeNotStatic
    private static final DSFIDFactory dsfidFactory;
    @MakeNotStatic
    private static volatile Set<RegistrationListener> listeners;

    public static String processIncomingClassName(String nameArg) {
        String name = StaticSerialization.processIncomingClassName((String)nameArg);
        if (name != nameArg) {
            return name;
        }
        if (name.equals(PRE_GEODE_190_SERVER_CQIMPL)) {
            return POST_GEODE_190_SERVER_CQIMPL;
        }
        OldClientSupportService svc = InternalDataSerializer.getOldClientSupportService();
        if (svc != null) {
            return svc.processIncomingClassName(name);
        }
        return name;
    }

    public static String processOutgoingClassName(String nameArg, DataOutput out) {
        VersionedDataStream vout;
        KnownVersion version;
        String name = StaticSerialization.processOutgoingClassName((String)nameArg);
        if (name != nameArg) {
            return name;
        }
        if (out instanceof VersionedDataStream && null != (version = (vout = (VersionedDataStream)out).getVersion()) && version.isOlderThan((Version)KnownVersion.GEODE_1_9_0) && name.equals(POST_GEODE_190_SERVER_CQIMPL)) {
            return PRE_GEODE_190_SERVER_CQIMPL;
        }
        OldClientSupportService svc = InternalDataSerializer.getOldClientSupportService();
        if (svc != null) {
            return svc.processOutgoingClassName(name, out);
        }
        return name;
    }

    public static void initializeSerializationFilter(SerializableObjectConfig config) {
        InternalDataSerializer.initializeSerializationFilter(config, SanctionedSerializables.loadSanctionedSerializablesServices());
    }

    @VisibleForTesting
    public static void initializeSerializationFilter(SerializableObjectConfig config, Collection<SanctionedSerializablesService> services) {
        logger.info("initializing InternalDataSerializer with {} services", (Object)services.size());
        ReflectiveFacadeStreamSerialFilterFactory objectInputFilterFactory = new ReflectiveFacadeStreamSerialFilterFactory();
        serializationFilter = objectInputFilterFactory.create(config, SanctionedSerializables.loadSanctionedClassNames(services));
    }

    @TestOnly
    static void clearSerializationFilter() {
        serializationFilter = defaultSerializationFilter;
    }

    private static SERIALIZATION_VERSION calculateSerializationVersion() {
        if (serializationVersionTxt == null || serializationVersionTxt.isEmpty()) {
            return latestVersion;
        }
        if (serializationVersionTxt.startsWith("6.6.0") || serializationVersionTxt.startsWith("6.6.1")) {
            return SERIALIZATION_VERSION.v660;
        }
        if (serializationVersionTxt.startsWith("6.6.2")) {
            return SERIALIZATION_VERSION.v662;
        }
        return SERIALIZATION_VERSION.vINVALID;
    }

    public static boolean is662SerializationEnabled() {
        return serializationVersion.ordinal() >= SERIALIZATION_VERSION.v662.ordinal();
    }

    public static void checkSerializationVersion() {
        if (serializationVersion == SERIALIZATION_VERSION.vINVALID) {
            throw new IllegalArgumentException("The system property \"gemfire.serializationVersion\" was set to \"" + serializationVersionTxt + "\" which is not a valid serialization version. Valid versions must start with \"6.6.0\", \"6.6.1\", or \"6.6.2\"");
        }
    }

    private static void initializeWellKnownSerializers() {
        classesToSerializers.put("java.lang.String", new WellKnownPdxDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                try {
                    3.writeString((String)o, out);
                }
                catch (UTFDataFormatException ex) {
                    String s = "While writing a String of length " + ((String)o).length();
                    UTFDataFormatException ex2 = new UTFDataFormatException(s);
                    ex2.initCause(ex);
                    throw ex2;
                }
                return true;
            }
        });
        classesToSerializers.put("java.net.InetAddress", new WellKnownDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                InetAddress address = (InetAddress)o;
                out.writeByte(DSCODE.INET_ADDRESS.toByte());
                4.writeInetAddress(address, out);
                return true;
            }
        });
        classesToSerializers.put("java.net.Inet4Address", new WellKnownDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                InetAddress address = (InetAddress)o;
                out.writeByte(DSCODE.INET_ADDRESS.toByte());
                5.writeInetAddress(address, out);
                return true;
            }
        });
        classesToSerializers.put("java.net.Inet6Address", new WellKnownDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                InetAddress address = (InetAddress)o;
                out.writeByte(DSCODE.INET_ADDRESS.toByte());
                6.writeInetAddress(address, out);
                return true;
            }
        });
        classesToSerializers.put("java.lang.Class", new WellKnownDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                Class c = (Class)o;
                if (c.isPrimitive()) {
                    StaticSerialization.writePrimitiveClass((Class)c, (DataOutput)out);
                } else {
                    out.writeByte(DSCODE.CLASS.toByte());
                    7.writeClass(c, out);
                }
                return true;
            }
        });
        classesToSerializers.put("java.lang.Boolean", new WellKnownPdxDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                Boolean value = (Boolean)o;
                out.writeByte(DSCODE.BOOLEAN.toByte());
                8.writeBoolean(value, out);
                return true;
            }
        });
        classesToSerializers.put("java.lang.Character", new WellKnownPdxDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                Character value = (Character)o;
                out.writeByte(DSCODE.CHARACTER.toByte());
                9.writeCharacter(value, out);
                return true;
            }
        });
        classesToSerializers.put("java.lang.Byte", new WellKnownPdxDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                Byte value = (Byte)o;
                out.writeByte(DSCODE.BYTE.toByte());
                10.writeByte(value, out);
                return true;
            }
        });
        classesToSerializers.put("java.lang.Short", new WellKnownPdxDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                Short value = (Short)o;
                out.writeByte(DSCODE.SHORT.toByte());
                11.writeShort(value, out);
                return true;
            }
        });
        classesToSerializers.put("java.lang.Integer", new WellKnownPdxDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                Integer value = (Integer)o;
                out.writeByte(DSCODE.INTEGER.toByte());
                12.writeInteger(value, out);
                return true;
            }
        });
        classesToSerializers.put("java.lang.Long", new WellKnownPdxDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                Long value = (Long)o;
                out.writeByte(DSCODE.LONG.toByte());
                13.writeLong(value, out);
                return true;
            }
        });
        classesToSerializers.put("java.lang.Float", new WellKnownPdxDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                Float value = (Float)o;
                out.writeByte(DSCODE.FLOAT.toByte());
                14.writeFloat(value, out);
                return true;
            }
        });
        classesToSerializers.put("java.lang.Double", new WellKnownPdxDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                Double value = (Double)o;
                out.writeByte(DSCODE.DOUBLE.toByte());
                15.writeDouble(value, out);
                return true;
            }
        });
        classesToSerializers.put("[Z", new WellKnownPdxDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                out.writeByte(DSCODE.BOOLEAN_ARRAY.toByte());
                16.writeBooleanArray((boolean[])o, out);
                return true;
            }
        });
        classesToSerializers.put("[B", new WellKnownPdxDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                byte[] array = (byte[])o;
                out.writeByte(DSCODE.BYTE_ARRAY.toByte());
                17.writeByteArray(array, out);
                return true;
            }
        });
        classesToSerializers.put("[C", new WellKnownPdxDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                out.writeByte(DSCODE.CHAR_ARRAY.toByte());
                18.writeCharArray((char[])o, out);
                return true;
            }
        });
        classesToSerializers.put("[D", new WellKnownPdxDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                double[] array = (double[])o;
                out.writeByte(DSCODE.DOUBLE_ARRAY.toByte());
                19.writeDoubleArray(array, out);
                return true;
            }
        });
        classesToSerializers.put("[F", new WellKnownPdxDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                float[] array = (float[])o;
                out.writeByte(DSCODE.FLOAT_ARRAY.toByte());
                20.writeFloatArray(array, out);
                return true;
            }
        });
        classesToSerializers.put("[I", new WellKnownPdxDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                int[] array = (int[])o;
                out.writeByte(DSCODE.INT_ARRAY.toByte());
                21.writeIntArray(array, out);
                return true;
            }
        });
        classesToSerializers.put("[J", new WellKnownPdxDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                long[] array = (long[])o;
                out.writeByte(DSCODE.LONG_ARRAY.toByte());
                22.writeLongArray(array, out);
                return true;
            }
        });
        classesToSerializers.put("[S", new WellKnownPdxDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                short[] array = (short[])o;
                out.writeByte(DSCODE.SHORT_ARRAY.toByte());
                23.writeShortArray(array, out);
                return true;
            }
        });
        classesToSerializers.put("[Ljava.lang.String;", new WellKnownPdxDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                String[] array = (String[])o;
                out.writeByte(DSCODE.STRING_ARRAY.toByte());
                24.writeStringArray(array, out);
                return true;
            }
        });
        WellKnownDS TIME_UNIT_SERIALIZER = new WellKnownDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                TimeUnit timeUnit = (TimeUnit)((Object)o);
                switch (timeUnit) {
                    case NANOSECONDS: {
                        out.writeByte(DSCODE.TIME_UNIT.toByte());
                        out.writeByte(-1);
                        break;
                    }
                    case MICROSECONDS: {
                        out.writeByte(DSCODE.TIME_UNIT.toByte());
                        out.writeByte(-2);
                        break;
                    }
                    case MILLISECONDS: {
                        out.writeByte(DSCODE.TIME_UNIT.toByte());
                        out.writeByte(-3);
                        break;
                    }
                    case SECONDS: {
                        out.writeByte(DSCODE.TIME_UNIT.toByte());
                        out.writeByte(-4);
                        break;
                    }
                    default: {
                        InternalDataSerializer.writeGemFireEnum(timeUnit, out);
                    }
                }
                return true;
            }
        };
        if (((Object)((Object)TimeUnit.NANOSECONDS)).getClass().getName().equals(((Object)((Object)TimeUnit.SECONDS)).getClass().getName())) {
            classesToSerializers.put(TimeUnit.class.getName(), TIME_UNIT_SERIALIZER);
        } else {
            classesToSerializers.put(((Object)((Object)TimeUnit.NANOSECONDS)).getClass().getName(), TIME_UNIT_SERIALIZER);
            classesToSerializers.put(((Object)((Object)TimeUnit.MICROSECONDS)).getClass().getName(), TIME_UNIT_SERIALIZER);
            classesToSerializers.put(((Object)((Object)TimeUnit.MILLISECONDS)).getClass().getName(), TIME_UNIT_SERIALIZER);
            classesToSerializers.put(((Object)((Object)TimeUnit.SECONDS)).getClass().getName(), TIME_UNIT_SERIALIZER);
        }
        classesToSerializers.put("java.util.Date", new WellKnownPdxDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                Date date = (Date)o;
                out.writeByte(DSCODE.DATE.toByte());
                26.writeDate(date, out);
                return true;
            }
        });
        classesToSerializers.put("java.io.File", new WellKnownDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                File file = (File)o;
                out.writeByte(DSCODE.FILE.toByte());
                27.writeFile(file, out);
                return true;
            }
        });
        classesToSerializers.put("java.util.ArrayList", new WellKnownPdxDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                ArrayList list = (ArrayList)o;
                out.writeByte(DSCODE.ARRAY_LIST.toByte());
                28.writeArrayList(list, out);
                return true;
            }
        });
        classesToSerializers.put("java.util.LinkedList", new WellKnownDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                LinkedList list = (LinkedList)o;
                out.writeByte(DSCODE.LINKED_LIST.toByte());
                29.writeLinkedList(list, out);
                return true;
            }
        });
        classesToSerializers.put("java.util.Vector", new WellKnownPdxDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                out.writeByte(DSCODE.VECTOR.toByte());
                30.writeVector((Vector)o, out);
                return true;
            }
        });
        classesToSerializers.put("java.util.Stack", new WellKnownDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                out.writeByte(DSCODE.STACK.toByte());
                31.writeStack((Stack)o, out);
                return true;
            }
        });
        classesToSerializers.put("java.util.HashSet", new WellKnownPdxDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                HashSet list = (HashSet)o;
                out.writeByte(DSCODE.HASH_SET.toByte());
                32.writeHashSet(list, out);
                return true;
            }
        });
        classesToSerializers.put("java.util.LinkedHashSet", new WellKnownPdxDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                out.writeByte(DSCODE.LINKED_HASH_SET.toByte());
                33.writeLinkedHashSet((LinkedHashSet)o, out);
                return true;
            }
        });
        classesToSerializers.put("java.util.HashMap", new WellKnownPdxDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                HashMap list = (HashMap)o;
                out.writeByte(DSCODE.HASH_MAP.toByte());
                34.writeHashMap(list, out);
                return true;
            }
        });
        classesToSerializers.put("java.util.IdentityHashMap", new WellKnownDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                out.writeByte(DSCODE.IDENTITY_HASH_MAP.toByte());
                35.writeIdentityHashMap((IdentityHashMap)o, out);
                return true;
            }
        });
        classesToSerializers.put("java.util.Hashtable", new WellKnownPdxDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                out.writeByte(DSCODE.HASH_TABLE.toByte());
                36.writeHashtable((Hashtable)o, out);
                return true;
            }
        });
        classesToSerializers.put("java.util.Properties", new WellKnownDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                Properties props = (Properties)o;
                out.writeByte(DSCODE.PROPERTIES.toByte());
                37.writeProperties(props, out);
                return true;
            }
        });
        classesToSerializers.put("java.util.TreeMap", new WellKnownDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                out.writeByte(DSCODE.TREE_MAP.toByte());
                38.writeTreeMap((TreeMap)o, out);
                return true;
            }
        });
        classesToSerializers.put("java.util.TreeSet", new WellKnownDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                out.writeByte(DSCODE.TREE_SET.toByte());
                39.writeTreeSet((TreeSet)o, out);
                return true;
            }
        });
        if (InternalDataSerializer.is662SerializationEnabled()) {
            classesToSerializers.put("java.math.BigInteger", new WellKnownDS(){

                @Override
                public boolean toData(Object o, DataOutput out) throws IOException {
                    out.writeByte(DSCODE.BIG_INTEGER.toByte());
                    InternalDataSerializer.writeBigInteger((BigInteger)o, out);
                    return true;
                }
            });
            classesToSerializers.put("java.math.BigDecimal", new WellKnownDS(){

                @Override
                public boolean toData(Object o, DataOutput out) throws IOException {
                    out.writeByte(DSCODE.BIG_DECIMAL.toByte());
                    InternalDataSerializer.writeBigDecimal((BigDecimal)o, out);
                    return true;
                }
            });
            classesToSerializers.put("java.util.UUID", new WellKnownDS(){

                @Override
                public boolean toData(Object o, DataOutput out) throws IOException {
                    out.writeByte(DSCODE.UUID.toByte());
                    InternalDataSerializer.writeUUID((UUID)o, out);
                    return true;
                }
            });
            classesToSerializers.put("java.sql.Timestamp", new WellKnownDS(){

                @Override
                public boolean toData(Object o, DataOutput out) throws IOException {
                    out.writeByte(DSCODE.TIMESTAMP.toByte());
                    InternalDataSerializer.writeTimestamp((Timestamp)o, out);
                    return true;
                }
            });
        }
    }

    private static int ubyteToInt(byte ub) {
        return ub & 0xFF;
    }

    public static OldClientSupportService getOldClientSupportService() {
        return oldClientSupportService;
    }

    public static void setOldClientSupportService(OldClientSupportService svc) {
        oldClientSupportService = svc;
    }

    static DataSerializer newInstance(Class<? extends DataSerializer> c) throws IllegalArgumentException {
        DataSerializer s;
        Constructor<? extends DataSerializer> init;
        if (!DataSerializer.class.isAssignableFrom(c)) {
            throw new IllegalArgumentException(String.format("%s does not extend DataSerializer.", c.getName()));
        }
        try {
            init = c.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException ignored) {
            if (c.getDeclaringClass() != null) {
                String message = String.format("Class %s does not have a zero-argument constructor. It is an inner class of %s. Should it be a static inner class?", c.getName(), c.getDeclaringClass());
                throw new IllegalArgumentException(message);
            }
            String message = String.format("Class %s does not have a zero-argument constructor.", c.getName());
            throw new IllegalArgumentException(message);
        }
        try {
            init.setAccessible(true);
            s = init.newInstance(new Object[0]);
        }
        catch (IllegalAccessException ignored) {
            throw new IllegalArgumentException(String.format("Could not instantiate an instance of %s", c.getName()));
        }
        catch (InstantiationException ex) {
            throw new IllegalArgumentException(String.format("Could not instantiate an instance of %s", c.getName()), ex);
        }
        catch (InvocationTargetException ex) {
            throw new IllegalArgumentException(String.format("While instantiating an instance of %s", c.getName()), ex);
        }
        return s;
    }

    public static DataSerializer register(Class<? extends DataSerializer> c, boolean distribute, EventID eventId, ClientProxyMembershipID context) {
        DataSerializer s = InternalDataSerializer.newInstance(c);
        s.setEventId(eventId);
        s.setContext(context);
        return InternalDataSerializer._register(s, distribute);
    }

    public static DataSerializer register(Class<? extends DataSerializer> c, boolean distribute) {
        DataSerializer s = InternalDataSerializer.newInstance(c);
        return InternalDataSerializer._register(s, distribute);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataSerializer _register(DataSerializer s, boolean distribute) {
        boolean retry;
        int id = s.getId();
        DataSerializer dsForMarkers = s;
        if (id == 0) {
            throw new IllegalArgumentException("Cannot create a DataSerializer with id 0.");
        }
        Class<?>[] classes = s.getSupportedClasses();
        if (classes == null || classes.length == 0) {
            String msg = "The DataSerializer %s has no supported classes. It's getSupportedClasses method must return at least one class";
            throw new IllegalArgumentException(String.format("The DataSerializer %s has no supported classes. It's getSupportedClasses method must return at least one class", s.getClass().getName()));
        }
        for (Class<?> aClass : classes) {
            if (aClass == null) {
                String msg = "The DataSerializer getSupportedClasses method for %s returned an array that contained a null element.";
                throw new IllegalArgumentException(String.format("The DataSerializer getSupportedClasses method for %s returned an array that contained a null element.", s.getClass().getName()));
            }
            if (!aClass.isArray()) continue;
            String msg = "The DataSerializer getSupportedClasses method for %s returned an array that contained an array class which is not allowed since arrays have built-in support.";
            throw new IllegalArgumentException(String.format("The DataSerializer getSupportedClasses method for %s returned an array that contained an array class which is not allowed since arrays have built-in support.", s.getClass().getName()));
        }
        Integer idx = id;
        Marker oldMarker = null;
        InitMarker m = new InitMarker();
        do {
            retry = false;
            Object oldSerializer = idsToSerializers.putIfAbsent(idx, m);
            if (oldSerializer == null) continue;
            if (oldSerializer instanceof Marker) {
                boolean bl = retry = !idsToSerializers.replace(idx, oldSerializer, m);
                if (retry) continue;
                oldMarker = (Marker)oldSerializer;
                continue;
            }
            if (oldSerializer.getClass().equals(s.getClass())) {
                if (distribute) {
                    InternalDataSerializer.sendRegistrationMessage(s);
                }
                return (DataSerializer)oldSerializer;
            }
            DataSerializer other = (DataSerializer)oldSerializer;
            throw new IllegalStateException(String.format("A DataSerializer of class %s is already registered with id %s.", other.getClass().getName(), other.getId()));
        } while (retry);
        try {
            for (int i = 0; i < classes.length; ++i) {
                DataSerializer oldS = classesToSerializers.putIfAbsent(classes[i].getName(), s);
                if (oldS == null || s.equals(oldS)) continue;
                for (int j = 0; j < i; ++j) {
                    classesToSerializers.remove(classes[j].getName(), s);
                }
                dsForMarkers = null;
                Object oldMsg = oldS.getId() == 0 ? "DataSerializer has built-in support for class " : "A DataSerializer of class " + oldS.getClass().getName() + " is already registered to support class ";
                String msg = (String)oldMsg + classes[i].getName() + " so the DataSerializer of class " + s.getClass().getName() + " could not be registered.";
                if (oldS.getId() == 0) {
                    throw new IllegalArgumentException(msg);
                }
                throw new IllegalStateException(msg);
            }
        }
        finally {
            if (dsForMarkers == null) {
                idsToSerializers.remove(idx, m);
            } else {
                idsToSerializers.replace(idx, m, dsForMarkers);
            }
            if (oldMarker != null) {
                oldMarker.setSerializer(dsForMarkers);
            }
            m.setSerializer(dsForMarkers);
        }
        InternalCache cache = InternalDataSerializer.getInternalCache();
        if (cache != null && s.getEventId() == null) {
            s.setEventId(new EventID(cache.getDistributedSystem()));
        }
        if (distribute) {
            InternalDataSerializer.sendRegistrationMessage(s);
            InternalDataSerializer.sendRegistrationMessageToServers(s);
        }
        InternalDataSerializer.sendRegistrationMessageToClients(s);
        InternalDataSerializer.fireNewDataSerializer(s);
        return s;
    }

    private static InternalCache getInternalCache() {
        return GemFireCacheImpl.getInstance();
    }

    public static void register(String className, boolean distribute, EventID eventId, ClientProxyMembershipID proxyId, int id) {
        InternalDataSerializer.register(className, distribute, new SerializerAttributesHolder(className, eventId, proxyId, id));
    }

    public static void register(String className, boolean distribute) {
        InternalDataSerializer.register(className, distribute, new SerializerAttributesHolder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void register(String className, boolean distribute, SerializerAttributesHolder holder) {
        if (StringUtils.isBlank((CharSequence)className)) {
            throw new IllegalArgumentException("Class name cannot be null or empty.");
        }
        SerializerAttributesHolder oldValue = dsClassesToHolders.putIfAbsent(className, holder);
        if (oldValue != null && oldValue.getId() != 0 && holder.getId() != 0 && oldValue.getId() != holder.getId()) {
            throw new IllegalStateException(String.format("A DataSerializer of class %s is already registered with id %s.", oldValue.getClass().getName(), oldValue.getId()));
        }
        idsToHolders.putIfAbsent(holder.getId(), holder);
        Object ds = idsToSerializers.get(holder.getId());
        if (ds instanceof Marker) {
            Object v = ds;
            synchronized (v) {
                ds.notifyAll();
            }
        }
        if (distribute) {
            InternalDataSerializer.sendRegistrationMessageToServers(holder);
        }
    }

    public static void updateSupportedClassesMap(Map<Integer, List<String>> map) {
        for (Map.Entry<Integer, List<String>> e : map.entrySet()) {
            for (String supportedClassName : e.getValue()) {
                SerializerAttributesHolder serializerAttributesHolder = idsToHolders.get(e.getKey());
                if (serializerAttributesHolder == null) continue;
                supportedClassesToHolders.putIfAbsent(supportedClassName, serializerAttributesHolder);
            }
        }
    }

    public static void updateSupportedClassesMap(String dsClassName, String supportedClassName) {
        SerializerAttributesHolder holder = dsClassesToHolders.get(dsClassName);
        if (holder != null) {
            supportedClassesToHolders.putIfAbsent(supportedClassName, holder);
        }
    }

    private static void sendRegistrationMessageToServers(DataSerializer dataSerializer) {
        PoolManagerImpl.allPoolsRegisterDataSerializers(dataSerializer);
    }

    private static void sendRegistrationMessageToServers(SerializerAttributesHolder holder) {
        PoolManagerImpl.allPoolsRegisterDataSerializers(holder);
    }

    private static void sendRegistrationMessageToClients(DataSerializer dataSerializer) {
        byte[][] serializedDataSerializer;
        block3: {
            InternalCache cache = InternalDataSerializer.getInternalCache();
            if (cache == null) {
                return;
            }
            serializedDataSerializer = new byte[2][];
            try {
                serializedDataSerializer[0] = CacheServerHelper.serialize(dataSerializer.getClass().toString().substring(6));
                byte[] idBytes = new byte[4];
                Part.encodeInt(dataSerializer.getId(), idBytes);
                serializedDataSerializer[1] = idBytes;
            }
            catch (IOException ignored) {
                if (!logger.isTraceEnabled(LogMarker.SERIALIZER_VERBOSE)) break block3;
                logger.trace(LogMarker.SERIALIZER_VERBOSE, "InternalDataSerializer encountered an IOException while serializing DataSerializer :{}", (Object)dataSerializer);
            }
        }
        ClientDataSerializerMessage clientDataSerializerMessage = new ClientDataSerializerMessage(EnumListenerEvent.AFTER_REGISTER_DATASERIALIZER, serializedDataSerializer, (ClientProxyMembershipID)dataSerializer.getContext(), (EventID)dataSerializer.getEventId(), new Class[][]{dataSerializer.getSupportedClasses()});
        CacheClientNotifier.routeClientMessage(clientDataSerializerMessage);
    }

    public static EventID generateEventId() {
        InternalCache cache = InternalDataSerializer.getInternalCache();
        if (cache == null) {
            return null;
        }
        return new EventID(InternalDistributedSystem.getAnyInstance());
    }

    public static void unregister(int id) {
        Integer idx = id;
        Object o = idsToSerializers.remove(idx);
        if (o != null && o instanceof InitMarker) {
            o = ((Marker)o).getSerializer();
        }
        if (o instanceof DataSerializer) {
            Class<?>[] classes;
            DataSerializer s = (DataSerializer)o;
            for (Class<?> aClass : classes = s.getSupportedClasses()) {
                classesToSerializers.remove(aClass.getName(), s);
                supportedClassesToHolders.remove(aClass.getName());
            }
            dsClassesToHolders.remove(s.getClass().getName());
            idsToHolders.remove(idx);
        }
    }

    public static void reinitialize() {
        idsToSerializers.clear();
        classesToSerializers.clear();
        supportedClassesToHolders.clear();
        dsClassesToHolders.clear();
        idsToHolders.clear();
        InternalDataSerializer.initializeWellKnownSerializers();
    }

    private static DataSerializer getSerializer(Class c) {
        SerializerAttributesHolder sah;
        DataSerializer ds = classesToSerializers.get(c.getName());
        if (ds == null && (sah = supportedClassesToHolders.get(c.getName())) != null) {
            try {
                Class dsClass = InternalDataSerializer.getCachedClass(sah.getClassName());
                DataSerializer serializer = InternalDataSerializer.register(dsClass, false);
                dsClassesToHolders.remove(dsClass.getName());
                idsToHolders.remove(serializer.getId());
                for (Class<?> clazz : serializer.getSupportedClasses()) {
                    supportedClassesToHolders.remove(clazz.getName());
                }
                return serializer;
            }
            catch (ClassNotFoundException ignored) {
                logger.info(LogMarker.SERIALIZER_MARKER, "Could not load DataSerializer class: {}", (Object)c.getName());
            }
        }
        return ds;
    }

    public static DataSerializer getSerializer(int id) {
        Integer idx = id;
        GetMarker marker = new GetMarker();
        DataSerializer result = null;
        boolean timedOut = false;
        SerializerAttributesHolder sah = idsToHolders.get(idx);
        while (result == null && !timedOut && sah == null) {
            Object o = idsToSerializers.putIfAbsent(idx, marker);
            if (o == null) {
                result = marker.getSerializer();
                if (result != null) continue;
                timedOut = true;
                idsToSerializers.remove(idx, marker);
                continue;
            }
            if (o instanceof Marker) {
                result = ((Marker)o).getSerializer();
                continue;
            }
            result = (DataSerializer)o;
        }
        if (result == null && sah != null) {
            try {
                Class dsClass = InternalDataSerializer.getCachedClass(sah.getClassName());
                DataSerializer ds = InternalDataSerializer.register(dsClass, false);
                dsClassesToHolders.remove(sah.getClassName());
                idsToHolders.remove(id);
                for (Class<?> clazz : ds.getSupportedClasses()) {
                    supportedClassesToHolders.remove(clazz.getName());
                }
                return ds;
            }
            catch (ClassNotFoundException ignored) {
                logger.info(LogMarker.SERIALIZER_MARKER, "Could not load DataSerializer class: {}", (Object)sah.getClassName());
            }
        }
        return result;
    }

    public static DataSerializer[] getSerializers() {
        int size = idsToSerializers.size();
        ArrayList<DataSerializer> coll = new ArrayList<DataSerializer>(size);
        for (Object v : idsToSerializers.values()) {
            if (v instanceof InitMarker) {
                v = ((Marker)v).getSerializer();
            }
            if (!(v instanceof DataSerializer)) continue;
            coll.add((DataSerializer)v);
        }
        Iterator<Map.Entry<String, SerializerAttributesHolder>> iterator = dsClassesToHolders.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, SerializerAttributesHolder> entry = iterator.next();
            String name = entry.getKey();
            SerializerAttributesHolder holder = entry.getValue();
            try {
                Class cl = InternalDataSerializer.getCachedClass(name);
                DataSerializer ds = holder.getEventId() != null ? InternalDataSerializer.register(cl, false, holder.getEventId(), holder.getProxyId()) : InternalDataSerializer.register(cl, false);
                coll.add(ds);
                iterator.remove();
                idsToHolders.remove(ds.getId());
                for (Class<?> clazz : ds.getSupportedClasses()) {
                    supportedClassesToHolders.remove(clazz.getName());
                }
            }
            catch (ClassNotFoundException ignored) {
                logger.info(LogMarker.SERIALIZER_MARKER, "Could not load DataSerializer class: {}", (Object)name);
            }
        }
        return coll.toArray(new DataSerializer[0]);
    }

    /*
     * WARNING - void declaration
     */
    public static SerializerAttributesHolder[] getSerializersForDistribution() {
        int size = idsToSerializers.size() + dsClassesToHolders.size();
        ArrayList<SerializerAttributesHolder> coll = new ArrayList<SerializerAttributesHolder>(size);
        for (Object v : idsToSerializers.values()) {
            void var3_3;
            if (v instanceof InitMarker) {
                DataSerializer dataSerializer = ((Marker)v).getSerializer();
            }
            if (!(var3_3 instanceof DataSerializer)) continue;
            DataSerializer s = (DataSerializer)var3_3;
            coll.add(new SerializerAttributesHolder(s.getClass().getName(), (EventID)s.getEventId(), (ClientProxyMembershipID)s.getContext(), s.getId()));
        }
        for (Map.Entry entry : dsClassesToHolders.entrySet()) {
            SerializerAttributesHolder v = (SerializerAttributesHolder)entry.getValue();
            coll.add(v);
        }
        return coll.toArray(new SerializerAttributesHolder[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRegistrationListener(RegistrationListener l) {
        Object object = listenersSync;
        synchronized (object) {
            HashSet<RegistrationListener> newSet = new HashSet<RegistrationListener>(listeners);
            newSet.add(l);
            listeners = newSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeRegistrationListener(RegistrationListener l) {
        Object object = listenersSync;
        synchronized (object) {
            HashSet<RegistrationListener> newSet = new HashSet<RegistrationListener>(listeners);
            newSet.remove(l);
            listeners = newSet;
        }
    }

    private static void fireNewDataSerializer(DataSerializer ds) {
        for (RegistrationListener listener : listeners) {
            listener.newDataSerializer(ds);
        }
    }

    static void fireNewInstantiator(Instantiator instantiator) {
        for (RegistrationListener listener : listeners) {
            listener.newInstantiator(instantiator);
        }
    }

    private static void sendRegistrationMessage(DataSerializer s) {
        InternalDistributedSystem system = InternalDistributedSystem.getConnectedInstance();
        if (system != null) {
            RegistrationMessage m = new RegistrationMessage(s);
            system.getDistributionManager().putOutgoing(m);
        }
    }

    public static void writeDSFIDHeader(int dsfid, DataOutput out) throws IOException {
        if (dsfid == 0) {
            throw new IllegalStateException("attempted to serialize ILLEGAL dsfid");
        }
        if (dsfid <= 127 && dsfid >= -128) {
            out.writeByte(DSCODE.DS_FIXED_ID_BYTE.toByte());
            out.writeByte(dsfid);
        } else if (dsfid <= Short.MAX_VALUE && dsfid >= Short.MIN_VALUE) {
            out.writeByte(DSCODE.DS_FIXED_ID_SHORT.toByte());
            out.writeShort(dsfid);
        } else {
            out.writeByte(DSCODE.DS_FIXED_ID_INT.toByte());
            out.writeInt(dsfid);
        }
    }

    public static void writeDSFID(DataSerializableFixedID o, DataOutput out) throws IOException {
        int dsfid = o.getDSFID();
        try {
            if (dsfid != Integer.MAX_VALUE) {
                dsfidSerializer.write((BasicSerializable)o, out);
                return;
            }
            out.writeByte(DSCODE.DS_NO_FIXED_ID.toByte());
            DataSerializer.writeClass(o.getClass(), out);
            InternalDataSerializer.invokeToData(o, out);
        }
        catch (IOException | CancelException | GemFireRethrowable | ToDataException io) {
            throw io;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            throw new ToDataException("toData failed on dsfid=" + dsfid + " msg:" + t.getMessage(), t);
        }
    }

    private static boolean writeWellKnownObject(Object o, DataOutput out, boolean ensurePdxCompatibility) throws IOException {
        return InternalDataSerializer.writeUserObject(o, out, ensurePdxCompatibility);
    }

    private static boolean writeUserObject(Object o, DataOutput out, boolean ensurePdxCompatibility) throws IOException {
        Class<?> c = o.getClass();
        DataSerializer serializer = InternalDataSerializer.getSerializer(c);
        if (serializer != null) {
            boolean toDataResult;
            int id = serializer.getId();
            if (id != 0) {
                InternalDataSerializer.checkPdxCompatible(o, ensurePdxCompatibility);
                if (id <= 127 && id >= -128) {
                    out.writeByte(DSCODE.USER_CLASS.toByte());
                    out.writeByte((byte)id);
                } else if (id <= Short.MAX_VALUE && id >= Short.MIN_VALUE) {
                    out.writeByte(DSCODE.USER_CLASS_2.toByte());
                    out.writeShort(id);
                } else {
                    out.writeByte(DSCODE.USER_CLASS_4.toByte());
                    out.writeInt(id);
                }
            } else if (ensurePdxCompatibility && !(serializer instanceof WellKnownPdxDS)) {
                InternalDataSerializer.checkPdxCompatible(o, ensurePdxCompatibility);
            }
            try {
                toDataResult = serializer.toData(o, out);
            }
            catch (IOException io) {
                if (serializer instanceof WellKnownDS) {
                    throw io;
                }
                throw new ToDataException("toData failed on DataSerializer with id=" + id + " for class " + String.valueOf(c), io);
            }
            catch (CancelException | GemFireRethrowable | ToDataException ex) {
                throw ex;
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                throw new ToDataException("toData failed on DataSerializer with id=" + id + " for class " + String.valueOf(c), t);
            }
            if (toDataResult) {
                return true;
            }
            throw new ToDataException(String.format("Serializer %s (a %s ) said that it could serialize an instance of %s , but its toData() method returned false.", serializer.getId(), serializer.getClass().getName(), o.getClass().getName()));
        }
        if (o instanceof byte[][]) {
            byte[][] byteArrays = (byte[][])o;
            out.writeByte(DSCODE.ARRAY_OF_BYTE_ARRAYS.toByte());
            InternalDataSerializer.writeArrayOfByteArrays(byteArrays, out);
            return true;
        }
        if (o instanceof Object[]) {
            Object[] array = (Object[])o;
            out.writeByte(DSCODE.OBJECT_ARRAY.toByte());
            InternalDataSerializer.writeObjectArray(array, out, ensurePdxCompatibility);
            return true;
        }
        if (InternalDataSerializer.is662SerializationEnabled() && (o.getClass().isEnum() || o.getClass().getSuperclass() != null && o.getClass().getSuperclass().isEnum())) {
            if (InternalDataSerializer.isPdxSerializationInProgress()) {
                InternalDataSerializer.writePdxEnum((Enum)o, out);
            } else {
                InternalDataSerializer.checkPdxCompatible(o, ensurePdxCompatibility);
                InternalDataSerializer.writeGemFireEnum((Enum)o, out);
            }
            return true;
        }
        PdxSerializer pdxSerializer = TypeRegistry.getPdxSerializer();
        return pdxSerializer != null && InternalDataSerializer.writePdx(out, null, o, pdxSerializer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean autoSerialized(Object o, DataOutput out) throws IOException {
        AutoSerializableManager.AutoClassInfo aci;
        AutoSerializableManager asm = TypeRegistry.getAutoSerializableManager();
        if (asm != null && (aci = asm.getExistingClassInfo(o.getClass())) != null) {
            PdxWriterImpl writer;
            GemFireCacheImpl internalCache;
            block11: {
                internalCache = GemFireCacheImpl.getForPdx("PDX registry is unavailable because the Cache has been closed.");
                TypeRegistry tr = internalCache.getPdxRegistry();
                PdxOutputStream os = out instanceof HeapDataOutputStream ? new PdxOutputStream((HeapDataOutputStream)out) : new PdxOutputStream();
                writer = new PdxWriterImpl(tr, o, aci, os);
                try {
                    if (InternalDataSerializer.is662SerializationEnabled()) {
                        boolean alreadyInProgress = InternalDataSerializer.isPdxSerializationInProgress();
                        if (!alreadyInProgress) {
                            InternalDataSerializer.setPdxSerializationInProgress(true);
                            try {
                                asm.writeData(writer, o, aci);
                                break block11;
                            }
                            finally {
                                InternalDataSerializer.setPdxSerializationInProgress(false);
                            }
                        }
                        asm.writeData(writer, o, aci);
                        break block11;
                    }
                    asm.writeData(writer, o, aci);
                }
                catch (CancelException | GemFireRethrowable | ToDataException | NonPortableClassException ex) {
                    throw ex;
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable t) {
                    SystemFailure.checkFailure();
                    throw new ToDataException("PdxSerializer failed when calling toData on " + String.valueOf(o.getClass()), t);
                }
            }
            int bytesWritten = writer.completeByteStreamGeneration();
            InternalDataSerializer.getDMStats(internalCache).incPdxSerialization(bytesWritten);
            if (!(out instanceof HeapDataOutputStream)) {
                writer.sendTo(out);
            }
            return true;
        }
        return false;
    }

    private static void checkPdxCompatible(Object o, boolean ensurePdxCompatibility) {
        if (ensurePdxCompatibility) {
            throw new NonPortableClassException("Instances of " + String.valueOf(o.getClass()) + " are not compatible with non-java PDX.");
        }
    }

    static boolean isGemfireObject(Object o) {
        return (o instanceof Function || o.getClass().getName().startsWith("org.apache.geode.")) && !(o instanceof PdxSerializerObject);
    }

    private static Object readUserObject(DataInput in, int serializerId) throws IOException, ClassNotFoundException {
        DataSerializer serializer = InternalDataSerializer.getSerializer(serializerId);
        if (serializer == null) {
            throw new IOException(String.format("Serializer with Id %s is not registered", serializerId));
        }
        return serializer.fromData(in);
    }

    public static void checkOut(DataOutput out) {
        if (out == null) {
            throw new NullPointerException("Null DataOutput");
        }
    }

    public static void checkIn(DataInput in) {
        if (in == null) {
            throw new NullPointerException("Null DataInput");
        }
    }

    public static void writeSet(Collection<?> set, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        if (set != null) {
            int size = set.size();
            InternalDataSerializer.writeArrayLength(size, out);
            if (logger.isTraceEnabled(LogMarker.SERIALIZER_VERBOSE)) {
                logger.trace(LogMarker.SERIALIZER_VERBOSE, "Writing Set with {} elements: {}", (Object)size, set);
            }
            for (Object element : set) {
                InternalDataSerializer.writeObject(element, out);
            }
        } else {
            InternalDataSerializer.writeArrayLength(-1, out);
            if (logger.isTraceEnabled(LogMarker.SERIALIZER_VERBOSE)) {
                logger.trace(LogMarker.SERIALIZER_VERBOSE, "Writing Set with {} elements: {}", (Object)-1, null);
            }
        }
    }

    public static Set readSet(DataInput in) throws IOException, ClassNotFoundException {
        return InternalDataSerializer.readHashSet(in);
    }

    public static void writeSetOfLongs(Set set, boolean hasLongIDs, DataOutput out) throws IOException {
        if (set == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(set.size());
            out.writeBoolean(hasLongIDs);
            for (Object aSet : set) {
                Long l = (Long)aSet;
                if (hasLongIDs) {
                    out.writeLong(l);
                    continue;
                }
                out.writeInt((int)l.longValue());
            }
        }
    }

    public static Set<Long> readSetOfLongs(DataInput in) throws IOException {
        int size = in.readInt();
        if (size < 0) {
            return null;
        }
        HashSet<Long> result = new HashSet<Long>(size);
        boolean longIDs = in.readBoolean();
        for (int i = 0; i < size; ++i) {
            long l = longIDs ? in.readLong() : (long)in.readInt();
            result.add(l);
        }
        return result;
    }

    private static TimeUnit readTimeUnit(DataInput in) throws IOException {
        InternalDataSerializer.checkIn(in);
        byte type = in.readByte();
        TimeUnit unit = switch (type) {
            case -1 -> TimeUnit.NANOSECONDS;
            case -2 -> TimeUnit.MICROSECONDS;
            case -3 -> TimeUnit.MILLISECONDS;
            case -4 -> TimeUnit.SECONDS;
            default -> throw new IOException(String.format("Unknown TimeUnit type: %s", type));
        };
        if (logger.isTraceEnabled(LogMarker.SERIALIZER_VERBOSE)) {
            logger.trace(LogMarker.SERIALIZER_VERBOSE, "Read TimeUnit: {}", (Object)unit);
        }
        return unit;
    }

    private static void writeTimestamp(Timestamp o, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER_VERBOSE)) {
            logger.trace(LogMarker.SERIALIZER_VERBOSE, "Writing Timestamp: {}", (Object)o);
        }
        DataSerializer.writePrimitiveLong(o.getTime(), out);
    }

    private static Timestamp readTimestamp(DataInput in) throws IOException {
        InternalDataSerializer.checkIn(in);
        Timestamp result = new Timestamp(DataSerializer.readPrimitiveLong(in));
        if (logger.isTraceEnabled(LogMarker.SERIALIZER_VERBOSE)) {
            logger.trace(LogMarker.SERIALIZER_VERBOSE, "Read Timestamp: {}", (Object)result);
        }
        return result;
    }

    private static void writeUUID(UUID o, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER_VERBOSE)) {
            logger.trace(LogMarker.SERIALIZER_VERBOSE, "Writing UUID: {}", (Object)o);
        }
        DataSerializer.writePrimitiveLong(o.getMostSignificantBits(), out);
        DataSerializer.writePrimitiveLong(o.getLeastSignificantBits(), out);
    }

    private static UUID readUUID(DataInput in) throws IOException {
        InternalDataSerializer.checkIn(in);
        long mb = DataSerializer.readPrimitiveLong(in);
        long lb = DataSerializer.readPrimitiveLong(in);
        UUID result = new UUID(mb, lb);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER_VERBOSE)) {
            logger.trace(LogMarker.SERIALIZER_VERBOSE, "Read UUID: {}", (Object)result);
        }
        return result;
    }

    private static void writeBigDecimal(BigDecimal o, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER_VERBOSE)) {
            logger.trace(LogMarker.SERIALIZER_VERBOSE, "Writing BigDecimal: {}", (Object)o);
        }
        DataSerializer.writeString(o.toString(), out);
    }

    private static BigDecimal readBigDecimal(DataInput in) throws IOException {
        InternalDataSerializer.checkIn(in);
        BigDecimal result = new BigDecimal(DataSerializer.readString(in));
        if (logger.isTraceEnabled(LogMarker.SERIALIZER_VERBOSE)) {
            logger.trace(LogMarker.SERIALIZER_VERBOSE, "Read BigDecimal: {}", (Object)result);
        }
        return result;
    }

    private static void writeBigInteger(BigInteger o, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER_VERBOSE)) {
            logger.trace(LogMarker.SERIALIZER_VERBOSE, "Writing BigInteger: {}", (Object)o);
        }
        DataSerializer.writeByteArray(o.toByteArray(), out);
    }

    private static BigInteger readBigInteger(DataInput in) throws IOException {
        InternalDataSerializer.checkIn(in);
        BigInteger result = new BigInteger(Objects.requireNonNull(DataSerializer.readByteArray(in)));
        if (logger.isTraceEnabled(LogMarker.SERIALIZER_VERBOSE)) {
            logger.trace(LogMarker.SERIALIZER_VERBOSE, "Read BigInteger: {}", (Object)result);
        }
        return result;
    }

    public static void writeUserDataSerializableHeader(int classId, DataOutput out) throws IOException {
        if (classId <= 127 && classId >= -128) {
            out.writeByte(DSCODE.USER_DATA_SERIALIZABLE.toByte());
            out.writeByte(classId);
        } else if (classId <= Short.MAX_VALUE && classId >= Short.MIN_VALUE) {
            out.writeByte(DSCODE.USER_DATA_SERIALIZABLE_2.toByte());
            out.writeShort(classId);
        } else {
            out.writeByte(DSCODE.USER_DATA_SERIALIZABLE_4.toByte());
            out.writeInt(classId);
        }
    }

    public static void writeCharArray(char[] array, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        if (array == null) {
            InternalDataSerializer.writeArrayLength(-1, out);
        } else {
            int length = array.length;
            if (logger.isTraceEnabled(LogMarker.SERIALIZER_VERBOSE)) {
                logger.trace(LogMarker.SERIALIZER_VERBOSE, "Writing char array of length {}", (Object)length);
            }
            InternalDataSerializer.writeArrayLength(length, out);
            for (char character : array) {
                out.writeChar(character);
            }
        }
    }

    public static boolean isSerializedNull(byte[] serializedForm) {
        return serializedForm.length == 1 && serializedForm[0] == DSCODE.NULL.toByte();
    }

    public static void basicWriteObject(Object o, DataOutput out, boolean ensurePdxCompatibility) throws IOException {
        InternalDataSerializer.checkOut(out);
        boolean isDebugEnabled_SERIALIZER = logger.isTraceEnabled(LogMarker.SERIALIZER_VERBOSE);
        if (isDebugEnabled_SERIALIZER) {
            logger.trace(LogMarker.SERIALIZER_VERBOSE, "basicWriteObject: {}", o);
        }
        if (o == null) {
            out.writeByte(DSCODE.NULL.toByte());
        } else if (o instanceof BasicSerializable) {
            InternalDataSerializer.checkPdxCompatible(o, ensurePdxCompatibility);
            BasicSerializable bs = (BasicSerializable)o;
            dsfidSerializer.write(bs, out);
        } else if (!InternalDataSerializer.autoSerialized(o, out)) {
            if (o instanceof DataSerializable.Replaceable) {
                Object replacement = ((DataSerializable.Replaceable)o).replace();
                InternalDataSerializer.basicWriteObject(replacement, out, ensurePdxCompatibility);
            } else if (o instanceof PdxSerializable) {
                InternalDataSerializer.writePdx(out, GemFireCacheImpl.getForPdx("PDX registry is unavailable because the Cache has been closed."), o, null);
            } else if (o instanceof DataSerializable) {
                if (isDebugEnabled_SERIALIZER) {
                    logger.trace(LogMarker.SERIALIZER_VERBOSE, "Writing DataSerializable: {}", o);
                }
                InternalDataSerializer.checkPdxCompatible(o, ensurePdxCompatibility);
                Class<?> c = o.getClass();
                int classId = InternalInstantiator.getClassId(c);
                if (classId != 0) {
                    InternalDataSerializer.writeUserDataSerializableHeader(classId, out);
                } else {
                    out.writeByte(DSCODE.DATA_SERIALIZABLE.toByte());
                    DataSerializer.writeClass(c, out);
                }
                InternalDataSerializer.invokeToData(o, out);
            } else if (o instanceof Sendable) {
                if (!(o instanceof PdxInstance) || o instanceof PdxInstanceEnum) {
                    InternalDataSerializer.checkPdxCompatible(o, ensurePdxCompatibility);
                }
                ((Sendable)o).sendTo(out);
            } else if (!InternalDataSerializer.writeWellKnownObject(o, out, ensurePdxCompatibility)) {
                InternalDataSerializer.checkPdxCompatible(o, ensurePdxCompatibility);
                if (logger.isTraceEnabled(LogMarker.SERIALIZER_ANNOUNCE_TYPE_WRITTEN_VERBOSE)) {
                    logger.trace(LogMarker.SERIALIZER_ANNOUNCE_TYPE_WRITTEN_VERBOSE, "DataSerializer Serializing an instance of {}", (Object)o.getClass().getName());
                }
                if (InternalDataSerializer.disallowJavaSerialization() && o instanceof Serializable) {
                    throw new NotSerializableException(String.format("%s is not DataSerializable and Java Serialization is disallowed", o.getClass().getName()));
                }
                InternalDataSerializer.writeSerializableObject(o, out);
            }
        }
    }

    private static boolean disallowJavaSerialization() {
        Boolean v = (Boolean)DISALLOW_JAVA_SERIALIZATION.get();
        return v != null && v != false;
    }

    private static void writePdxEnum(Enum<?> e, DataOutput out) throws IOException {
        TypeRegistry tr = GemFireCacheImpl.getForPdx("PDX registry is unavailable because the Cache has been closed.").getPdxRegistry();
        int eId = tr.getEnumId(e);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER_VERBOSE)) {
            logger.trace(LogMarker.SERIALIZER_VERBOSE, "write PdxEnum id={} enum={}", (Object)eId, e);
        }
        InternalDataSerializer.writePdxEnumId(eId, out);
    }

    public static void writePdxEnumId(int eId, DataOutput out) throws IOException {
        out.writeByte(DSCODE.PDX_ENUM.toByte());
        out.writeByte(eId >> 24);
        InternalDataSerializer.writeArrayLength(eId & 0xFFFFFF, out);
    }

    private static Object readPdxEnum(DataInput in) throws IOException {
        GemFireCacheImpl internalCache;
        TypeRegistry tr;
        Object result;
        byte dsId = in.readByte();
        int tmp = InternalDataSerializer.readArrayLength(in);
        int enumId = dsId << 24 | tmp & 0xFFFFFF;
        if (logger.isTraceEnabled(LogMarker.SERIALIZER_VERBOSE)) {
            logger.trace(LogMarker.SERIALIZER_VERBOSE, "read PdxEnum id={}", (Object)enumId);
        }
        if ((result = (tr = (internalCache = GemFireCacheImpl.getForPdx("PDX registry is unavailable because the Cache has been closed.")).getPdxRegistry()).getEnumById(enumId)) instanceof PdxInstance) {
            InternalDataSerializer.getDMStats(internalCache).incPdxInstanceCreations();
        }
        return result;
    }

    private static void writeGemFireEnum(Enum<?> e, DataOutput out) throws IOException {
        boolean isGemFireObject = InternalDataSerializer.isGemfireObject(e);
        DataSerializer.writePrimitiveByte(isGemFireObject ? DSCODE.GEMFIRE_ENUM.toByte() : DSCODE.PDX_INLINE_ENUM.toByte(), out);
        DataSerializer.writeString(e.getDeclaringClass().getName(), out);
        DataSerializer.writeString(e.name(), out);
        if (!isGemFireObject) {
            InternalDataSerializer.writeArrayLength(e.ordinal(), out);
        }
    }

    private static Enum<?> readGemFireEnum(DataInput in) throws IOException, ClassNotFoundException {
        String className = DataSerializer.readString(in);
        String enumName = DataSerializer.readString(in);
        Class c = InternalDataSerializer.getCachedClass(className);
        return Enum.valueOf(c, enumName);
    }

    private static Object readPdxInlineEnum(DataInput in) throws IOException, ClassNotFoundException {
        InternalCache internalCache = InternalDataSerializer.getInternalCache();
        if (internalCache != null && internalCache.getPdxReadSerializedByAnyGemFireServices()) {
            String className = DataSerializer.readString(in);
            String enumName = DataSerializer.readString(in);
            int enumOrdinal = InternalDataSerializer.readArrayLength(in);
            InternalDataSerializer.getDMStats(internalCache).incPdxInstanceCreations();
            return new PdxInstanceEnum(className, enumName, enumOrdinal);
        }
        Enum<?> e = InternalDataSerializer.readGemFireEnum(in);
        InternalDataSerializer.readArrayLength(in);
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeSerializableObject(Object o, DataOutput out) throws IOException {
        out.writeByte(DSCODE.SERIALIZABLE.toByte());
        if (out instanceof ObjectOutputStream) {
            ((ObjectOutputStream)out).writeObject(o);
        } else {
            OutputStream stream;
            if (out instanceof OutputStream) {
                stream = (OutputStream)((Object)out);
            } else {
                final DataOutput out2 = out;
                stream = new OutputStream(){

                    @Override
                    public void write(int b) throws IOException {
                        out2.write(b);
                    }

                    @Override
                    public void write(byte[] b, int off, int len) throws IOException {
                        out2.write(b, off, len);
                    }
                };
            }
            boolean wasDoNotCopy = false;
            if (out instanceof HeapDataOutputStream) {
                wasDoNotCopy = ((HeapDataOutputStream)out).setDoNotCopy(false);
            }
            try {
                KnownVersion v;
                ObjectOutput oos = new ObjectOutputStream(stream);
                if (stream instanceof VersionedDataStream && (v = ((VersionedDataStream)stream).getVersion()) != null && v != KnownVersion.CURRENT) {
                    oos = new VersionedObjectOutput(oos, v);
                }
                oos.writeObject(o);
                oos.flush();
            }
            finally {
                if (wasDoNotCopy) {
                    ((HeapDataOutputStream)out).setDoNotCopy(true);
                }
            }
        }
    }

    public static void invokeToData(Object serializableObject, DataOutput out) throws IOException {
        try {
            if (serializableObject instanceof BasicSerializable) {
                dsfidSerializer.invokeToData(serializableObject, out);
                return;
            }
            boolean invoked = false;
            KnownVersion v = StaticSerialization.getVersionForDataStreamOrNull((DataOutput)out);
            if (KnownVersion.CURRENT != v && v != null) {
                KnownVersion[] versions = null;
                if (serializableObject instanceof SerializationVersions) {
                    SerializationVersions sv = (SerializationVersions)serializableObject;
                    versions = sv.getSerializationVersions();
                }
                if (versions != null) {
                    for (KnownVersion version : versions) {
                        if (v.compareTo((Version)version) >= 0) continue;
                        serializableObject.getClass().getMethod("toDataPre_" + version.getMethodSuffix(), DataOutput.class).invoke(serializableObject, out);
                        invoked = true;
                        break;
                    }
                }
            }
            if (!invoked) {
                ((DataSerializable)serializableObject).toData(out);
            }
        }
        catch (IOException io) {
            throw new ToDataException("toData failed on DataSerializable " + String.valueOf(serializableObject.getClass()), io);
        }
        catch (CancelException | GemFireRethrowable | ToDataException ex) {
            throw ex;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            throw new ToDataException(StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"toData failed on DataSerializable null"}) == serializableObject ? "null" : serializableObject.getClass().toString(), t);
        }
    }

    public static void invokeFromData(Object deserializableObject, DataInput in) throws IOException, ClassNotFoundException {
        if (deserializableObject instanceof BasicSerializable) {
            dsfidSerializer.invokeFromData(deserializableObject, in);
            return;
        }
        try {
            boolean invoked = false;
            KnownVersion v = StaticSerialization.getVersionForDataStreamOrNull((DataInput)in);
            if (KnownVersion.CURRENT != v && v != null) {
                KnownVersion[] versions = null;
                if (deserializableObject instanceof SerializationVersions) {
                    SerializationVersions vds = (SerializationVersions)deserializableObject;
                    versions = vds.getSerializationVersions();
                }
                if (versions != null) {
                    for (KnownVersion version : versions) {
                        if (v.compareTo((Version)version) >= 0) continue;
                        deserializableObject.getClass().getMethod("fromDataPre_" + version.getMethodSuffix(), DataInput.class).invoke(deserializableObject, in);
                        invoked = true;
                        break;
                    }
                }
            }
            if (!invoked) {
                ((DataSerializable)deserializableObject).fromData(in);
                if (logger.isTraceEnabled(LogMarker.SERIALIZER_VERBOSE)) {
                    logger.trace(LogMarker.SERIALIZER_VERBOSE, "Read DataSerializable {}", deserializableObject);
                }
            }
        }
        catch (EOFException | ClassNotFoundException | SocketException | CacheClosedException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SerializationException(String.format("Could not create an instance of %s .", deserializableObject.getClass().getName()), ex);
        }
    }

    private static Object readDataSerializable(DataInput in) throws IOException, ClassNotFoundException {
        Class<?> c = InternalDataSerializer.readClass(in);
        try {
            Constructor<?> init = c.getConstructor(new Class[0]);
            init.setAccessible(true);
            Object o = init.newInstance(new Object[0]);
            InternalDataSerializer.invokeFromData(o, in);
            return o;
        }
        catch (EOFException | SocketException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SerializationException(String.format("Could not create an instance of %s .", c.getName()), ex);
        }
    }

    public static void writeArrayLength(int len, DataOutput out) throws IOException {
        if (len == -1) {
            out.writeByte(-1);
        } else if (len <= 252) {
            out.writeByte(len);
        } else if (len <= 65535) {
            out.writeByte(-2);
            out.writeShort(len);
        } else {
            out.writeByte(-3);
            out.writeInt(len);
        }
    }

    public static int readArrayLength(DataInput in) throws IOException {
        byte code = in.readByte();
        if (code == -1) {
            return -1;
        }
        int result = InternalDataSerializer.ubyteToInt(code);
        if (result > 252) {
            if (code == -2) {
                return in.readUnsignedShort();
            }
            if (code == -3) {
                return in.readInt();
            }
            throw new IllegalStateException("unexpected array length code=" + code);
        }
        return result;
    }

    private static Object readDSFID(DataInput in, DSCODE dscode) throws IOException, ClassNotFoundException {
        if (logger.isTraceEnabled(LogMarker.SERIALIZER_VERBOSE)) {
            logger.trace(LogMarker.SERIALIZER_VERBOSE, "readDSFID: header={}", (Object)dscode);
        }
        switch (dscode) {
            case DS_FIXED_ID_BYTE: {
                return dsfidFactory.create(in.readByte(), in);
            }
            case DS_FIXED_ID_SHORT: {
                return dsfidFactory.create(in.readShort(), in);
            }
            case DS_NO_FIXED_ID: {
                return InternalDataSerializer.readDataSerializable(in);
            }
            case DS_FIXED_ID_INT: {
                return dsfidFactory.create(in.readInt(), in);
            }
        }
        throw new IllegalStateException("unexpected byte: " + String.valueOf(dscode) + " while reading dsfid");
    }

    public static Object readDSFID(DataInput in) throws IOException, ClassNotFoundException {
        InternalDataSerializer.checkIn(in);
        return InternalDataSerializer.readDSFID(in, DscodeHelper.toDSCODE((byte)in.readByte()));
    }

    private static String readString(DataInput in, DSCODE dscode) throws IOException {
        switch (dscode) {
            case STRING_BYTES: {
                return InternalDataSerializer.readStringBytesFromDataInput(in, in.readUnsignedShort());
            }
            case STRING: {
                return InternalDataSerializer.readStringUTFFromDataInput(in);
            }
            case NULL_STRING: {
                if (logger.isTraceEnabled(LogMarker.SERIALIZER_VERBOSE)) {
                    logger.trace(LogMarker.SERIALIZER_VERBOSE, "Reading NULL_STRING");
                }
                return null;
            }
            case HUGE_STRING_BYTES: {
                return InternalDataSerializer.readStringBytesFromDataInput(in, in.readInt());
            }
            case HUGE_STRING: {
                return InternalDataSerializer.readHugeStringFromDataInput(in);
            }
        }
        throw new IOException("Unknown String header " + String.valueOf(dscode));
    }

    private static String readHugeStringFromDataInput(DataInput in) throws IOException {
        int len = in.readInt();
        if (logger.isTraceEnabled(LogMarker.SERIALIZER_VERBOSE)) {
            logger.trace(LogMarker.SERIALIZER_VERBOSE, "Reading HUGE_STRING of len={}", (Object)len);
        }
        char[] buf = new char[len];
        for (int i = 0; i < len; ++i) {
            buf[i] = in.readChar();
        }
        return new String(buf);
    }

    private static String readStringUTFFromDataInput(DataInput in) throws IOException {
        if (logger.isTraceEnabled(LogMarker.SERIALIZER_VERBOSE)) {
            logger.trace(LogMarker.SERIALIZER_VERBOSE, "Reading utf STRING");
        }
        return in.readUTF();
    }

    private static String readStringBytesFromDataInput(DataInput dataInput, int len) throws IOException {
        if (logger.isTraceEnabled(LogMarker.SERIALIZER_VERBOSE)) {
            logger.trace(LogMarker.SERIALIZER_VERBOSE, "Reading STRING_BYTES of len={}", (Object)len);
        }
        if (len == 0) {
            return "";
        }
        byte[] buf = StaticSerialization.getThreadLocalByteArray((int)len);
        dataInput.readFully(buf, 0, len);
        return new String(buf, 0, 0, len);
    }

    public static String readString(DataInput in, byte header) throws IOException {
        return StaticSerialization.readString((DataInput)in, (byte)header);
    }

    public static <T> T readNonPdxInstanceObject(DataInput in) throws IOException, ClassNotFoundException {
        boolean wouldReadSerialized = PdxInstanceImpl.getPdxReadSerialized();
        if (!wouldReadSerialized) {
            return DataSerializer.readObject(in);
        }
        PdxInstanceImpl.setPdxReadSerialized(false);
        try {
            Object t = DataSerializer.readObject(in);
            return t;
        }
        finally {
            PdxInstanceImpl.setPdxReadSerialized(true);
        }
    }

    public static Object basicReadObject(DataInput in) throws IOException, ClassNotFoundException {
        InternalDataSerializer.checkIn(in);
        byte header = in.readByte();
        DSCODE headerDSCode = DscodeHelper.toDSCODE((byte)header);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER_VERBOSE)) {
            logger.trace(LogMarker.SERIALIZER_VERBOSE, "basicReadObject: header={}", (Object)header);
        }
        if (headerDSCode == null) {
            throw new IOException("Unknown header byte: " + header);
        }
        switch (headerDSCode) {
            case DS_FIXED_ID_BYTE: {
                return dsfidFactory.create(in.readByte(), in);
            }
            case DS_FIXED_ID_SHORT: {
                return dsfidFactory.create(in.readShort(), in);
            }
            case DS_FIXED_ID_INT: {
                return dsfidFactory.create(in.readInt(), in);
            }
            case DS_NO_FIXED_ID: 
            case DATA_SERIALIZABLE: {
                return InternalDataSerializer.readDataSerializable(in);
            }
            case NULL_STRING: 
            case NULL: {
                return null;
            }
            case STRING: {
                return InternalDataSerializer.readStringUTFFromDataInput(in);
            }
            case HUGE_STRING: {
                return InternalDataSerializer.readHugeStringFromDataInput(in);
            }
            case STRING_BYTES: {
                return InternalDataSerializer.readStringBytesFromDataInput(in, in.readUnsignedShort());
            }
            case HUGE_STRING_BYTES: {
                return InternalDataSerializer.readStringBytesFromDataInput(in, in.readInt());
            }
            case CLASS: {
                return InternalDataSerializer.readClass(in);
            }
            case DATE: {
                return InternalDataSerializer.readDate(in);
            }
            case FILE: {
                return InternalDataSerializer.readFile(in);
            }
            case INET_ADDRESS: {
                return InternalDataSerializer.readInetAddress(in);
            }
            case BOOLEAN: {
                return InternalDataSerializer.readBoolean(in);
            }
            case CHARACTER: {
                return InternalDataSerializer.readCharacter(in);
            }
            case BYTE: {
                return InternalDataSerializer.readByte(in);
            }
            case SHORT: {
                return InternalDataSerializer.readShort(in);
            }
            case INTEGER: {
                return InternalDataSerializer.readInteger(in);
            }
            case LONG: {
                return InternalDataSerializer.readLong(in);
            }
            case FLOAT: {
                return InternalDataSerializer.readFloat(in);
            }
            case DOUBLE: {
                return InternalDataSerializer.readDouble(in);
            }
            case BYTE_ARRAY: {
                return InternalDataSerializer.readByteArray(in);
            }
            case ARRAY_OF_BYTE_ARRAYS: {
                return InternalDataSerializer.readArrayOfByteArrays(in);
            }
            case SHORT_ARRAY: {
                return InternalDataSerializer.readShortArray(in);
            }
            case STRING_ARRAY: {
                return InternalDataSerializer.readStringArray(in);
            }
            case INT_ARRAY: {
                return InternalDataSerializer.readIntArray(in);
            }
            case LONG_ARRAY: {
                return InternalDataSerializer.readLongArray(in);
            }
            case FLOAT_ARRAY: {
                return InternalDataSerializer.readFloatArray(in);
            }
            case DOUBLE_ARRAY: {
                return InternalDataSerializer.readDoubleArray(in);
            }
            case BOOLEAN_ARRAY: {
                return InternalDataSerializer.readBooleanArray(in);
            }
            case CHAR_ARRAY: {
                return InternalDataSerializer.readCharArray(in);
            }
            case OBJECT_ARRAY: {
                return InternalDataSerializer.readObjectArray(in);
            }
            case ARRAY_LIST: {
                return InternalDataSerializer.readArrayList(in);
            }
            case LINKED_LIST: {
                return InternalDataSerializer.readLinkedList(in);
            }
            case HASH_SET: {
                return InternalDataSerializer.readHashSet(in);
            }
            case LINKED_HASH_SET: {
                return InternalDataSerializer.readLinkedHashSet(in);
            }
            case HASH_MAP: {
                return InternalDataSerializer.readHashMap(in);
            }
            case IDENTITY_HASH_MAP: {
                return InternalDataSerializer.readIdentityHashMap(in);
            }
            case HASH_TABLE: {
                return InternalDataSerializer.readHashtable(in);
            }
            case CONCURRENT_HASH_MAP: {
                return InternalDataSerializer.readConcurrentHashMap(in);
            }
            case PROPERTIES: {
                return InternalDataSerializer.readProperties(in);
            }
            case TIME_UNIT: {
                return InternalDataSerializer.readTimeUnit(in);
            }
            case USER_CLASS: {
                return InternalDataSerializer.readUserObject(in, in.readByte());
            }
            case USER_CLASS_2: {
                return InternalDataSerializer.readUserObject(in, in.readShort());
            }
            case USER_CLASS_4: {
                return InternalDataSerializer.readUserObject(in, in.readInt());
            }
            case VECTOR: {
                return InternalDataSerializer.readVector(in);
            }
            case STACK: {
                return InternalDataSerializer.readStack(in);
            }
            case TREE_MAP: {
                return InternalDataSerializer.readTreeMap(in);
            }
            case TREE_SET: {
                return InternalDataSerializer.readTreeSet(in);
            }
            case BOOLEAN_TYPE: {
                return Boolean.TYPE;
            }
            case CHARACTER_TYPE: {
                return Character.TYPE;
            }
            case BYTE_TYPE: {
                return Byte.TYPE;
            }
            case SHORT_TYPE: {
                return Short.TYPE;
            }
            case INTEGER_TYPE: {
                return Integer.TYPE;
            }
            case LONG_TYPE: {
                return Long.TYPE;
            }
            case FLOAT_TYPE: {
                return Float.TYPE;
            }
            case DOUBLE_TYPE: {
                return Double.TYPE;
            }
            case VOID_TYPE: {
                return Void.TYPE;
            }
            case USER_DATA_SERIALIZABLE: {
                return InternalDataSerializer.readUserDataSerializable(in, in.readByte());
            }
            case USER_DATA_SERIALIZABLE_2: {
                return InternalDataSerializer.readUserDataSerializable(in, in.readShort());
            }
            case USER_DATA_SERIALIZABLE_4: {
                return InternalDataSerializer.readUserDataSerializable(in, in.readInt());
            }
            case SERIALIZABLE: {
                return InternalDataSerializer.readSerializable(in);
            }
            case PDX: {
                return InternalDataSerializer.readPdxSerializable(in);
            }
            case PDX_ENUM: {
                return InternalDataSerializer.readPdxEnum(in);
            }
            case GEMFIRE_ENUM: {
                return InternalDataSerializer.readGemFireEnum(in);
            }
            case PDX_INLINE_ENUM: {
                return InternalDataSerializer.readPdxInlineEnum(in);
            }
            case BIG_INTEGER: {
                return InternalDataSerializer.readBigInteger(in);
            }
            case BIG_DECIMAL: {
                return InternalDataSerializer.readBigDecimal(in);
            }
            case UUID: {
                return InternalDataSerializer.readUUID(in);
            }
            case TIMESTAMP: {
                return InternalDataSerializer.readTimestamp(in);
            }
        }
        throw new IOException("Unknown header byte: " + header);
    }

    private static Serializable readSerializable(final DataInput in) throws IOException, ClassNotFoundException {
        Serializable serializableResult;
        boolean isDebugEnabled_SERIALIZER = logger.isTraceEnabled(LogMarker.SERIALIZER_VERBOSE);
        if (in instanceof DSObjectInputStream) {
            serializableResult = (Serializable)((DSObjectInputStream)in).readObject();
        } else {
            KnownVersion v;
            InputStream stream = in instanceof InputStream ? (InputStream)((Object)in) : new InputStream(){

                @Override
                public int read() throws IOException {
                    try {
                        return in.readUnsignedByte();
                    }
                    catch (EOFException ignored) {
                        return -1;
                    }
                }
            };
            ObjectInput ois = new DSObjectInputStream(stream);
            try {
                serializationFilter.setFilterOn((ObjectInputStream)ois);
            }
            catch (UnableToSetSerialFilterException e) {
                throw new UnsupportedOperationException(e);
            }
            if (stream instanceof VersionedDataStream && KnownVersion.CURRENT != (v = ((VersionedDataStream)stream).getVersion()) && v != null) {
                ois = new VersionedObjectInput(ois, v);
            }
            serializableResult = (Serializable)ois.readObject();
            if (isDebugEnabled_SERIALIZER) {
                logger.trace(LogMarker.SERIALIZER_VERBOSE, "Read Serializable object: {}", (Object)serializableResult);
            }
        }
        if (isDebugEnabled_SERIALIZER) {
            logger.trace(LogMarker.SERIALIZER_VERBOSE, "deserialized instanceof {}", serializableResult.getClass());
        }
        return serializableResult;
    }

    private static Object readUserDataSerializable(DataInput in, int classId) throws IOException {
        Instantiator instantiator = InternalInstantiator.getInstantiator(classId);
        if (instantiator == null) {
            logger.error(LogMarker.SERIALIZER_MARKER, "No Instantiator has been registered for class with id {}", (Object)classId);
            throw new IOException(String.format("No Instantiator has been registered for class with id %s", classId));
        }
        try {
            DataSerializable ds;
            if (instantiator instanceof CanonicalInstantiator) {
                CanonicalInstantiator ci = (CanonicalInstantiator)instantiator;
                ds = ci.newInstance(in);
            } else {
                ds = instantiator.newInstance();
            }
            ds.fromData(in);
            return ds;
        }
        catch (Exception ex) {
            throw new SerializationException(String.format("Could not deserialize an instance of %s", instantiator.getInstantiatedClass().getName()), ex);
        }
    }

    public static boolean isPdxSerializationInProgress() {
        Boolean v = pdxSerializationInProgress.get();
        return v != null && v != false;
    }

    public static void setPdxSerializationInProgress(boolean inProgress) {
        pdxSerializationInProgress.set(inProgress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean writePdx(DataOutput out, InternalCache internalCache, Object pdx, PdxSerializer pdxSerializer) throws IOException {
        PdxWriterImpl writer;
        block20: {
            if (pdxSerializer != null && InternalDataSerializer.isGemfireObject(pdx)) {
                return false;
            }
            TypeRegistry tr = null;
            if (internalCache != null) {
                tr = internalCache.getPdxRegistry();
            }
            PdxOutputStream os = out instanceof HeapDataOutputStream ? new PdxOutputStream((HeapDataOutputStream)out) : new PdxOutputStream();
            writer = new PdxWriterImpl(tr, pdx, os);
            try {
                boolean alreadyInProgress;
                if (pdxSerializer != null) {
                    if (InternalDataSerializer.is662SerializationEnabled()) {
                        alreadyInProgress = InternalDataSerializer.isPdxSerializationInProgress();
                        if (!alreadyInProgress) {
                            InternalDataSerializer.setPdxSerializationInProgress(true);
                            try {
                                if (!pdxSerializer.toData(pdx, writer)) {
                                    boolean bl = false;
                                    return bl;
                                }
                                break block20;
                            }
                            finally {
                                InternalDataSerializer.setPdxSerializationInProgress(false);
                            }
                        }
                        if (!pdxSerializer.toData(pdx, writer)) {
                            return false;
                        }
                        break block20;
                    }
                    if (!pdxSerializer.toData(pdx, writer)) {
                        return false;
                    }
                    break block20;
                }
                if (InternalDataSerializer.is662SerializationEnabled()) {
                    alreadyInProgress = InternalDataSerializer.isPdxSerializationInProgress();
                    if (!alreadyInProgress) {
                        InternalDataSerializer.setPdxSerializationInProgress(true);
                        try {
                            ((PdxSerializable)pdx).toData(writer);
                            break block20;
                        }
                        finally {
                            InternalDataSerializer.setPdxSerializationInProgress(false);
                        }
                    }
                    ((PdxSerializable)pdx).toData(writer);
                    break block20;
                }
                ((PdxSerializable)pdx).toData(writer);
            }
            catch (CancelException | GemFireRethrowable | ToDataException | NonPortableClassException ex) {
                throw ex;
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                if (pdxSerializer == null) throw new ToDataException("toData failed on PdxSerializable " + String.valueOf(pdx.getClass()), t);
                throw new ToDataException("PdxSerializer failed when calling toData on " + String.valueOf(pdx.getClass()), t);
            }
        }
        int bytesWritten = writer.completeByteStreamGeneration();
        InternalDataSerializer.getDMStats(internalCache).incPdxSerialization(bytesWritten);
        if (out instanceof HeapDataOutputStream) return true;
        writer.sendTo(out);
        return true;
    }

    public static DMStats getDMStats(InternalCache internalCache) {
        if (internalCache != null) {
            return internalCache.getDistributionManager().getStats();
        }
        DMStats result = InternalDistributedSystem.getDMStats();
        if (result == null) {
            result = new LonerDistributionManager.DummyDMStats();
        }
        return result;
    }

    private static Object readPdxSerializable(DataInput in) throws IOException, ClassNotFoundException {
        int len = in.readInt();
        int typeId = in.readInt();
        GemFireCacheImpl internalCache = GemFireCacheImpl.getForPdx("PDX registry is unavailable because the Cache has been closed.");
        PdxType pdxType = internalCache.getPdxRegistry().getType(typeId);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER_VERBOSE)) {
            logger.trace(LogMarker.SERIALIZER_VERBOSE, "readPdxSerializable pdxType={}", (Object)pdxType);
        }
        if (pdxType == null) {
            throw new IllegalStateException("Unknown pdx type=" + typeId);
        }
        DMStats dmStats = InternalDataSerializer.getDMStats(internalCache);
        dmStats.incPdxDeserialization(len + 9);
        if (pdxType.getNoDomainClass() || internalCache.getPdxReadSerializedByAnyGemFireServices()) {
            dmStats.incPdxInstanceCreations();
            return new PdxInstanceImpl(pdxType, in, len);
        }
        PdxReaderImpl pdxReader = new PdxReaderImpl(pdxType, in, len);
        return pdxReader.getObject();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PdxInstance readPdxInstance(byte[] dataBytes, InternalCache internalCache) {
        try {
            byte type = dataBytes[0];
            if (type == DSCODE.PDX.toByte()) {
                PdxInputStream in = new PdxInputStream(dataBytes);
                in.readByte();
                int len = in.readInt();
                int typeId = in.readInt();
                PdxType pdxType = internalCache.getPdxRegistry().getType(typeId);
                if (pdxType != null) return new PdxInstanceImpl(pdxType, in, len);
                throw new IllegalStateException("Unknown pdx type=" + typeId);
            }
            if (type == DSCODE.PDX_ENUM.toByte()) {
                try (PdxInputStream in = new PdxInputStream(dataBytes);){
                    in.readByte();
                    byte dsId = in.readByte();
                    int tmp = InternalDataSerializer.readArrayLength(in);
                    int enumId = dsId << 24 | tmp & 0xFFFFFF;
                    TypeRegistry tr = internalCache.getPdxRegistry();
                    EnumInfo ei = tr.getEnumInfoById(enumId);
                    if (ei == null) {
                        throw new IllegalStateException("Unknown pdx enum id=" + enumId);
                    }
                    PdxInstance pdxInstance = ei.getPdxInstance(enumId);
                    return pdxInstance;
                }
            }
            if (type != DSCODE.PDX_INLINE_ENUM.toByte()) return null;
            try (PdxInputStream in = new PdxInputStream(dataBytes);){
                in.readByte();
                String className = DataSerializer.readString(in);
                String enumName = DataSerializer.readString(in);
                int enumOrdinal = InternalDataSerializer.readArrayLength(in);
                PdxInstanceEnum pdxInstanceEnum = new PdxInstanceEnum(className, enumName, enumOrdinal);
                return pdxInstanceEnum;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static int getLoadedDataSerializers() {
        return idsToSerializers.size();
    }

    public static Map getDsClassesToHoldersMap() {
        return dsClassesToHolders;
    }

    public static Map getIdsToHoldersMap() {
        return idsToHolders;
    }

    public static Map getSupportedClassesToHoldersMap() {
        return supportedClassesToHolders;
    }

    public static void writeObjectArray(Object[] array, DataOutput out, boolean ensureCompatibility) throws IOException {
        InternalDataSerializer.checkOut(out);
        int length = -1;
        if (array != null) {
            length = array.length;
        }
        InternalDataSerializer.writeArrayLength(length, out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER_VERBOSE)) {
            logger.trace(LogMarker.SERIALIZER_VERBOSE, "Writing Object array of length {}", (Object)length);
        }
        if (length >= 0) {
            InternalDataSerializer.writeClass(array.getClass().getComponentType(), out);
            for (int i = 0; i < length; ++i) {
                InternalDataSerializer.basicWriteObject(array[i], out, ensureCompatibility);
            }
        }
    }

    public static void writeVLOld(long data, DataOutput out) throws IOException {
        if (data < 0L) {
            Assert.fail("Data expected to be >=0 is " + data);
        }
        if (data <= 125L) {
            out.writeByte((byte)data);
        } else if (data <= 32767L) {
            out.write(((int)data >>> 8 | 0x80) & 0xFF);
            out.write((int)data & 0xFF);
        } else if (data <= Integer.MAX_VALUE) {
            out.writeByte(126);
            out.writeInt((int)data);
        } else {
            out.writeByte(127);
            out.writeLong(data);
        }
    }

    public static long readVLOld(DataInput in) throws IOException {
        long result;
        byte code = in.readByte();
        if (code < 0) {
            result = code & 0x7F;
            result <<= 8;
            result |= (long)(in.readByte() & 0xFF);
        } else {
            result = code <= 125 ? (long)code : (code == 126 ? (long)in.readInt() : in.readLong());
        }
        return result;
    }

    public static void writeUnsignedVL(long data, DataOutput out) throws IOException {
        while (true) {
            if ((data & 0xFFFFFFFFFFFFFF80L) == 0L) {
                out.writeByte((int)data);
                return;
            }
            out.writeByte((int)data & 0x7F | 0x80);
            data >>>= 7;
        }
    }

    public static long readUnsignedVL(DataInput in) throws IOException {
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            byte b = in.readByte();
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new GemFireIOException("Malformed variable length integer");
    }

    public static void writeSignedVL(long data, DataOutput out) throws IOException {
        InternalDataSerializer.writeUnsignedVL(InternalDataSerializer.encodeZigZag64(data), out);
    }

    public static long readSignedVL(DataInput in) throws IOException {
        return InternalDataSerializer.decodeZigZag64(InternalDataSerializer.readUnsignedVL(in));
    }

    private static long decodeZigZag64(long n) {
        return n >>> 1 ^ -(n & 1L);
    }

    private static long encodeZigZag64(long n) {
        return n << 1 ^ n >> 63;
    }

    public static int calculateBytesForTSandDSID(int dsid) {
        HeapDataOutputStream out = new HeapDataOutputStream(12, KnownVersion.CURRENT);
        long now = System.currentTimeMillis();
        try {
            InternalDataSerializer.writeUnsignedVL(now, out);
            InternalDataSerializer.writeUnsignedVL(InternalDataSerializer.encodeZigZag64(dsid), out);
        }
        catch (IOException ignored) {
            return 0;
        }
        return out.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Class<T> getCachedClass(String p_className) throws ClassNotFoundException {
        String className = InternalDataSerializer.processIncomingClassName(p_className);
        if (LOAD_CLASS_EACH_TIME) {
            return ClassPathLoader.getLatest().forName(className);
        }
        Class<?> result = InternalDataSerializer.getExistingCachedClass(className);
        if (result == null) {
            result = ClassPathLoader.getLatest().forName(className);
            Object object = cacheAccessLock;
            synchronized (object) {
                Class<?> cachedClass = InternalDataSerializer.getExistingCachedClass(className);
                if (cachedClass == null) {
                    classCache.put(className, new WeakReference(result));
                } else {
                    result = cachedClass;
                }
            }
        }
        return result;
    }

    private static Class<?> getExistingCachedClass(String className) {
        WeakReference<Class<?>> wr = classCache.get(className);
        Class result = null;
        if (wr != null) {
            result = (Class)wr.get();
        }
        return result;
    }

    public static void flushClassCache() {
        if (classCache != null) {
            classCache.clear();
        }
    }

    public static DSFIDSerializer getDSFIDSerializer() {
        return dsfidSerializer;
    }

    public static DeserializationContext createDeserializationContext(DataInput in) {
        return dsfidSerializer.createDeserializationContext(in);
    }

    public static SerializationContext createSerializationContext(DataOutput out) {
        return dsfidSerializer.createSerializationContext(out);
    }

    public static DSFIDFactory getDSFIDFactory() {
        return dsfidFactory;
    }

    static {
        serializationFilter = defaultSerializationFilter = new NullStreamSerialFilter();
        listeners = new HashSet<RegistrationListener>();
        dsfidSerializer = new DSFIDSerializerFactory().setObjectSerializer(new ObjectSerializer(){

            public void writeObject(Object obj, DataOutput output) throws IOException {
                InternalDataSerializer.writeObject(obj, output);
            }

            public void invokeToData(Object ds, DataOutput out) throws IOException {
                InternalDataSerializer.invokeToData(ds, out);
            }
        }).setObjectDeserializer(new ObjectDeserializer(){

            public <T> T readObject(DataInput input) throws IOException, ClassNotFoundException {
                return InternalDataSerializer.readObject(input);
            }

            public void invokeFromData(Object ds, DataInput in) throws IOException, ClassNotFoundException {
                InternalDataSerializer.invokeFromData(ds, in);
            }
        }).create();
        InternalDataSerializer.initializeWellKnownSerializers();
        dsfidFactory = new DSFIDFactory(dsfidSerializer);
        ServiceLoader<DataSerializableFixedIdRegistrant> loaders = ServiceLoader.load(DataSerializableFixedIdRegistrant.class);
        for (DataSerializableFixedIdRegistrant loader : loaders) {
            try {
                loader.register((DataSerializableFixedIdRegistrar)dsfidSerializer);
            }
            catch (Exception ex) {
                logger.warn("Data serializable fixed ID loader '{}' failed", (Object)loader.getClass().getName(), (Object)ex);
            }
        }
    }

    private static enum SERIALIZATION_VERSION {
        vINVALID,
        v660,
        v662;

    }

    static class InitMarker
    extends Marker {
        InitMarker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        DataSerializer getSerializer() {
            InitMarker initMarker = this;
            synchronized (initMarker) {
                while (!this.hasBeenSet) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ignored) {
                        Thread.currentThread().interrupt();
                        return null;
                    }
                }
                return this.serializer;
            }
        }
    }

    static abstract class Marker {
        protected DataSerializer serializer = null;
        boolean hasBeenSet = false;

        Marker() {
        }

        abstract DataSerializer getSerializer();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setSerializer(DataSerializer serializer) {
            Marker marker = this;
            synchronized (marker) {
                this.hasBeenSet = true;
                this.serializer = serializer;
                this.notifyAll();
            }
        }
    }

    public static class SerializerAttributesHolder {
        private String className = "";
        private EventID eventId = null;
        private ClientProxyMembershipID proxyId = null;
        private int id = 0;

        SerializerAttributesHolder() {
        }

        SerializerAttributesHolder(String name, EventID event, ClientProxyMembershipID proxy, int id) {
            this.className = name;
            this.eventId = event;
            this.proxyId = proxy;
            this.id = id;
        }

        public String getClassName() {
            return this.className;
        }

        public EventID getEventId() {
            return this.eventId;
        }

        public ClientProxyMembershipID getProxyId() {
            return this.proxyId;
        }

        public int getId() {
            return this.id;
        }

        public String toString() {
            return "SerializerAttributesHolder[name=" + this.className + ",id=" + this.id + ",eventId=" + String.valueOf(this.eventId) + "]";
        }
    }

    public static class GetMarker
    extends Marker {
        @MutableForTesting
        public static int WAIT_MS = Integer.getInteger("gemfire.InternalDataSerializer.WAIT_MS", 60000);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        DataSerializer getSerializer() {
            GetMarker getMarker = this;
            synchronized (getMarker) {
                boolean firstTime = true;
                long endTime = 0L;
                while (!this.hasBeenSet) {
                    if (firstTime) {
                        firstTime = false;
                        endTime = System.currentTimeMillis() + (long)WAIT_MS;
                    }
                    try {
                        long remainingMs = endTime - System.currentTimeMillis();
                        if (remainingMs > 0L) {
                            this.wait(remainingMs);
                            continue;
                        }
                        this.setSerializer(null);
                        break;
                    }
                    catch (InterruptedException ignored) {
                        Thread.currentThread().interrupt();
                        return null;
                    }
                }
                return this.serializer;
            }
        }
    }

    public static interface RegistrationListener {
        public void newInstantiator(Instantiator var1);

        public void newDataSerializer(DataSerializer var1);
    }

    public static class RegistrationMessage
    extends SerialDistributionMessage {
        @Immutable
        private static final KnownVersion[] dsfidVersions = new KnownVersion[0];
        protected EventID eventId;
        private int id;
        private String className;

        public RegistrationMessage() {
        }

        public RegistrationMessage(DataSerializer s) {
            this.className = s.getClass().getName();
            this.id = s.getId();
            this.eventId = (EventID)s.getEventId();
        }

        static String getFullMessage(Throwable t) {
            StringBuilder sb = new StringBuilder();
            RegistrationMessage.getFullMessage(sb, t);
            return sb.toString();
        }

        private static void getFullMessage(StringBuilder sb, Throwable t) {
            if (t.getMessage() != null) {
                sb.append(t.getMessage());
            } else {
                sb.append(t.getClass());
            }
            if (t.getCause() != null) {
                sb.append(" caused by: ");
                RegistrationMessage.getFullMessage(sb, t.getCause());
            }
        }

        @Override
        protected void process(ClusterDistributionManager dm) {
            if (CacheClientNotifier.getInstance() != null) {
                DataSerializer s;
                Class c;
                try {
                    c = InternalDataSerializer.getCachedClass(this.className);
                }
                catch (ClassNotFoundException ex) {
                    logger.warn("Could not load data serializer class {} so both clients of this server and this server will not have this data serializer. Load failed because: {}", (Object)this.className, (Object)RegistrationMessage.getFullMessage(ex));
                    return;
                }
                try {
                    s = InternalDataSerializer.newInstance(c);
                }
                catch (IllegalArgumentException ex) {
                    logger.warn("Could not create an instance of data serializer for class {} so both clients of this server and this server will not have this data serializer. Create failed because: {}", (Object)this.className, (Object)RegistrationMessage.getFullMessage(ex));
                    return;
                }
                s.setEventId(this.eventId);
                try {
                    InternalDataSerializer._register(s, false);
                }
                catch (IllegalArgumentException | IllegalStateException ex) {
                    logger.warn("Could not register data serializer for class {} so both clients of this server and this server will not have this data serializer. Registration failed because: {}", (Object)this.className, (Object)RegistrationMessage.getFullMessage(ex));
                }
            } else {
                try {
                    InternalDataSerializer.register(this.className, false, this.eventId, null, this.id);
                }
                catch (IllegalArgumentException | IllegalStateException ex) {
                    logger.warn("Could not register data serializer for class {} so it will not be available in this JVM. Registration failed because: {}", (Object)this.className, (Object)RegistrationMessage.getFullMessage(ex));
                }
            }
        }

        public int getDSFID() {
            return -68;
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            super.toData(out, context);
            DataSerializer.writeNonPrimitiveClassName(this.className, out);
            out.writeInt(this.id);
            DataSerializer.writeObject(this.eventId, out);
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            super.fromData(in, context);
            InternalDataSerializer.checkIn(in);
            this.className = DataSerializer.readNonPrimitiveClassName(in);
            this.id = in.readInt();
            this.eventId = (EventID)DataSerializer.readObject(in);
        }

        @Override
        public String toString() {
            return String.format("Register DataSerializer %s of class %s", this.id, this.className);
        }

        @Override
        public KnownVersion[] getSerializationVersions() {
            return dsfidVersions;
        }
    }

    static abstract class WellKnownPdxDS
    extends WellKnownDS {
        WellKnownPdxDS() {
        }
    }

    protected static abstract class WellKnownDS
    extends DataSerializer {
        protected WellKnownDS() {
        }

        @Override
        public int getId() {
            return 0;
        }

        public Class[] getSupportedClasses() {
            return null;
        }

        @Override
        public Object fromData(DataInput in) throws IOException, ClassNotFoundException {
            throw new IllegalStateException("Should not be invoked");
        }
    }

    private static class DSObjectInputStream
    extends ObjectInputStream {
        DSObjectInputStream(InputStream stream) throws IOException {
            super(stream);
        }

        protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            String className = desc.getName();
            OldClientSupportService svc = InternalDataSerializer.getOldClientSupportService();
            if (svc != null) {
                className = svc.processIncomingClassName(className);
            }
            try {
                return InternalDataSerializer.getCachedClass(className);
            }
            catch (ClassNotFoundException ignored) {
                return super.resolveClass(desc);
            }
        }

        protected Class resolveProxyClass(String[] interfaces) throws ClassNotFoundException {
            ClassLoader nonPublicLoader = null;
            boolean hasNonPublicInterface = false;
            Class[] classObjs = new Class[interfaces.length];
            for (int i = 0; i < interfaces.length; ++i) {
                Class cl = InternalDataSerializer.getCachedClass(interfaces[i]);
                if ((cl.getModifiers() & 1) == 0) {
                    if (hasNonPublicInterface) {
                        if (nonPublicLoader != cl.getClassLoader()) {
                            String s = "conflicting non-public interface class loaders";
                            throw new IllegalAccessError(s);
                        }
                    } else {
                        nonPublicLoader = cl.getClassLoader();
                        hasNonPublicInterface = true;
                    }
                }
                classObjs[i] = cl;
            }
            try {
                if (hasNonPublicInterface) {
                    return Proxy.getProxyClass(nonPublicLoader, classObjs);
                }
                return ClassPathLoader.getLatest().getProxyClass(classObjs);
            }
            catch (IllegalArgumentException e) {
                throw new ClassNotFoundException(null, e);
            }
        }
    }
}

