/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.deadlock;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.deadlock.DeadlockDetector;
import org.apache.geode.distributed.internal.deadlock.Dependency;
import org.apache.geode.distributed.internal.deadlock.DependencyGraph;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.execute.AbstractExecution;
import org.apache.geode.internal.cache.execute.InternalFunction;

public class GemFireDeadlockDetector {
    private Set<DistributedMember> targetMembers = null;

    public GemFireDeadlockDetector() {
    }

    public GemFireDeadlockDetector(Set<DistributedMember> targetMembers) {
        this.targetMembers = targetMembers;
    }

    public DependencyGraph find() {
        final DeadlockDetector detector = new DeadlockDetector();
        ResultCollector<HashSet<Dependency>, Serializable> collector = new ResultCollector<HashSet<Dependency>, Serializable>(){

            @Override
            public synchronized Serializable getResult() throws FunctionException {
                return null;
            }

            @Override
            public synchronized Serializable getResult(long timeout, TimeUnit unit) throws FunctionException, InterruptedException {
                return null;
            }

            @Override
            public synchronized void addResult(DistributedMember memberID, HashSet<Dependency> resultOfSingleExecution) {
                detector.addDependencies(resultOfSingleExecution);
            }

            @Override
            public void endResults() {
            }

            @Override
            public void clearResults() {
            }
        };
        Execution execution = this.targetMembers != null ? FunctionService.onMembers(this.targetMembers).withCollector(collector) : FunctionService.onMembers(new String[0]).withCollector(collector);
        ((AbstractExecution)execution).setIgnoreDepartedMembers(true);
        collector = execution.execute(new CollectDependencyFunction());
        collector.getResult();
        return detector.getDependencyGraph();
    }

    private static class CollectDependencyFunction
    implements InternalFunction {
        private static final long serialVersionUID = 6204378622627095817L;

        private CollectDependencyFunction() {
        }

        @Override
        public boolean hasResult() {
            return true;
        }

        @Override
        public void execute(FunctionContext context) {
            InternalDistributedSystem instance = InternalDistributedSystem.getAnyInstance();
            if (instance == null) {
                context.getResultSender().lastResult(new HashSet());
                return;
            }
            InternalDistributedMember member = instance.getDistributedMember();
            Set<Dependency> dependencies = DeadlockDetector.collectAllDependencies(member);
            context.getResultSender().lastResult(dependencies);
        }

        @Override
        public String getId() {
            return "DetectDeadlock";
        }

        @Override
        public boolean optimizeForWrite() {
            return false;
        }

        @Override
        public boolean isHA() {
            return false;
        }
    }
}

