/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.deadlock;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.deadlock.Dependency;
import org.apache.geode.distributed.internal.deadlock.DependencyMonitor;
import org.apache.geode.distributed.internal.deadlock.UnsafeThreadLocal;
import org.apache.geode.distributed.internal.locks.DLockService;
import org.apache.geode.distributed.internal.locks.DLockToken;

public class DLockDependencyMonitor
implements DependencyMonitor {
    @Immutable
    static final DLockDependencyMonitor INSTANCE = new DLockDependencyMonitor();

    @Override
    public Set<Dependency<Thread, Serializable>> getBlockedThreads(Thread[] allThreads) {
        HashSet<Dependency<Thread, Serializable>> results = new HashSet<Dependency<Thread, Serializable>>();
        DLockService.dumpAllServices();
        Map<String, DLockService> services = DLockService.snapshotAllServices();
        for (Map.Entry<String, DLockService> entry : services.entrySet()) {
            String serviceName = entry.getKey();
            DLockService service = entry.getValue();
            UnsafeThreadLocal<Object> blockedThreadLocal = service.getBlockedOn();
            for (Thread thread : allThreads) {
                Object lockName = blockedThreadLocal.get(thread);
                if (lockName == null) continue;
                results.add(new Dependency<Thread, LockId>(thread, new LockId(serviceName, (Serializable)lockName)));
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Dependency<Serializable, Thread>> getHeldResources(Thread[] allThreads) {
        InternalDistributedSystem ds = InternalDistributedSystem.getAnyInstance();
        if (ds == null) {
            return Collections.emptySet();
        }
        HashSet<Dependency<Serializable, Thread>> results = new HashSet<Dependency<Serializable, Thread>>();
        Map<String, DLockService> services = DLockService.snapshotAllServices();
        for (Map.Entry<String, DLockService> entry : services.entrySet()) {
            String serviceName = entry.getKey();
            DLockService service = entry.getValue();
            Map<Object, DLockToken> tokens = service.snapshotService();
            for (Map.Entry<Object, DLockToken> tokenEntry : tokens.entrySet()) {
                DLockToken token;
                Object tokenName = tokenEntry.getKey();
                DLockToken dLockToken = token = tokenEntry.getValue();
                synchronized (dLockToken) {
                    Thread holdingThread = token.getThread();
                    if (holdingThread != null) {
                        results.add(new Dependency<LockId, Thread>(new LockId(serviceName, (Serializable)tokenName), holdingThread));
                    }
                }
            }
        }
        return results;
    }

    private static class LockId
    implements Serializable {
        private final String serviceName;
        private final Serializable tokenName;

        public LockId(String serviceName, Serializable tokenName) {
            this.serviceName = serviceName;
            this.tokenName = tokenName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.serviceName == null ? 0 : this.serviceName.hashCode());
            result = 31 * result + (this.tokenName == null ? 0 : this.tokenName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof LockId)) {
                return false;
            }
            LockId other = (LockId)obj;
            if (this.serviceName == null ? other.serviceName != null : !this.serviceName.equals(other.serviceName)) {
                return false;
            }
            if (this.tokenName == null) {
                return other.tokenName == null;
            }
            return this.tokenName.equals(other.tokenName);
        }

        public String toString() {
            return "DLock(" + this.serviceName + ", " + String.valueOf(this.tokenName) + ")";
        }
    }
}

